#include "mbed.h"
#include "USBMouse.h"
#include "MMA8451Q.h"

#define LED_ON  0 //outON, pwmON
#define LED_OFF 1 //outOFF,pwmOFF
DigitalOut gLED(LED_GREEN); //PTD5

#define PRESS_ON  0
#define PRESS_OFF 1
DigitalIn  sw1(PTC3);  //if(sw1) Release else Press
DigitalIn  sw3(PTC12); //while(sw3); wait for Press

#define rLEDperiod 150      //[ms]
PwmOut rLED(LED_RED);       //PTE29

#define MMA8451_I2C_ADDRESS (0x1d<<1)
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);

struct KL46_SENSOR_DATA {
    int   sw1State;
    int   sw3State;
    float   accValX;
    float   accValY;
    float   accValZ;
} sensorData;
#define sD sensorData

USBMouse mouse;

int main(void)
{
    sw1.mode(PullUp); sw3.mode(PullUp);
    gLED = LED_ON; //Green LED ON to indicate running program
    rLED = LED_OFF; //Red LED OFF
    rLED.period(rLEDperiod); //Red LED (rLED) blinkig shows accZ

   while (1)
   {
        sD.sw1State = sw1; sD.sw3State = sw3;
        sD.accValX = acc.getAccX(); //accX[-1..1]->mouse (Lab1)
        sD.accValY = acc.getAccY(); //accY[-1..1]->mouse (Lab1)
        sD.accValZ = acc.getAccZ(); //accZ[-1..1]->rLED

        if(sD.sw1State==PRESS_ON) //mouse left button
            mouse.press(MOUSE_LEFT);
        else
            mouse.release(MOUSE_LEFT);

        if(sD.sw3State==PRESS_ON) //mouse right button
            mouse.press(MOUSE_RIGHT);
        else
            mouse.release(MOUSE_RIGHT);        

        mouse.move(sD.accValX*16, sD.accValY*16);
      //mouse.move(20, 0);\
      //acc: z-axis 1g min-blinking//acc: z-axis 1g min-blinking
        rLED = abs(sD.accValZ);

      //wait(0.5);
      wait(0.05); //wait 50ms
  }
}