//USB Academy - Lab2 rev 00
//_____________________________________________________________//
//======== INCLUDES ===========================================//
//¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯//
#include "mbed.h"
#include "MMA8451Q.h"
#include "MAG3110.h"
#include "SLCD.h"
#include "TSISensor.h"

//#include "MAG3110.h"
//#include "SLCD.h"
//#include "TSISensor.h"

//#include "USBMouse.h" //Lab1-Hid
//#include "USBSerial.h" //Lab2-cdc
//#include "USBHostMSD.h" //Lab3-Msd





//_____________________________________________________________//
//======== DEFINES & VARIABLES ================================//
//¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯//
#define LED_ON  0 //outON, pwmON
#define LED_OFF 1 //outOFF,pwmOFF
DigitalOut gLED(LED_GREEN); //PTD5

#define rLEDperiod 150      //[ms]
PwmOut rLED(LED_RED);       //PTE29

#define PRESS_ON  0
#define PRESS_OFF 1
DigitalIn  sw1(PTC3);  //if(sw1) Release else Press
DigitalIn  sw3(PTC12); //while(sw3); wait for Press

#define MMA8451_I2C_ADDRESS (0x1d<<1)
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);

SLCD slcd; //[88:88][8.8.8.8] SegmentLCD

AnalogIn  light(PTE22); //analog-light input

TSISensor slider; //Capacitive Touch Slider

MAG3110 mag(PTE25, PTE24); //Magnetometer

Serial usb_osda(USBTX, USBRX); //OpenSDA Terminal
#define pf usb_osda //printf out -> osda (lab1,2,3)


struct KL46_SENSOR_DATA {
    int   sw1State;
    int   sw3State;
    float   accValX;
    float   accValY;
    float   accValZ;
    float   slider;
    float   light;
    int     magValX;
    int     magValY;
    int     magValZ;

} sensorData;
#define sD sensorData

void SLCD_blinking_msg_wait(char *slcd_msg1, char *slcd_msg2);



//_____________________________________________________________//
//======== MAIN() =============================================//
//¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯//
int main(void)
{
    //---- MAIN/Inits -----------------------------------------//
    
    sw1.mode(PullUp);
    sw3.mode(PullUp);
    
    gLED = LED_ON; //Green LED ON to indicate running/writing
    rLED = LED_OFF; //Red LED OFF
    rLED.period(rLEDperiod); //Red LED (rLED) tsi/accZ/mag
    
    //---- MAIN/Inits (Wait4SW1) -> Start! --------------------//   
    //wait for Press SW1 - e.g. for HID/CDC/MSD Windows install.
    SLCD_blinking_msg_wait("   o","PrES");//Lab1=Hid;2=cdc;3=Msd

    //---- MAIN/Inits Interface -------------------------------//
    
    usb_osda.baud(115200);
    usb_osda.printf("\n___________________________________\r\n");
    usb_osda.printf("\nFRDM-KL46Z_Lab\r\n \r\n I am a CDC serial port @OpenSDA/mUSB. Baud=115200 \r\n");

    
    //---- MAIN/Inits Interface -------------------------------//
    
    //---- MAIN/Inits Labs ------------------------------------//
    
    //---- MAIN/Inits (Wait4SW1) -> Calib. eCompass -----------//
    
    //---- MAIN/Inits Done! (Wait4SW1) -> MANI/Loop -----------//
    
    gLED = LED_OFF; //Inits are done

    //---- MAIN/Loop  -----------------------------------------//
    while (1) {
        
        // MAIN/Loop/Sensing and Storing data -----------------//
        sD.sw1State = sw1; sD.sw3State = sw3;
        sD.accValX = acc.getAccX(); //accX[-1..1]->mouse (Lab1)
        sD.accValY = acc.getAccY(); //accY[-1..1]->mouse (Lab1)
        sD.accValZ = acc.getAccZ(); //accZ[-1..1]->rLED
        
        sD.slider = slider.readPercentage() * 100;
        sD.light = light;
        sD.magValX = mag.readVal(MAG_OUT_X_MSB);
        sD.magValY = mag.readVal(MAG_OUT_Y_MSB);
        sD.magValZ = mag.readVal(MAG_OUT_Z_MSB);

        
        // MAIN/Loop/Processing and Actions -------------------//
        //sensor -> terminal
        if (sD.sw1State != PRESS_OFF) { gLED = !gLED; //blinking 
            pf.printf(" \r\n");
            pf.printf(" Switches. Light . Slider . Accelerometer       . Magnetometer      . Compass\r\n");
            pf.printf("  SW1:SW2|  LUX  |  TSI   |  accX : accY : accZ |  magX: magY: maxZ | Heading\r\n");
            pf.printf("  %d : %d  | %1.3f |  %2.0f %%  | %+1.3f:%+1.3f:%+1.3f| %5d:%5d:%5d |  Lab3 \r\n", 
                sD.sw1State, sD.sw3State,    sD.light, sD.slider,    sD.accValX, sD.accValY, sD.accValZ,    
                (short)sD.magValX, (short)sD.magValY, (short)sD.magValZ);
        } gLED = LED_OFF;

        //disable all SLCD DPs
        slcd.DP(0, false); slcd.DP(1, false); slcd.DP(2, false);

        
        //acc: z-axis 1g min-blinking//acc: z-axis 1g min-blinking
        
        rLED = abs(sD.accValZ);
        
        if (sD.slider) 
            slcd.printf(" %3.0f", sD.slider); //night->light .. 1->0
        else
            slcd.printf("%1.3f", sD.light); //left->right .. 0->100%

        
        wait(0.05); //wait 50ms
    }
}





//_____________________________________________________________//
//======== FUNC() =============================================//
//¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯¯//
//Lab2add
void SLCD_blinking_msg_wait(char *slcd_msg1, char *slcd_msg2)
{
    char wait4sw1=0; //~500ms blinking
    slcd.CharPosition=0;
    //wait for Press SW1 - to start mag calibration
    while(sw1 == PRESS_ON); //wait for release
    while(sw1 == PRESS_OFF) { //wait for press
        if (++wait4sw1 < 150) //300ms
            slcd.printf(slcd_msg1);
        else //200ms
            slcd.printf(slcd_msg2);
        wait(0.002);
        slcd.CharPosition=0;
    }
    while(sw1 == PRESS_ON); //wait for release
}

