#include "mbed.h"
#include "USBHostKeyboard.h"
#include "SDFileSystem.h"

DigitalOut led(LED1);
SDFileSystem sd(p5, p6, p7, p8, "sd");
int i=0;


void onKey(uint8_t key) {
    printf("Key: %c\r\n", key);
    char log[8];
    ++i;

    FILE *fp;
    sprintf(log, "log%03d.csv", i);
    fp = fopen("log", "a");
    fprintf(fp, "Keydata[%d],:,%c\r\n", i, key);
    fclose(fp); 
}

void keyboard_task(void const *) {
    
    USBHostKeyboard keyboard;
    
    while(1) {
        // try to connect a USB keyboard
        while(!keyboard.connect())
            Thread::wait(500);
    
        // when connected, attach handler called on keyboard event
        keyboard.attach(onKey);
        
        // wait until the keyboard is disconnected
        while(keyboard.connected())
            Thread::wait(500);
    }
}

int main() {
    mkdir("/sd/keylog", 0777);
    FILE *fp;
    fp = fopen("/sd/keylog/log.csv","w");
    fclose(fp);
    
    
    Thread keyboardTask(keyboard_task, NULL, osPriorityNormal, 256 * 4);
    
     while(1) {
        led=!led;
        Thread::wait(500);
    }
}
