#include "radio.h"

// Semtech radio definitions for SX127x, SX126x and SX128x

#if defined(SX127x_H)
    #define BW_KHZ              500
    #define SPREADING_FACTOR    11
    #define CF_HZ               912000000
    #define TX_DBM              20
#elif defined(SX126x_H)
    #define BW_KHZ              500
    #define SPREADING_FACTOR    10
    #define CF_HZ               915000000
    #define TX_DBM              (Radio::chipType == CHIP_TYPE_SX1262 ? 20 : 14) 
#elif defined(SX128x_H)
    #define BW_KHZ              200
    #define SPREADING_FACTOR    7
    #define CF_HZ               2487000000
    #define TX_DBM              6
#endif

/******************** Setup radio transmitter ****************************/


volatile bool txDone;

void txDoneCB()
{
    txDone = true;
}

void rxDoneCB(uint8_t size, float rssi, float snr)
{
}

    // Define radio events for transmitter

const RadioEvents_t rev = {
    /* Dio0_top_half */     NULL,
    /* TxDone_topHalf */    NULL,
    /* TxDone_botHalf */    txDoneCB,
    /* TxTimeout  */        NULL,
    /* RxDone  */           rxDoneCB,
    /* RxTimeout  */        NULL,
    /* RxError  */          NULL,
    /* FhssChangeChannel  */NULL,
    /* CadDone  */          NULL
};

int main()
{
    uint8_t seq = 0;  //  Set initial transmit sequence to 0
 
    printf("\r\nreset-tx ");
    
    // Start radio transmitter after POR or reset

    Radio::Init(&rev);

    //Set radio properties for transmitter

    Radio::Standby();
    Radio::LoRaModemConfig(BW_KHZ, SPREADING_FACTOR, 1);
    Radio::SetChannel(CF_HZ);

    // Set transmitter output power

    Radio::set_tx_dbm(TX_DBM);

    // Setup transmit packet payload  -> preambleLen, fixLen, crcOn, invIQ
               
    Radio::LoRaPacketConfig(8, false, true, false);
    
    printf("\n");
    
    printf("%02d \r\n\n", seq);

    for (;;) {
        Radio::radio.tx_buf[0] = seq;  // set payload 
        txDone = false;
        Radio::Send(10, 0, 0, 0);   // begin transmission of payload 

        while (!txDone) {
            Radio::service();
        }

        // Transmit payload every 500mS

        wait(0.5);  // throttle sending rate 
        seq++;  // change payload (increment sequence number)
        printf("%02d \r\n\n", seq);  // Print sequence number
        
        }
}
