#include "radio.h"

// Semtech radio definitions for SX127x, SX126x and SX128x

#if defined(SX127x_H)
    #define BW_KHZ              500
    #define SPREADING_FACTOR    11
    #define CF_HZ               912000000
#elif defined(SX126x_H)
    #define BW_KHZ              500
    #define SPREADING_FACTOR    10
    #define CF_HZ               913000000
#elif defined(SX128x_H)
    #define BW_KHZ              200
    #define SPREADING_FACTOR    7
    #define CF_HZ               2487000000
#endif

DigitalOut myled(LED1);

/**********************************************************************/

void txDoneCB()
{
}

void rxDoneCB(uint8_t size, float rssi, float snr)
{
    unsigned i;
    printf("%.1fdBm  snr:%.1fdB\t", rssi, snr);

    myled.write(!myled.read()); // toggle LED

    // Display payload packet information

    for (i = 0; i < size; i++) {
        printf("%02d ", Radio::radio.rx_buf[i]);   // Changed to "%02d \n"
    }
    printf("\r\n\n");
}

const RadioEvents_t rev = {
    /* Dio0_top_half */     NULL,
    /* TxDone_topHalf */    NULL,
    /* TxDone_botHalf */    txDoneCB,
    /* TxTimeout  */        NULL,
    /* RxDone  */           rxDoneCB,
    /* RxTimeout  */        NULL,
    /* RxError  */          NULL,
    /* FhssChangeChannel  */NULL,
    /* CadDone  */          NULL
};

int main()
{   

    // POR & Reset debug message
        
    printf("\r\nreset-rx\r\n");
    
    Radio::Init(&rev);

    // Radio Start
    
    Radio::Standby();
    Radio::LoRaModemConfig(BW_KHZ, SPREADING_FACTOR, 1);
    Radio::SetChannel(CF_HZ);

    // preambleLen, fixLen, crcOn, invIQ
               
    Radio::LoRaPacketConfig(8, false, true, false);
    
    // Start radio receiver, wait for packets from transmitter

    Radio::Rx(0);
    
    for (;;) {     
        Radio::service();
    }
}
