#include "main.h"
/*
 * Auxiliary functions
 */
using namespace std;
Serial pc(SERIAL_TX, SERIAL_RX);
Thread thread;
DigitalOut led1(LED1);
InterruptIn mybutton(USER_BUTTON);
Timeout timeout;
bool running = false;
bool game_progress = false;
bool timeout_triggered = false;


void led1_thread() {
    while (running) {
        while(game_progress) {
            led1 = !led1;
            wait(1);
        }
    }
}

void time_expired(){
    timeout_triggered = true;
    timeout.detach();
}

int _get_number_users(string received) {
    if (received[received.length()-1] == '!') {
        char* tmp = &received[received.find("!")-1];
        return atoi(tmp); 
    }
    return -1;
}

int get_number_users(){
    int response = -1;
    string stash = "";
    while(1){
        // Get number of players
        if (pc.readable()){
           char got=pc.getc();
           stash = stash + got;
            response = _get_number_users(stash);
            if (response != -1) {
                pc.printf("Starting match with %d users\n", response);    
                return response;
            }
        }
    }
}
    
int get_answer(){
    while(1){
        if (pc.readable()){
           timeout_triggered = false;
           char got = pc.getc();
           return atoi(&got);
        } else if (timeout_triggered) {
            timeout_triggered = false;
            return 0;
        }
    }
}

string readline_questions(){
    size_t pos = questions.find("!"); 
    string buffer = questions.substr(0, pos);
    read_questions += buffer;
    questions = questions.substr(pos+1);
    return buffer;
}


void delay(){
    printf("Timeout!");
    wait(30);
}
    

    
vector<string> get_answers_vector(string question){
    char buf[question.length()+1];
    sprintf(buf, "%s", question.c_str());
    vector <string> answers; 
    char * pch = strtok(buf, ";");
    while (pch != NULL) {
        answers.push_back(std::string(pch));
        pch = strtok(NULL, ";");
    }
    return answers;
}
  
void print_score(std::map<int, int> map){
    for(std::map<int,int>::iterator it = map.begin(); it != map.end(); ++it) printf("User %d - Score: %d\n",it->first, it->second);
}

void start_game(){
    int users = -1, user=0;
    int round = 0;
    std::map<int, int> map;
    string stash = "";
    while(1){
        mybutton.fall(&delay);
        if (users == -1) users = get_number_users();
        // Propose questions
        else{
            map[user];
            mybutton.fall(NULL);
            string domanda = readline_questions();
            if(domanda=="\0") {
                printf("No questions avaialable!\n");
                print_score(map);
                break;
            }
            game_progress = true;
            vector<string> ret = get_answers_vector(domanda);
            printf("%s\n",ret.at(0).c_str());
            string correct_answer = ret.at(1);
            ret.erase(ret.begin());
            std::random_shuffle(ret.begin(),ret.end());
            
            // Print shuffled answers
            for (std::vector<string>::const_iterator i = ret.begin(); i != ret.end(); ++i) printf("%s",(*i).c_str());
            printf("\n");
            timeout.attach(&time_expired, 10.0);
            int answer = get_answer();
            if (answer!=0 && (answer<0 || ret.size()<answer)) answer = 0;
            printf("Your answer: %d\n",answer);
            if (answer!=0 && ret.at(--answer)==correct_answer) {
                printf("CORRECT!\n");
                map[user]++;
            }
            else printf("WRONG!\n");
            game_progress = false;
            user++;
            if (user == users) {
                user=0;
                round++;
            }
        }

        // Check if game has ended
        if(round==TURN){
            printf("Game has ended\n");
            print_score(map);
            break;
        }
    }
}
    
int main()
{
    running = true;
    printf("Insert number of users (using ASCII)\n");
    thread.start(led1_thread);
    start_game();
    running = false;
}