//---------------------------------------------------------------
//  Demo program of Button class and ButtonGroup class
//
//  2016/02/22, Copyright (c) 2016 MIKAMI, Naoki
//---------------------------------------------------------------

#include "button_group.hpp"
#include "MCP9808.h"

using namespace Mikami;

TS_DISCO_F746NG ts_;
LCD_DISCO_F746NG lcd_;
Serial pc(USBTX, USBRX); // tx, rx
MCP9808 capteur(D14, D15); //: i2c(sda, scl)

int main()
{ // ---------------------------------------INITIALISATION DES VARIABLES---------------------------------------------------
    float temperature, kelvin, fahrenheit;
    const int Y0 = 5;
    const int X1 = 30;
    const int Y1 = 100;
    int mode = 0;

    const uint32_t BACK_COLOR = 0xFF006A6C;             // fond blue
    lcd_.Clear(BACK_COLOR);
       
    const int NUMBER_BUTTONS = 3;   // nb de bouton
    const string STR[NUMBER_BUTTONS] = {"KELVIN", "CELSIUS", "FAHRENHEIT"};
    ButtonGroup bGroup(lcd_, ts_, 10, Y0, 100, 40,
                       LCD_COLOR_BLUE, BACK_COLOR, NUMBER_BUTTONS, STR, 5, 5, 3); // 100 taille de la case
        
    DigitalOut dOut(D7);
    int num;
//--------------------------------------------------------------------------------------------------------------------------
    while (true)
    {
        temperature =capteur.readTemp(); // reception de la valeur de la temperature
        fahrenheit = (temperature*9/5) + 32; // convertion
        kelvin = temperature +273.15;       // convertion
        
        lcd_.DisplayStringAt(30, 200, (uint8_t *)"Medzo Owono Lionel", LEFT_MODE);
        lcd_.DisplayStringAt(30, 230, (uint8_t *)"Capteur de temperature", LEFT_MODE);
        
        dOut = 1;
        bool touched = bGroup.GetTouchedNumber(num, LCD_COLOR_DARKBLUE); // bouton actionné change de couleur
        dOut = 0;
        char str[20];
        if (touched)
        {
            
            lcd_.SetFont(&Font16);
            lcd_.SetTextColor(LCD_COLOR_WHITE);
            
           if (num==0) // choix du mode  1pour ensuite aller au switch case coorespondant
            {
                mode = 1;
                lcd_.DisplayStringAt(X1, Y1, (uint8_t *)"                ", CENTER_MODE); c
                
            }
            else if (num==1) //  choix du mode  2 pour ensuite aller au switch case coorespondant
            {
                mode = 2;
                lcd_.DisplayStringAt(X1, Y1, (uint8_t *)"                ", CENTER_MODE);// effacer l'ecriture précedente
            }
            else if (num==2) // choix du mode 3 pour ensuite aller au switch case coorespondant
            {
                mode = 3;
                lcd_.DisplayStringAt(X1, Y1, (uint8_t *)"                ", CENTER_MODE);// effacer l'ecriture précedente
            }
           
            
        }
        
         switch (mode){ //  choix du mode, avec affichage en continue 
                case 1:
                    
                    
                    sprintf(str, "%.2f K", kelvin);
                    lcd_.DisplayStringAt(X1, Y1, (uint8_t *)str, CENTER_MODE);
                    break;
                    
                case 2:
                    
                    
                    sprintf(str, "%.2f C", temperature);
                    lcd_.DisplayStringAt(X1, Y1, (uint8_t *)str, CENTER_MODE);
                    break;
                    
                case 3:
                    
                    
                    sprintf(str, "%.2f F",fahrenheit );
                    lcd_.DisplayStringAt(X1, Y1, (uint8_t *)str, CENTER_MODE);
                    break;
                }
        wait(0.01f);
    }
}

