//After RaL
#include "mbed.h"
#include "FastPWM.h"
#include "INIT_HW.h"
#include "function_CAN.h"
#include "SPI_EEP_ENC.h"
#include "I2C_AS5510.h"
#include "setting.h"
#include "function_utilities.h"
#include "stm32f4xx_flash.h"
#include "FlashWriter.h"
#include <string>
#include <iostream>
#include <cmath>

using namespace std;
Timer t;

///191008////

// dac & check ///////////////////////////////////////////
DigitalOut check(PC_2);
DigitalOut check_2(PC_3);
AnalogOut dac_1(PA_4);
AnalogOut dac_2(PA_5);
AnalogIn adc1(PC_4); //pressure_1
AnalogIn adc2(PB_0); //pressure_2
AnalogIn adc3(PC_1); //current


// PWM ///////////////////////////////////////////
float dtc_v=0.0f;
float dtc_w=0.0f;

// I2C ///////////////////////////////////////////
I2C i2c(PC_9,PA_8); // SDA, SCL (for K22F)
const int i2c_slave_addr1 =  0x56;
unsigned int value; // 10bit output of reading sensor AS5510

// SPI ///////////////////////////////////////////
SPI eeprom(PB_15, PB_14, PB_13); // EEPROM //(SPI_MOSI, SPI_MISO, SPI_SCK);
DigitalOut eeprom_cs(PB_12);
//FlashWriter writer(6);//2부터 7까지 되는듯 아마 sector
SPI enc(PC_12,PC_11,PC_10);
DigitalOut enc_cs(PD_2);
DigitalOut LED(PA_15);

// UART ///////////////////////////////////////////
Serial pc(PA_9,PA_10); //  _ UART

// CAN ///////////////////////////////////////////
CAN can(PB_8, PB_9, 1000000);
CANMessage msg;
void onMsgReceived()
{
    CAN_RX_HANDLER();
}

// Variables ///////////////////////////////////////////
State pos;
State vel;
State Vout;
State torq;
State torq_dot;
State pres_A;
State pres_B;
State cur;
State valve_pos;

State INIT_Vout;
State INIT_Valve_Pos;
State INIT_Pos;
State INIT_torq;

extern int CID_RX_CMD;
extern int CID_RX_REF_POSITION;
extern int CID_RX_REF_VALVE_POS;
extern int CID_RX_REF_PWM;

extern int CID_TX_INFO;
extern int CID_TX_POSITION;
extern int CID_TX_TORQUE;
extern int CID_TX_PRES;
extern int CID_TX_VOUT;
extern int CID_TX_VALVE_POSITION;




// =============================================================================
// =============================================================================
// =============================================================================

/*******************************************************************************
 *  REFERENCE MODE
 ******************************************************************************/
enum _REFERENCE_MODE {
    MODE_REF_NO_ACT = 0,                                //0
    MODE_REF_DIRECT,                                //1
    MODE_REF_COS_INC,                                  //2
    MODE_REF_LINE_INC,                                 //3
    MODE_REF_SIN_WAVE,                                  //4
    MODE_REF_SQUARE_WAVE,                                  //5
};

/*******************************************************************************
 *  CONTROL MODE
 ******************************************************************************/
enum _CONTROL_MODE {
    //control mode
    MODE_NO_ACT = 0,                                    //0
    MODE_VALVE_POSITION_CONTROL,                        //1
    MODE_JOINT_CONTROL,                                 //2

    MODE_VALVE_OPEN_LOOP,                               //3
    MODE_JOINT_ADAPTIVE_BACKSTEPPING,                   //4
    MODE_RL,                                            //5

    MODE_JOINT_POSITION_PRES_CONTROL_PWM,               //6
    MODE_JOINT_POSITION_PRES_CONTROL_VALVE_POSITION,    //7
    MODE_VALVE_POSITION_PRES_CONTROL_LEARNING,          //8

    MODE_TEST_CURRENT_CONTROL,                          //9
    MODE_TEST_PWM_CONTROL,                              //10

    MODE_CURRENT_CONTROL,                               //11
    MODE_JOINT_POSITION_TORQUE_CONTROL_CURRENT,         //12
    MODE_JOINT_POSITION_PRES_CONTROL_CURRENT,           //13
    MODE_VALVE_POSITION_TORQUE_CONTROL_LEARNING,                                            //14

    //utility
    MODE_TORQUE_SENSOR_NULLING = 20,                    //20
    MODE_VALVE_NULLING_AND_DEADZONE_SETTING,            //21
    MODE_FIND_HOME,                                     //22
    MODE_VALVE_GAIN_SETTING,                            //23
    MODE_PRESSURE_SENSOR_NULLING,                       //24
    MODE_PRESSURE_SENSOR_CALIB,                         //25
    MODE_ROTARY_FRICTION_TUNING,                        //26

    MODE_DDV_POS_VS_PWM_ID = 30,                           //30
    MODE_DDV_DEADZONE_AND_CENTER,                       //31
    MODE_DDV_POS_VS_FLOWRATE,                           //32
    MODE_SYSTEM_ID,                                     //33
    MODE_FREQ_TEST,                                     //34
    MODE_SEND_BUFFER,                                   //35
    MODE_SEND_OVER,                                     //36
    MODE_STEP_TEST,                                     //37
};

void SystemClock_Config(void)
{
    RCC_OscInitTypeDef RCC_OscInitStruct = {0};
    RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

    /** Configure the main internal regulator output voltage
    */
    __HAL_RCC_PWR_CLK_ENABLE();
    __HAL_PWR_VOLTAGESCALING_CONFIG(PWR_REGULATOR_VOLTAGE_SCALE1);
    /** Initializes the CPU, AHB and APB busses clocks
    */
    RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI;
    RCC_OscInitStruct.HSIState = RCC_HSI_ON;
    RCC_OscInitStruct.HSICalibrationValue = RCC_HSICALIBRATION_DEFAULT;
    RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
    RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSI;
    RCC_OscInitStruct.PLL.PLLM = 8;//8
    RCC_OscInitStruct.PLL.PLLN = 180; //180
    RCC_OscInitStruct.PLL.PLLP = RCC_PLLP_DIV2;
    RCC_OscInitStruct.PLL.PLLQ = 2;
    RCC_OscInitStruct.PLL.PLLR = 2;
    if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK) {
        //Error_Handler();
    }
    /** Activate the Over-Drive mode
    */
    if (HAL_PWREx_EnableOverDrive() != HAL_OK) {
        //Error_Handler();
    }
    /** Initializes the CPU, AHB and APB busses clocks
    */
    RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                                  |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
    RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
    RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
    RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV4;
    RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV2;

    if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_5) != HAL_OK) {
        //Error_Handler();
    }
}

float u_past[num_array_u_past] = {0.0f};
float x_past[num_array_x_past] = {0.0f};
float x_future[num_array_x_future] = {0.0f};
float f_past[num_array_f_past] = {0.0f};
float f_future[num_array_f_future] = {0.0f};

float input_NN[num_input] = { 0.0f };

const float h1[num_input][16] = {
    {-0.034636590629816055f,-0.08510791510343552f,-0.3801865577697754f,0.03776714578270912f,0.2840934693813324f,-0.1901460736989975f,0.12296205759048462f,0.2284609079360962f,0.14127975702285767f,-0.1274729073047638f,-0.6219204664230347f,-0.3406560719013214f,0.26510030031204224f,0.04862070083618164f,-0.10759569704532623f,0.15142720937728882f},
    {-0.14657218754291534f,-0.34830769896507263f,-0.044384635984897614f,0.09097779542207718f,0.29299843311309814f,0.20048391819000244f,-0.3669555187225342f,0.577765166759491f,0.26391828060150146f,-0.6116664409637451f,-0.48967164754867554f,0.43264442682266235f,-0.2875143885612488f,0.20838868618011475f,0.4987501800060272f,-0.12150795757770538f},
    {-0.36621227860450745f,-0.5775251388549805f,0.25328558683395386f,-0.4689198136329651f,0.48624423146247864f,0.1806947886943817f,-0.02977663278579712f,0.46608680486679077f,-0.3409912884235382f,0.09726854413747787f,-0.5142548680305481f,0.39275670051574707f,-0.05826932191848755f,-0.1345062553882599f,0.35789212584495544f,-0.3863421678543091f},
    {-0.4689311385154724f,-0.5520263910293579f,0.11156318336725235f,-0.4460775554180145f,0.477514386177063f,-0.06286724656820297f,-0.20234209299087524f,-0.023230334743857384f,-0.39478203654289246f,0.22159633040428162f,-0.4476903975009918f,0.38044995069503784f,-0.17981481552124023f,0.2829986810684204f,0.041659221053123474f,0.010006793774664402f},
    {0.07658018171787262f,-0.13551065325737f,-0.04930756241083145f,-0.18194161355495453f,-0.30434608459472656f,-0.3774596154689789f,0.030568987131118774f,0.45075833797454834f,-0.34993308782577515f,0.00814745482057333f,0.271629273891449f,0.2641938328742981f,0.3928338885307312f,0.3520948886871338f,0.2681606411933899f,0.04452916979789734f},
    {0.1398475617170334f,-0.30324965715408325f,0.23745456337928772f,0.3544830083847046f,0.28628432750701904f,0.1924915313720703f,0.031466126441955566f,-0.05242495983839035f,-0.003589123487472534f,0.019043268635869026f,0.15009407699108124f,-0.33466243743896484f,-0.30160367488861084f,-0.2585424780845642f,-0.03835311904549599f,-0.620620608329773f},
    {0.7865412831306458f,0.34918898344039917f,-0.1276814490556717f,-0.7611914873123169f,0.07091358304023743f,-0.3924251198768616f,-0.030166536569595337f,0.13422253727912903f,0.3674931526184082f,-0.10135196149349213f,-0.21664942800998688f,0.23833078145980835f,-0.27123963832855225f,-0.08386284112930298f,-0.01957280933856964f,0.8007774353027344f},
    {0.6253918409347534f,0.3427291512489319f,0.2446969449520111f,-0.5424080491065979f,-0.4171082675457001f,-0.1339646875858307f,0.08264404535293579f,0.20667369663715363f,-0.16528040170669556f,0.10038857161998749f,0.2882964611053467f,0.19816702604293823f,0.37595224380493164f,-0.2227029651403427f,-0.20252738893032074f,0.4010050594806671f},
    {-0.10320301353931427f,-0.0669734925031662f,-0.3952587842941284f,0.014424772933125496f,0.06123732402920723f,0.12584073841571808f,-0.15519720315933228f,-0.12384038418531418f,0.20291584730148315f,-0.013697299174964428f,0.34133532643318176f,-0.1940154880285263f,-0.2515442967414856f,-0.23373761773109436f,-0.3340805768966675f,-0.005585795734077692f},
    {0.21723592281341553f,-0.3871166408061981f,-0.6769354343414307f,0.013060376048088074f,-0.3935699462890625f,-0.13699966669082642f,0.20312511920928955f,-0.24272094666957855f,0.28880298137664795f,0.012722134590148926f,0.6101362109184265f,0.1407831907272339f,-0.4085739254951477f,0.014354228973388672f,0.2012835443019867f,-0.41867175698280334f},
    {-0.348349392414093f,0.10514415800571442f,-0.29263970255851746f,0.14298589527606964f,-0.4824093282222748f,-0.16298454999923706f,-0.3280268609523773f,-0.14835195243358612f,-0.3790266811847687f,0.12452945858240128f,0.09102929383516312f,-0.017614006996154785f,-0.18276402354240417f,0.21967029571533203f,0.18263429403305054f,0.12917377054691315f},
    {-0.16717736423015594f,0.3654094338417053f,0.22285446524620056f,-0.2079508751630783f,0.15254132449626923f,-0.428370863199234f,0.12378334999084473f,0.042758338153362274f,-0.23888027667999268f,0.015105051919817924f,-0.03244645148515701f,0.07999944686889648f,-0.19709044694900513f,0.3904615044593811f,0.3818567395210266f,-0.1811094582080841f},
    {0.44972071051597595f,-0.028732342645525932f,-0.12203003466129303f,-0.16853941977024078f,-0.002657646546140313f,-0.27321964502334595f,-0.39909395575523376f,-0.22719086706638336f,-0.04522088170051575f,0.39755183458328247f,0.26120442152023315f,0.2014879584312439f,0.2502625584602356f,-0.049918800592422485f,-0.2698128819465637f,-0.39346325397491455f},
    {0.18112419545650482f,-0.0779980793595314f,-0.45121440291404724f,-0.5473600029945374f,-0.5366666913032532f,0.18330438435077667f,0.1997523307800293f,-0.09354571998119354f,-0.12511596083641052f,0.48358815908432007f,-0.172188401222229f,0.41015303134918213f,-0.3052411675453186f,-0.1892547309398651f,0.2224881649017334f,-0.10170229524374008f},
    {0.10940403491258621f,-0.23863136768341064f,-0.6232994794845581f,0.16091983020305634f,-0.304459810256958f,0.2962200939655304f,0.18491721153259277f,0.01318122074007988f,0.18640142679214478f,0.13724061846733093f,0.24989944696426392f,0.35947704315185547f,-0.332058310508728f,0.40907591581344604f,-0.28181812167167664f,-0.16143277287483215f},
};

const float h2[16][16] = {
    {0.04833245277404785f,0.8406158089637756f,0.3808237612247467f,0.3637321889400482f,0.644477128982544f,0.35276496410369873f,-1.0592999458312988f,-0.44195684790611267f,-2.155895948410034f,0.42358145117759705f,0.21362772583961487f,0.046894848346710205f,0.1278792917728424f,-0.37168267369270325f,0.04797150567173958f,0.41920337080955505f},
    {-0.0274239182472229f,0.9419358372688293f,-0.34082740545272827f,0.2642888128757477f,0.7276898622512817f,0.002614683471620083f,-1.1622995138168335f,0.30911850929260254f,-0.6000240445137024f,0.026576727628707886f,-0.29539918899536133f,-0.20509253442287445f,-0.1801471710205078f,-0.5503743290901184f,-0.09623444825410843f,0.16039973497390747f},
    {-0.35354936122894287f,-0.09730152785778046f,-0.24224385619163513f,-0.41592511534690857f,0.07027829438447952f,0.013607672415673733f,0.22128823399543762f,-0.10003288835287094f,-1.014364242553711f,-0.26868098974227905f,0.21410873532295227f,-0.228165864944458f,-0.05225086212158203f,-0.7968334555625916f,0.25415247678756714f,0.2862052619457245f},
    {-0.11117833852767944f,0.46299421787261963f,0.11902371048927307f,0.35618194937705994f,0.15819178521633148f,-0.5194926261901855f,-0.1352825164794922f,0.4493905305862427f,-0.4192030429840088f,-0.4216589629650116f,-0.4289160966873169f,-0.3305668830871582f,0.43245211243629456f,-0.18652261793613434f,-0.4980774223804474f,0.2913265824317932f},
    {0.39269885420799255f,-0.17476780712604523f,-0.07237827777862549f,0.09812912344932556f,-0.33486536145210266f,-0.47770196199417114f,0.9116359949111938f,0.20927821099758148f,0.6805155873298645f,-0.08264759182929993f,-0.15345615148544312f,0.3926151692867279f,-0.28366416692733765f,0.9803341031074524f,-0.7951028943061829f,-0.38231852650642395f},
    {-0.02339586615562439f,-0.21557484567165375f,0.0382651686668396f,-0.10381102561950684f,0.20424866676330566f,0.0569344200193882f,-0.15795065462589264f,-0.2686183750629425f,0.02425282634794712f,0.2855292856693268f,0.3241807520389557f,0.08525893092155457f,-0.07454681396484375f,-0.3016861081123352f,0.30999064445495605f,-0.2047392874956131f},
    {0.06456553936004639f,-0.29620951414108276f,-0.28450071811676025f,-0.3608437776565552f,0.14704784750938416f,-0.36015424132347107f,-0.315707266330719f,-0.2272750288248062f,-0.16718602180480957f,-0.3622615337371826f,0.3609362542629242f,0.3271537125110626f,-0.1134117841720581f,-0.24684466421604156f,-0.3105827271938324f,-0.29518258571624756f},
    {0.40061601996421814f,-0.2499115914106369f,-0.42576566338539124f,0.2771916687488556f,0.1725580394268036f,0.24982130527496338f,0.032843999564647675f,-0.13448423147201538f,-0.30728211998939514f,-0.24666368961334229f,0.034479737281799316f,0.11201921105384827f,-0.3116337060928345f,0.20088200271129608f,0.07602878659963608f,-0.32380038499832153f},
    {0.01738646626472473f,0.42550787329673767f,0.16973963379859924f,-0.19240723550319672f,-0.03196948766708374f,-0.12532320618629456f,-0.1082024872303009f,0.3715610206127167f,-0.23925665020942688f,0.15291878581047058f,0.21075895428657532f,-0.06213498115539551f,0.41508081555366516f,-0.27582913637161255f,0.06960871815681458f,-0.020523756742477417f},
    {0.2798302471637726f,0.3964071571826935f,0.23923692107200623f,0.1867220103740692f,-0.3472009599208832f,-0.4335924983024597f,-0.35373935103416443f,0.16244973242282867f,-0.7462126612663269f,-0.2594975531101227f,-0.315661758184433f,-0.2793809175491333f,0.27418074011802673f,-0.10312201827764511f,0.4119209051132202f,-0.05471741408109665f},
    {-0.14383485913276672f,1.081695318222046f,-0.404108464717865f,-0.22689129412174225f,-0.3717469274997711f,-0.41622504591941833f,-0.8190008401870728f,0.5285307168960571f,-3.050868034362793f,-0.16521230340003967f,-0.0948835015296936f,-0.3281487226486206f,-0.32793286442756653f,-1.8892099857330322f,-0.8883360028266907f,-0.44808080792427063f},
    {-0.3993529975414276f,0.41353103518486023f,0.2625258266925812f,-0.40873271226882935f,0.3280826508998871f,0.10209885239601135f,0.22779449820518494f,0.27592143416404724f,-0.24499990046024323f,0.11430332064628601f,0.1062566339969635f,-0.3577694296836853f,-0.05476459860801697f,0.17576757073402405f,0.21356281638145447f,-0.21355248987674713f},
    {0.26238974928855896f,0.13264122605323792f,0.17779704928398132f,0.3172527849674225f,-0.07196182012557983f,0.3440147936344147f,-0.20966216921806335f,0.19133642315864563f,-0.40352103114128113f,-0.01865154504776001f,0.4056650698184967f,0.4148031175136566f,-0.3938596844673157f,-0.15683236718177795f,-0.2691075801849365f,-0.31552961468696594f},
    {0.04255214333534241f,-0.10101297497749329f,-0.20923052728176117f,0.2541695535182953f,0.41217753291130066f,-0.301749050617218f,0.16364464163780212f,-0.16757863759994507f,-0.33475184440612793f,-0.3079894781112671f,-0.15280935168266296f,-0.3279605209827423f,-0.21071602404117584f,-0.09943103790283203f,0.25322189927101135f,-0.047403186559677124f},
    {-0.3407605290412903f,-1.6339330673217773f,-0.08496147394180298f,0.18828937411308289f,-1.2263431549072266f,-1.4933935403823853f,1.361119031906128f,1.3889564275741577f,1.7450194358825684f,0.3321857750415802f,0.10198095440864563f,0.14103266596794128f,0.07074931263923645f,1.626432180404663f,-1.5846821069717407f,-1.6313681602478027f},
    {-0.430133581161499f,2.0306808948516846f,0.3826504647731781f,0.4254762828350067f,1.4177906513214111f,0.9060602188110352f,-2.047635793685913f,-0.610949695110321f,-4.190510272979736f,-0.26547297835350037f,0.17560508847236633f,0.4241798222064972f,-0.07467690110206604f,-3.596113681793213f,0.9893742203712463f,1.3326054811477661f},
};

const float h3[16][16] = {
    {0.37046024203300476f,0.04798617959022522f,0.392690509557724f,-0.20555028319358826f,-0.04246211051940918f,-0.37363746762275696f,0.015186339616775513f,-0.061466217041015625f,-0.13781791925430298f,-0.11356508731842041f,0.30632129311561584f,-0.03401225805282593f,0.14026448130607605f,-0.41080594062805176f,-0.021881461143493652f,-0.1677863597869873f},
    {-0.21526779234409332f,-1.1129813194274902f,-0.12068668007850647f,0.09446603804826736f,-0.015299053862690926f,0.23865419626235962f,-0.16593411564826965f,-1.1282691955566406f,-0.2572314739227295f,0.025441110134124756f,0.08321377635002136f,-0.22488360106945038f,0.10835165530443192f,0.01774216815829277f,-0.05000334233045578f,-0.3466002941131592f},
    {-0.08673667907714844f,0.23056277632713318f,0.42949649691581726f,-0.3032870888710022f,0.4159357249736786f,0.03299093246459961f,-0.035138070583343506f,0.00458759069442749f,-0.2919609248638153f,0.13052961230278015f,-0.09829097986221313f,-0.24485144019126892f,0.3602481186389923f,0.3898719251155853f,-0.0538104772567749f,0.07017943263053894f},
    {0.2464427649974823f,0.39936527609825134f,0.21032699942588806f,-0.2072734385728836f,0.19923558831214905f,0.2847035825252533f,-0.22418056428432465f,-0.43023446202278137f,-0.21198244392871857f,0.23950514197349548f,-0.3551802337169647f,0.11705091595649719f,0.18541833758354187f,-0.023748815059661865f,0.1462016999721527f,-0.08909019827842712f},
    {0.34622398018836975f,-1.2129888534545898f,-0.20742447674274445f,-0.032929010689258575f,0.08672287315130234f,-0.08068259805440903f,0.45541882514953613f,-2.018517017364502f,0.10944971442222595f,0.04921719431877136f,-0.20607680082321167f,0.21179592609405518f,0.4078998863697052f,0.09382607787847519f,-0.6051720380783081f,-0.19378763437271118f},
    {0.07416597008705139f,-0.1509564220905304f,-0.3286089599132538f,0.2575420141220093f,-0.32409292459487915f,-0.04360950365662575f,-0.05032980069518089f,0.03308649733662605f,-0.14956387877464294f,0.06287035346031189f,-0.18942220509052277f,-0.22120867669582367f,0.36484384536743164f,0.34050697088241577f,0.033385224640369415f,0.028106003999710083f},
    {-0.24521887302398682f,0.3061828017234802f,-0.09969070553779602f,-0.835078239440918f,-1.1966766119003296f,0.7502152919769287f,-0.6856613159179688f,0.31733009219169617f,0.16320112347602844f,-0.08684051036834717f,-0.3433442711830139f,-0.3093454837799072f,-0.3787883520126343f,-0.6157321929931641f,0.27898073196411133f,-0.3274548649787903f},
    {-0.037380099296569824f,-0.053829364478588104f,-0.23550507426261902f,-0.32296717166900635f,0.1419943869113922f,0.3212539851665497f,-0.5291021466255188f,-0.3196764588356018f,0.23772326111793518f,-0.15706628561019897f,-0.03474658727645874f,-0.42883461713790894f,-0.43303486704826355f,-0.46498894691467285f,0.23065359890460968f,-0.06882688403129578f},
    {0.22414228320121765f,0.6167948842048645f,0.17398694157600403f,-1.2930227518081665f,-0.07601547241210938f,1.1093199253082275f,-0.4207235872745514f,0.2633194625377655f,-0.16447538137435913f,0.31832489371299744f,-0.01876583695411682f,0.425087034702301f,-1.1076250076293945f,0.1036156564950943f,-0.3688891530036926f,-0.37546294927597046f},
    {-0.37478217482566833f,-0.10878506302833557f,-0.33313462138175964f,0.08732470870018005f,-0.4272407591342926f,0.42993465065956116f,-0.3373659551143646f,-0.1347610354423523f,0.27883973717689514f,0.15846404433250427f,0.23034706711769104f,0.2679099142551422f,0.26554760336875916f,-0.39576658606529236f,0.27645888924598694f,0.3027357757091522f},
    {0.01714116334915161f,-0.41286614537239075f,-0.30441972613334656f,0.09042176604270935f,0.305792897939682f,0.25930657982826233f,-0.0077957212924957275f,0.2839451730251312f,0.06527414917945862f,0.30544695258140564f,-0.3269312381744385f,-0.23118992149829865f,-0.36912286281585693f,0.18185165524482727f,0.06934896111488342f,0.20831605792045593f},
    {-0.16316500306129456f,0.09996911883354187f,-0.11835616827011108f,0.22180476784706116f,0.2730047404766083f,-0.39772462844848633f,0.3122676908969879f,0.025347262620925903f,-0.0864812433719635f,-0.2908649444580078f,0.05068853497505188f,-0.23324716091156006f,-0.27006956934928894f,0.3646886646747589f,-0.22474992275238037f,0.03918728232383728f},
    {-0.2255314439535141f,0.0861915647983551f,-0.37378355860710144f,0.09740594029426575f,-0.17835164070129395f,-0.28151828050613403f,0.08090576529502869f,0.27042338252067566f,0.10048076510429382f,0.3275263011455536f,0.3301452696323395f,-0.33213010430336f,0.18207183480262756f,0.224577397108078f,-0.2358287274837494f,0.16939416527748108f},
    {0.18313375115394592f,3.035151958465576f,0.15208670496940613f,-2.073854684829712f,0.9186175465583801f,0.35607829689979553f,-1.5632147789001465f,-0.4666653871536255f,-0.15266752243041992f,-0.3787156641483307f,-0.23417361080646515f,0.41418468952178955f,-2.05690336227417f,-2.3053674697875977f,-0.29849734902381897f,-0.3566729426383972f},
    {0.19047978520393372f,0.24750559031963348f,-0.1217426061630249f,0.5728633403778076f,-0.08453264087438583f,0.24713492393493652f,0.41920486092567444f,0.4218023419380188f,-0.27937382459640503f,0.06346243619918823f,-0.3896019458770752f,0.36481839418411255f,0.7093786597251892f,-0.09001748263835907f,-0.4630468785762787f,-0.3792039752006531f},
    {-0.3329339325428009f,-0.4124312996864319f,-0.00382271409034729f,0.05026526004076004f,-0.49761754274368286f,0.3193882703781128f,0.4324275553226471f,-0.7607815861701965f,-0.3335152566432953f,0.10636988282203674f,0.262630432844162f,-0.17788830399513245f,0.3869096338748932f,0.1590534746646881f,-0.16216763854026794f,-0.017990201711654663f},
};

const float hout[16] = { 0.28352612257003784f,7.027318000793457f,0.20054447650909424f,-1.0949580669403076f,-0.5842559933662415f,0.2186238020658493f,-1.2922117710113525f,2.97406268119812f,0.3234240412712097f,-0.5405333638191223f,-0.04778480529785156f,0.04107429087162018f,-1.542391300201416f,-0.6290411949157715f,0.531202495098114f,-0.49622899293899536f };

const float b1[16] = { -0.023235002532601357f,1.8784174919128418f,1.2490769624710083f,1.8262481689453125f,-0.7069734334945679f,0.3653741180896759f,-2.117748498916626f,0.10555768758058548f,-0.2616904079914093f,0.9018311500549316f,1.0800175666809082f,-2.6183178424835205f,-1.0385421514511108f,-0.8662141561508179f,-0.949005663394928f,0.9264617562294006f };

const float b2[16] = { -1.3552442789077759f,0.2431674301624298f,0.09128525853157043f,-1.9293867349624634f,0.07398243993520737f,1.9222168922424316f,1.02919340133667f,0.9952839016914368f,1.659902811050415f,-1.3622498512268066f,0.16149760782718658f,-0.7032756209373474f,-0.3943362534046173f,0.033961519598960876f,0.5282865166664124f,1.0235947370529175f };

const float b3[16] = { -1.2821701765060425f,0.5424966812133789f,-2.4415693283081055f,-0.10150174796581268f,1.364449381828308f,1.4641811847686768f,0.3352581560611725f,0.6453125476837158f,-0.42281195521354675f,-0.8339861035346985f,-1.7887413501739502f,0.39875528216362f,-1.0230937004089355f,-0.40120580792427063f,-0.31424298882484436f,-0.0870584174990654f };

const float bout[1] = { 1.0808764696121216f };

float valve_ref_pos_buffer[10] = {0.0f};

/////////////////////////////////////////////////////////////////////////////////////////////RL
float input_RL[num_input_RL] = { 0.0f };

//Critic Networks
float hc1[num_input_RL][num_hidden_unit1] = {0.0f};
float bc1[num_hidden_unit1] = {0.0f};
float hc2[num_hidden_unit1][num_hidden_unit2] = {0.0f};
float bc2[num_hidden_unit2] = {0.0f};
float hc3[num_hidden_unit2] = {0.0f};
float bc3 = 0.0f;

//Critic Networks Temporary
float hc1_temp[num_input_RL][num_hidden_unit1] = {0.0f};
float bc1_temp[num_hidden_unit1] = {0.0f};
float hc2_temp[num_hidden_unit1][num_hidden_unit2] = {0.0f};
float bc2_temp[num_hidden_unit2] = {0.0f};
float hc3_temp[num_hidden_unit2] = {0.0f};
float bc3_temp = 0.0f;

//Actor Networks
float ha1[num_input_RL][num_hidden_unit1] = {0.0f};
float ba1[num_hidden_unit1] = {0.0f};
float ha2[num_hidden_unit1][num_hidden_unit2] = {0.0f};
float ba2[num_hidden_unit2] = {0.0f};
float ha3[num_hidden_unit2][2] = {0.0f};
float ba3[2] = {0.0f};

//Actor Networks Temporary
float ha1_temp[num_input_RL][num_hidden_unit1] = {0.0f};
float ba1_temp[num_hidden_unit1] = {0.0f};
float ha2_temp[num_hidden_unit1][num_hidden_unit2] = {0.0f};
float ba2_temp[num_hidden_unit2] = {0.0f};
float ha3_temp[num_hidden_unit2][2] = {0.0f};
float ba3_temp[2] = {0.0f};

float VALVE_POS_RAW_NN = 0.0f;
float DDV_JOINT_POS_FF(float REF_JOINT_VEL);

/////////////////////////////////////////////RL tuning
float Gradient_Limit = 0.5f;
float gradient_rate_actor = 0.001f;
float gradient_rate_critic = 0.001f;
//////////////////////////////////////////////////////////////////////////////

float Critic_Network_Temp(float *arr)
{
    float output1[num_hidden_unit1] = { 0.0f };
    float output2[num_hidden_unit2] = { 0.0f };
    float output = 0.0f;
    for (int index2 = 0; index2 < num_hidden_unit1; index2++) {
        for (int index1 = 0; index1 < num_input_RL; index1++) {
            output1[index2] = output1[index2] + hc1_temp[index1][index2] * arr[index1];
        }
        //ReLU
        output1[index2] = output1[index2] + bc1_temp[index2];
        hx_c_sum[index2] = output1[index2];
        if (output1[index2] < 0) {
            output1[index2] = 0;
        }
        //tanh
        //output1[index2] = tanh(output1[index2] + bc1_temp[index2]);
    }
    for (int index2 = 0; index2 < num_hidden_unit2; index2++) {
        for (int index1 = 0; index1 < num_hidden_unit1; index1++) {
            output2[index2] = output2[index2] + hc2_temp[index1][index2] * output1[index1];
        }
        //ReLU
        output2[index2] = output2[index2] + bc2_temp[index2];
        hxh_c_sum[index2] = output2[index2];
        if (output2[index2] < 0) {
            output2[index2] = 0;
        }
        //tanh
        //output2[index2] = tanh(output2[index2] + bc2_temp[index2]);
    }
    for (int index2 = 0; index2 < 1; index2++) {
        for (int index1 = 0; index1 < num_hidden_unit2; index1++) {
            output = output + hc3_temp[index1] * output2[index1];
        }
        output = output + bc3_temp;
        hxhh_c_sum = output;
    }
    return output;
}


void Actor_Network(float *arr)
{
    float output1[num_hidden_unit1] = {0.0f};
    float output2[num_hidden_unit2] = {0.0f};
    float output[2] = {0.0f};

    for (int index2 = 0; index2 < num_hidden_unit1; index2++) {
        for (int index1 = 0; index1 < num_input_RL; index1++) {
            output1[index2] = output1[index2] + ha1_temp[index1][index2] * arr[index1];
        }
        output1[index2] = output1[index2] + ba1_temp[index2];
        hx_a_sum[index2] = output1[index2];
        if (output1[index2] < 0) {
            output1[index2] = 0;
        }
    }
    for (int index2 = 0; index2 < num_hidden_unit2; index2++) {
        for (int index1 = 0; index1 < num_hidden_unit1; index1++) {
            output2[index2] = output2[index2] + ha2_temp[index1][index2] * output1[index1];
        }
        output2[index2] = output2[index2] + ba2_temp[index2];
        hxh_a_sum[index2] = output2[index2];
        if (output2[index2] < 0) {
            output2[index2] = 0;
        }
    }
    for (int index2 = 0; index2 < 2; index2++) {
        for (int index1 = 0; index1 < num_hidden_unit2; index1++) {
            output[index2] = output[index2] + ha3_temp[index1][index2] * output2[index1];
        }
        hxhh_a_sum[index2] = output[index2] + ba3_temp[index2];
    }

    mean_before_SP = output[0] + ba3_temp[0];    //SP = softplus
    deviation_before_SP = output[1] + ba3_temp[1];
    //Softplus
    mean = log(1.0f+exp(mean_before_SP));
    deviation = log(1.0f+exp(deviation_before_SP));
    logging2 = mean;
    logging4 = deviation;
}


void Actor_Network_Old(float *arr)
{
    float output1[num_hidden_unit1] = {0.0f};
    float output2[num_hidden_unit2] = {0.0f};
    float output[2] = {0.0f};

    for (int index2 = 0; index2 < num_hidden_unit1; index2++) {
        for (int index1 = 0; index1 < num_input_RL; index1++) {
            output1[index2] = output1[index2] + ha1[index1][index2] * arr[index1];
        }
        output1[index2] = output1[index2] + ba1[index2];
        if (output1[index2] < 0) {
            output1[index2] = 0;
        }
    }
    for (int index2 = 0; index2 < num_hidden_unit2; index2++) {
        for (int index1 = 0; index1 < num_hidden_unit1; index1++) {
            output2[index2] = output2[index2] + ha2[index1][index2] * output1[index1];
        }
        output2[index2] = output2[index2] + ba2[index2];
        if (output2[index2] < 0) {
            output2[index2] = 0;
        }
    }
    for (int index2 = 0; index2 < 2; index2++) {
        for (int index1 = 0; index1 < num_hidden_unit2; index1++) {
            output[index2] = output[index2] + ha3[index1][index2] * output2[index1];
        }
    }
    mean_old = output[0] + ba3[0];
    deviation_old = output[1] + ba3[1];
    //Softplus
    mean_old = log(1.0f+exp(mean_old));
    deviation_old = log(1.0f+exp(deviation_old));
}

float Grad_Normal_Dist_Mean(float mean, float deviation, float action)
{
    float grad_mean = 0.0f;
    grad_mean = (action-mean)*exp(-(action-mean)*(action-mean)/(2.0f*deviation*deviation))/(sqrt(2.0f*PI)*deviation*deviation*deviation);
    return grad_mean;
}

float Grad_Normal_Dist_Deviation(float mean, float deviation, float action)
{
    float grad_dev = 0.0f;
    grad_dev = exp(-(action-mean)*(action-mean)/(2.0f*deviation*deviation))*(-1.0f/(sqrt(2.0f*PI)*deviation*deviation) + (action-mean)*(action-mean)/(sqrt(2.0f*PI)*deviation*deviation*deviation*deviation));
    return grad_dev;
}

float ReLU(float x)
{
    if (x >= 0) {
        return x;
    } else {
        return 0.0f;
    }
}

void update_Critic_Networks(float (*arr)[num_input_RL])
{
    float G_hc1[num_input_RL][num_hidden_unit1] = {0.0f};
    float G_bc1[num_hidden_unit1] = {0.0f};
    for (int index2 = 0; index2 < num_hidden_unit1; index2++) {
        for (int index1 = 0; index1 < num_input_RL; index1++) {
            for (int n=0; n<batch_size; n++) {
                float d_V_d_hc1 = 0.0f;
                for(int k=0; k<num_hidden_unit2; k++) {
                    if (hxh_c_sum_array[n][k] >= 0) {
                        if (hx_c_sum_array[n][index2] > 0) {
                            d_V_d_hc1 = d_V_d_hc1 + arr[n][index1]*hc2_temp[index2][k]*hc3_temp[k];
                        }
                    }
                }
                G_hc1[index1][index2] = G_hc1[index1][index2] + 2.0f*(return_G[n]-V[n])*(-d_V_d_hc1);
            }
            G_hc1[index1][index2] = G_hc1[index1][index2] / batch_size;
            if(G_hc1[index1][index2] > Gradient_Limit) G_hc1[index1][index2] = Gradient_Limit;
            else if (G_hc1[index1][index2] < -Gradient_Limit) G_hc1[index1][index2] = -Gradient_Limit;
            //hc1_temp[index1][index2] = hc1_temp[index1][index2] - gradient_rate_critic * G_hc1[index1][index2];
        }
        for (int n=0; n<batch_size; n++) {
            float d_V_d_bc1 = 0.0f;
            for(int k=0; k<num_hidden_unit2; k++) {
                if (hxh_c_sum_array[n][k] >= 0) {
                    if (hx_c_sum_array[n][index2] > 0) {
                        d_V_d_bc1 = d_V_d_bc1 + hc2_temp[index2][k]*hc3_temp[k];
                    }
                }
            }
            G_bc1[index2] = G_bc1[index2] + 2.0f*(return_G[n]-V[n])*(-d_V_d_bc1);
        }
        G_bc1[index2] = G_bc1[index2] / batch_size;
        if(G_bc1[index2] > Gradient_Limit) G_bc1[index2] = Gradient_Limit;
        else if (G_bc1[index2] < -Gradient_Limit) G_bc1[index2] = -Gradient_Limit;
        //bc1_temp[index2] = bc1_temp[index2] - gradient_rate_critic * G_bc1[index2];
    }


    float G_hc2[num_hidden_unit1][num_hidden_unit2] = {0.0f};
    float G_bc2[num_hidden_unit2] = {0.0f};
    for (int index2 = 0; index2 < num_hidden_unit2; index2++) {
        for (int index1 = 0; index1 < num_hidden_unit1; index1++) {
            for (int n=0; n<batch_size; n++) {
                float d_V_d_hc2 = 0.0f;
                if (hxh_c_sum_array[n][index2] >= 0) {
                    if (hx_c_sum_array[n][index1] > 0) {
                        d_V_d_hc2 = hx_c_sum_array[n][index1]*hc3_temp[index2];
                    }
                }
                G_hc2[index1][index2] = G_hc2[index1][index2] + 2.0f*(return_G[n]-V[n])*(-d_V_d_hc2);
            }
            G_hc2[index1][index2] = G_hc2[index1][index2] / batch_size;
            if(G_hc2[index1][index2] > Gradient_Limit) G_hc2[index1][index2] = Gradient_Limit;
            else if (G_hc2[index1][index2] < -Gradient_Limit) G_hc2[index1][index2] = -Gradient_Limit;
            //hc2_temp[index1][index2] = hc2_temp[index1][index2] - gradient_rate_critic * G_hc2[index1][index2];
        }
        for (int n=0; n<batch_size; n++) {
            float d_V_d_bc2 = 0.0f;
            if (hxh_c_sum_array[n][index2] >= 0) {
                d_V_d_bc2 = hc3_temp[index2];
            }
            G_bc2[index2] = G_bc2[index2] + 2.0f*(return_G[n]-V[n])*(-d_V_d_bc2);
        }
        G_bc2[index2] = G_bc2[index2] / batch_size;
        if(G_bc2[index2] > Gradient_Limit) G_bc2[index2] = Gradient_Limit;
        else if (G_bc2[index2] < -Gradient_Limit) G_bc2[index2] = -Gradient_Limit;
        //bc2_temp[index2] = bc2_temp[index2] - gradient_rate_critic * G_bc2[index2];
    }

    float G_hc3[num_hidden_unit2]= {0.0f};
    float G_bc3 = 0.0f;
    for (int index2 = 0; index2 < 1; index2++) {
        for (int index1 = 0; index1 < num_hidden_unit2; index1++) {
            for (int n=0; n<batch_size; n++) {
                float d_V_d_hc3 = 0.0f;
                if (hxh_c_sum_array[n][index1] >= 0) {
                    d_V_d_hc3 = d_V_d_hc3 + hxh_c_sum_array[n][index1];
                }
                G_hc3[index1] = G_hc3[index1] + 2.0f*(return_G[n]-V[n])*(-d_V_d_hc3);
            }
            G_hc3[index1] = G_hc3[index1] / batch_size;
            if(G_hc3[index1] > Gradient_Limit) G_hc3[index1] = Gradient_Limit;
            else if (G_hc3[index1] < -Gradient_Limit) G_hc3[index1] = -Gradient_Limit;
            //hc3_temp[index1] = hc3_temp[index1] - gradient_rate_critic * G_hc3[index1];
        }
        for (int n=0; n<batch_size; n++) {
            float d_V_d_bc3 = 0.0f;
            d_V_d_bc3 = 1.0f;
            G_bc3 = G_bc3 + 2.0f*(return_G[n]-V[n])*(-d_V_d_bc3);
        }
        G_bc3 = G_bc3 / batch_size;
        if(G_bc3 > Gradient_Limit) G_bc3 = Gradient_Limit;
        else if (G_bc3 < -Gradient_Limit) G_bc3 = -Gradient_Limit;
        //bc3_temp = bc3_temp - gradient_rate_critic * G_bc3;
    }

    // Simultaneous Update
    for (int index2 = 0; index2 < num_hidden_unit1; index2++) {
        for (int index1 = 0; index1 < num_input_RL; index1++) {
            hc1_temp[index1][index2] = hc1_temp[index1][index2] - gradient_rate_critic * G_hc1[index1][index2];
        }
        bc1_temp[index2] = bc1_temp[index2] - gradient_rate_critic * G_bc1[index2];
    }
    for (int index2 = 0; index2 < num_hidden_unit2; index2++) {
        for (int index1 = 0; index1 < num_hidden_unit1; index1++) {
            hc2_temp[index1][index2] = hc2_temp[index1][index2] - gradient_rate_critic * G_hc2[index1][index2];
        }
        bc2_temp[index2] = bc2_temp[index2] - gradient_rate_critic * G_bc2[index2];
    }
    for (int index2 = 0; index2 < 1; index2++) {
        for (int index1 = 0; index1 < num_hidden_unit2; index1++) {
            hc3_temp[index1] = hc3_temp[index1] - gradient_rate_critic * G_hc3[index1];
        }
        bc3_temp = bc3_temp - gradient_rate_critic * G_bc3;
    }
}

///////////////////////////Softplus//////////////////////////////////
void update_Actor_Networks(float (*arr)[num_input_RL])
{


    float G_ha1[num_input_RL][num_hidden_unit1] = {0.0f};
    float G_ba1[num_hidden_unit1] = {0.0f};

    for (int index2 = 0; index2 < num_hidden_unit1; index2++) {
        for (int index1 = 0; index1 < num_input_RL; index1++) {
            for (int n=0; n<batch_size; n++) {
                float d_x_d_ha1 = 0.0f;
                float d_y_d_ha1 = 0.0f;
                if((advantage[n] >= 0.0f && ratio[n] >= 1.0f + epsilon) || (advantage[n] < 0.0f && ratio[n] < 1.0f - epsilon)) {
                    G_ha1[index1][index2] = G_ha1[index1][index2];
                } else {
                    for(int k=0; k<num_hidden_unit2; k++) {
                        if (hxh_a_sum_array[n][k] >= 0) {
                            if (hx_a_sum_array[n][index2] > 0) {
                                d_x_d_ha1 = d_x_d_ha1 + arr[n][index1]*ha2_temp[index2][k]*ha3_temp[k][0];
                                d_y_d_ha1 = d_y_d_ha1 + arr[n][index1]*ha2_temp[index2][k]*ha3_temp[k][1];
                            }
                        }
                    }
                    float d_mean_d_ha1 = 0.0f;
                    float d_dev_d_ha1 = 0.0f;
                    d_mean_d_ha1 = exp(hxhh_a_sum_array[n][0])/(1.0f+exp(hxhh_a_sum_array[n][0]))*d_x_d_ha1;
                    d_dev_d_ha1 = exp(hxhh_a_sum_array[n][1])/(1.0f+exp(hxhh_a_sum_array[n][1]))*d_y_d_ha1;

                    G_ha1[index1][index2] = G_ha1[index1][index2] + advantage[n]/pi_old[n]*(d_mean_d_ha1*Grad_Normal_Dist_Mean(mean_array[n],deviation_array[n],action_array[n])+d_dev_d_ha1*Grad_Normal_Dist_Deviation(mean_array[n],deviation_array[n],action_array[n]));
                }
            }
            G_ha1[index1][index2] = -G_ha1[index1][index2] / batch_size;
            if(G_ha1[index1][index2] > Gradient_Limit) G_ha1[index1][index2] = Gradient_Limit;
            else if (G_ha1[index1][index2] < -Gradient_Limit) G_ha1[index1][index2] = -Gradient_Limit;
            //ha1_temp[index1][index2] = ha1_temp[index1][index2] - gradient_rate_actor * G_ha1[index1][index2];
        }

        for (int n=0; n<batch_size; n++) {
            float d_x_d_ba1 = 0.0f;
            float d_y_d_ba1 = 0.0f;
            if((advantage[n] >= 0.0f && ratio[n] >= 1.0f + epsilon) || (advantage[n] < 0.0f && ratio[n] < 1.0f - epsilon))  {
                G_ba1[index2] = G_ba1[index2];
            } else {
                for(int k=0; k<num_hidden_unit2; k++) {
                    if (hxh_a_sum_array[n][k] >= 0) {
                        if (hx_a_sum_array[n][index2] > 0) {
                            d_x_d_ba1 = d_x_d_ba1 + ha2_temp[index2][k]*ha3_temp[k][0];
                            d_y_d_ba1 = d_y_d_ba1 + ha2_temp[index2][k]*ha3_temp[k][1];
                        }
                    }
                }
                float d_mean_d_ba1 = 0.0f;
                float d_dev_d_ba1 = 0.0f;
                d_mean_d_ba1 = exp(hxhh_a_sum_array[n][0])/(1.0f+exp(hxhh_a_sum_array[n][0]))*d_x_d_ba1;
                d_dev_d_ba1 = exp(hxhh_a_sum_array[n][1])/(1.0f+exp(hxhh_a_sum_array[n][1]))*d_y_d_ba1;

                G_ba1[index2] = G_ba1[index2] + advantage[n]/pi_old[n]*(d_mean_d_ba1*Grad_Normal_Dist_Mean(mean_array[n],deviation_array[n],action_array[n])+d_dev_d_ba1*Grad_Normal_Dist_Deviation(mean_array[n],deviation_array[n],action_array[n]));
            }
        }
        G_ba1[index2] = -G_ba1[index2] / batch_size;
        if(G_ba1[index2] > Gradient_Limit) G_ba1[index2] = Gradient_Limit;
        else if (G_ba1[index2] < -Gradient_Limit) G_ba1[index2] = -Gradient_Limit;
        //ba1_temp[index2] = ba1_temp[index2] - gradient_rate_actor * G_ba1[index2];
    }

    float G_ha2[num_hidden_unit1][num_hidden_unit2] = {0.0f};
    float G_ba2[num_hidden_unit2] = {0.0f};

    for (int index2 = 0; index2 < num_hidden_unit2; index2++) {
        for (int index1 = 0; index1 < num_hidden_unit1; index1++) {
            for (int n=0; n<batch_size; n++) {
                float d_x_d_ha2 = 0.0f;
                float d_y_d_ha2 = 0.0f;
                if((advantage[n] >= 0.0f && ratio[n] >= 1.0f + epsilon) || (advantage[n] < 0.0f && ratio[n] < 1.0f - epsilon)) {
                    G_ha2[index1][index2] = G_ha2[index1][index2];
                } else {
                    if (hxh_a_sum_array[n][index2] >= 0) {
                        if (hx_a_sum_array[n][index1] > 0) {
                            d_x_d_ha2 = hx_a_sum_array[n][index1]*ha3_temp[index2][0];
                            d_y_d_ha2 = hx_a_sum_array[n][index1]*ha3_temp[index2][1];
                        }
                    }

                    float d_mean_d_ha2 = 0.0f;
                    float d_dev_d_ha2 = 0.0f;
                    d_mean_d_ha2 = exp(hxhh_a_sum_array[n][0])/(1.0f+exp(hxhh_a_sum_array[n][0]))*d_x_d_ha2;
                    d_dev_d_ha2 = exp(hxhh_a_sum_array[n][1])/(1.0f+exp(hxhh_a_sum_array[n][1]))*d_y_d_ha2;

                    G_ha2[index1][index2] = G_ha2[index1][index2] + advantage[n]/pi_old[n]*(d_mean_d_ha2*Grad_Normal_Dist_Mean(mean_array[n],deviation_array[n],action_array[n])+d_dev_d_ha2*Grad_Normal_Dist_Deviation(mean_array[n],deviation_array[n],action_array[n]));
                }
            }
            G_ha2[index1][index2] = -G_ha2[index1][index2] / batch_size;
            if(G_ha2[index1][index2] > Gradient_Limit) G_ha2[index1][index2] = Gradient_Limit;
            else if (G_ha2[index1][index2] < -Gradient_Limit) G_ha2[index1][index2] = -Gradient_Limit;
            //ha2_temp[index1][index2] = ha2_temp[index1][index2] - gradient_rate_actor * G_ha2[index1][index2];
        }

        for (int n=0; n<batch_size; n++) {
            float d_x_d_ba2 = 0.0f;
            float d_y_d_ba2 = 0.0f;
            if((advantage[n] >= 0.0f && ratio[n] >= 1.0f + epsilon) || (advantage[n] < 0.0f && ratio[n] < 1.0f - epsilon))  {
                G_ba2[index2] = G_ba2[index2];
            } else {

                if (hxh_a_sum_array[n][index2] >= 0) {
                    d_x_d_ba2 = ha3_temp[index2][0];
                    d_y_d_ba2 = ha3_temp[index2][1];
                }
                float d_mean_d_ba2= 0.0f;
                float d_dev_d_ba2= 0.0f;
                d_mean_d_ba2 = exp(hxhh_a_sum_array[n][0])/(1.0f+exp(hxhh_a_sum_array[n][0]))*d_x_d_ba2;
                d_dev_d_ba2 = exp(hxhh_a_sum_array[n][1])/(1.0f+exp(hxhh_a_sum_array[n][1]))*d_y_d_ba2;

                G_ba2[index2] = G_ba2[index2] + advantage[n]/pi_old[n]*(d_mean_d_ba2*Grad_Normal_Dist_Mean(mean_array[n],deviation_array[n],action_array[n])+d_dev_d_ba2*Grad_Normal_Dist_Deviation(mean_array[n],deviation_array[n],action_array[n]));
            }
        }
        G_ba2[index2] = -G_ba2[index2] / batch_size;
        if(G_ba2[index2] > Gradient_Limit) G_ba2[index2] = Gradient_Limit;
        else if (G_ba2[index2] < -Gradient_Limit) G_ba2[index2] = -Gradient_Limit;
        //ba2_temp[index2] = ba2_temp[index2] - gradient_rate_actor * G_ba2[index2];
    }

    float G_ha3[num_hidden_unit2][2] = {0.0f};
    float G_ba3[2] = {0.0f};

    for (int index2 = 0; index2 < 2; index2++) {
        for (int index1 = 0; index1 < num_hidden_unit2; index1++) {
            for (int n=0; n<batch_size; n++) {
                float d_x_d_ha3 = 0.0f;
                float d_y_d_ha3 = 0.0f;
                if((advantage[n] >= 0.0f && ratio[n] >= 1.0f + epsilon) || (advantage[n] < 0.0f && ratio[n] < 1.0f - epsilon)) {
                    G_ha3[index1][index2] = G_ha3[index1][index2];
                } else {
                    if (hxh_a_sum_array[n][index1] >= 0) {
                        if (hx_a_sum_array[n][index1] > 0) {
                            d_x_d_ha3 = hxh_a_sum_array[n][index1];
                            d_y_d_ha3 = hxh_a_sum_array[n][index1];
                        }
                    }
                    float d_mean_d_ha3 = 0.0f;
                    float d_dev_d_ha3 = 0.0f;
                    d_mean_d_ha3 = exp(hxhh_a_sum_array[n][0])/(1.0f+exp(hxhh_a_sum_array[n][0]))*d_x_d_ha3;
                    d_dev_d_ha3 = exp(hxhh_a_sum_array[n][1])/(1.0f+exp(hxhh_a_sum_array[n][1]))*d_y_d_ha3;

                    G_ha3[index1][index2] = G_ha3[index1][index2] + advantage[n]/pi_old[n]*(d_mean_d_ha3*Grad_Normal_Dist_Mean(mean_array[n],deviation_array[n],action_array[n])+d_dev_d_ha3*Grad_Normal_Dist_Deviation(mean_array[n],deviation_array[n],action_array[n]));
                }
            }
            G_ha3[index1][index2] = -G_ha3[index1][index2] / batch_size;
            if(G_ha3[index1][index2] > Gradient_Limit) G_ha3[index1][index2] = Gradient_Limit;
            else if (G_ha3[index1][index2] < -Gradient_Limit) G_ha3[index1][index2] = -Gradient_Limit;
            //ha3_temp[index1][index2] = ha3_temp[index1][index2] - gradient_rate_actor * G_ha3[index1][index2];
        }

        for (int n=0; n<batch_size; n++) {
            float d_x_d_ba3 = 0.0f;
            float d_y_d_ba3 = 0.0f;
            if((advantage[n] >= 0.0f && ratio[n] >= 1.0f + epsilon) || (advantage[n] < 0.0f && ratio[n] < 1.0f - epsilon))  {
                G_ba3[index2] = G_ba3[index2];
            } else {

                d_x_d_ba3 = 1.0f;
                d_y_d_ba3 = 1.0f;

                float d_mean_d_ba3= 0.0f;
                float d_dev_d_ba3= 0.0f;
                d_mean_d_ba3 = exp(hxhh_a_sum_array[n][0])/(1.0f+exp(hxhh_a_sum_array[n][0]))*d_x_d_ba3;
                d_dev_d_ba3 = exp(hxhh_a_sum_array[n][1])/(1.0f+exp(hxhh_a_sum_array[n][1]))*d_y_d_ba3;

                G_ba3[index2] = G_ba3[index2] + advantage[n]/pi_old[n]*(d_mean_d_ba3*Grad_Normal_Dist_Mean(mean_array[n],deviation_array[n],action_array[n])+d_dev_d_ba3*Grad_Normal_Dist_Deviation(mean_array[n],deviation_array[n],action_array[n]));
            }
        }
        G_ba3[index2] = -G_ba3[index2] / batch_size;
        if(G_ba3[index2] > Gradient_Limit) G_ba3[index2] = Gradient_Limit;
        else if (G_ba3[index2] < -Gradient_Limit) G_ba3[index2] = -Gradient_Limit;
        //ba3_temp[index2] = ba3_temp[index2] - gradient_rate_actor * G_ba3[index2];
    }

    // Simultaneous Update
    for (int index2 = 0; index2 < num_hidden_unit1; index2++) {
        for (int index1 = 0; index1 < num_input_RL; index1++) {
            ha1_temp[index1][index2] = ha1_temp[index1][index2] - gradient_rate_actor * G_ha1[index1][index2];
        }
        ba1_temp[index2] = ba1_temp[index2] - gradient_rate_actor * G_ba1[index2];
    }
    for (int index2 = 0; index2 < num_hidden_unit2; index2++) {
        for (int index1 = 0; index1 < num_hidden_unit1; index1++) {
            ha2_temp[index1][index2] = ha2_temp[index1][index2] - gradient_rate_actor * G_ha2[index1][index2];
        }
        ba2_temp[index2] = ba2_temp[index2] - gradient_rate_actor * G_ba2[index2];
    }
    for (int index2 = 0; index2 < 2; index2++) {
        for (int index1 = 0; index1 < num_hidden_unit2; index1++) {
            ha3_temp[index1][index2] = ha3_temp[index1][index2] - gradient_rate_actor * G_ha3[index1][index2];
        }
        ba3_temp[index2] = ba3_temp[index2] - gradient_rate_actor * G_ba3[index2];
    }
}

float rand_normal(double mean, double stddev)
{
    //Box muller method
    static double n2 = 0.0f;
    static int n2_cached = 0;
    if (!n2_cached) {
        double x, y, r;
        do {
            x = 2.0f*rand()/RAND_MAX - 1;
            y = 2.0f*rand()/RAND_MAX - 1;

            r = x*x + y*y;
        } while (r == 0.0f || r > 1.0f);
        {
            double d = sqrt(-2.0f*log(r)/r);
            double n1 = x*d;
            n2 = y*d;
            double result = n1*stddev + mean;
            n2_cached = 1;
            return result;
        }
    } else {
        n2_cached = 0;
        return n2*stddev + mean;
    }
}

float mean_adv(float x[], int size)
{
    float add = 0.0f;
    float result;

    for (int i=0; i<size; i++) {
        add += x[i];
    }
    result = (float) add/size;
    return result;
}
float deviation_adv(float x[], int size)
{
    float sigma = 0.0f;
    float resultDeb = 0.0f;

    for (int k=0; k<size; k++) {
        sigma = pow((float)x[k]-mean_adv(x,size), (float)2.0f)/(size-1);
        resultDeb += sqrt(sigma);
    }
    return resultDeb;
}


void Overwirte_Critic_Networks()
{
    for (int index2 = 0; index2 < num_hidden_unit1; index2++) {
        for (int index1 = 0; index1 < num_input_RL; index1++) {
            hc1[index1][index2] = hc1_temp[index1][index2];
        }
        bc1[index2] = bc1_temp[index2];
    }
    for (int index2 = 0; index2 < num_hidden_unit2; index2++) {
        for (int index1 = 0; index1 < num_hidden_unit1; index1++) {
            hc2[index1][index2] = hc2_temp[index1][index2];
        }
        bc2[index2] = bc2_temp[index2];
        hc3[index2] = hc3_temp[index2];
    }
    bc3 = bc3_temp;
}
void Overwirte_Actor_Networks()
{
    for (int index2 = 0; index2 < num_hidden_unit1; index2++) {
        for (int index1 = 0; index1 < num_input_RL; index1++) {
            ha1[index1][index2] = ha1_temp[index1][index2];
        }
        ba1[index2] = ba1_temp[index2];
    }
    for (int index2 = 0; index2 < num_hidden_unit2; index2++) {
        for (int index1 = 0; index1 < num_hidden_unit1; index1++) {
            ha2[index1][index2] = ha2_temp[index1][index2];
        }
        ba2[index2] = ba2_temp[index2];
    }
    for (int index2 = 0; index2 < 2; index2++) {
        for (int index1 = 0; index1 < num_hidden_unit2; index1++) {
            ha3[index1][index2] = ha3_temp[index1][index2];
        }
        ba3[index2] = ba3_temp[index2];
    }
}


int main()
{

    HAL_Init();
    SystemClock_Config();

    /*********************************
    ***     Initialization
    *********************************/
    LED = 0;
    pc.baud(9600);

    // i2c init
    i2c.frequency(400 * 1000);          // 0.4 mHz
    wait_ms(2);                         // Power Up wait
    look_for_hardware_i2c();            // Hardware present
    init_as5510(i2c_slave_addr1);
    make_delay();

//    // spi init
    eeprom_cs = 1;
    eeprom.format(8,3);
    eeprom.frequency(5000000); //5M
    eeprom_cs = 0;
    make_delay();

    enc_cs = 1;     //sw add
    enc.format(8,0);
    enc.frequency(5000000); //10M
    enc_cs = 0;     //sw add
    
    make_delay();
    
    // spi _ enc
    spi_enc_set_init();
    make_delay();
    
    //Inital BNO setting
//    spi_eeprom_write(RID_BNO, (int16_t) 1);
//    make_delay();

    //rom
    ROM_CALL_DATA();
    make_delay();

    // ADC init
    Init_ADC();
    make_delay();

    // Pwm init
    Init_PWM();
    TIM4->CR1 ^= TIM_CR1_UDIS;
    make_delay();
    
    // CAN
    can.attach(&CAN_RX_HANDLER);
    CAN_ID_INIT();
    make_delay();

   //can.reset();
    can.filter(msg.id, 0xFFFFF000, CANStandard);

    // TMR3 init
    Init_TMR3();
    TIM3->CR1 ^= TIM_CR1_UDIS;
    make_delay();

    // TMR2 init
//    Init_TMR2();
//    TIM2->CR1 ^= TIM_CR1_UDIS;
//    make_delay();

//    // CAN
//    can.attach(&CAN_RX_HANDLER);
//    CAN_ID_INIT();
//    make_delay();
    
      

    //Timer priority
    NVIC_SetPriority(TIM3_IRQn, 2);
    //NVIC_SetPriority(TIM2_IRQn, 3);
    NVIC_SetPriority(TIM4_IRQn, 3);

//    //can.reset();
//    can.filter(msg.id, 0xFFFFF000, CANStandard);

  //  // spi _ enc
//    spi_enc_set_init();
//    make_delay();

    //DAC init
    if (SENSING_MODE == 0) {
        dac_1 = TORQUE_VREF / 3.3f;
        dac_2 = 0.0f;
    } else if (SENSING_MODE == 1) {
        dac_1 = PRES_A_VREF / 3.3f;
        dac_2 = PRES_B_VREF / 3.3f;
    }
    make_delay();

    for (int i=0; i<50; i++) {
        if(i%2==0)
            ID_index_array[i] = - i * 0.5f;
        else
            ID_index_array[i] =  (i+1) * 0.5f;
    }

    for (int index2 = 0; index2 < num_hidden_unit1; index2++) {
        for (int index1 = 0; index1 < num_input_RL; index1++) {
            hc1_temp[index1][index2] = (float) (rand()%100) * 0.007f ;
        }
        bc1_temp[index2] = (float) (rand()%100) * 0.007f;
    }
    for (int index2 = 0; index2 < num_hidden_unit2; index2++) {
        for (int index1 = 0; index1 < num_hidden_unit1; index1++) {
            hc2_temp[index1][index2] = (float) (rand()%100) * 0.007f;
        }
        bc2_temp[index2] = (float) (rand()%100) * 0.007f;
        hc3_temp[index2] = (float) (rand()%100) * 0.007f;
    }
    bc3_temp = (float) (rand()%100) * 0.007f;

    for (int index2 = 0; index2 < num_hidden_unit1; index2++) {
        for (int index1 = 0; index1 < num_input_RL; index1++) {
            ha1_temp[index1][index2] = (float) (rand()%100) * 0.007f;
        }
        ba1_temp[index2] = (float) (rand()%100) * 0.007f;
    }
    for (int index2 = 0; index2 < num_hidden_unit2; index2++) {
        for (int index1 = 0; index1 < num_hidden_unit1; index1++) {
            ha2_temp[index1][index2] = (float) (rand()%100) * 0.007f;
        }
        ba2_temp[index2] = (float) (rand()%100) * 0.007f;
    }
    for (int index2 = 0; index2 < 2; index2++) {
        for (int index1 = 0; index1 < num_hidden_unit2; index1++) {
            ha3_temp[index1][index2] = (float) (rand()%100) * 0.007f;
        }
        ba3_temp[index2] = (float) (rand()%100) * 0.007f;
    }

    Overwirte_Critic_Networks();
    Overwirte_Actor_Networks();

    /************************************
    ***     Program is operating!
    *************************************/
    while(1) {

//        if(timer_while==27491) {
//            timer_while = 0;
//            pc.printf("ref : %f     virt_pos : %f  mean : %f    deviation : %f       Last_pos_of_batch : %f      reward_sum : %f\n", pos.sen/(float)(ENC_PULSE_PER_POSITION), logging3, logging2, logging4, logging1, logging5);
//            //pc.printf("%f\n", virt_pos);
//            //pc.printf("%f\n", pos.sen/(float)(ENC_PULSE_PER_POSITION));
//            //pc.printf("ref : %f     virt_pos : %f\n", pos.sen/(float)(ENC_PULSE_PER_POSITION), virt_pos);
//        }


        //i2c
        read_field(i2c_slave_addr1);
        if(DIR_VALVE_ENC < 0) value = 1023 - value;

        //timer_while ++;

        ///////////////////////////////////////////////////////Neural Network

        if(NN_Control_Flag == 0) {
            LED = 0;
        }

        else if(NN_Control_Flag == 1) {

            int ind = 0;
            for(int i=0; i<numpast_u; i++) {
                input_NN[ind] = u_past[time_interval*i];
                ind = ind + 1;
            }

            for(int i=0; i<numpast_x; i++) {
                input_NN[ind] = x_past[time_interval*i] / 60.0f;
                ind = ind + 1;
            }
            input_NN[ind] = (pos.sen / ENC_PULSE_PER_POSITION) / 60.0f;
            ind = ind + 1;

//            for(int i=0; i<numfuture_x; i++) {
//                input_NN[ind] = x_future[time_interval*i+time_interval] / 60.0f;
//                ind = ind + 1;
//            }

            for(int i=0; i<numpast_f; i++) {
//                input_NN[ind] = f_past[time_interval*i] / 10000.0f * 8.0f + 0.5f;
                input_NN[ind] = f_past[time_interval*i] / 10000.0f + 0.5f;
                ind = ind + 1;
            }
//            input_NN[ind] = torq.sen / 10000.0f * 8.0f + 0.5f;
            input_NN[ind] = torq.sen / 10000.0f + 0.5f;
            ind = ind + 1;
            for(int i=0; i<numfuture_f; i++) {
//                input_NN[ind] = (f_future[time_interval*i+time_interval] - torq.sen)/10000.0f * 8.0f + 0.5f;
//                input_NN[ind] = (f_future[time_interval*i+time_interval] - torq.sen)/10000.0f + 0.5f;
//                input_NN[ind] = (f_future[time_interval*i+time_interval])/10000.0f*8.0f+0.5f;
                input_NN[ind] = (f_future[time_interval*i+time_interval])/10000.0f + 0.5f;
                ind = ind + 1;
            }

            float output1[16] = { 0.0f };
            float output2[16] = { 0.0f };
            float output3[16] = { 0.0f };
            float output = 0.0f;

            for (int index2 = 0; index2 < 16; index2++) {
                for (int index1 = 0; index1 < num_input; index1++) {
                    output1[index2] = output1[index2]
                                      + h1[index1][index2] * input_NN[index1];
                }
                output1[index2] = output1[index2] + b1[index2];
                if (output1[index2] < 0) {
                    output1[index2] = 0;
                }
            }

            for (int index2 = 0; index2 < 16; index2++) {
                for (int index1 = 0; index1 < 16; index1++) {
                    output2[index2] = output2[index2]
                                      + h2[index1][index2] * output1[index1];
                }
                output2[index2] = output2[index2] + b2[index2];
                if (output2[index2] < 0) {
                    output2[index2] = 0;
                }
            }

            for (int index2 = 0; index2 < 16; index2++) {
                for (int index1 = 0; index1 < 16; index1++) {
                    output3[index2] = output3[index2]
                                      + h3[index1][index2] * output2[index1];
                }
                output3[index2] = output3[index2] + b3[index2];
                if (output3[index2] < 0) {
                    output3[index2] = 0;
                }
            }

            for (int index2 = 0; index2 < 1; index2++) {
                for (int index1 = 0; index1 < 16; index1++) {
                    output = output + hout[index1] * output3[index1];
                }
                output = output + bout[index2];

            }
            output = 1.0f/(1.0f+exp(-output));
            output_normalized = output;
            output = output * 20000.0f - 10000.0f;

            if(output>=0) {
                valve_pos.ref = output*0.0001f*((double)VALVE_MAX_POS - (double) VALVE_CENTER) + (double) VALVE_CENTER;
            } else {
                valve_pos.ref = -output*0.0001f*((double)VALVE_MIN_POS - (double) VALVE_CENTER) + (double) VALVE_CENTER;
            }


            if(LED==1) {
                LED=0;
            } else
                LED = 1;

        }


        /////////////////////////////////////////////////////////////////////RL
        switch (Update_Case) {
            case 0: {
                break;
            }
            case 1: {
                //Network Update(just update and hold network)
                for (int epoch = 0; epoch < num_epoch; epoch++) {
                    float loss_sum = 0.0f;
                    for (int n=batch_size-1; n>=0; n--) {
                        //Calculate Estimated V
                        //float temp_array[3] = {state_array[n][0], state_array[n][1], state_array[n][2]};
                        float temp_array[2] = {state_array[n][0], state_array[n][1]};
                        V[n] = Critic_Network_Temp(temp_array);
                        for (int i=0; i<num_hidden_unit1; i++) {
                            hx_c_sum_array[n][i] = hx_c_sum[i];
                        }
                        for (int i=0; i<num_hidden_unit2; i++) {
                            hxh_c_sum_array[n][i] = hxh_c_sum[i];
                        }
                        hxhh_c_sum_array[n] = hxhh_c_sum;

                        pi[n] = exp(-(action_array[n]-mean_array[n])*(action_array[n]-mean_array[n])/(2.0f*deviation_array[n]*deviation_array[n]))/(sqrt(2.0f*PI)*deviation_array[n]);
                        Actor_Network_Old(temp_array);
                        pi_old[n] = exp(-(action_array[n]-mean_old)*(action_array[n]-mean_old)/(2.0f*deviation_old*deviation_old))/(sqrt(2.0f*PI)*deviation_old);
                        r[n] = exp(-0.25f * 5.0f * state_array[n][1] * state_array[n][1]);
                        if(n == batch_size-1) return_G[n] = 0.0f;
                        else return_G[n] = gamma * return_G[n+1] + r[n];
                        if(n == batch_size-1) td_target[n] = r[n];
                        else td_target[n] = r[n] + gamma * V[n+1];
                        delta[n] = td_target[n] - V[n];
                        if(n == batch_size-1) advantage[n] = 0.0f;
                        else advantage[n] = gamma * lmbda * advantage[n+1] + delta[n];
//                        return_G[n] = advantage[n] + V[n];
                        ratio[n] = pi[n]/pi_old[n];
                    }
                    float mean_advantage = 0.0f;
                    float dev_advantage = 0.0f;
                    mean_advantage = mean_adv(advantage, batch_size);
                    dev_advantage = deviation_adv(advantage, batch_size);
                    for (int n=batch_size-1; n>=0; n--) {
                        //advantage[n] = (advantage[n]-mean_advantage)/dev_advantage;
                        surr1[n] = ratio[n] * advantage[n];
                        if (ratio[n] > 1.0f + epsilon) {
                            surr2[n] = (1.0f + epsilon)*advantage[n];
                        } else if( ratio[n] < 1.0f - epsilon) {
                            surr2[n] = (1.0f - epsilon)*advantage[n];
                        } else {
                            surr2[n] = ratio[n]*advantage[n];
                        }
                        loss[n] = -min(surr1[n], surr2[n]);
                        loss_sum = loss_sum + loss[n];
                    }
                    reward_sum = 0.0f;
                    for (int i=0; i<batch_size; i++) {
                        reward_sum = reward_sum + r[i];
                    }
                    logging5 = reward_sum;


                    //loss_batch = loss_sum / (float) batch_size;
                    loss_batch = loss_sum;
                    //Update Networks
                    update_Critic_Networks(state_array);
                    update_Actor_Networks(state_array);
                }
                Update_Done_Flag = 1;
                Update_Case = 0;
                //logging1 = V[0];

                break;
            }
            case 2: {
                //Network apply to next Network
                Overwirte_Critic_Networks();
                Overwirte_Actor_Networks();
                virt_pos = 10.0f;
                Update_Done_Flag = 1;
                Update_Case = 0;
                break;
            }

        }
    }
}

float DDV_JOINT_POS_FF(float REF_JOINT_VEL)
{

    int i = 0;
    float Ref_Valve_Pos_FF = 0.0f;
    for(i=0; i<VALVE_POS_NUM; i++) {
        if(REF_JOINT_VEL >= min(JOINT_VEL[i],JOINT_VEL[i+1]) && REF_JOINT_VEL <=  max(JOINT_VEL[i],JOINT_VEL[i+1])) {
            if(i==0) {
                if(JOINT_VEL[i+1] == JOINT_VEL[i]) {
                    Ref_Valve_Pos_FF = (float) VALVE_CENTER;
                } else {
                    Ref_Valve_Pos_FF = ((float) 10/(JOINT_VEL[i+1] - JOINT_VEL[i]) * (REF_JOINT_VEL - JOINT_VEL[i])) + (float) VALVE_CENTER;
                }
            } else {
                if(JOINT_VEL[i+1] == JOINT_VEL[i-1]) {
                    Ref_Valve_Pos_FF = (float) VALVE_CENTER;
                } else {
                    Ref_Valve_Pos_FF = ((float) 10*(ID_index_array[i+1] - ID_index_array[i-1])/(JOINT_VEL[i+1] - JOINT_VEL[i-1]) * (REF_JOINT_VEL - JOINT_VEL[i-1])) + (float) VALVE_CENTER + (float) (10*ID_index_array[i-1]);
                }
            }
            break;
        }
    }
    if(REF_JOINT_VEL > max(JOINT_VEL[VALVE_POS_NUM-1], JOINT_VEL[VALVE_POS_NUM-2])) {
        Ref_Valve_Pos_FF = (float) VALVE_MAX_POS;
    } else if(REF_JOINT_VEL < min(JOINT_VEL[VALVE_POS_NUM-1], JOINT_VEL[VALVE_POS_NUM-2])) {
        Ref_Valve_Pos_FF = (float) VALVE_MIN_POS;
    }

    Ref_Valve_Pos_FF = (float) VELOCITY_COMP_GAIN * 0.01f * (float) (Ref_Valve_Pos_FF - (float) VALVE_CENTER);
    return Ref_Valve_Pos_FF;

}


void VALVE_POS_CONTROL(float REF_VALVE_POS)
{
    int i = 0;

    if(REF_VALVE_POS > VALVE_MAX_POS) {
        REF_VALVE_POS = VALVE_MAX_POS;
    } else if(REF_VALVE_POS < VALVE_MIN_POS) {
        REF_VALVE_POS = VALVE_MIN_POS;
    }

    valve_pos_err = (float) (REF_VALVE_POS - value);
    valve_pos_err_diff = valve_pos_err - valve_pos_err_old;
    valve_pos_err_old = valve_pos_err;
    valve_pos_err_sum += valve_pos_err;
    if (valve_pos_err_sum > 1000.0f) valve_pos_err_sum = 1000.0f;
    if (valve_pos_err_sum<-1000.0f) valve_pos_err_sum = -1000.0f;

    VALVE_PWM_RAW_FB = P_GAIN_VALVE_POSITION * valve_pos_err + I_GAIN_VALVE_POSITION * valve_pos_err_sum + D_GAIN_VALVE_POSITION * valve_pos_err_diff;

    for(i=0; i<24; i++) {
        if(REF_VALVE_POS >= min(VALVE_POS_VS_PWM[i],VALVE_POS_VS_PWM[i+1]) && (float) REF_VALVE_POS <=  max(VALVE_POS_VS_PWM[i],VALVE_POS_VS_PWM[i+1])) {
            if(i==0) {
                VALVE_PWM_RAW_FF = (float) 1000.0f / (float) (VALVE_POS_VS_PWM[i+1] - VALVE_POS_VS_PWM[i]) * ((float) REF_VALVE_POS - VALVE_POS_VS_PWM[i]);
            } else {
                VALVE_PWM_RAW_FF = (float) 1000.0f* (float) (ID_index_array[i+1] - ID_index_array[i-1])/(VALVE_POS_VS_PWM[i+1] - VALVE_POS_VS_PWM[i-1]) * ((float) REF_VALVE_POS - VALVE_POS_VS_PWM[i-1]) + 1000.0f * (float) ID_index_array[i-1];
            }
            break;
        }
    }
    Vout.ref = VALVE_PWM_RAW_FF + VALVE_PWM_RAW_FB;
}

#define LT_MAX_IDX  57
float LT_PWM_duty[LT_MAX_IDX] = {-100.0f, -80.0f, -60.0f, -50.0f, -40.0f, -35.0f, -30.0f, -25.0f, -20.0f,
                                 -19.0f, -18.0f, -17.0f, -16.0f, -15.0f, -14.0f, -13.0f, -12.0f, -11.0f, -10.0f,
                                 -9.0f, -8.0f, -7.0f, -6.0f, -5.0f, -4.0f, -3.0f, -2.0f, -1.0f, 0.0f,
                                 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f,
                                 11.0f, 12.0f, 13.0f, 14.0f, 15.0f, 16.0f, 17.0f, 18.0f, 19.0f, 20.0f,
                                 25.0f, 30.0f, 35.0f, 40.0f, 50.0f, 60.0f, 80.0f, 100.0f
                                };  // duty
float LT_Voltage_Output[LT_MAX_IDX] = {-230.0f, -215.0f, -192.5f, -185.0f, -177.5f, -170.0f, -164.0f, -160.0f, -150.0f,
                                       -150.0f, -145.0f, -145.0f, -145.0f, -135.0f, -135.0f, -135.0f, -127.5f, -127.5f, -115.0f,
                                       -115.0f, -115.0F, -100.0f, -100.0f, -100.0f, -60.0f, -60.0f, -10.0f, -5.0f, 0.0f,
                                       7.5f, 14.0f, 14.0f, 14.0f, 42.5f, 42.5f, 42.5f, 80.0f, 80.0f, 105.0f,
                                       105.0f, 105.0f, 120.0f, 120.0f, 120.0f, 131.0f, 131.0f, 140.0f, 140.0f, 140.0f,
                                       155.0f, 160.0f, 170.0f, 174.0f, 182.0f, 191.0f, 212.0f, 230.0f
                                      }; // mV

float PWM_duty_byLT(float Ref_V)
{
    float PWM_duty = 0.0f;
    if(Ref_V<LT_Voltage_Output[0]) {
        PWM_duty = (Ref_V-LT_Voltage_Output[0])/1.5f+LT_PWM_duty[0];
    } else if (Ref_V>=LT_Voltage_Output[LT_MAX_IDX-1]) {
        PWM_duty = (Ref_V-LT_Voltage_Output[LT_MAX_IDX-1])/1.5f+LT_PWM_duty[LT_MAX_IDX-1];
    } else {
        int idx = 0;
        for(idx=0; idx<LT_MAX_IDX-1; idx++) {
            float ini_x = LT_Voltage_Output[idx];
            float fin_x = LT_Voltage_Output[idx+1];
            float ini_y = LT_PWM_duty[idx];
            float fin_y = LT_PWM_duty[idx+1];
            if(Ref_V>=ini_x && Ref_V<fin_x) {
                PWM_duty = (fin_y-ini_y)/(fin_x-ini_x)*(Ref_V-ini_x) + ini_y;
                break;
            }
        }
    }

    return PWM_duty;
}





/*******************************************************************************
                            TIMER INTERRUPT
*******************************************************************************/

float FREQ_TMR4 = (float)FREQ_20k;
float DT_TMR4 = (float)DT_20k;
long  CNT_TMR4 = 0;
int   TMR4_FREQ_10k = (int)FREQ_10k;
extern "C" void TIM4_IRQHandler(void)
{
    if (TIM4->SR & TIM_SR_UIF ) {

        /*******************************************************
        ***     Sensor Read & Data Handling
        ********************************************************/

        //Encoder
        if (CNT_TMR4 % (int) ((int) FREQ_TMR4/TMR4_FREQ_10k) == 0) {
            ENC_UPDATE();
        }

        ADC1->CR2  |= 0x40000000;
        if (SENSING_MODE == 0) {
            // Torque Sensing (0~210)bar =============================================
            float pres_A_new = (((float) ADC1->DR) - 2047.5f);
            double alpha_update_ft = 1.0f / (1.0f + FREQ_TMR4 / (2.0f * 3.14f * 100.0f)); // f_cutoff : 200Hz
            pres_A.sen = (1.0f - alpha_update_ft) * pres_A.sen + alpha_update_ft * pres_A_new;
            torq.sen = pres_A.sen / TORQUE_SENSOR_PULSE_PER_TORQUE;


//        float alpha_update_pres_A = 1.0f/(1.0f + FREQ_TMR4/(2.0f*3.14f*100.0f));
////        float pres_A_new = ((float)ADC1->DR - PRES_A_NULL)  / PRES_SENSOR_A_PULSE_PER_BAR;
//        float pres_A_new = ((float)ADC1->DR);
//        pres_A.sen = pres_A.sen*(1.0f-alpha_update_pres_A)+pres_A_new*(alpha_update_pres_A);
//        torq.sen = - (pres_A.sen-2048.0f); //pulse -2047~2047


        } else if (SENSING_MODE == 1) {
            // Pressure Sensing (0~210)bar =============================================
            float pres_A_new = (((float)ADC1->DR) - PRES_A_NULL);
            float pres_B_new = (((float)ADC2->DR) - PRES_B_NULL);
            double alpha_update_pres = 1.0f / (1.0f + FREQ_TMR4 / (2.0f * 3.14f * 200.0f)); // f_cutoff : 500Hz
            pres_A.sen = (1.0f - alpha_update_pres) * pres_A.sen + alpha_update_pres * pres_A_new;
            pres_B.sen = (1.0f - alpha_update_pres) * pres_B.sen + alpha_update_pres * pres_B_new;
            CUR_PRES_A_BAR = pres_A.sen / PRES_SENSOR_A_PULSE_PER_BAR;
            CUR_PRES_B_BAR = pres_B.sen / PRES_SENSOR_B_PULSE_PER_BAR;

            if ((OPERATING_MODE & 0x01) == 0) { // Rotary Actuator
                torq.sen = (PISTON_AREA_A * CUR_PRES_A_BAR - PISTON_AREA_B * CUR_PRES_B_BAR) * 0.0001f; // mm^3*bar >> Nm
            } else if ((OPERATING_MODE & 0x01) == 1) { // Linear Actuator
                torq.sen = (PISTON_AREA_A * CUR_PRES_A_BAR - PISTON_AREA_B * CUR_PRES_B_BAR) * 0.1f; // mm^2*bar >> N
            }
        }

//        //Pressure sensor A
//        ADC1->CR2  |= 0x40000000;                        // adc _ 12bit
//        //while((ADC1->SR & 0b10));
//        float alpha_update_pres_A = 1.0f/(1.0f + FREQ_TMR4/(2.0f*3.14f*100.0f));
//        float pres_A_new = ((float)ADC1->DR);
//        pres_A.sen = pres_A.sen*(1.0f-alpha_update_pres_A)+pres_A_new*(alpha_update_pres_A);
//        torq.sen = - (pres_A.sen-2048.0f); //pulse -2047~2047    //SW just changed the sign to correct the direction of loadcell on LIGHT. Correct later.
//
//
//        //Pressure sensor B
//        float alpha_update_pres_B = 1.0f/(1.0f + FREQ_TMR4/(2.0f*3.14f*100.0f));
//        float pres_B_new = ((float)ADC2->DR);
//        pres_B.sen = pres_B.sen*(1.0f-alpha_update_pres_B)+pres_B_new*(alpha_update_pres_B);
//        //torq.sen = pres_A.sen * (float) PISTON_AREA_A - pres_B.sen * (float) PISTON_AREA_B;


        //Current
        //ADC3->CR2  |= 0x40000000;                        // adc _ 12bit
        //int raw_cur = ADC3->DR;
        //while((ADC3->SR & 0b10));
        float alpha_update_cur = 1.0f/(1.0f + FREQ_TMR4/(2.0f*3.14f*500.0f)); // f_cutoff : 500Hz
        float cur_new = ((float)ADC3->DR-2048.0f)*20.0f/4096.0f; // unit : mA
        cur.sen=cur.sen*(1.0f-alpha_update_cur)+cur_new*(alpha_update_cur);
        //cur.sen = raw_cur;

        CNT_TMR4++;
    }
    TIM4->SR = 0x0;  // reset the status register
}


int j =0;
float FREQ_TMR3 = (float)FREQ_5k;
float DT_TMR3 = (float)DT_5k;
int cnt_trans = 0;
double VALVE_POS_RAW_FORCE_FB_LOGGING = 0.0f;

extern "C" void TIM3_IRQHandler(void)
{
    if (TIM3->SR & TIM_SR_UIF ) {

        if (((OPERATING_MODE&0b110)>>1) == 0) {
            K_v = 0.4f; // Moog (LPM >> mA) , 100bar
            mV_PER_mA = 500.0f; // 5000mV/10mA
            mV_PER_pulse = 0.5f; // 5000mV/10000pulse
            mA_PER_pulse = 0.001f; // 10mA/10000pulse
        } else if (((OPERATING_MODE&0b110)>>1) == 1) {
            K_v = 0.5f; // KNR (LPM >> mA) , 100bar
            mV_PER_mA = 166.6666f; // 5000mV/30mA
            mV_PER_pulse = 0.5f; // 5000mV/10000pulse
            mA_PER_pulse = 0.003f; // 30mA/10000pulse
        }

        if(MODE_POS_FT_TRANS == 1) {
            alpha_trans = (float)(1.0f - cos(3.141592f * (float)cnt_trans * DT_TMR3 /3.0f))/2.0f;
            cnt_trans++;
            torq.err_sum = 0;
            if((float)cnt_trans * DT_TMR3 > 3.0f)
                MODE_POS_FT_TRANS = 2;
        } else if(MODE_POS_FT_TRANS == 3) {
            alpha_trans = (float)(1.0f + cos(3.141592f * (float)cnt_trans * DT_TMR3 /3.0f))/2.0f;
            cnt_trans++;
            torq.err_sum = 0;
            if((float) cnt_trans * DT_TMR3 > 3.0f )
                MODE_POS_FT_TRANS = 0;
        } else if(MODE_POS_FT_TRANS == 2) {
            alpha_trans = 1.0f;
            cnt_trans = 0;
        } else {
            alpha_trans = 0.0f;
            cnt_trans = 0;
        }


        int UTILITY_MODE = 0;
        int CONTROL_MODE = 0;

        if (CONTROL_UTILITY_MODE >= 20 || CONTROL_UTILITY_MODE == 0) {
            UTILITY_MODE = CONTROL_UTILITY_MODE;
            CONTROL_MODE = MODE_NO_ACT;
        } else {
            CONTROL_MODE = CONTROL_UTILITY_MODE;
            UTILITY_MODE = MODE_NO_ACT;
        }



        // UTILITY MODE ------------------------------------------------------------

        switch (UTILITY_MODE) {
            case MODE_NO_ACT: {
                break;
            }

            case MODE_TORQUE_SENSOR_NULLING: {
                // DAC Voltage reference set
                if (TMR3_COUNT_TORQUE_NULL < TMR_FREQ_5k * 2) {
                    CUR_TORQUE_sum += torq.sen;

                    if (TMR3_COUNT_TORQUE_NULL % 10 == 0) {
                        CUR_TORQUE_mean = CUR_TORQUE_sum / 10.0f;
                        CUR_TORQUE_sum = 0;

                        TORQUE_VREF -= 0.000003f * (0.0f - CUR_TORQUE_mean);

                        if (TORQUE_VREF > 3.3f) TORQUE_VREF = 3.3f;
                        if (TORQUE_VREF < 0.0f) TORQUE_VREF = 0.0f;

                        //spi_eeprom_write(RID_TORQUE_SENSOR_VREF, (int16_t) (TORQUE_VREF * 1000.0));
                        dac_1 = TORQUE_VREF / 3.3f;
                    }
                } else {
                    CONTROL_UTILITY_MODE = MODE_NO_ACT;
                    TMR3_COUNT_TORQUE_NULL = 0;
                    CUR_TORQUE_sum = 0;
                    CUR_TORQUE_mean = 0;

//                    ROM_RESET_DATA();
                    spi_eeprom_write(RID_TORQUE_SENSOR_VREF, (int16_t) (TORQUE_VREF * 1000.0f));

                    dac_1 = TORQUE_VREF / 3.3f;

                }
                TMR3_COUNT_TORQUE_NULL++;
                break;
            }

//            case MODE_VALVE_NULLING_AND_DEADZONE_SETTING: {
//                if (TMR3_COUNT_DEADZONE == 0) {
//                    if (pos_plus_end == pos_minus_end) need_enc_init = true;
//                    else temp_time = 0;
//                }
//                if (need_enc_init) {
//                    if (TMR3_COUNT_DEADZONE < (int) (0.5f * (float) TMR_FREQ_5k)) {
//                        V_out = VALVE_VOLTAGE_LIMIT * 1000.0f;
//                        pos_plus_end = pos.sen;
//                    } else if (TMR3_COUNT_DEADZONE < TMR_FREQ_5k) {
//                        V_out = -VALVE_VOLTAGE_LIMIT * 1000.0f;
//                        pos_minus_end = pos.sen;
//                    } else if (TMR3_COUNT_DEADZONE == TMR_FREQ_5k) need_enc_init = false;
//                    temp_time = TMR_FREQ_5k;
//                }
//
//                if (temp_time <= TMR3_COUNT_DEADZONE && TMR3_COUNT_DEADZONE < (temp_time + TMR_FREQ_5k)) {
//                    V_out = (float) P_GAIN_JOINT_POSITION * (0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end - (float) pos.sen);
//                    VALVE_CENTER = VALVE_DEADZONE_PLUS = VALVE_DEADZONE_MINUS = 0;
//
//                } else if (temp_time <= TMR3_COUNT_DEADZONE && TMR3_COUNT_DEADZONE < (temp_time + (int) (1.9f * (float) TMR_FREQ_5k))) {
//                    V_out = 0;
//                    CUR_VELOCITY_sum += CUR_VELOCITY;
//                } else if (TMR3_COUNT_DEADZONE == (temp_time + 2 * TMR_FREQ_5k)) {
//                    if (CUR_VELOCITY_sum == 0) DZ_dir = 1;
//                    else if (CUR_VELOCITY_sum > 0) DZ_dir = 1;
//                    else if (CUR_VELOCITY_sum < 0) DZ_dir = -1;
//                    else DZ_temp_cnt2 = DZ_end;
//                    CUR_VELOCITY_sum = 0;
//                } else if (TMR3_COUNT_DEADZONE > (temp_time + 2 * TMR_FREQ_5k)) {
//                    if (TMR3_COUNT_DEADZONE > (temp_time + 10 * TMR_FREQ_5k)) DZ_temp_cnt2 = DZ_end;
//
//                    // Position of Dead Zone
//                    //  (CUR_VELOCITY < 0)  (CUR_VELOCITY == 0)  (CUR_VELOCITY > 0)
//                    //     |        /                 |    /                      |/
//                    //     | ______/               ___|___/                ______/|
//                    //     |/                     /   |                   /       |
//                    //    /|                     /    |                  /        |
//                    //     0V                         0V                          0V
//
//                    if (DZ_temp_cnt2 < DZ_end) {
//                        if (TMR3_COUNT_DEADZONE % 20 != 0) {
//                            CUR_VELOCITY_sum += CUR_VELOCITY;
//                        } else {
//                            V_out -= DZ_dir;
//                            if (CUR_VELOCITY_sum * DZ_dir < 0) DZ_temp_cnt++;
//                            CUR_VELOCITY_sum = 0;
//                        }
//                        if (DZ_temp_cnt == 5) {
//                            if (DZ_dir >= 0) VALVE_DEADZONE_MINUS = (int16_t) V_out;
//                            else VALVE_DEADZONE_PLUS = (int16_t) V_out;
//                            DZ_dir = -DZ_dir;
//                            DZ_temp_cnt = 0;
//                            DZ_temp_cnt2++;
//                        }
//                    } else {
//                        TMR3_COUNT_DEADZONE = -1;
//                        VALVE_CENTER = VALVE_DEADZONE_PLUS / 2 + VALVE_DEADZONE_MINUS / 2;
//                        if (VALVE_DEADZONE_PLUS < VALVE_DEADZONE_MINUS) {
//                            VALVE_DEADZONE_PLUS = VALVE_CENTER;
//                            VALVE_DEADZONE_MINUS = VALVE_CENTER;
//                        }
//                        V_out = 0;
//
//                        ROM_RESET_DATA();
//
//                        //spi_eeprom_write(RID_VALVE_DEADZONE_PLUS, VALVE_DEADZONE_PLUS);
//                        //spi_eeprom_write(RID_VALVE_DEADZONE_MINUS, VALVE_DEADZONE_MINUS);
//
//                        CONTROL_MODE = MODE_NO_ACT;
//                        DZ_temp_cnt2 = 0;
//                    }
//                }
//                TMR3_COUNT_DEADZONE++;
//                break;
//            }

            case MODE_FIND_HOME: {
                if (FINDHOME_STAGE == FINDHOME_INIT) {
                    cnt_findhome = 0;
                    cnt_vel_findhome = 0;
                    //REFERENCE_MODE = MODE_REF_NO_ACT; // Stop taking reference data from PODO
                    pos.ref = pos.sen;
                    vel.ref = 0.0f;
                    FINDHOME_STAGE = FINDHOME_GOTOLIMIT;
                } else if (FINDHOME_STAGE == FINDHOME_GOTOLIMIT) {
                    int cnt_check_enc = (TMR_FREQ_5k/20);
                    if(cnt_findhome%cnt_check_enc == 0) {
                        FINDHOME_POSITION = pos.sen;
                        FINDHOME_VELOCITY = FINDHOME_POSITION - FINDHOME_POSITION_OLD;
                        FINDHOME_POSITION_OLD = FINDHOME_POSITION;
                    }
                    cnt_findhome++;

                    if (abs(FINDHOME_VELOCITY) <= 1) {
                        cnt_vel_findhome = cnt_vel_findhome + 1;
                    } else {
                        cnt_vel_findhome = 0;
                    }

                    if ((cnt_vel_findhome < 3*TMR_FREQ_5k) &&  cnt_findhome < 10*TMR_FREQ_5k) { // wait for 3sec
                        //REFERENCE_MODE = MODE_REF_NO_ACT;
                        if (HOMEPOS_OFFSET > 0) pos.ref = pos.ref + 12.0f;
                        else pos.ref = pos.ref - 12.0f;

//                        pos.err = pos.ref_home_pos - pos.sen;
//                        float VALVE_POS_RAW_POS_FB = 0.0f;
//                        VALVE_POS_RAW_POS_FB = (float) P_GAIN_JOINT_POSITION * pos.err/(float) ENC_PULSE_PER_POSITION * 0.01f;
//                        valve_pos.ref = VALVE_POS_RAW_POS_FB + (float) VALVE_CENTER;
//                        VALVE_POS_CONTROL(valve_pos.ref);

                        CONTROL_MODE = MODE_JOINT_CONTROL;
                        alpha_trans = 0.0f;


                    } else {
                        ENC_SET(HOMEPOS_OFFSET);
//                        ENC_SET_ZERO();
                        INIT_REF_POS = HOMEPOS_OFFSET;
                        REF_POSITION = 0;
                        REF_VELOCITY = 0;
                        FINDHOME_POSITION = 0;
                        FINDHOME_POSITION_OLD = 0;
                        FINDHOME_VELOCITY = 0;
                        cnt_findhome = 0;
                        cnt_vel_findhome = 0;
                        FINDHOME_STAGE = FINDHOME_ZEROPOSE;


                        cnt_findhome = 0;
                        pos.ref = 0.0f;
                        vel.ref = 0.0f;
                        pos.ref_home_pos = 0.0f;
                        vel.ref_home_pos = 0.0f;
                        //FINDHOME_STAGE = FINDHOME_INIT;
                        //CONTROL_UTILITY_MODE = MODE_JOINT_CONTROL;


                    }
                } else if (FINDHOME_STAGE == FINDHOME_ZEROPOSE) {
                    int T_move = 2*TMR_FREQ_5k;
                    pos.ref = (0.0f - (float)INIT_REF_POS)*0.5f*(1.0f - cos(3.14159f * (float)cnt_findhome / (float)T_move)) + (float)INIT_REF_POS;
                    //pos.ref = 0.0f;
                    vel.ref = 0.0f;

                    // input for position control

//                    CONTROL_MODE = MODE_JOINT_CONTROL;
                    alpha_trans = 0.0f;

                    double torq_ref = 0.0f;
                    pos.err = (pos.ref - pos.sen)/(float)(ENC_PULSE_PER_POSITION); //[mm]
                    vel.err = (0.0f - vel.sen)/(float)(ENC_PULSE_PER_POSITION); //[mm/s]
                    pos.err_sum += pos.err/(float) TMR_FREQ_5k; //[mm]

                    if (((OPERATING_MODE&0b110)>>1) == 0 || ((OPERATING_MODE&0b110)>>1) == 1) {

                        double I_REF_POS = 0.0f;
                        double I_REF_FORCE_FB = 0.0f; // I_REF by Force Feedback
                        double I_REF_VC = 0.0f; // I_REF for velocity compensation

                        double temp_vel_pos = 0.0f;
                        double temp_vel_torq = 0.0f;
                        double wn_Pos = 2.0f * PI * 5.0f; // f_cut : 5Hz Position Control

                        if ((OPERATING_MODE & 0x01) == 0) { // Rotary Mode
                            temp_vel_pos = (0.01f * (double) P_GAIN_JOINT_POSITION * wn_Pos * pos.err + 0.01f * (double) I_GAIN_JOINT_POSITION * wn_Pos * pos.err_sum + 0.01f * (double) VELOCITY_COMP_GAIN * vel.ref / ENC_PULSE_PER_POSITION) * 3.14159f / 180.0f; // rad/s
                            //                            L when P-gain = 100, f_cut = 10Hz                                 L feedforward velocity
                        } else if ((OPERATING_MODE & 0x01) == 1) {
                            temp_vel_pos = (0.01f * (double) P_GAIN_JOINT_POSITION * wn_Pos * pos.err + 0.01f * (double) I_GAIN_JOINT_POSITION * wn_Pos * pos.err_sum + 0.01f * (double) VELOCITY_COMP_GAIN * vel.ref / ENC_PULSE_PER_POSITION); // mm/s
                            //                            L when P-gain = 100, f_cut = 10Hz                                 L feedforward velocity
                        }
                        if (temp_vel_pos > 0.0f) I_REF_POS = temp_vel_pos * ((double) PISTON_AREA_A * 0.00006f / (K_v * sqrt(2.0f * alpha3 / (alpha3 + 1.0f))));
                        else I_REF_POS = temp_vel_pos * ((double) PISTON_AREA_B * 0.00006f / (K_v * sqrt(2.0f / (alpha3 + 1.0f))));

                        I_REF = I_REF_POS;



                    } else {
                        float VALVE_POS_RAW_FORCE_FB = 0.0f;
                        VALVE_POS_RAW_FORCE_FB = DDV_JOINT_POS_FF(vel.sen) + (P_GAIN_JOINT_POSITION * 0.01f * pos.err + DDV_JOINT_POS_FF(vel.ref));

                        if (VALVE_POS_RAW_FORCE_FB >= 0) {
                            valve_pos.ref = VALVE_POS_RAW_FORCE_FB + VALVE_DEADZONE_PLUS;
                        } else {
                            valve_pos.ref = VALVE_POS_RAW_FORCE_FB + VALVE_DEADZONE_MINUS;
                        }

                        VALVE_POS_CONTROL(valve_pos.ref);

                        V_out = (float) Vout.ref;

                    }




//                    pos.err = pos.ref - (float)pos.sen;
//                    float VALVE_POS_RAW_POS_FB = 0.0f;
//                    VALVE_POS_RAW_POS_FB = (float) P_GAIN_JOINT_POSITION * 0.01f * pos.err/(float) ENC_PULSE_PER_POSITION;
//                    valve_pos.ref = VALVE_POS_RAW_POS_FB + (float) VALVE_CENTER;
//                    VALVE_POS_CONTROL(valve_pos.ref);

                    cnt_findhome++;
                    if (cnt_findhome >= T_move) {
                        //REFERENCE_MODE = MODE_REF_DIRECT;
                        cnt_findhome = 0;
                        pos.ref = 0.0f;
                        vel.ref = 0.0f;
                        pos.ref_home_pos = 0.0f;
                        vel.ref_home_pos = 0.0f;
                        FINDHOME_STAGE = FINDHOME_INIT;
                        CONTROL_UTILITY_MODE = MODE_JOINT_CONTROL;
                    }
                }

                break;
            }

//            case MODE_VALVE_GAIN_SETTING: {
//                if (TMR3_COUNT_FLOWRATE == 0) {
//                    if (pos_plus_end == pos_minus_end) need_enc_init = true;
//                    else {
//                        V_out = -VALVE_VOLTAGE_LIMIT * 1000.0f;
//                        temp_time = (int) (0.5f * (float) TMR_FREQ_5k);
//                    }
//                }
//                if (need_enc_init) {
//                    if (TMR3_COUNT_FLOWRATE < (int) (0.5f * (float) TMR_FREQ_5k)) {
//                        V_out = VALVE_VOLTAGE_LIMIT * 1000.0f;
//                        pos_plus_end = pos.sen;
//                    } else if (TMR3_COUNT_FLOWRATE < TMR_FREQ_5k) {
//                        V_out = -VALVE_VOLTAGE_LIMIT * 1000.0f;
//                        pos_minus_end = pos.sen;
//                    } else if (TMR3_COUNT_FLOWRATE == TMR_FREQ_5k) {
//                        need_enc_init = false;
//                        check_vel_pos_init = (int) (0.9f * (float) (pos_plus_end - pos_minus_end));
//                        check_vel_pos_fin = (int) (0.95f * (float) (pos_plus_end - pos_minus_end));
//                        check_vel_pos_interv = check_vel_pos_fin - check_vel_pos_init;
//                    }
//                    temp_time = TMR_FREQ_5k;
//                }
//                TMR3_COUNT_FLOWRATE++;
//                if (TMR3_COUNT_FLOWRATE > temp_time) {
//                    if (flag_flowrate % 2 == 0) { // (+)
//                        VALVE_VOLTAGE = 1000.0f * (float) (flag_flowrate / 2 + 1);
//                        V_out = VALVE_VOLTAGE;
//                        if (pos.sen > (pos_minus_end + check_vel_pos_init) && pos.sen < (pos_minus_end + check_vel_pos_fin)) {
//                            fl_temp_cnt++;
//                        } else if (pos.sen >= (pos_minus_end + check_vel_pos_fin) && CUR_VELOCITY == 0) {
//                            VALVE_GAIN_LPM_PER_V[flag_flowrate] = 0.95873f * 0.5757f * (float) TMR_FREQ_5k / 10000.0 * (float) check_vel_pos_interv / (float) fl_temp_cnt / VALVE_VOLTAGE; // 0.9587=6*pi/65536*10000 0.5757=0.02525*0.02*0.0095*2*60*1000
//                            //                        VALVE_GAIN_LPM_PER_V[flag_flowrate] = (float) TMR_FREQ_10k * (float) check_vel_pos_interv / (float) fl_temp_cnt / VALVE_VOLTAGE; // PULSE/sec
//                            fl_temp_cnt2++;
//                        }
//                    } else if (flag_flowrate % 2 == 1) { // (-)
//                        VALVE_VOLTAGE = -1. * (float) (flag_flowrate / 2 + 1);
//                        V_out = VALVE_VOLTAGE;
//                        if (pos.sen < (pos_plus_end - check_vel_pos_init) && pos.sen > (pos_plus_end - check_vel_pos_fin)) {
//                            fl_temp_cnt++;
//                        } else if (pos.sen <= (pos_plus_end - check_vel_pos_fin) && CUR_VELOCITY == 0) {
//                            VALVE_GAIN_LPM_PER_V[flag_flowrate] = 0.95873f * 0.5757f * (float) TMR_FREQ_5k / 10000.0f * (float) check_vel_pos_interv / (float) fl_temp_cnt / (-VALVE_VOLTAGE);
//                            //                        VALVE_GAIN_LPM_PER_V[flag_flowrate] = (float) TMR_FREQ_10k * (float) check_vel_pos_interv / (float) fl_temp_cnt / (-VALVE_VOLTAGE); // PULSE/sec
//                            fl_temp_cnt2++;
//                        }
//                    }
//                    if (fl_temp_cnt2 == 100) {
//
//                        ROM_RESET_DATA();
//
//                        //spi_eeprom_write(RID_VALVE_GAIN_PLUS_1 + flag_flowrate, (int16_t) (VALVE_GAIN_LPM_PER_V[flag_flowrate] * 100.0f));
//                        cur_vel_sum = 0;
//                        fl_temp_cnt = 0;
//                        fl_temp_cnt2 = 0;
//                        flag_flowrate++;
//                    }
//                    if (flag_flowrate == 10) {
//                        V_out = 0;
//                        flag_flowrate = 0;
//                        TMR3_COUNT_FLOWRATE = 0;
//                        valve_gain_repeat_cnt++;
//                        if (valve_gain_repeat_cnt >= 1) {
//                            CONTROL_MODE = MODE_NO_ACT;
//                            valve_gain_repeat_cnt = 0;
//                        }
//
//                    }
//                    break;
//                }
//
//            }
            case MODE_PRESSURE_SENSOR_NULLING: {
                // DAC Voltage reference set
                if (TMR3_COUNT_PRES_NULL < TMR_FREQ_5k * 2) {
                    CUR_PRES_A_sum += pres_A.sen;
                    CUR_PRES_B_sum += pres_B.sen;

                    if (TMR3_COUNT_PRES_NULL % 10 == 0) {
                        CUR_PRES_A_mean = CUR_PRES_A_sum / 10.0f;
                        CUR_PRES_B_mean = CUR_PRES_B_sum / 10.0f;
                        CUR_PRES_A_sum = 0;
                        CUR_PRES_B_sum = 0;

                        float VREF_NullingGain = 0.0003f;
                        PRES_A_VREF = PRES_A_VREF + VREF_NullingGain * CUR_PRES_A_mean;
                        PRES_B_VREF = PRES_B_VREF + VREF_NullingGain * CUR_PRES_B_mean;

                        if (PRES_A_VREF > 3.3f) PRES_A_VREF = 3.3f;
                        if (PRES_A_VREF < 0.0f) PRES_A_VREF = 0.0f;
                        if (PRES_B_VREF > 3.3f) PRES_B_VREF = 3.3f;
                        if (PRES_B_VREF < 0.0f) PRES_B_VREF = 0.0f;

                        dac_1 = PRES_A_VREF / 3.3f;
                        dac_2 = PRES_B_VREF / 3.3f;
                    }
                } else {
                    CONTROL_UTILITY_MODE = MODE_NO_ACT;
                    TMR3_COUNT_PRES_NULL = 0;
                    CUR_PRES_A_sum = 0;
                    CUR_PRES_B_sum = 0;
                    CUR_PRES_A_mean = 0;
                    CUR_PRES_B_mean = 0;

//                    ROM_RESET_DATA();
                    spi_eeprom_write(RID_PRES_A_SENSOR_VREF, (int16_t) (PRES_A_VREF * 1000.0f));
                    spi_eeprom_write(RID_PRES_B_SENSOR_VREF, (int16_t) (PRES_B_VREF * 1000.0f));

                    dac_1 = PRES_A_VREF / 3.3f;
                    dac_2 = PRES_B_VREF / 3.3f;
                    //pc.printf("nulling end");
                }
                TMR3_COUNT_PRES_NULL++;
                break;
            }

//            case MODE_PRESSURE_SENSOR_CALIB: {
//                if (TMR3_COUNT_PRES_CALIB < 2 * TMR_FREQ_5k) {
//                    V_out = -VALVE_VOLTAGE_LIMIT * 1000.0f;
//                    if (TMR3_COUNT_PRES_CALIB >= TMR_FREQ_5k) {
//                        CUR_PRES_A_sum += CUR_PRES_A;
//                    }
//                } else if (TMR3_COUNT_PRES_CALIB < 4 * TMR_FREQ_5k) {
//                    V_out = VALVE_VOLTAGE_LIMIT * 1000.0f;
//                    if (TMR3_COUNT_PRES_CALIB >= 3 * TMR_FREQ_5k) {
//                        CUR_PRES_B_sum += CUR_PRES_B;
//                    }
//                } else {
//                    CONTROL_MODE = MODE_NO_ACT;
//                    TMR3_COUNT_PRES_CALIB = 0;
//                    V_out = 0;
//                    PRES_SENSOR_A_PULSE_PER_BAR = CUR_PRES_A_sum / ((float) TMR_FREQ_5k - 1.0f) - PRES_A_NULL;
//                    PRES_SENSOR_A_PULSE_PER_BAR = PRES_SENSOR_A_PULSE_PER_BAR / ((float) PRES_SUPPLY - 1.0f);
//                    PRES_SENSOR_B_PULSE_PER_BAR = CUR_PRES_B_sum / ((float) TMR_FREQ_5k - 1.0f) - PRES_B_NULL;
//                    PRES_SENSOR_B_PULSE_PER_BAR = PRES_SENSOR_B_PULSE_PER_BAR / ((float) PRES_SUPPLY - 1.0f);
//                    CUR_PRES_A_sum = 0;
//                    CUR_PRES_B_sum = 0;
//                    CUR_PRES_A_mean = 0;
//                    CUR_PRES_B_mean = 0;
//
//                    ROM_RESET_DATA();
//
//                    //spi_eeprom_write(RID_PRES_SENSOR_A_PULSE_PER_BAR, (int16_t) (PRES_SENSOR_A_PULSE_PER_BAR * 100.0f));
//                    //spi_eeprom_write(RID_PRES_SENSOR_B_PULSE_PER_BAR, (int16_t) (PRES_SENSOR_B_PULSE_PER_BAR * 100.0f));
//                }
//                TMR3_COUNT_PRES_CALIB++;
//                break;
//            }

//            case MODE_ROTARY_FRICTION_TUNING: {
//                if (TMR3_COUNT_ROTARY_FRIC_TUNE % (5 * TMR_FREQ_5k) == 0) freq_fric_tune = 4.0f + 3.0f * sin(2 * 3.14159f * 0.5f * TMR3_COUNT_ROTARY_FRIC_TUNE * 0.0001f * 0.05f);
//                V_out = PWM_out * sin(2 * 3.14159f * freq_fric_tune * TMR3_COUNT_ROTARY_FRIC_TUNE * 0.0001f);
//                if (V_out > 0) V_out = VALVE_VOLTAGE_LIMIT * 1000.0f;
//                else V_out = -VALVE_VOLTAGE_LIMIT * 1000.0f;
//                TMR3_COUNT_ROTARY_FRIC_TUNE++;
//                if (TMR3_COUNT_ROTARY_FRIC_TUNE > TUNING_TIME * TMR_FREQ_5k) {
//                    TMR3_COUNT_ROTARY_FRIC_TUNE = 0;
//                    V_out = 0.0f;
//                    CONTROL_MODE = MODE_NO_ACT;
//                }
//                break;
//            }

            case MODE_DDV_POS_VS_PWM_ID: {
                CONTROL_MODE = MODE_VALVE_OPEN_LOOP;
                VALVE_ID_timer = VALVE_ID_timer + 1;

                if(VALVE_ID_timer < TMR_FREQ_5k*1) {
                    Vout.ref = 3000.0f * sin(2.0f*3.14f*VALVE_ID_timer/TMR_FREQ_5k * 100.0f);
                } else if(VALVE_ID_timer < TMR_FREQ_5k*2) {
                    Vout.ref = 1000.0f*(ID_index_array[ID_index]);
                } else if(VALVE_ID_timer == TMR_FREQ_5k*2) {
                    VALVE_POS_TMP = 0;
                    data_num = 0;
                } else if(VALVE_ID_timer < TMR_FREQ_5k*3) {
                    data_num = data_num + 1;
                    VALVE_POS_TMP = VALVE_POS_TMP + value;
                } else if(VALVE_ID_timer == TMR_FREQ_5k*3) {
                    Vout.ref = 0.0f;
                } else {
                    VALVE_POS_AVG[ID_index] = VALVE_POS_TMP / data_num;
                    VALVE_ID_timer = 0;
                    ID_index= ID_index +1;
                }

                if(ID_index>=25) {
                    int i;
                    VALVE_POS_AVG_OLD = VALVE_POS_AVG[0];
                    for(i=0; i<25; i++) {
                        VALVE_POS_VS_PWM[i] = (int16_t) (VALVE_POS_AVG[i]);
                        if(VALVE_POS_AVG[i] > VALVE_POS_AVG_OLD) {
                            VALVE_MAX_POS = VALVE_POS_AVG[i];
                            VALVE_POS_AVG_OLD = VALVE_MAX_POS;
                        } else if(VALVE_POS_AVG[i] < VALVE_POS_AVG_OLD) {
                            VALVE_MIN_POS = VALVE_POS_AVG[i];
                            VALVE_POS_AVG_OLD = VALVE_MIN_POS;
                        }
                    }
//                    ROM_RESET_DATA();
                    spi_eeprom_write(RID_VALVE_MAX_POS, (int16_t) VALVE_MAX_POS);
                    spi_eeprom_write(RID_VALVE_MIN_POS, (int16_t) VALVE_MIN_POS);
                    for(int i=0; i<25; i++) {
                        spi_eeprom_write(RID_VALVE_POS_VS_PWM_0 + i, (int16_t) VALVE_POS_VS_PWM[i]);
                    }
                    ID_index = 0;
                    CONTROL_UTILITY_MODE = MODE_NO_ACT;
                }


                break;
            }

            case MODE_DDV_DEADZONE_AND_CENTER: {
                CONTROL_MODE = MODE_VALVE_OPEN_LOOP;
                VALVE_DZ_timer = VALVE_DZ_timer + 1;
                if(first_check == 0) {
                    if(VALVE_DZ_timer < (int) (1.0f * (float) TMR_FREQ_5k)) {
                        Vout.ref = VALVE_VOLTAGE_LIMIT * 1000.0f;
                    } else if(VALVE_DZ_timer == (int) (1.0f * (float) TMR_FREQ_5k)) {
                        Vout.ref = VALVE_VOLTAGE_LIMIT * 1000.0f;
                        pos_plus_end = pos.sen;
                    } else if(VALVE_DZ_timer < (int) (2.0f * (float) TMR_FREQ_5k)) {
                        Vout.ref = -VALVE_VOLTAGE_LIMIT * 1000.0f;
                    } else if(VALVE_DZ_timer == (int) (2.0f * (float) TMR_FREQ_5k)) {
                        Vout.ref = -VALVE_VOLTAGE_LIMIT * 1000.0f;
                        pos_minus_end = pos.sen;
                    } else if(VALVE_DZ_timer < (int) (3.0f * (float) TMR_FREQ_5k)) {
                        Vout.ref = (float) P_GAIN_JOINT_POSITION * (0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end - (float) pos.sen)/(float) ENC_PULSE_PER_POSITION;
                    } else if(VALVE_DZ_timer < (int) (4.0f * (float) TMR_FREQ_5k)) {
                        Vout.ref = (float) P_GAIN_JOINT_POSITION * (0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end - (float) pos.sen)/(float) ENC_PULSE_PER_POSITION;
                        data_num = data_num + 1;
                        VALVE_POS_TMP = VALVE_POS_TMP + value;
                    } else if(VALVE_DZ_timer == (int) (4.0f * (float) TMR_FREQ_5k)) {
                        Vout.ref = (float) P_GAIN_JOINT_POSITION * (0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end - (float) pos.sen)/(float) ENC_PULSE_PER_POSITION;
                        DDV_POS_AVG = VALVE_POS_TMP / data_num;
                        START_POS = pos.sen;
                        VALVE_POS_TMP = 0;
                        data_num = 0;

                    } else if(VALVE_DZ_timer < (int) (5.0f * (float) TMR_FREQ_5k)) {
                        valve_pos.ref = DDV_POS_AVG;
                        VALVE_POS_CONTROL(valve_pos.ref);

                    } else if(VALVE_DZ_timer < (int) (6.0f * (float) TMR_FREQ_5k)) {
                        valve_pos.ref = DDV_POS_AVG;
                        VALVE_POS_CONTROL(valve_pos.ref);

                    } else if(VALVE_DZ_timer == (int) (6.0f * (float) TMR_FREQ_5k)) {
                        valve_pos.ref = DDV_POS_AVG;
                        VALVE_POS_CONTROL(valve_pos.ref);
                        FINAL_POS = pos.sen;

                        if((FINAL_POS - START_POS)>200) {
                            DZ_case = 1;
                        } else if((FINAL_POS - START_POS)<-200) {
                            DZ_case = -1;
                        } else {
                            DZ_case = 0;
                        }

                        CAN_TX_PRES((int16_t) (DZ_case), (int16_t) (6));

                        first_check = 1;
                        DZ_DIRECTION = 1;
                        VALVE_DZ_timer = 0;
                        Ref_Valve_Pos_Old = DDV_POS_AVG;
                        DZ_NUM = 1;
                        DZ_index = 1;

                    }
                } else {
                    if((DZ_case == -1 && DZ_NUM == 1) | (DZ_case == 1 && DZ_NUM == 1)) {
                        if(VALVE_DZ_timer < (int) (1.0 * (float) TMR_FREQ_5k)) {
                            Vout.ref = (float) P_GAIN_JOINT_POSITION * (0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end - (float) pos.sen)/(float) ENC_PULSE_PER_POSITION;
                            //pos.ref = 0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end;
                            //CONTROL_MODE = MODE_JOINT_CONTROL;
                        } else if(VALVE_DZ_timer == (int) (1.0f * (float) TMR_FREQ_5k)) {
                            START_POS = pos.sen;
                        } else if(VALVE_DZ_timer < (int) (2.0f * (float) TMR_FREQ_5k)) {
                            valve_pos.ref = Ref_Valve_Pos_Old  - DZ_case * DZ_DIRECTION * 64 / DZ_index;
                            if(valve_pos.ref <= VALVE_MIN_POS) {
                                valve_pos.ref = VALVE_MIN_POS;
                            } else if(valve_pos.ref >= VALVE_MAX_POS) {
                                valve_pos.ref = VALVE_MAX_POS;
                            }
                            VALVE_POS_CONTROL(valve_pos.ref);

                        } else if(VALVE_DZ_timer == (int) (2.0f * (float) TMR_FREQ_5k)) {
                            Ref_Valve_Pos_Old = valve_pos.ref;
                            FINAL_POS = pos.sen;

                            if((FINAL_POS - START_POS)>100) {
                                DZ_DIRECTION = 1 * DZ_case;
                            } else if((FINAL_POS - START_POS)<-100) {
                                DZ_DIRECTION = -1 * DZ_case;
                            } else {
                                DZ_DIRECTION = 1 * DZ_case;
                            }

                            VALVE_DZ_timer = 0;
                            DZ_index= DZ_index *2;
                            if(DZ_index >= 128) {
                                FIRST_DZ = valve_pos.ref;
                                DZ_NUM = 2;
                                Ref_Valve_Pos_Old = FIRST_DZ;
                                DZ_index = 1;
                                DZ_DIRECTION = 1;
                            }
                        }
                    } else if((DZ_case == -1 && DZ_NUM == 2) | (DZ_case == 1 && DZ_NUM == 2)) {
                        if(VALVE_DZ_timer < (int) (1.0f * (float) TMR_FREQ_5k)) {
                            Vout.ref = (float) P_GAIN_JOINT_POSITION * (0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end - (float) pos.sen)/(float) ENC_PULSE_PER_POSITION;
                            //pos.ref = 0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end;
                            //CONTROL_MODE = MODE_JOINT_CONTROL;
                        } else if(VALVE_DZ_timer == (int) (1.0f * (float) TMR_FREQ_5k)) {
                            START_POS = pos.sen;
                        } else if(VALVE_DZ_timer < (int) (2.0f * (float) TMR_FREQ_5k)) {
                            valve_pos.ref = Ref_Valve_Pos_Old  - DZ_case * DZ_DIRECTION * 64 / DZ_index;
                            if(valve_pos.ref <= VALVE_MIN_POS) {
                                valve_pos.ref = VALVE_MIN_POS;
                            } else if(valve_pos.ref >= VALVE_MAX_POS) {
                                valve_pos.ref = VALVE_MAX_POS;
                            }
                            VALVE_POS_CONTROL(valve_pos.ref);

                        } else if(VALVE_DZ_timer == (int) (2.0f * (float) TMR_FREQ_5k)) {
                            Vout.ref = 0.0f;
                        } else if(VALVE_DZ_timer > (int) (2.0f * (float) TMR_FREQ_5k)) {
                            Ref_Valve_Pos_Old = valve_pos.ref;
                            FINAL_POS = pos.sen;

                            if((FINAL_POS - START_POS)>100) {
                                DZ_DIRECTION = 1 * DZ_case;
                            } else if((FINAL_POS - START_POS)<-100) {
                                DZ_DIRECTION = -1 * DZ_case;
                            } else {
                                DZ_DIRECTION = -1 * DZ_case;
                            }

                            VALVE_DZ_timer = 0;
                            DZ_index= DZ_index * 2;
                            if(DZ_index >= 128) {
                                SECOND_DZ = valve_pos.ref;
                                VALVE_CENTER = (int) (0.5f * (float) (FIRST_DZ) + 0.5f * (float) (SECOND_DZ));
                                first_check = 0;
                                VALVE_DEADZONE_MINUS = (float) FIRST_DZ;
                                VALVE_DEADZONE_PLUS = (float) SECOND_DZ;

//                                ROM_RESET_DATA();
                                spi_eeprom_write(RID_VALVE_CNETER, (int16_t) VALVE_CENTER);
                                spi_eeprom_write(RID_VALVE_MAX_POS, (int16_t) VALVE_MAX_POS);
                                spi_eeprom_write(RID_VALVE_MIN_POS, (int16_t) VALVE_MIN_POS);

                                CONTROL_UTILITY_MODE = MODE_NO_ACT;
                                DZ_index = 1;
                            }
                        }
                    } else if(DZ_case == 0 && DZ_NUM ==1) {
                        if(VALVE_DZ_timer < (int) (1.0f * (float) TMR_FREQ_5k)) {
                            Vout.ref = (float) P_GAIN_JOINT_POSITION * (0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end - (float) pos.sen)/(float) ENC_PULSE_PER_POSITION;
                            //pos.ref = 0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end;
                            //CONTROL_MODE = MODE_JOINT_CONTROL;
                        } else if(VALVE_DZ_timer == (int) (1.0f * (float) TMR_FREQ_5k)) {
                            START_POS = pos.sen;
                        } else if(VALVE_DZ_timer < (int) (2.0f * (float) TMR_FREQ_5k)) {
                            valve_pos.ref = Ref_Valve_Pos_Old  - DZ_DIRECTION * 64 / DZ_index;
                            if(valve_pos.ref <= VALVE_MIN_POS) {
                                valve_pos.ref = VALVE_MIN_POS;
                            } else if(valve_pos.ref >= VALVE_MAX_POS) {
                                valve_pos.ref = VALVE_MAX_POS;
                            }
                            VALVE_POS_CONTROL(valve_pos.ref);

                        } else if(VALVE_DZ_timer == (int) (2.0f * (float) TMR_FREQ_5k)) {
                            Ref_Valve_Pos_Old = valve_pos.ref;
                            FINAL_POS = pos.sen;

                            if((FINAL_POS - START_POS)>100) {
                                DZ_DIRECTION = 1;
                            } else if((FINAL_POS - START_POS)<-100) {
                                DZ_DIRECTION = -1;
                            } else {
                                DZ_DIRECTION = 1;
                            }
                            VALVE_DZ_timer = 0;
                            DZ_index= DZ_index *2;
                            if(DZ_index >= 128) {
                                FIRST_DZ = valve_pos.ref;
                                DZ_NUM = 2;
                                Ref_Valve_Pos_Old = FIRST_DZ;
                                DZ_index = 1;
                                DZ_DIRECTION = 1;
                            }
                        }
                    } else {
                        if(VALVE_DZ_timer < (int) (1.0f * (float) TMR_FREQ_5k)) {
                            Vout.ref = (float) P_GAIN_JOINT_POSITION * (0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end - (float) pos.sen)/(float) ENC_PULSE_PER_POSITION;
                            //pos.ref = 0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end;
                            //CONTROL_MODE = MODE_JOINT_CONTROL;
                        } else if(VALVE_DZ_timer == (int) (1.0f * (float) TMR_FREQ_5k)) {
                            START_POS = pos.sen;
                        } else if(VALVE_DZ_timer < (int) (2.0f * (float) TMR_FREQ_5k)) {
                            valve_pos.ref = Ref_Valve_Pos_Old  + DZ_DIRECTION * 64 / DZ_index;
                            if(valve_pos.ref <= VALVE_MIN_POS) {
                                valve_pos.ref = VALVE_MIN_POS;
                            } else if(valve_pos.ref > VALVE_MAX_POS) {
                                valve_pos.ref = VALVE_MAX_POS - 1;
                            }
                            VALVE_POS_CONTROL(valve_pos.ref);

                        } else if(VALVE_DZ_timer == (int) (2.0f * (float) TMR_FREQ_5k)) {
                            Vout.ref = 0.0f;
                        } else if(VALVE_DZ_timer > (int) (2.0f * (float) TMR_FREQ_5k)) {
                            Ref_Valve_Pos_Old = valve_pos.ref;
                            FINAL_POS = pos.sen;

                            if((FINAL_POS - START_POS)>100) {
                                DZ_DIRECTION = 1;
                            } else if((FINAL_POS - START_POS)<-100) {
                                DZ_DIRECTION = -1;
                            } else {
                                DZ_DIRECTION = 1;
                            }

                            VALVE_DZ_timer = 0;
                            DZ_index= DZ_index *2;
                            if(DZ_index >= 128) {
                                SECOND_DZ = valve_pos.ref;
                                VALVE_CENTER = (int) (0.5f * (float) (FIRST_DZ) + 0.5f * (float) (SECOND_DZ));
                                first_check = 0;
                                VALVE_DEADZONE_MINUS = (float) FIRST_DZ;
                                VALVE_DEADZONE_PLUS = (float) SECOND_DZ;

//                                ROM_RESET_DATA();
                                spi_eeprom_write(RID_VALVE_CNETER, (int16_t) VALVE_CENTER);
                                spi_eeprom_write(RID_VALVE_MAX_POS, (int16_t) VALVE_MAX_POS);
                                spi_eeprom_write(RID_VALVE_MIN_POS, (int16_t) VALVE_MIN_POS);

                                CONTROL_UTILITY_MODE = MODE_NO_ACT;
                                DZ_index = 1;
                            }
                        }
                    }
                }
                break;
            }

            case MODE_DDV_POS_VS_FLOWRATE: {
                CONTROL_MODE = MODE_VALVE_OPEN_LOOP;
                VALVE_FR_timer = VALVE_FR_timer + 1;
                if(first_check == 0) {
                    if(VALVE_FR_timer < (int) (1.0f * (float) TMR_FREQ_5k)) {
                        Vout.ref = VALVE_VOLTAGE_LIMIT * 1000.0f;
                        //CAN_TX_PRES((int16_t) (VALVE_FR_timer), (int16_t) (6));
                    } else if(VALVE_FR_timer == (int) (1.0f * (float) TMR_FREQ_5k)) {
                        Vout.ref = VALVE_VOLTAGE_LIMIT * 1000.0f;
                        pos_plus_end = pos.sen;
                        //                    CAN_TX_PRES((int16_t) (V_out), (int16_t) (7));
                    } else if(VALVE_FR_timer < (int) (2.0f * (float) TMR_FREQ_5k)) {
                        Vout.ref = -VALVE_VOLTAGE_LIMIT * 1000.0f;
                    } else if(VALVE_FR_timer == (int) (2.0f * (float) TMR_FREQ_5k)) {
                        //                    CAN_TX_PRES((int16_t) (V_out), (int16_t) (8));
                        Vout.ref = -VALVE_VOLTAGE_LIMIT * 1000.0f;
                        pos_minus_end = pos.sen;
                        first_check = 1;
                        VALVE_FR_timer = 0;
                        valve_pos.ref = (float) VALVE_CENTER;
                        ID_index = 0;
                        max_check = 0;
                        min_check = 0;
                    }
                } else {
                    if(VALVE_FR_timer < (int) (1.0f * (float) TMR_FREQ_5k)) {
                        //V_out = (float) P_GAIN_JOINT_POSITION * (0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end - (float) pos.sen)/(float) ENC_PULSE_PER_POSITION;
                        pos.ref = 0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end;
                        CONTROL_MODE = MODE_JOINT_CONTROL;
                    } else if(VALVE_FR_timer == (int) (1.0f * (float) TMR_FREQ_5k)) {
                        data_num = 0;
                        valve_pos.ref = 10.0f*((float) ID_index_array[ID_index]) + (float) VALVE_CENTER;

                        VALVE_POS_CONTROL(valve_pos.ref);
                        START_POS = pos.sen;
                    } else if(VALVE_FR_timer < (int) (5.0f * (float) TMR_FREQ_5k)) {
                        valve_pos.ref = 10.0f*((float) ID_index_array[ID_index]) + (float) VALVE_CENTER;
                        VALVE_POS_CONTROL(valve_pos.ref);
                        data_num = data_num + 1;
                        if(abs(0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end - (float) pos.sen) > 20000.0f) {
                            FINAL_POS = pos.sen;
                            one_period_end = 1;
                        }
                    } else if(VALVE_FR_timer == (int) (5.0f * (float) TMR_FREQ_5k)) {
                        FINAL_POS = pos.sen;
                        one_period_end = 1;
                        V_out = 0.0f;
                    }

                    if(one_period_end == 1) {
                        if(valve_pos.ref > VALVE_MAX_POS) {
                            max_check = 1;
                        } else if(valve_pos.ref < VALVE_MIN_POS) {
                            min_check = 1;
                        }
                        JOINT_VEL[ID_index] = (FINAL_POS - START_POS) / data_num * TMR_FREQ_5k;   //  pulse/sec

                        VALVE_FR_timer = 0;
                        one_period_end = 0;
                        ID_index= ID_index +1;
                        V_out = 0.0f;
                    }

                    if(max_check == 1 && min_check == 1) {

                        VALVE_POS_NUM = ID_index;
//                        ROM_RESET_DATA();
                        for(int i=0; i<100; i++) {
                            spi_eeprom_write(RID_VALVE_POS_VS_FLOWRATE_0 + i, (int16_t) (JOINT_VEL[i] & 0xFFFF));
                            spi_eeprom_write(RID_VALVE_POS_VS_FLOWRATE_0_1 + i, (int16_t) ((JOINT_VEL[i] >> 16) & 0xFFFF));
                        }
                        ID_index = 0;
                        first_check = 0;
                        VALVE_FR_timer = 0;
                        CONTROL_UTILITY_MODE = MODE_NO_ACT;
//                        CAN_TX_PRES((int16_t) (VALVE_FR_timer), (int16_t) (6));
                    }
                }
                break;
            }

            case MODE_SYSTEM_ID: {
                freq_sysid_Iref = (double) cnt_sysid * DT_TMR3 * 3.0f;
                valve_pos.ref = 2500.0f * sin(2.0f * 3.14159f * freq_sysid_Iref * (double) cnt_sysid * DT_TMR3);
                CONTROL_MODE = MODE_VALVE_OPEN_LOOP;
                cnt_sysid++;
                if (freq_sysid_Iref >= 300) {
                    cnt_sysid = 0;
                    CONTROL_UTILITY_MODE = MODE_NO_ACT;
                }
                break;
            }

            case MODE_FREQ_TEST: {
                float valve_pos_ref = 2500.0f * sin(2.0f * 3.141592f * freq_test_valve_ref * (float) cnt_freq_test * DT_TMR3);
                if(valve_pos_ref >= 0) {
                    valve_pos.ref = (double)VALVE_CENTER + (double)valve_pos_ref * ((double)VALVE_MAX_POS-(double)VALVE_CENTER)/10000.0f;
                } else {
                    valve_pos.ref = (double)VALVE_CENTER - (double)valve_pos_ref * ((double)VALVE_MIN_POS-(double)VALVE_CENTER)/10000.0f;
                }
                ref_array[cnt_freq_test] = valve_pos_ref;
                if(value>=(float) VALVE_CENTER) {
                    pos_array[cnt_freq_test] = 10000.0f*((double)value - (double)VALVE_CENTER)/((double)VALVE_MAX_POS - (double)VALVE_CENTER);
                } else {
                    pos_array[cnt_freq_test] = -10000.0f*((double)value - (double)VALVE_CENTER)/((double)VALVE_MIN_POS - (double)VALVE_CENTER);
                }

                CONTROL_MODE = MODE_VALVE_POSITION_CONTROL;
                cnt_freq_test++;
                if (freq_test_valve_ref * (float) cnt_freq_test * DT_TMR3 > 2) {
                    buffer_data_size = cnt_freq_test;
                    cnt_freq_test = 0;
                    cnt_send_buffer = 0;
                    freq_test_valve_ref = freq_test_valve_ref * 1.05f;
                    if (freq_test_valve_ref >= 400) {
                        CONTROL_UTILITY_MODE = MODE_NO_ACT;
                        CONTROL_MODE = MODE_NO_ACT;
                        CAN_TX_PWM((int16_t) (1)); //1300
                    }
                    CONTROL_MODE = MODE_NO_ACT;
                    CONTROL_UTILITY_MODE = MODE_SEND_OVER;

                }
                break;
            }
            case MODE_SEND_BUFFER: {
//                if (TMR2_COUNT_CAN_TX % (int) ((int) TMR_FREQ_5k/CAN_FREQ) == 0) {
//                    CAN_TX_PRES((int16_t) (pos_array[cnt_send_buffer]), (int16_t) (ref_array[cnt_send_buffer])); // 1400
//                    if(cnt_send_buffer>=buffer_data_size) {
//                        CONTROL_UTILITY_MODE = MODE_FREQ_TEST;
//                    }
//                    cnt_send_buffer++;
//                }

                break;
            }
            case MODE_SEND_OVER: {
                CAN_TX_TORQUE((int16_t) (buffer_data_size)); //1300
                CONTROL_UTILITY_MODE = MODE_NO_ACT;
                CONTROL_MODE = MODE_NO_ACT;
                break;
            }

            case MODE_STEP_TEST: {
                float valve_pos_ref = 0.0f;
                if (cnt_step_test < (int) (1.0f * (float) TMR_FREQ_5k)) {
                    valve_pos_ref = 0.0f;
                } else {
                    valve_pos_ref = 10000.0f;
                }
                if(valve_pos_ref >= 0) {
                    valve_pos.ref = (double)VALVE_CENTER + (double)valve_pos_ref * ((double)VALVE_MAX_POS-(double)VALVE_CENTER)/10000.0f;
                } else {
                    valve_pos.ref = (double)VALVE_CENTER - (double)valve_pos_ref * ((double)VALVE_MIN_POS-(double)VALVE_CENTER)/10000.0f;
                }
                ref_array[cnt_step_test] = valve_pos_ref;
                if(value>=(float) VALVE_CENTER) {
                    pos_array[cnt_step_test] = 10000.0f*((double)value - (double)VALVE_CENTER)/((double)VALVE_MAX_POS - (double)VALVE_CENTER);
                } else {
                    pos_array[cnt_step_test] = -10000.0f*((double)value - (double)VALVE_CENTER)/((double)VALVE_MIN_POS - (double)VALVE_CENTER);
                }

                CONTROL_MODE = MODE_VALVE_POSITION_CONTROL;
                cnt_step_test++;
                if (cnt_step_test > (int) (2.0f * (float) TMR_FREQ_5k)) {
                    buffer_data_size = cnt_step_test;
                    cnt_step_test = 0;
                    cnt_send_buffer = 0;
                    CONTROL_UTILITY_MODE = MODE_SEND_OVER;
                    CONTROL_MODE = MODE_NO_ACT;
                }
//                if (cnt_step_test > (int) (2.0f * (float) TMR_FREQ_5k))
//                {
//                    CONTROL_UTILITY_MODE = MODE_NO_ACT;
//                    CONTROL_MODE = MODE_NO_ACT;
//                    CAN_TX_PWM((int16_t) (1)); //1300
//                }

                break;
            }

            default:
                break;
        }

        // CONTROL MODE ------------------------------------------------------------

        switch (CONTROL_MODE) {
            case MODE_NO_ACT: {
                V_out = 0.0f;
                break;
            }

            case MODE_VALVE_POSITION_CONTROL: {
                if (OPERATING_MODE == 5) { //SW Valve
                    ////For Test LIMC//////////////////////////////////////////
                    VALVE_POS_CONTROL(valve_pos.ref);
//                    for(int i=0; i<9; i++){
//                        valve_ref_pos_buffer[i] = valve_ref_pos_buffer[i+1];
//                    }
//                    valve_ref_pos_buffer[9] = valve_pos.ref;
//                    VALVE_POS_CONTROL(valve_ref_pos_buffer[0]);
                    ////////////////////////////////////////////////////////////

                    V_out = Vout.ref;
                } else if (CURRENT_CONTROL_MODE == 0) { //PWM
                    V_out = valve_pos.ref;
                } else {
                    I_REF = valve_pos.ref * 0.001f;
                }
                break;
            }

            case MODE_JOINT_CONTROL: {

                double torq_ref = 0.0f;
                pos.err = (pos.ref - pos.sen)/(float)(ENC_PULSE_PER_POSITION); //[mm]
                vel.err = (vel.ref - vel.sen)/(float)(ENC_PULSE_PER_POSITION); //[mm/s]
                pos.err_sum += pos.err/(float) TMR_FREQ_5k; //[mm]

                //K & D Low Pass Filter
                float alpha_K_D = 1.0f/(1.0f + 5000.0f/(2.0f*3.14f*30.0f)); // f_cutoff : 30Hz
                K_LPF = K_LPF*(1.0f-alpha_K_D)+K_SPRING*(alpha_K_D);
                D_LPF = D_LPF*(1.0f-alpha_K_D)+D_DAMPER*(alpha_K_D);
                torq_ref = torq.ref + K_LPF * pos.err - D_LPF * vel.sen / ENC_PULSE_PER_POSITION; //[N]
//                torq_ref = torq.ref;

                // torque feedback
                torq.err = torq_ref - torq.sen; //[N]
                torq.err_sum += torq.err/(float) TMR_FREQ_5k; //[N]

                if (((OPERATING_MODE&0b110)>>1) == 0 || ((OPERATING_MODE&0b110)>>1) == 1) {

                    double I_REF_POS = 0.0f;
                    double I_REF_FORCE_FB = 0.0f; // I_REF by Force Feedback
                    double I_REF_VC = 0.0f; // I_REF for velocity compensation

                    double temp_vel_pos = 0.0f;
                    double temp_vel_torq = 0.0f;
                    double wn_Pos = 2.0f * PI * 5.0f; // f_cut : 5Hz Position Control

                    if ((OPERATING_MODE & 0x01) == 0) { // Rotary Mode
                        temp_vel_pos = (0.01f * (double) P_GAIN_JOINT_POSITION * wn_Pos * pos.err + 0.01f * (double) I_GAIN_JOINT_POSITION * wn_Pos * pos.err_sum + 0.01f * (double) D_GAIN_JOINT_POSITION * wn_Pos * vel.err + 0.01f * (double) VELOCITY_COMP_GAIN * vel.ref / ENC_PULSE_PER_POSITION) * PI / 180.0f; // rad/s
                        //                            L when P-gain = 100, f_cut = 10Hz                                 L feedforward velocity
                    } else if ((OPERATING_MODE & 0x01) == 1) {
                        temp_vel_pos = (0.01f * (double) P_GAIN_JOINT_POSITION * wn_Pos * pos.err + 0.01f * (double) I_GAIN_JOINT_POSITION * wn_Pos * pos.err_sum + 0.01f * (double) D_GAIN_JOINT_POSITION * wn_Pos * vel.err + 0.01f * (double) VELOCITY_COMP_GAIN * vel.ref / ENC_PULSE_PER_POSITION); // mm/s
                        //                            L when P-gain = 100, f_cut = 10Hz                                 L feedforward velocity
                    }
                    if (temp_vel_pos > 0.0f) I_REF_POS = temp_vel_pos * ((double) PISTON_AREA_A * 0.00006f / (K_v * sqrt(2.0f * alpha3 / (alpha3 + 1.0f))));
                    else I_REF_POS = temp_vel_pos * ((double) PISTON_AREA_B * 0.00006f / (K_v * sqrt(2.0f / (alpha3 + 1.0f))));

                    // velocity compensation for torque control
                    if ((OPERATING_MODE & 0x01) == 0) { // Rotary Mode
                        I_REF_FORCE_FB = 0.001f * ((double) P_GAIN_JOINT_TORQUE * torq.err + (double) I_GAIN_JOINT_TORQUE * torq.err_sum);
                        //                temp_vel_torq = (0.01 * (double) VELOCITY_COMP_GAIN * (double) CUR_VELOCITY / (double) ENC_PULSE_PER_POSITION) * PI / 180.0; // rad/s
                        temp_vel_torq = (0.01f * (double) VELOCITY_COMP_GAIN * vel.ref / (double) ENC_PULSE_PER_POSITION) * PI / 180.0f; // rad/s
                        //                                                          L feedforward velocity
                    } else if ((OPERATING_MODE & 0x01) == 1) {
                        I_REF_FORCE_FB = 0.001f * 0.01f*((double) P_GAIN_JOINT_TORQUE * torq.err + (double) I_GAIN_JOINT_TORQUE * torq.err_sum); // Linear Actuators are more sensitive.
                        //                temp_vel_torq = (0.01 * (double) VELOCITY_COMP_GAIN * (double) CUR_VELOCITY / (double) ENC_PULSE_PER_POSITION); // mm/s
                        temp_vel_torq = (0.01f * (double) VELOCITY_COMP_GAIN * vel.ref / (double) ENC_PULSE_PER_POSITION); // mm/s
                        //                                                          L feedforward velocity
                    }
                    if (temp_vel_torq > 0.0f) I_REF_VC = temp_vel_torq * ((double) PISTON_AREA_A * 0.00006f / (K_v * sqrt(2.0f * alpha3 / (alpha3 + 1.0f))));
                    else I_REF_VC = temp_vel_torq * ((double) PISTON_AREA_B * 0.00006f / (K_v * sqrt(2.0f / (alpha3 + 1.0f))));
                    //                                                  L   velocity(rad/s or mm/s) >> I_ref(mA)
                    //            Ref_Joint_FT_dot = (Ref_Joint_FT_Nm - Ref_Joint_FT_Nm_old) / TMR_DT_5k;
                    //            Ref_Joint_FT_Nm_old = Ref_Joint_FT_Nm;

                    I_REF = (1.0f - alpha_trans) * I_REF_POS + alpha_trans * (I_REF_VC + I_REF_FORCE_FB);

                    // Anti-windup for FT
                    if (I_GAIN_JOINT_TORQUE != 0) {
                        double I_MAX = 10.0f; // Maximum Current : 10mV
                        double Ka = 2.0f / ((double) I_GAIN_JOINT_TORQUE * 0.001f);
                        if (I_REF > I_MAX) {
                            double I_rem = I_REF - I_MAX;
                            I_rem = Ka*I_rem;
                            I_REF = I_MAX;
                            torq.err_sum = torq.err_sum - I_rem /(float) TMR_FREQ_5k;
                        } else if (I_REF < -I_MAX) {
                            double I_rem = I_REF - (-I_MAX);
                            I_rem = Ka*I_rem;
                            I_REF = -I_MAX;
                            torq.err_sum = torq.err_sum - I_rem /(float) TMR_FREQ_5k;
                        }
                    }

                } else {
                    float VALVE_POS_RAW_FORCE_FB = 0.0f;
                    float VALVE_POS_RAW_FORCE_FF = 0.0f;
                    float VALVE_POS_RAW = 0.0f;

                    VALVE_POS_RAW_FORCE_FB = alpha_trans*(((float) P_GAIN_JOINT_TORQUE * torq.err + (float) I_GAIN_JOINT_TORQUE * torq.err_sum + (float) D_GAIN_JOINT_TORQUE * (torq.ref_diff - torq_dot.sen)) * 0.01f + DDV_JOINT_POS_FF(vel.sen))+ (1.0f-alpha_trans) * (P_GAIN_JOINT_POSITION * 0.01f * pos.err + DDV_JOINT_POS_FF(vel.ref));

                    VALVE_POS_RAW_FORCE_FF = P_GAIN_JOINT_TORQUE_FF * torq_ref * 0.001f + D_GAIN_JOINT_TORQUE_FF * (torq_ref - torq_ref_past) * 0.0001f;

                    VALVE_POS_RAW = VALVE_POS_RAW_FORCE_FB + VALVE_POS_RAW_FORCE_FF;


                    if (VALVE_POS_RAW >= 0) {
                        valve_pos.ref = VALVE_POS_RAW + VALVE_DEADZONE_PLUS;
                    } else {
                        valve_pos.ref = VALVE_POS_RAW + VALVE_DEADZONE_MINUS;
                    }

                    if(I_GAIN_JOINT_TORQUE != 0) {
                        double Ka = 2.0f / (double) I_GAIN_JOINT_TORQUE * 100.0f;
                        if(valve_pos.ref>VALVE_MAX_POS) {
                            double valve_pos_rem = valve_pos.ref - VALVE_MAX_POS;
                            valve_pos_rem = valve_pos_rem * Ka;
                            valve_pos.ref = VALVE_MAX_POS;
                            torq.err_sum = torq.err_sum - valve_pos_rem/(float) TMR_FREQ_5k;
                        } else if(valve_pos.ref < VALVE_MIN_POS) {
                            double valve_pos_rem = valve_pos.ref - VALVE_MIN_POS;
                            valve_pos_rem = valve_pos_rem * Ka;
                            valve_pos.ref = VALVE_MIN_POS;
                            torq.err_sum = torq.err_sum - valve_pos_rem/(float) TMR_FREQ_5k;
                        }
                    }

                    VALVE_POS_CONTROL(valve_pos.ref);

//                    Vout.ref = (float) P_GAIN_JOINT_POSITION * 0.01f * ((float) pos.err);
                    V_out = (float) Vout.ref;

                }

                torq_ref_past = torq_ref;


                break;
            }

            case MODE_VALVE_OPEN_LOOP: {
                V_out = (float) Vout.ref;
                break;
            }

            case MODE_JOINT_ADAPTIVE_BACKSTEPPING: {


                float Va = (1256.6f + Amm * pos.sen/(float)(ENC_PULSE_PER_POSITION)) * 0.000000001f; // 4mm pipe * 100mm + (25mm Cylinder 18mm Rod) * x,      unit : m^3
                float Vb = (1256.6f + Amm  * (79.0f - pos.sen/(float)(ENC_PULSE_PER_POSITION))) * 0.000000001f; // 4mm pipe * 100mm + (25mm Cylinder 18mm Rod) * (79.0mm-x),      unit : m^3

                V_adapt = 1.0f / (1.0f/Va + 1.0f/Vb); //initial 0.0000053f

                //float f3 = -Amm*Amm*beta*0.000001f*0.000001f/V_adapt * vel.sen/(float)(ENC_PULSE_PER_POSITION)*0.001f; // unit : N/s    //xdot=10mm/s일때 -137076
                float f3_hat = -a_hat * vel.sen/(float)(ENC_PULSE_PER_POSITION)*0.001f; // unit : N/s    //xdot=10mm/s일때 -137076

                float g3_prime = 0.0f;
                if (torq.sen > Amm*(Ps-Pt)*0.000001f) {
                    g3_prime = 1.0f;
                } else if (torq.sen < -Amm*(Ps-Pt)*0.000001f) {
                    g3_prime = -1.0f;
                } else {
                    if ((value-VALVE_CENTER) > 0) {
                        g3_prime = sqrt(Ps-Pt-torq.sen/Amm*1000000.0f);
//                        g3_prime = sqrt(Ps-Pt);
                    } else {
                        g3_prime = sqrt(Ps-Pt+torq.sen/Amm*1000000.0f);
//                        g3_prime = sqrt(Ps-Pt);
                    }
                }
                float tau = 0.01f;
                //float K_valve = 0.0004f;
                float K_valve = 0.0002f;

                float x_v = 0.0f;   //x_v : -1~1
                if(value>=VALVE_CENTER) {
                    x_v = 1.0f*((double)value - (double)VALVE_CENTER)/((double)VALVE_MAX_POS - (double)VALVE_CENTER);
                } else {
                    x_v = -1.0f*((double)value - (double)VALVE_CENTER)/((double)VALVE_MIN_POS - (double)VALVE_CENTER);
                }
                float f4 = -x_v/tau;
                float g4 = K_valve/tau;

                float torq_ref_dot = torq.ref_diff * 500.0f;

                pos.err = (pos.ref - pos.sen)/(float)(ENC_PULSE_PER_POSITION); //[mm]
                vel.err = (0.0f - vel.sen)/(float)(ENC_PULSE_PER_POSITION); //[mm/s]
                pos.err_sum += pos.err/(float) TMR_FREQ_5k; //[mm]

                torq.err = torq.ref - torq.sen; //[N]
                torq.err_sum += torq.err/(float) TMR_FREQ_5k; //[N]

                float k3 = 2000.0f; //2000  //20000
                float k4 = 10.0f;
                float rho3 = 3.2f;
                float rho4 = 10000000.0f;  //25000000.0f;
                float x_4_des = (-f3_hat + torq_ref_dot - k3*(-torq.err))/(gamma_hat*g3_prime);
                if (x_4_des > 1) x_4_des = 1;
                else if (x_4_des < -1) x_4_des = -1;

                if (x_4_des > 0) {
                    valve_pos.ref = x_4_des * (float)(VALVE_MAX_POS - VALVE_CENTER) + (float) VALVE_CENTER;
                } else {
                    valve_pos.ref = x_4_des * (float)(VALVE_CENTER - VALVE_MIN_POS) + (float) VALVE_CENTER;
                }

                float x_4_des_dot = (x_4_des - x_4_des_old)*(float) TMR_FREQ_5k;
                x_4_des_old = x_4_des;
                float V_input = 0.0f;
                V_out = (-f4 + x_4_des_dot - k4*(x_v-x_4_des)- rho3/rho4*gamma_hat*g3_prime*(-torq.err))/g4;
//                //V_out LPF
//                float alpha_V_out = 1.0f/(1.0f + 5000.0f/(2.0f*3.14f*50.0f)); // f_cutoff : 50Hz
//                V_out = V_out*(1.0f-alpha_V_out)+V_input*(alpha_V_out);

//                float rho_gamma = 5000.0f;//5000 for change //50000 for not change
//                float gamma_hat_dot = rho3*(-torq.err)/rho_gamma*((-f3+torq_ref_dot-k3*(-torq.err))/gamma_hat + g3_prime*(x_v-x_4_des));
//                gamma_hat = gamma_hat + gamma_hat_dot / (float) TMR_FREQ_5k;
//
//                if(gamma_hat > 10000.0f) gamma_hat = 10000.0f;
//                else if(gamma_hat < 100.0f) gamma_hat = 100.0f;

                float rho_a = 0.00001f;
                float a_hat_dot = -rho3/rho_a*vel.sen/(float)(ENC_PULSE_PER_POSITION)*0.001f*(-torq.err);
                a_hat = a_hat + a_hat_dot / (float) TMR_FREQ_5k;

                if(a_hat > -3000000.0f) a_hat = -3000000.0f;
                else if(a_hat < -30000000.0f) a_hat = -30000000.0f;

                break;
            }

            case MODE_RL: {
                //t.reset();
                //t.start();

//                if(LED == 0) LED = 1;
//                else LED = 0;

                if (Update_Done_Flag == 1) {
                    //Gather Data on each loop
//                  pos.err = (pos.ref - pos.sen)/(float)(ENC_PULSE_PER_POSITION); //[mm]
//                  train_set_x[RL_timer] = pos.sen/(float)(ENC_PULSE_PER_POSITION)/35.0f - 1.0f;   //-1.0~1.0
//                  train_set_error[RL_timer] = pos.err/70.0f;      //-1.0~1.0
                    pos.err = pos.sen/(float)(ENC_PULSE_PER_POSITION)  - virt_pos; //[mm]
                    train_set_x[RL_timer] = virt_pos/70.0f;   //-1.0~1.0
                    train_set_error[RL_timer] = pos.err/70.0f;      //-1.0~1.0
                    //train_set_count[RL_timer] = (float) RL_timer / (batch_size *num_batch);  //-1.0~1.0
                    //float temp_array[3] = {train_set_x[RL_timer], train_set_error[RL_timer], train_set_count[RL_timer]};
                    float temp_array[2] = {train_set_x[RL_timer], train_set_error[RL_timer]};
                    Actor_Network(temp_array);
                    for (int i=0; i<num_hidden_unit1; i++) {
                        hx_a_sum_array[RL_timer][i] = hx_a_sum[i];
                    }
                    for (int i=0; i<num_hidden_unit2; i++) {
                        hxh_a_sum_array[RL_timer][i] = hxh_a_sum[i];
                    }
                    hxhh_a_sum_array[RL_timer][0] = hxhh_a_sum[0];
                    hxhh_a_sum_array[RL_timer][1] = hxhh_a_sum[1];
                    mean_array[RL_timer] = mean;
                    deviation_array[RL_timer] = deviation;
                    action_array[RL_timer] = rand_normal(mean_array[RL_timer], deviation_array[RL_timer]);

                    virt_pos = virt_pos + (action_array[RL_timer] - 5.0f) * 1000.0f * 0.0002f;
                    if (virt_pos > 70 ) {
                        virt_pos = 70.0f;
                    } else if(virt_pos < -70) {
                        virt_pos = -70.0f;
                    }

                    RL_timer++;


                    if (RL_timer >= batch_size) {
                        RL_timer = 0;
                        batch++;
                        for(int i=0; i<batch_size; i++) {
                            state_array[i][0] = train_set_x[i];
                            state_array[i][1] = train_set_error[i];
                            //state_array[i][2] = train_set_count[i];
                        }
                        Update_Case = 1;
                        Update_Done_Flag = 0;
                        logging1 = virt_pos;

                        if(batch >= num_batch) {
                            batch = 0;
                            RL_timer = 0;
                            Update_Case = 2;
                            Update_Done_Flag = 0;
                            virt_pos = 10.0f;
                        }
                    }
                }

                else {
                    pos.err = pos.sen/(float)(ENC_PULSE_PER_POSITION) - virt_pos; //[mm]
                    float temp_array[3] = {0.0f};
                    temp_array[0] = virt_pos/70.0f;   //-1.0~1.0
                    temp_array[1] = pos.err/70.0f;      //-1.0~1.0
                    //temp_array[2] = (float) RL_timer / (batch_size *num_batch);  //-1.0~1.0
                    Actor_Network(temp_array);
                    action = rand_normal(mean, deviation);
                    //logging1 = action;
                    //logging2 = mean;
                    //logging4 = deviation;
                    virt_pos = virt_pos + (action-5.0f) * 1000.0f * 0.0002f;
                    if (virt_pos > 70) {
                        virt_pos = 70.0f;
                    } else if(virt_pos < -70) {
                        virt_pos = -70.0f;
                    }

                    logging3 = virt_pos;
                }

                //t.stop();
                //logging1 = t.read()*1000.0f;    //msec

                break;
            }

            default:
                break;
        }


        if (((OPERATING_MODE&0b110)>>1) == 0 || ((OPERATING_MODE&0b110)>>1) == 1) { //Moog Valve or KNR Valve

            ////////////////////////////////////////////////////////////////////////////
            ////////////////////////////  CURRENT CONTROL //////////////////////////////
            ////////////////////////////////////////////////////////////////////////////
            if (CURRENT_CONTROL_MODE) {
                double alpha_update_Iref = 1.0f / (1.0f + 5000.0f / (2.0f * 3.14f * 300.0f)); // f_cutoff : 500Hz
                I_REF_fil = (1.0f - alpha_update_Iref) * I_REF_fil + alpha_update_Iref*I_REF;

                if (I_REF_fil > 0) I_REF_fil_DZ = I_REF_fil + (double)VALVE_DEADZONE_PLUS/1000.0f; // unit: mA
                else if (I_REF_fil < 0) I_REF_fil_DZ = I_REF_fil + (double)VALVE_DEADZONE_MINUS/1000.0f; // unit: mA
                else I_REF_fil_DZ = I_REF_fil + (double)(VALVE_DEADZONE_PLUS+VALVE_DEADZONE_MINUS)/2.0/1000.0f; // unit: mA

                I_ERR = I_REF_fil_DZ - cur.sen;
                I_ERR_INT = I_ERR_INT + (I_ERR) * 0.0002f;


                // Moog Valve Current Control Gain
                double R_model = 500.0f; // ohm
                double L_model = 1.2f;
                double w0 = 2.0f * 3.14f * 150.0f;
                double KP_I = 0.1f * L_model*w0;
                double KI_I = 0.1f * R_model*w0;

                // KNR Valve Current Control Gain
                if (((OPERATING_MODE & 0b110)>>1) == 1) { // KNR Valve
                    R_model = 163.0f; // ohm
                    L_model = 1.0f;
                    w0 = 2.0f * 3.14f * 80.0f;
                    KP_I = 1.0f * L_model*w0;
                    KI_I = 0.08f * R_model*w0;
                }

                double FF_gain = 1.0f;

                VALVE_PWM_RAW = KP_I * 2.0f * I_ERR + KI_I * 2.0f* I_ERR_INT;
                //        VALVE_PWM_RAW = VALVE_PWM_RAW + FF_gain * (R_model*I_REF); // Unit : mV
                I_REF_fil_diff = I_REF_fil - I_REF_fil_old;
                I_REF_fil_old = I_REF_fil;
//                VALVE_PWM_RAW = VALVE_PWM_RAW + FF_gain * (R_model * I_REF_fil + L_model * I_REF_fil_diff * 5000.0f); // Unit : mV
                VALVE_PWM_RAW = VALVE_PWM_RAW + FF_gain * (R_model * I_REF_fil); // Unit : mV
                double V_MAX = 12000.0f; // Maximum Voltage : 12V = 12000mV

                double Ka = 3.0f / KP_I;
                if (VALVE_PWM_RAW > V_MAX) {
                    V_rem = VALVE_PWM_RAW - V_MAX;
                    V_rem = Ka*V_rem;
                    VALVE_PWM_RAW = V_MAX;
                    I_ERR_INT = I_ERR_INT - V_rem * 0.0002f;
                } else if (VALVE_PWM_RAW < -V_MAX) {
                    V_rem = VALVE_PWM_RAW - (-V_MAX);
                    V_rem = Ka*V_rem;
                    VALVE_PWM_RAW = -V_MAX;
                    I_ERR_INT = I_ERR_INT - V_rem * 0.0002f;
                }
                Cur_Valve_Open_pulse = cur.sen / mA_PER_pulse;
            } else {
                VALVE_PWM_RAW = I_REF * mV_PER_mA;
                Cur_Valve_Open_pulse = I_REF / mA_PER_pulse;
            }

            ////////////////////////////////////////////////////////////////////////////
            /////////////////  Dead Zone Cancellation & Linearization //////////////////
            ////////////////////////////////////////////////////////////////////////////
            // Dead Zone Cancellation (Mechanical Valve dead-zone)
//            FLAG_VALVE_DEADZONE = 1;
            if (FLAG_VALVE_DEADZONE) {
//                if (VALVE_PWM_RAW > 0) VALVE_PWM_RAW = VALVE_PWM_RAW + VALVE_DEADZONE_PLUS * mV_PER_pulse; // unit: mV
//                else if (VALVE_PWM_RAW < 0) VALVE_PWM_RAW = VALVE_PWM_RAW + VALVE_DEADZONE_MINUS * mV_PER_pulse; // unit: mV
//                else VALVE_PWM_RAW = VALVE_PWM_RAW + (VALVE_DEADZONE_PLUS+VALVE_DEADZONE_MINUS)/2.0f * mV_PER_pulse; // unit: mV

                //VALVE_PWM_VALVE_DZ = VALVE_PWM_RAW + (double)VALVE_CENTER * mV_PER_pulse; // unit: mV
                VALVE_PWM_VALVE_DZ = VALVE_PWM_RAW; // unit: mV

            } else {
                VALVE_PWM_VALVE_DZ = VALVE_PWM_RAW;
            }

            // Output Voltage Linearization
            double CUR_PWM_nonlin = VALVE_PWM_VALVE_DZ; // Unit : mV
            double CUR_PWM_lin = PWM_duty_byLT(CUR_PWM_nonlin);  // -8000~8000

            // Dead Zone Cancellation (Electrical dead-zone)
            if (CUR_PWM_lin > 0) V_out = (float) (CUR_PWM_lin + 169.0f);
            else if (CUR_PWM_lin < 0) V_out = (float) (CUR_PWM_lin - 174.0f);
            else V_out = (float) (CUR_PWM_lin);
        } else {            //////////////////////////sw valve
            // Output Voltage Linearization
//            double CUR_PWM_nonlin = V_out; // Unit : mV
//            double CUR_PWM_lin = PWM_duty_byLT(CUR_PWM_nonlin);  // -8000~8000

            // Dead Zone Cancellation (Electrical dead-zone)
//            if (CUR_PWM_lin > 0) V_out = (float) (CUR_PWM_lin + 169.0f);
//            else if (CUR_PWM_lin < 0) V_out = (float) (CUR_PWM_lin - 174.0f);
//            else V_out = (float) (CUR_PWM_lin);

            if (V_out > 0 ) V_out = (V_out + 180.0f)/0.8588f;
            else if (V_out < 0) V_out = (V_out - 200.0f)/0.8651f;
            else V_out = 0.0f;
        }

//        if(V_out > 0.0f) V_out = (float) (V_out + 169.0f);
//        else if(V_out < 0.0f) V_out = (float) (V_out - 174.0f);
//        else V_out = V_out;

        /*******************************************************
        ***     PWM
        ********************************************************/
        if(DIR_VALVE<0) {
            V_out = -V_out;
        }

        if (V_out >= VALVE_VOLTAGE_LIMIT*1000.0f) {
            V_out = VALVE_VOLTAGE_LIMIT*1000.0f;
        } else if(V_out<=-VALVE_VOLTAGE_LIMIT*1000.0f) {
            V_out = -VALVE_VOLTAGE_LIMIT*1000.0f;
        }
        PWM_out= V_out/(SUPPLY_VOLTAGE*1000.0f); // Full duty : 12000.0mV

        // Saturation of output voltage to 12.0V
        if(PWM_out > 1.0f) PWM_out=1.0f;
        else if (PWM_out < -1.0f) PWM_out=-1.0f;

        if (PWM_out>0.0f) {
            dtc_v=0.0f;
            dtc_w=PWM_out;
        } else {
            dtc_v=-PWM_out;
            dtc_w=0.0f;
        }

        //pwm
        TIM4->CCR2 = (PWM_ARR)*(1.0f-dtc_v);
        TIM4->CCR1 = (PWM_ARR)*(1.0f-dtc_w);


//        if (TMR2_COUNT_CAN_TX % 5 == 0) {
//        if (TMR2_COUNT_CAN_TX % (int) ((int) TMR_FREQ_5k/1000.0f) == 0) {
//            CAN_TX_POSITION_FT((int16_t) (pos.sen), (int16_t) (vel.sen/10.0f), (int16_t) (torq.sen*10.0f));
//        }
//        TMR2_COUNT_CAN_TX++;
        
        
//                if (TMR2_COUNT_CAN_TX % (int) ((int) TMR_FREQ_5k/CAN_FREQ) == 0) {
//
//                    // Position, Velocity, and Torque (ID:1200)
//                    if (flag_data_request[0] == 0) {
//                        if ((OPERATING_MODE & 0b01) == 0) { // Rotary Actuator
//                            if (SENSING_MODE == 0) {
//                                CAN_TX_POSITION_FT((int16_t) (pos.sen), (int16_t) (vel.sen/10.0f), (int16_t) (torq.sen*10.0f));
//                            } else if (SENSING_MODE == 1) {
//                                CAN_TX_POSITION_PRESSURE((int16_t) (pos.sen), (int16_t) (vel.sen/10.0f), (int16_t) ((pres_A.sen)*5.0f), (int16_t) ((pres_B.sen)*5.0f));
//                            }
//                        } else if ((OPERATING_MODE & 0b01) == 1) { // Linear Actuator
//                            if (SENSING_MODE == 0) {
//                                CAN_TX_POSITION_FT((int16_t) (pos.sen/16.0f), (int16_t) (vel.sen/256.0f), (int16_t) (torq.sen * 10.0f * (float)(TORQUE_SENSOR_PULSE_PER_TORQUE)));
//                            } else if (SENSING_MODE == 1) {
//                                CAN_TX_POSITION_PRESSURE((int16_t) (pos.sen/10.0f), (int16_t) (vel.sen/256.0f), (int16_t) ((pres_A.sen)*5.0f), (int16_t) ((pres_B.sen)*5.0f));
//                            }
//                        }
//                    }
//
//                    if (flag_data_request[1] == HIGH) {
//                        CAN_TX_TORQUE((int16_t) (return_G[0]*100.0f)); //1300
//                    }
//
//
//                    if (flag_data_request[2] == HIGH) {
//                        double t_value = 0.0f;
//                        if(value>=(float) VALVE_CENTER) {
//                            t_value = 10000.0f*((double)value - (double)VALVE_CENTER)/((double)VALVE_MAX_POS - (double)VALVE_CENTER);
//                        } else {
//                            t_value = -10000.0f*((double)value - (double)VALVE_CENTER)/((double)VALVE_MIN_POS - (double)VALVE_CENTER);
//                        }
//                        double t_value_ref = 0.0f;
//                        if(valve_pos.ref>=(float) VALVE_CENTER) {
//                            t_value_ref = 10000.0f*((double)valve_pos.ref - (double)VALVE_CENTER)/((double)VALVE_MAX_POS - (double)VALVE_CENTER);
//                        } else {
//                            t_value_ref = -10000.0f*((double)valve_pos.ref - (double)VALVE_CENTER)/((double)VALVE_MIN_POS - (double)VALVE_CENTER);
//                        }
//
//
//                        CAN_TX_PRES((int16_t) (t_value), (int16_t) (t_value_ref)); // 1400
//                    }
//
//                    //If it doesn't rest, below can can not work.
//                    for (int can_rest = 0; can_rest < 10000; can_rest++) {
//                        ;
//                    }
//
//                    if (flag_data_request[3] == HIGH) {
//                        //PWM
//                        CAN_TX_PWM((int16_t) (torq.ref)); //1500
//        //                CAN_TX_PWM((int16_t) (f_future[1])); //1500
//                    }
//
//                    if (flag_data_request[4] == HIGH) {
//                        //valve position
//                        //CAN_TX_VALVE_POSITION((int16_t) pos.sen/(float)(ENC_PULSE_PER_POSITION), (int16_t) virt_pos, (int16_t) (logging2*1000.0f), (int16_t) (logging4*1000.0f)); //1600
//                        CAN_TX_VALVE_POSITION((int16_t) (a_hat*0.0001f), (int16_t) 0, (int16_t) 0, (int16_t) 0); //1600
//                    }
//
//
//
//                    // Others : Reference position, Reference FT, PWM, Current  (ID:1300)
////                if (flag_data_request[1] == HIGH) {
////                    CAN_TX_SOMETHING((int) (0), (int16_t) (1), (int16_t) (2), (int16_t) (3));
////                }
////                    if (flag_delay_test == 1){
////                    CAN_TX_PRES((int16_t) (0),(int16_t) torq_ref);
////                    }
////
////                    TMR2_COUNT_CAN_TX = 0;
//                }
//                TMR2_COUNT_CAN_TX++;


        
    }
    TIM3->SR = 0x0;  // reset the status register

}