//200518
#include "mbed.h"
#include "FastPWM.h"
#include "INIT_HW.h"
#include "function_CAN.h"
#include "SPI_EEP_ENC.h"
#include "I2C_AS5510.h"
#include "setting.h"
#include "function_utilities.h"
#include "stm32f4xx_flash.h"
#include "FlashWriter.h"

///191008////

// dac & check ///////////////////////////////////////////
DigitalOut check(PC_2);
DigitalOut check_2(PC_3);
AnalogOut dac_1(PA_4);
AnalogOut dac_2(PA_5);
AnalogIn adc1(PC_4); //pressure_1
AnalogIn adc2(PB_0); //pressure_2
AnalogIn adc3(PC_1); //current


// PWM ///////////////////////////////////////////
float dtc_v=0.0f;
float dtc_w=0.0f;

// I2C ///////////////////////////////////////////
I2C i2c(PC_9,PA_8); // SDA, SCL (for K22F)
const int i2c_slave_addr1 =  0x56;
unsigned int value; // 10bit output of reading sensor AS5510

// SPI ///////////////////////////////////////////
//SPI eeprom(PB_15, PB_14, PB_13); // EEPROM //(SPI_MOSI, SPI_MISO, SPI_SCK);
//DigitalOut eeprom_cs(PB_12);
//FlashWriter writer(6);//2부터 7까지 되는듯 아마 sector
SPI enc(PC_12,PC_11,PC_10);
DigitalOut enc_cs(PD_2);
DigitalOut LED(PA_15);

// UART ///////////////////////////////////////////
Serial pc(PA_9,PA_10); //  _ UART

// CAN ///////////////////////////////////////////
CAN can(PB_8, PB_9, 1000000);
CANMessage msg;
void onMsgReceived()
{
    CAN_RX_HANDLER();
}

// Variables ///////////////////////////////////////////
State pos;
State vel;
State Vout;
State torq;
State pres_A;
State pres_B;
State cur;
State valve_pos;

State INIT_Vout;
State INIT_Valve_Pos;
State INIT_Pos;
State INIT_torq;

extern int CID_RX_CMD;
extern int CID_RX_REF_POSITION;
extern int CID_RX_REF_VALVE_POS;
extern int CID_RX_REF_PWM;

extern int CID_TX_INFO;
extern int CID_TX_POSITION;
extern int CID_TX_TORQUE;
extern int CID_TX_PRES;
extern int CID_TX_VOUT;
extern int CID_TX_VALVE_POSITION;

float I_REF_fil_DZ = 0.0f;

// =============================================================================
// =============================================================================
// =============================================================================

/*******************************************************************************
 *  REFERENCE MODE
 ******************************************************************************/
enum _REFERENCE_MODE {
    MODE_REF_NO_ACT = 0,                                //0
    MODE_REF_DIRECT,                                //1
    MODE_REF_COS_INC,                                  //2
    MODE_REF_LINE_INC,                                 //3
    MODE_REF_SIN_WAVE,                                  //4
    MODE_REF_SQUARE_WAVE,                                  //5
};

/*******************************************************************************
 *  CONTROL MODE
 ******************************************************************************/
enum _CONTROL_MODE {
    //control mode
    MODE_NO_ACT = 0,                                    //0
    MODE_VALVE_POSITION_CONTROL,                        //1
    MODE_JOINT_CONTROL,                                 //2

    MODE_VALVE_OPEN_LOOP,                               //3
    MODE_JOINT_POSITION_TORQUE_CONTROL_VALVE_POSITION,  //4
    MODE_VALVE_POSITION_TORQUE_CONTROL_LEARNING,        //5

    MODE_JOINT_POSITION_PRES_CONTROL_PWM,               //6
    MODE_JOINT_POSITION_PRES_CONTROL_VALVE_POSITION,    //7
    MODE_VALVE_POSITION_PRES_CONTROL_LEARNING,          //8

    MODE_TEST_CURRENT_CONTROL,                          //9
    MODE_TEST_PWM_CONTROL,                              //10

    MODE_CURRENT_CONTROL,                               //11
    MODE_JOINT_POSITION_TORQUE_CONTROL_CURRENT,         //12
    MODE_JOINT_POSITION_PRES_CONTROL_CURRENT,           //13

    //utility
    MODE_TORQUE_SENSOR_NULLING = 20,                    //20
    MODE_VALVE_NULLING_AND_DEADZONE_SETTING,            //21
    MODE_FIND_HOME,                                     //22
    MODE_VALVE_GAIN_SETTING,                            //23
    MODE_PRESSURE_SENSOR_NULLING,                       //24
    MODE_PRESSURE_SENSOR_CALIB,                         //25
    MODE_ROTARY_FRICTION_TUNING,                        //26

    MODE_DDV_POS_VS_PWM_ID = 30,                           //30
    MODE_DDV_DEADZONE_AND_CENTER,                       //31
    MODE_DDV_POS_VS_FLOWRATE,                           //32
    MODE_SYSTEM_ID,                                     //33
};

void SystemClock_Config(void);

int main()
{
    /*********************************
    ***     Initialization
    *********************************/
    HAL_Init();
//    SystemClock_Config();
    
    
//    LED = 1;
//    pc.baud(9600);

    // i2c init
    i2c.frequency(400 * 1000);          // 0.4 mHz
    wait_ms(2);                         // Power Up wait
    look_for_hardware_i2c();            // Hardware present
    init_as5510(i2c_slave_addr1);
    make_delay();

//    // spi init
    //eeprom.format(8,3);
    //eeprom.frequency(5000000); //5M
    enc.format(8,0);
    enc.frequency(5000000); //5M
    make_delay();

    //rom
    ROM_CALL_DATA();
    make_delay();

    // ADC init
    Init_ADC();
    make_delay();

    // Pwm init
    Init_PWM();
    TIM4->CR1 ^= TIM_CR1_UDIS;
    make_delay();

    // TMR3 init
    Init_TMR3();
    TIM3->CR1 ^= TIM_CR1_UDIS;
    make_delay();

    // TMR2 init
//    Init_TMR2();
//    TIM2->CR1 ^= TIM_CR1_UDIS;
//    make_delay();

    // CAN
//    can.reset();
    CAN_ID_INIT();
//    can.filter(msg.id, 0xFFFFF000, CANStandard);
//    can.frequency(1000000); // set CAN bit rate to 1Mbps
    can.filter(CID_RX_CMD, 0xFFF, CANStandard, 0);
    can.filter(CID_RX_REF_POSITION, 0xFFF, CANStandard, 1);
    can.filter(CID_RX_REF_VALVE_POS, 0xFFF, CANStandard, 2);
    can.filter(CID_RX_REF_PWM, 0xFFF, CANStandard, 3);
    can.attach(&CAN_RX_HANDLER);
    
    make_delay();

    //Timer priority
    NVIC_SetPriority(TIM3_IRQn, 2);
    //NVIC_SetPriority(TIM2_IRQn, 3);
    NVIC_SetPriority(TIM4_IRQn, 3);

    

    // spi _ enc
    spi_enc_set_init();
    make_delay();

    //DAC init
    if (SENSING_MODE == 0) {
        dac_1 = TORQUE_VREF / 3.3f;
        dac_2 = 0.0f;
    } else if (SENSING_MODE == 1) {
        dac_1 = PRES_A_VREF / 3.3f;
        dac_2 = PRES_B_VREF / 3.3f;
    }
    make_delay();

    for (int i=0; i<50; i++) {
        if(i%2==0)
            ID_index_array[i] = - i * 0.5f;
        else
            ID_index_array[i] =  (i+1) * 0.5f;
    }

    /************************************
    ***     Program is operating!
    *************************************/
    while(1) {
        if(timer_while==1000 && OPERATING_MODE==5) {
//        if(timer_while==1000) {
            //i2c
            read_field(i2c_slave_addr1);
            if(DIR_VALVE_ENC < 0) value = 1023 - value;
            //            if(LED==1) {
            //                LED=0;
            //            } else
            //                LED = 1;
            timer_while = 0;
        }
        timer_while ++;
        //pc.printf("%d\n", value);
    }
}

float DDV_JOINT_POS_FF(float REF_JOINT_VEL)
{

    int i = 0;
    float Ref_Valve_Pos_FF = 0.0f;
    for(i=0; i<VALVE_POS_NUM; i++) {
        if(REF_JOINT_VEL >= min(JOINT_VEL[i],JOINT_VEL[i+1]) && REF_JOINT_VEL <=  max(JOINT_VEL[i],JOINT_VEL[i+1])) {
            if(i==0) {
                if(JOINT_VEL[i+1] == JOINT_VEL[i]) {
                    Ref_Valve_Pos_FF = (float) VALVE_CENTER;
                } else {
                    Ref_Valve_Pos_FF = ((float) 10/(JOINT_VEL[i+1] - JOINT_VEL[i]) * (REF_JOINT_VEL - JOINT_VEL[i])) + (float) VALVE_CENTER;
                }
            } else {
                if(JOINT_VEL[i+1] == JOINT_VEL[i-1]) {
                    Ref_Valve_Pos_FF = (float) VALVE_CENTER;
                } else {
                    Ref_Valve_Pos_FF = ((float) 10*(ID_index_array[i+1] - ID_index_array[i-1])/(JOINT_VEL[i+1] - JOINT_VEL[i-1]) * (REF_JOINT_VEL - JOINT_VEL[i-1])) + (float) VALVE_CENTER + (float) (10*ID_index_array[i-1]);
                }
            }
            break;
        }
    }
    if(REF_JOINT_VEL > max(JOINT_VEL[VALVE_POS_NUM-1], JOINT_VEL[VALVE_POS_NUM-2])) {
        Ref_Valve_Pos_FF = (float) VALVE_MAX_POS;
    } else if(REF_JOINT_VEL < min(JOINT_VEL[VALVE_POS_NUM-1], JOINT_VEL[VALVE_POS_NUM-2])) {
        Ref_Valve_Pos_FF = (float) VALVE_MIN_POS;
    }

    Ref_Valve_Pos_FF = (float) VELOCITY_COMP_GAIN * 0.01f * (float) (Ref_Valve_Pos_FF - (float) VALVE_CENTER);
    return Ref_Valve_Pos_FF;

}


void VALVE_POS_CONTROL(float REF_VALVE_POS)
{
    int i = 0;

    if(REF_VALVE_POS > VALVE_MAX_POS) {
        REF_VALVE_POS = VALVE_MAX_POS;
    } else if(REF_VALVE_POS < VALVE_MIN_POS) {
        REF_VALVE_POS = VALVE_MIN_POS;
    }

    valve_pos_err = REF_VALVE_POS - value;
    valve_pos_err_diff = valve_pos_err - valve_pos_err_old;
    valve_pos_err_old = valve_pos_err;
    valve_pos_err_sum += valve_pos_err;
    if (valve_pos_err_sum > 1000) valve_pos_err_sum = 1000;
    if (valve_pos_err_sum<-1000) valve_pos_err_sum = -1000;

    VALVE_PWM_RAW_FB = P_GAIN_VALVE_POSITION * valve_pos_err + I_GAIN_VALVE_POSITION * valve_pos_err_sum + D_GAIN_VALVE_POSITION * valve_pos_err_diff;

    for(i=0; i<24; i++) {
        if(REF_VALVE_POS >= min(VALVE_POS_VS_PWM[i],VALVE_POS_VS_PWM[i+1]) && REF_VALVE_POS <=  max(VALVE_POS_VS_PWM[i],VALVE_POS_VS_PWM[i+1])) {
            if(i==0) {
                VALVE_PWM_RAW_FF = (float) 1000.0f / (float) (VALVE_POS_VS_PWM[i+1] - VALVE_POS_VS_PWM[i]) * ((float) REF_VALVE_POS - VALVE_POS_VS_PWM[i]);
            } else {
                VALVE_PWM_RAW_FF = (float) 1000.0f* (float) (ID_index_array[i+1] - ID_index_array[i-1])/(VALVE_POS_VS_PWM[i+1] - VALVE_POS_VS_PWM[i-1]) * ((float) REF_VALVE_POS - VALVE_POS_VS_PWM[i-1]) + 1000.0f * (float) ID_index_array[i-1];
            }
            break;
        }
    }
    Vout.ref = VALVE_PWM_RAW_FF + VALVE_PWM_RAW_FB;
}

#define LT_MAX_IDX  57
float LT_PWM_duty[LT_MAX_IDX] = {-100.0f, -80.0f, -60.0f, -50.0f, -40.0f, -35.0f, -30.0f, -25.0f, -20.0f,
                                 -19.0f, -18.0f, -17.0f, -16.0f, -15.0f, -14.0f, -13.0f, -12.0f, -11.0f, -10.0f,
                                 -9.0f, -8.0f, -7.0f, -6.0f, -5.0f, -4.0f, -3.0f, -2.0f, -1.0f, 0.0f,
                                 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f,
                                 11.0f, 12.0f, 13.0f, 14.0f, 15.0f, 16.0f, 17.0f, 18.0f, 19.0f, 20.0f,
                                 25.0f, 30.0f, 35.0f, 40.0f, 50.0f, 60.0f, 80.0f, 100.0f
                                };  // duty
float LT_Voltage_Output[LT_MAX_IDX] = {-230.0f, -215.0f, -192.5f, -185.0f, -177.5f, -170.0f, -164.0f, -160.0f, -150.0f,
                                       -150.0f, -145.0f, -145.0f, -145.0f, -135.0f, -135.0f, -135.0f, -127.5f, -127.5f, -115.0f,
                                       -115.0f, -115.0F, -100.0f, -100.0f, -100.0f, -60.0f, -60.0f, -10.0f, -5.0f, 0.0f,
                                       7.5f, 14.0f, 14.0f, 14.0f, 42.5f, 42.5f, 42.5f, 80.0f, 80.0f, 105.0f,
                                       105.0f, 105.0f, 120.0f, 120.0f, 120.0f, 131.0f, 131.0f, 140.0f, 140.0f, 140.0f,
                                       155.0f, 160.0f, 170.0f, 174.0f, 182.0f, 191.0f, 212.0f, 230.0f
                                      }; // mV

float PWM_duty_byLT(float Ref_V)
{
    float PWM_duty = 0.0f;
    if(Ref_V<LT_Voltage_Output[0]) {
        PWM_duty = (Ref_V-LT_Voltage_Output[0])/1.5f+LT_PWM_duty[0];
    } else if (Ref_V>=LT_Voltage_Output[LT_MAX_IDX-1]) {
        PWM_duty = (Ref_V-LT_Voltage_Output[LT_MAX_IDX-1])/1.5f+LT_PWM_duty[LT_MAX_IDX-1];
    } else {
        int idx = 0;
        for(idx=0; idx<LT_MAX_IDX-1; idx++) {
            float ini_x = LT_Voltage_Output[idx];
            float fin_x = LT_Voltage_Output[idx+1];
            float ini_y = LT_PWM_duty[idx];
            float fin_y = LT_PWM_duty[idx+1];
            if(Ref_V>=ini_x && Ref_V<fin_x) {
                PWM_duty = (fin_y-ini_y)/(fin_x-ini_x)*(Ref_V-ini_x) + ini_y;
                break;
            }
        }
    }

    return PWM_duty;
}





/*******************************************************************************
                            TIMER INTERRUPT
*******************************************************************************/

float FREQ_TMR4 = (float)FREQ_20k;
float DT_TMR4 = (float)DT_20k;
long  CNT_TMR4 = 0;
int   TMR4_FREQ_10k = (int)FREQ_10k;
extern "C" void TIM4_IRQHandler(void)
{
    if (TIM4->SR & TIM_SR_UIF ) {

        /*******************************************************
        ***     Sensor Read & Data Handling
        ********************************************************/

        //Encoder
        if (CNT_TMR4 % (int) ((int) FREQ_TMR4/TMR4_FREQ_10k) == 0) {
            ENC_UPDATE();
        }

        ADC1->CR2  |= 0x40000000;
        if (SENSING_MODE == 0) {
            // Torque Sensing (0~210)bar =============================================
            float pres_A_new = (((float) ADC1->DR) - 2047.5f);
            double alpha_update_ft = 1.0f / (1.0f + FREQ_TMR4 / (2.0f * 3.14f * 100.0f)); // f_cutoff : 200Hz
            pres_A.sen = (1.0f - alpha_update_ft) * pres_A.sen + alpha_update_ft * pres_A_new;
            torq.sen = -pres_A.sen / TORQUE_SENSOR_PULSE_PER_TORQUE;


//        float alpha_update_pres_A = 1.0f/(1.0f + FREQ_TMR4/(2.0f*3.14f*100.0f));
////        float pres_A_new = ((float)ADC1->DR - PRES_A_NULL)  / PRES_SENSOR_A_PULSE_PER_BAR;
//        float pres_A_new = ((float)ADC1->DR);
//        pres_A.sen = pres_A.sen*(1.0f-alpha_update_pres_A)+pres_A_new*(alpha_update_pres_A);
//        torq.sen = - (pres_A.sen-2048.0f); //pulse -2047~2047


        } else if (SENSING_MODE == 1) {
            // Pressure Sensing (0~210)bar =============================================
            float pres_A_new = (((float)ADC1->DR) - PRES_A_NULL);
            float pres_B_new = (((float)ADC2->DR) - PRES_B_NULL);
            double alpha_update_pres = 1.0f / (1.0f + FREQ_TMR4 / (2.0f * 3.14f * 200.0f)); // f_cutoff : 500Hz
            pres_A.sen = (1.0f - alpha_update_pres) * pres_A.sen + alpha_update_pres * pres_A_new;
            pres_B.sen = (1.0f - alpha_update_pres) * pres_B.sen + alpha_update_pres * pres_B_new;
            CUR_PRES_A_BAR = pres_A.sen / PRES_SENSOR_A_PULSE_PER_BAR;
            CUR_PRES_B_BAR = pres_B.sen / PRES_SENSOR_B_PULSE_PER_BAR;

            if ((OPERATING_MODE & 0x01) == 0) { // Rotary Actuator
                torq.sen = (PISTON_AREA_A * CUR_PRES_A_BAR - PISTON_AREA_B * CUR_PRES_B_BAR) * 0.0001f; // mm^3*bar >> Nm
            } else if ((OPERATING_MODE & 0x01) == 1) { // Linear Actuator
                torq.sen = (PISTON_AREA_A * CUR_PRES_A_BAR - PISTON_AREA_B * CUR_PRES_B_BAR) * 0.1f; // mm^2*bar >> N
            }
        }

//        //Pressure sensor A
//        ADC1->CR2  |= 0x40000000;                        // adc _ 12bit
//        //while((ADC1->SR & 0b10));
//        float alpha_update_pres_A = 1.0f/(1.0f + FREQ_TMR4/(2.0f*3.14f*100.0f));
//        float pres_A_new = ((float)ADC1->DR);
//        pres_A.sen = pres_A.sen*(1.0f-alpha_update_pres_A)+pres_A_new*(alpha_update_pres_A);
//        torq.sen = - (pres_A.sen-2048.0f); //pulse -2047~2047    //SW just changed the sign to correct the direction of loadcell on LIGHT. Correct later.
//
//
//        //Pressure sensor B
//        float alpha_update_pres_B = 1.0f/(1.0f + FREQ_TMR4/(2.0f*3.14f*100.0f));
//        float pres_B_new = ((float)ADC2->DR);
//        pres_B.sen = pres_B.sen*(1.0f-alpha_update_pres_B)+pres_B_new*(alpha_update_pres_B);
//        //torq.sen = pres_A.sen * (float) PISTON_AREA_A - pres_B.sen * (float) PISTON_AREA_B;


        //Current
        //ADC3->CR2  |= 0x40000000;                        // adc _ 12bit
        //int raw_cur = ADC3->DR;
        //while((ADC3->SR & 0b10));
        float alpha_update_cur = 1.0f/(1.0f + FREQ_TMR4/(2.0f*3.14f*500.0f)); // f_cutoff : 500Hz
        float cur_new = ((float)ADC3->DR-2048.0f) / 4096.0f * 3.3f * 10.0f / 1.44f; // unit : mA
        cur.sen=cur.sen*(1.0f-alpha_update_cur)+cur_new*(alpha_update_cur);
        //cur.sen = raw_cur;

        CNT_TMR4++;
    }
    TIM4->SR = 0x0;  // reset the status register
}


int j =0;
float FREQ_TMR3 = (float)FREQ_5k;
float DT_TMR3 = (float)DT_5k;
int cnt_trans = 0;
double VALVE_POS_RAW_FORCE_FB_LOGGING = 0.0f;
int can_rest =0;

extern "C" void TIM3_IRQHandler(void)
{
    if (TIM3->SR & TIM_SR_UIF ) {

        if (((OPERATING_MODE&0b110)>>1) == 0) {
            K_v = 0.4f; // Moog (LPM >> mA) , 100bar
            mV_PER_mA = 500.0f; // 5000mV/10mA
            mV_PER_pulse = 0.5f; // 5000mV/10000pulse
            mA_PER_pulse = 0.001f; // 10mA/10000pulse
        } else if (((OPERATING_MODE&0b110)>>1) == 1) {
            K_v = 0.5f; // KNR (LPM >> mA) , 100bar
            mV_PER_mA = 166.6666f; // 5000mV/30mA
            mV_PER_pulse = 0.5f; // 5000mV/10000pulse
            mA_PER_pulse = 0.003f; // 30mA/10000pulse
        }

        if(MODE_POS_FT_TRANS == 1) {
            alpha_trans = (float)(1.0f - cos(3.141592f * (float)cnt_trans * DT_TMR3 /3.0f))/2.0f;
            cnt_trans++;
            torq.err_sum = 0;
            if((float)cnt_trans * DT_TMR3 > 3.0f)
                MODE_POS_FT_TRANS = 2;
        } else if(MODE_POS_FT_TRANS == 3) {
            alpha_trans = (float)(1.0f + cos(3.141592f * (float)cnt_trans * DT_TMR3 /3.0f))/2.0f;
            cnt_trans++;
            torq.err_sum = 0;
            if((float) cnt_trans * DT_TMR3 > 3.0f )
                MODE_POS_FT_TRANS = 0;
        } else if(MODE_POS_FT_TRANS == 2) {
            alpha_trans = 1.0f;
            cnt_trans = 0;
        } else {
            alpha_trans = 0.0f;
            cnt_trans = 0;
        }


        int UTILITY_MODE = 0;
        int CONTROL_MODE = 0;

        if (CONTROL_UTILITY_MODE >= 20 || CONTROL_UTILITY_MODE == 0) {
            UTILITY_MODE = CONTROL_UTILITY_MODE;
            CONTROL_MODE = MODE_NO_ACT;
        } else {
            CONTROL_MODE = CONTROL_UTILITY_MODE;
            UTILITY_MODE = MODE_NO_ACT;
        }



        // UTILITY MODE ------------------------------------------------------------

        switch (UTILITY_MODE) {
            case MODE_NO_ACT: {
                break;
            }

            case MODE_TORQUE_SENSOR_NULLING: {

                if(SENSING_MODE == 0){

                    // DAC Voltage reference set
                    if (TMR3_COUNT_TORQUE_NULL < TMR_FREQ_5k * 2) {
                        CUR_TORQUE_sum += torq.sen;

                        if (TMR3_COUNT_TORQUE_NULL % 10 == 0) {
                            CUR_TORQUE_mean = CUR_TORQUE_sum / 10.0f;
                            CUR_TORQUE_sum = 0;

                            TORQUE_VREF += 0.0003f * (0.0f - CUR_TORQUE_mean);

                            if (TORQUE_VREF > 3.3f) TORQUE_VREF = 3.3f;
                            if (TORQUE_VREF < 0.0f) TORQUE_VREF = 0.0f;

                            //spi_eeprom_write(RID_TORQUE_SENSOR_VREF, (int16_t) (TORQUE_VREF * 1000.0));
                            dac_1 = TORQUE_VREF / 3.3f;
                        }
                    } else {
                        CONTROL_UTILITY_MODE = MODE_NO_ACT;
                        TMR3_COUNT_TORQUE_NULL = 0;
                        CUR_TORQUE_sum = 0;
                        CUR_TORQUE_mean = 0;

                        ROM_RESET_DATA();

                        dac_1 = TORQUE_VREF / 3.3f;
                    }
            } else {
                if (TMR3_COUNT_TORQUE_NULL < TMR_FREQ_5k * 2) {
                    CUR_PRES_A_sum += pres_A.sen;
                    CUR_PRES_B_sum += pres_B.sen;

                    if (TMR3_COUNT_TORQUE_NULL % 10 == 0) {
                        CUR_PRES_A_mean = CUR_PRES_A_sum / 10.0f;
                        CUR_PRES_B_mean = CUR_PRES_B_sum / 10.0f;
                        CUR_PRES_A_sum = 0;
                        CUR_PRES_B_sum = 0;

                        float VREF_NullingGain = 0.0003f;
                        PRES_A_VREF = PRES_A_VREF + VREF_NullingGain * CUR_PRES_A_mean;
                        PRES_B_VREF = PRES_B_VREF + VREF_NullingGain * CUR_PRES_B_mean;

                        if (PRES_A_VREF > 3.3f) PRES_A_VREF = 3.3f;
                        if (PRES_A_VREF < 0.0f) PRES_A_VREF = 0.0f;
                        if (PRES_B_VREF > 3.3f) PRES_B_VREF = 3.3f;
                        if (PRES_B_VREF < 0.0f) PRES_B_VREF = 0.0f;

                        dac_1 = PRES_A_VREF / 3.3f;
                        dac_2 = PRES_B_VREF / 3.3f;
                    }
                } else {
                    CONTROL_UTILITY_MODE = MODE_NO_ACT;
                    TMR3_COUNT_TORQUE_NULL = 0;
                    CUR_PRES_A_sum = 0;
                    CUR_PRES_B_sum = 0;
                    CUR_PRES_A_mean = 0;
                    CUR_PRES_B_mean = 0;

                    ROM_RESET_DATA();

                    dac_1 = PRES_A_VREF / 3.3f;
                    dac_2 = PRES_B_VREF / 3.3f;
                    //pc.printf("nulling end");
                }
            }
            TMR3_COUNT_TORQUE_NULL++;
            break;
        }

//            case MODE_VALVE_NULLING_AND_DEADZONE_SETTING: {
//                if (TMR3_COUNT_DEADZONE == 0) {
//                    if (pos_plus_end == pos_minus_end) need_enc_init = true;
//                    else temp_time = 0;
//                }
//                if (need_enc_init) {
//                    if (TMR3_COUNT_DEADZONE < (int) (0.5f * (float) TMR_FREQ_5k)) {
//                        V_out = VALVE_VOLTAGE_LIMIT * 1000.0f;
//                        pos_plus_end = pos.sen;
//                    } else if (TMR3_COUNT_DEADZONE < TMR_FREQ_5k) {
//                        V_out = -VALVE_VOLTAGE_LIMIT * 1000.0f;
//                        pos_minus_end = pos.sen;
//                    } else if (TMR3_COUNT_DEADZONE == TMR_FREQ_5k) need_enc_init = false;
//                    temp_time = TMR_FREQ_5k;
//                }
//
//                if (temp_time <= TMR3_COUNT_DEADZONE && TMR3_COUNT_DEADZONE < (temp_time + TMR_FREQ_5k)) {
//                    V_out = (float) P_GAIN_JOINT_POSITION * (0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end - (float) pos.sen);
//                    VALVE_CENTER = VALVE_DEADZONE_PLUS = VALVE_DEADZONE_MINUS = 0;
//
//                } else if (temp_time <= TMR3_COUNT_DEADZONE && TMR3_COUNT_DEADZONE < (temp_time + (int) (1.9f * (float) TMR_FREQ_5k))) {
//                    V_out = 0;
//                    CUR_VELOCITY_sum += CUR_VELOCITY;
//                } else if (TMR3_COUNT_DEADZONE == (temp_time + 2 * TMR_FREQ_5k)) {
//                    if (CUR_VELOCITY_sum == 0) DZ_dir = 1;
//                    else if (CUR_VELOCITY_sum > 0) DZ_dir = 1;
//                    else if (CUR_VELOCITY_sum < 0) DZ_dir = -1;
//                    else DZ_temp_cnt2 = DZ_end;
//                    CUR_VELOCITY_sum = 0;
//                } else if (TMR3_COUNT_DEADZONE > (temp_time + 2 * TMR_FREQ_5k)) {
//                    if (TMR3_COUNT_DEADZONE > (temp_time + 10 * TMR_FREQ_5k)) DZ_temp_cnt2 = DZ_end;
//
//                    // Position of Dead Zone
//                    //  (CUR_VELOCITY < 0)  (CUR_VELOCITY == 0)  (CUR_VELOCITY > 0)
//                    //     |        /                 |    /                      |/
//                    //     | ______/               ___|___/                ______/|
//                    //     |/                     /   |                   /       |
//                    //    /|                     /    |                  /        |
//                    //     0V                         0V                          0V
//
//                    if (DZ_temp_cnt2 < DZ_end) {
//                        if (TMR3_COUNT_DEADZONE % 20 != 0) {
//                            CUR_VELOCITY_sum += CUR_VELOCITY;
//                        } else {
//                            V_out -= DZ_dir;
//                            if (CUR_VELOCITY_sum * DZ_dir < 0) DZ_temp_cnt++;
//                            CUR_VELOCITY_sum = 0;
//                        }
//                        if (DZ_temp_cnt == 5) {
//                            if (DZ_dir >= 0) VALVE_DEADZONE_MINUS = (int16_t) V_out;
//                            else VALVE_DEADZONE_PLUS = (int16_t) V_out;
//                            DZ_dir = -DZ_dir;
//                            DZ_temp_cnt = 0;
//                            DZ_temp_cnt2++;
//                        }
//                    } else {
//                        TMR3_COUNT_DEADZONE = -1;
//                        VALVE_CENTER = VALVE_DEADZONE_PLUS / 2 + VALVE_DEADZONE_MINUS / 2;
//                        if (VALVE_DEADZONE_PLUS < VALVE_DEADZONE_MINUS) {
//                            VALVE_DEADZONE_PLUS = VALVE_CENTER;
//                            VALVE_DEADZONE_MINUS = VALVE_CENTER;
//                        }
//                        V_out = 0;
//
//                        ROM_RESET_DATA();
//
//                        //spi_eeprom_write(RID_VALVE_DEADZONE_PLUS, VALVE_DEADZONE_PLUS);
//                        //spi_eeprom_write(RID_VALVE_DEADZONE_MINUS, VALVE_DEADZONE_MINUS);
//
//                        CONTROL_MODE = MODE_NO_ACT;
//                        DZ_temp_cnt2 = 0;
//                    }
//                }
//                TMR3_COUNT_DEADZONE++;
//                break;
//            }

            case MODE_FIND_HOME: {
                if (FINDHOME_STAGE == FINDHOME_INIT) {
                    cnt_findhome = 0;
                    cnt_vel_findhome = 0;
                    //REFERENCE_MODE = MODE_REF_NO_ACT; // Stop taking reference data from PODO
                    pos.ref = pos.sen;
                    vel.ref = 0.0f;
                    I_ERR_INT = 0.0f;
                    FINDHOME_STAGE = FINDHOME_GOTOLIMIT;
                } else if (FINDHOME_STAGE == FINDHOME_GOTOLIMIT) {
                    int cnt_check_enc = (TMR_FREQ_5k/20);
                    if(cnt_findhome%cnt_check_enc == 0) {
                        FINDHOME_POSITION = pos.sen;
                        FINDHOME_VELOCITY = FINDHOME_POSITION - FINDHOME_POSITION_OLD;
                        FINDHOME_POSITION_OLD = FINDHOME_POSITION;
                    }
                    cnt_findhome++;

                    if (abs(FINDHOME_VELOCITY) <= 1) {
                        cnt_vel_findhome = cnt_vel_findhome + 1;
                    } else {
                        cnt_vel_findhome = 0;
                    }

                    if ((cnt_vel_findhome < 3*TMR_FREQ_5k) &&  cnt_findhome < 10*TMR_FREQ_5k) { // wait for 3sec
                        //REFERENCE_MODE = MODE_REF_NO_ACT;
                        if (HOMEPOS_OFFSET > 0) pos.ref = pos.ref + 12.0f;
                        else pos.ref = pos.ref - 12.0f;

                        pos.err = (pos.ref - pos.sen)/(float)(ENC_PULSE_PER_POSITION); //[mm]

                        if (((OPERATING_MODE&0b110)>>1) == 0 || ((OPERATING_MODE&0b110)>>1) == 1) {

                        double I_REF_POS = 0.0f;
                        double temp_vel_pos = 0.0f;
                        double wn_Pos = 2.0f * PI * 5.0f; // f_cut : 5Hz Position Control

                        if ((OPERATING_MODE && 0x01) == 0) { // Rotary Mode
                            temp_vel_pos = 0.01f * (double) P_GAIN_JOINT_POSITION * wn_Pos * pos.err; // rad/s
                        } else if ((OPERATING_MODE && 0x01) == 1) {
                            temp_vel_pos = 0.01f * (double) P_GAIN_JOINT_POSITION * wn_Pos * pos.err; // mm/s
                        }
                        if (temp_vel_pos > 0.0f) I_REF_POS = temp_vel_pos * ((double) PISTON_AREA_A * 0.00006f / (K_v * sqrt(2.0f * alpha3 / (alpha3 + 1.0f))));
                        else I_REF_POS = temp_vel_pos * ((double) PISTON_AREA_B * 0.00006f / (K_v * sqrt(2.0f / (alpha3 + 1.0f))));

                        I_REF = I_REF_POS;
                        I_ERR_INT = 0.0f;


                        } else {
                            float VALVE_POS_RAW_FORCE_FB = 0.0f;
                            VALVE_POS_RAW_FORCE_FB = DDV_JOINT_POS_FF(vel.sen) + (P_GAIN_JOINT_POSITION * 0.01f * pos.err + DDV_JOINT_POS_FF(vel.ref));

                            if (VALVE_POS_RAW_FORCE_FB >= 0) {
                                valve_pos.ref = VALVE_POS_RAW_FORCE_FB + VALVE_DEADZONE_PLUS;
                            } else {
                                valve_pos.ref = VALVE_POS_RAW_FORCE_FB + VALVE_DEADZONE_MINUS;
                            }

                            VALVE_POS_CONTROL(valve_pos.ref);

                            V_out = (float) Vout.ref;

                        }



//                        pos.err = pos.ref_home_pos - pos.sen;
//                        float VALVE_POS_RAW_POS_FB = 0.0f;
//                        VALVE_POS_RAW_POS_FB = (float) P_GAIN_JOINT_POSITION * pos.err/(float) ENC_PULSE_PER_POSITION * 0.01f;
//                        valve_pos.ref = VALVE_POS_RAW_POS_FB + (float) VALVE_CENTER;
//                        VALVE_POS_CONTROL(valve_pos.ref);

                        cnt_findhome_wait = 0;
//                        CONTROL_MODE = MODE_JOINT_CONTROL;
                        alpha_trans = 0.0f;


                    } else {
                        ENC_SET(HOMEPOS_OFFSET);
//                        ENC_SET_ZERO();
                        INIT_REF_POS = HOMEPOS_OFFSET;
                        REF_POSITION = 0;
                        REF_VELOCITY = 0;
                        FINDHOME_POSITION = 0;
                        FINDHOME_POSITION_OLD = 0;
                        FINDHOME_VELOCITY = 0;

                        cnt_findhome = 0;
                        cnt_vel_findhome = 0;
                        FINDHOME_STAGE = FINDHOME_ZEROPOSE;

                        pos.ref = 0.0f;
                        vel.ref = 0.0f;
                        pos.ref_home_pos = 0.0f;
                        vel.ref_home_pos = 0.0f;
                        
                        I_ERR_INT = 0.0f;
                        
//                        cnt_findhome_wait = 0;
//                        FINDHOME_STAGE = FINDHOME_INIT;
//                        CONTROL_UTILITY_MODE = MODE_JOINT_CONTROL;
                    }
                    
//                } else if (FINDHOME_STAGE == FINDHOME_WAIT)     {
//                    cnt_findhome_wait = cnt_findhome_wait + 1;
//                    if(cnt_findhome_wait >  3*TMR_FREQ_5k){
//                        FINDHOME_STAGE = FINDHOME_ZEROPOSE;
//                        pos.sen = 0.0f;
//                        vel.sen = 0.0f;
//                    }
                    
                } else if (FINDHOME_STAGE == FINDHOME_ZEROPOSE) {
                    int T_move = 2*TMR_FREQ_5k;
                    pos.ref = (0.0f - (float)INIT_REF_POS)*0.5f*(1.0f - cos(3.14159f * (float)cnt_findhome / (float)T_move)) + (float)INIT_REF_POS;
                    vel.ref = 0.0f;
                    
                    // input for position control
                
//                    CONTROL_MODE = MODE_JOINT_CONTROL;
                    pos.err = (pos.ref - pos.sen)/(float)(ENC_PULSE_PER_POSITION); //[mm]

                    if (((OPERATING_MODE&0b110)>>1) == 0 || ((OPERATING_MODE&0b110)>>1) == 1) {

                        double I_REF_POS = 0.0f;

                        double temp_vel_pos = 0.0f;
                        double wn_Pos = 2.0f * PI * 5.0f; // f_cut : 5Hz Position Control

                        if ((OPERATING_MODE && 0x01) == 0) { // Rotary Mode
                            temp_vel_pos = 0.01f * (double) P_GAIN_JOINT_POSITION * wn_Pos * pos.err; // rad/s
                        } else if ((OPERATING_MODE && 0x01) == 1) {
                            temp_vel_pos = 0.01f * (double) P_GAIN_JOINT_POSITION * wn_Pos * pos.err; // mm/s
                        }
                        if (temp_vel_pos > 0.0f) I_REF_POS = temp_vel_pos * ((double) PISTON_AREA_A * 0.00006f / (K_v * sqrt(2.0f * alpha3 / (alpha3 + 1.0f))));
                        else I_REF_POS = temp_vel_pos * ((double) PISTON_AREA_B * 0.00006f / (K_v * sqrt(2.0f / (alpha3 + 1.0f))));

                        I_REF = I_REF_POS;
                        I_ERR_INT = 0.0f;



                    } else {
                        float VALVE_POS_RAW_FORCE_FB = 0.0f;
                        VALVE_POS_RAW_FORCE_FB = DDV_JOINT_POS_FF(vel.sen) + (P_GAIN_JOINT_POSITION * 0.01f * pos.err + DDV_JOINT_POS_FF(vel.ref));

                        if (VALVE_POS_RAW_FORCE_FB >= 0) {
                            valve_pos.ref = VALVE_POS_RAW_FORCE_FB + VALVE_DEADZONE_PLUS;
                        } else {
                            valve_pos.ref = VALVE_POS_RAW_FORCE_FB + VALVE_DEADZONE_MINUS;
                        }

                        VALVE_POS_CONTROL(valve_pos.ref);

                        V_out = (float) Vout.ref;

                    }
                    
//                    pos.err = pos.ref - (float)pos.sen;
//                    float VALVE_POS_RAW_POS_FB = 0.0f;
//                    VALVE_POS_RAW_POS_FB = (float) P_GAIN_JOINT_POSITION * 0.01f * pos.err/(float) ENC_PULSE_PER_POSITION;
//                    valve_pos.ref = VALVE_POS_RAW_POS_FB + (float) VALVE_CENTER;
//                    VALVE_POS_CONTROL(valve_pos.ref);

                    cnt_findhome++;
                    if (cnt_findhome >= T_move) {
                        //REFERENCE_MODE = MODE_REF_DIRECT;
                        cnt_findhome = 0;
                        pos.ref = 0.0f;
                        vel.ref = 0.0f;
                        pos.ref_home_pos = 0.0f;
                        vel.ref_home_pos = 0.0f;
                        FINDHOME_STAGE = FINDHOME_INIT;
                        CONTROL_UTILITY_MODE = MODE_JOINT_CONTROL;
                    }
                }

                break;
            }

//            case MODE_VALVE_GAIN_SETTING: {
//                if (TMR3_COUNT_FLOWRATE == 0) {
//                    if (pos_plus_end == pos_minus_end) need_enc_init = true;
//                    else {
//                        V_out = -VALVE_VOLTAGE_LIMIT * 1000.0f;
//                        temp_time = (int) (0.5f * (float) TMR_FREQ_5k);
//                    }
//                }
//                if (need_enc_init) {
//                    if (TMR3_COUNT_FLOWRATE < (int) (0.5f * (float) TMR_FREQ_5k)) {
//                        V_out = VALVE_VOLTAGE_LIMIT * 1000.0f;
//                        pos_plus_end = pos.sen;
//                    } else if (TMR3_COUNT_FLOWRATE < TMR_FREQ_5k) {
//                        V_out = -VALVE_VOLTAGE_LIMIT * 1000.0f;
//                        pos_minus_end = pos.sen;
//                    } else if (TMR3_COUNT_FLOWRATE == TMR_FREQ_5k) {
//                        need_enc_init = false;
//                        check_vel_pos_init = (int) (0.9f * (float) (pos_plus_end - pos_minus_end));
//                        check_vel_pos_fin = (int) (0.95f * (float) (pos_plus_end - pos_minus_end));
//                        check_vel_pos_interv = check_vel_pos_fin - check_vel_pos_init;
//                    }
//                    temp_time = TMR_FREQ_5k;
//                }
//                TMR3_COUNT_FLOWRATE++;
//                if (TMR3_COUNT_FLOWRATE > temp_time) {
//                    if (flag_flowrate % 2 == 0) { // (+)
//                        VALVE_VOLTAGE = 1000.0f * (float) (flag_flowrate / 2 + 1);
//                        V_out = VALVE_VOLTAGE;
//                        if (pos.sen > (pos_minus_end + check_vel_pos_init) && pos.sen < (pos_minus_end + check_vel_pos_fin)) {
//                            fl_temp_cnt++;
//                        } else if (pos.sen >= (pos_minus_end + check_vel_pos_fin) && CUR_VELOCITY == 0) {
//                            VALVE_GAIN_LPM_PER_V[flag_flowrate] = 0.95873f * 0.5757f * (float) TMR_FREQ_5k / 10000.0 * (float) check_vel_pos_interv / (float) fl_temp_cnt / VALVE_VOLTAGE; // 0.9587=6*pi/65536*10000 0.5757=0.02525*0.02*0.0095*2*60*1000
//                            //                        VALVE_GAIN_LPM_PER_V[flag_flowrate] = (float) TMR_FREQ_10k * (float) check_vel_pos_interv / (float) fl_temp_cnt / VALVE_VOLTAGE; // PULSE/sec
//                            fl_temp_cnt2++;
//                        }
//                    } else if (flag_flowrate % 2 == 1) { // (-)
//                        VALVE_VOLTAGE = -1. * (float) (flag_flowrate / 2 + 1);
//                        V_out = VALVE_VOLTAGE;
//                        if (pos.sen < (pos_plus_end - check_vel_pos_init) && pos.sen > (pos_plus_end - check_vel_pos_fin)) {
//                            fl_temp_cnt++;
//                        } else if (pos.sen <= (pos_plus_end - check_vel_pos_fin) && CUR_VELOCITY == 0) {
//                            VALVE_GAIN_LPM_PER_V[flag_flowrate] = 0.95873f * 0.5757f * (float) TMR_FREQ_5k / 10000.0f * (float) check_vel_pos_interv / (float) fl_temp_cnt / (-VALVE_VOLTAGE);
//                            //                        VALVE_GAIN_LPM_PER_V[flag_flowrate] = (float) TMR_FREQ_10k * (float) check_vel_pos_interv / (float) fl_temp_cnt / (-VALVE_VOLTAGE); // PULSE/sec
//                            fl_temp_cnt2++;
//                        }
//                    }
//                    if (fl_temp_cnt2 == 100) {
//
//                        ROM_RESET_DATA();
//
//                        //spi_eeprom_write(RID_VALVE_GAIN_PLUS_1 + flag_flowrate, (int16_t) (VALVE_GAIN_LPM_PER_V[flag_flowrate] * 100.0f));
//                        cur_vel_sum = 0;
//                        fl_temp_cnt = 0;
//                        fl_temp_cnt2 = 0;
//                        flag_flowrate++;
//                    }
//                    if (flag_flowrate == 10) {
//                        V_out = 0;
//                        flag_flowrate = 0;
//                        TMR3_COUNT_FLOWRATE = 0;
//                        valve_gain_repeat_cnt++;
//                        if (valve_gain_repeat_cnt >= 1) {
//                            CONTROL_MODE = MODE_NO_ACT;
//                            valve_gain_repeat_cnt = 0;
//                        }
//
//                    }
//                    break;
//                }
//
//            }
            case MODE_PRESSURE_SENSOR_NULLING: {
                // DAC Voltage reference set
                if (TMR3_COUNT_PRES_NULL < TMR_FREQ_5k * 2) {
                    CUR_PRES_A_sum += pres_A.sen;
                    CUR_PRES_B_sum += pres_B.sen;

                    if (TMR3_COUNT_PRES_NULL % 10 == 0) {
                        CUR_PRES_A_mean = CUR_PRES_A_sum / 10.0f;
                        CUR_PRES_B_mean = CUR_PRES_B_sum / 10.0f;
                        CUR_PRES_A_sum = 0;
                        CUR_PRES_B_sum = 0;

                        float VREF_NullingGain = 0.0003f;
                        PRES_A_VREF = PRES_A_VREF + VREF_NullingGain * CUR_PRES_A_mean;
                        PRES_B_VREF = PRES_B_VREF + VREF_NullingGain * CUR_PRES_B_mean;

                        if (PRES_A_VREF > 3.3f) PRES_A_VREF = 3.3f;
                        if (PRES_A_VREF < 0.0f) PRES_A_VREF = 0.0f;
                        if (PRES_B_VREF > 3.3f) PRES_B_VREF = 3.3f;
                        if (PRES_B_VREF < 0.0f) PRES_B_VREF = 0.0f;

                        dac_1 = PRES_A_VREF / 3.3f;
                        dac_2 = PRES_B_VREF / 3.3f;
                    }
                } else {
                    CONTROL_UTILITY_MODE = MODE_NO_ACT;
                    TMR3_COUNT_PRES_NULL = 0;
                    CUR_PRES_A_sum = 0;
                    CUR_PRES_B_sum = 0;
                    CUR_PRES_A_mean = 0;
                    CUR_PRES_B_mean = 0;

                    ROM_RESET_DATA();

                    dac_1 = PRES_A_VREF / 3.3f;
                    dac_2 = PRES_B_VREF / 3.3f;
                    //pc.printf("nulling end");
                }
                TMR3_COUNT_PRES_NULL++;
                break;
            }

//            case MODE_PRESSURE_SENSOR_CALIB: {
//                if (TMR3_COUNT_PRES_CALIB < 2 * TMR_FREQ_5k) {
//                    V_out = -VALVE_VOLTAGE_LIMIT * 1000.0f;
//                    if (TMR3_COUNT_PRES_CALIB >= TMR_FREQ_5k) {
//                        CUR_PRES_A_sum += CUR_PRES_A;
//                    }
//                } else if (TMR3_COUNT_PRES_CALIB < 4 * TMR_FREQ_5k) {
//                    V_out = VALVE_VOLTAGE_LIMIT * 1000.0f;
//                    if (TMR3_COUNT_PRES_CALIB >= 3 * TMR_FREQ_5k) {
//                        CUR_PRES_B_sum += CUR_PRES_B;
//                    }
//                } else {
//                    CONTROL_MODE = MODE_NO_ACT;
//                    TMR3_COUNT_PRES_CALIB = 0;
//                    V_out = 0;
//                    PRES_SENSOR_A_PULSE_PER_BAR = CUR_PRES_A_sum / ((float) TMR_FREQ_5k - 1.0f) - PRES_A_NULL;
//                    PRES_SENSOR_A_PULSE_PER_BAR = PRES_SENSOR_A_PULSE_PER_BAR / ((float) PRES_SUPPLY - 1.0f);
//                    PRES_SENSOR_B_PULSE_PER_BAR = CUR_PRES_B_sum / ((float) TMR_FREQ_5k - 1.0f) - PRES_B_NULL;
//                    PRES_SENSOR_B_PULSE_PER_BAR = PRES_SENSOR_B_PULSE_PER_BAR / ((float) PRES_SUPPLY - 1.0f);
//                    CUR_PRES_A_sum = 0;
//                    CUR_PRES_B_sum = 0;
//                    CUR_PRES_A_mean = 0;
//                    CUR_PRES_B_mean = 0;
//
//                    ROM_RESET_DATA();
//
//                    //spi_eeprom_write(RID_PRES_SENSOR_A_PULSE_PER_BAR, (int16_t) (PRES_SENSOR_A_PULSE_PER_BAR * 100.0f));
//                    //spi_eeprom_write(RID_PRES_SENSOR_B_PULSE_PER_BAR, (int16_t) (PRES_SENSOR_B_PULSE_PER_BAR * 100.0f));
//                }
//                TMR3_COUNT_PRES_CALIB++;
//                break;
//            }

//            case MODE_ROTARY_FRICTION_TUNING: {
//                if (TMR3_COUNT_ROTARY_FRIC_TUNE % (5 * TMR_FREQ_5k) == 0) freq_fric_tune = 4.0f + 3.0f * sin(2 * 3.14159f * 0.5f * TMR3_COUNT_ROTARY_FRIC_TUNE * 0.0001f * 0.05f);
//                V_out = PWM_out * sin(2 * 3.14159f * freq_fric_tune * TMR3_COUNT_ROTARY_FRIC_TUNE * 0.0001f);
//                if (V_out > 0) V_out = VALVE_VOLTAGE_LIMIT * 1000.0f;
//                else V_out = -VALVE_VOLTAGE_LIMIT * 1000.0f;
//                TMR3_COUNT_ROTARY_FRIC_TUNE++;
//                if (TMR3_COUNT_ROTARY_FRIC_TUNE > TUNING_TIME * TMR_FREQ_5k) {
//                    TMR3_COUNT_ROTARY_FRIC_TUNE = 0;
//                    V_out = 0.0f;
//                    CONTROL_MODE = MODE_NO_ACT;
//                }
//                break;
//            }

            case MODE_DDV_POS_VS_PWM_ID: {
                CONTROL_MODE = MODE_VALVE_OPEN_LOOP;
                VALVE_ID_timer = VALVE_ID_timer + 1;

                if(VALVE_ID_timer < TMR_FREQ_5k*1) {
                    Vout.ref = 3000.0f * sin(2.0f*3.14f*VALVE_ID_timer/TMR_FREQ_5k * 100.0f);
                } else if(VALVE_ID_timer < TMR_FREQ_5k*2) {
                    Vout.ref = 1000.0f*(ID_index_array[ID_index]);
                } else if(VALVE_ID_timer == TMR_FREQ_5k*2) {
                    VALVE_POS_TMP = 0;
                    data_num = 0;
                } else if(VALVE_ID_timer < TMR_FREQ_5k*3) {
                    data_num = data_num + 1;
                    VALVE_POS_TMP = VALVE_POS_TMP + value;
                } else if(VALVE_ID_timer == TMR_FREQ_5k*3) {
                    Vout.ref = 0.0f;
                } else {
                    VALVE_POS_AVG[ID_index] = VALVE_POS_TMP / data_num;
                    VALVE_ID_timer = 0;
                    ID_index= ID_index +1;
                }

                if(ID_index>=25) {
                    int i;
                    VALVE_POS_AVG_OLD = VALVE_POS_AVG[0];
                    for(i=0; i<25; i++) {
                        VALVE_POS_VS_PWM[i] = (int16_t) (VALVE_POS_AVG[i]);
                        if(VALVE_POS_AVG[i] > VALVE_POS_AVG_OLD) {
                            VALVE_MAX_POS = VALVE_POS_AVG[i];
                            VALVE_POS_AVG_OLD = VALVE_MAX_POS;
                        } else if(VALVE_POS_AVG[i] < VALVE_POS_AVG_OLD) {
                            VALVE_MIN_POS = VALVE_POS_AVG[i];
                            VALVE_POS_AVG_OLD = VALVE_MIN_POS;
                        }
                    }
                    ROM_RESET_DATA();
                    ID_index = 0;
                    CONTROL_UTILITY_MODE = MODE_NO_ACT;
                }


                break;
            }

            case MODE_DDV_DEADZONE_AND_CENTER: {
                CONTROL_MODE = MODE_VALVE_OPEN_LOOP;
                VALVE_DZ_timer = VALVE_DZ_timer + 1;
                if(first_check == 0) {
                    if(VALVE_DZ_timer < (int) (1.0f * (float) TMR_FREQ_5k)) {
                        Vout.ref = VALVE_VOLTAGE_LIMIT * 1000.0f;
                    } else if(VALVE_DZ_timer == (int) (1.0f * (float) TMR_FREQ_5k)) {
                        Vout.ref = VALVE_VOLTAGE_LIMIT * 1000.0f;
                        pos_plus_end = pos.sen;
                    } else if(VALVE_DZ_timer < (int) (2.0f * (float) TMR_FREQ_5k)) {
                        Vout.ref = -VALVE_VOLTAGE_LIMIT * 1000.0f;
                    } else if(VALVE_DZ_timer == (int) (2.0f * (float) TMR_FREQ_5k)) {
                        Vout.ref = -VALVE_VOLTAGE_LIMIT * 1000.0f;
                        pos_minus_end = pos.sen;
                    } else if(VALVE_DZ_timer < (int) (3.0f * (float) TMR_FREQ_5k)) {
                        Vout.ref = (float) P_GAIN_JOINT_POSITION * (0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end - (float) pos.sen)/(float) ENC_PULSE_PER_POSITION;
                    } else if(VALVE_DZ_timer < (int) (4.0f * (float) TMR_FREQ_5k)) {
                        Vout.ref = (float) P_GAIN_JOINT_POSITION * (0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end - (float) pos.sen)/(float) ENC_PULSE_PER_POSITION;
                        data_num = data_num + 1;
                        VALVE_POS_TMP = VALVE_POS_TMP + value;
                    } else if(VALVE_DZ_timer == (int) (4.0f * (float) TMR_FREQ_5k)) {
                        Vout.ref = (float) P_GAIN_JOINT_POSITION * (0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end - (float) pos.sen)/(float) ENC_PULSE_PER_POSITION;
                        DDV_POS_AVG = VALVE_POS_TMP / data_num;
                        START_POS = pos.sen;
                        VALVE_POS_TMP = 0;
                        data_num = 0;

                    } else if(VALVE_DZ_timer < (int) (5.0f * (float) TMR_FREQ_5k)) {
                        valve_pos.ref = DDV_POS_AVG;
                        VALVE_POS_CONTROL(valve_pos.ref);

                    } else if(VALVE_DZ_timer < (int) (6.0f * (float) TMR_FREQ_5k)) {
                        valve_pos.ref = DDV_POS_AVG;
                        VALVE_POS_CONTROL(valve_pos.ref);

                    } else if(VALVE_DZ_timer == (int) (6.0f * (float) TMR_FREQ_5k)) {
                        valve_pos.ref = DDV_POS_AVG;
                        VALVE_POS_CONTROL(valve_pos.ref);
                        FINAL_POS = pos.sen;

                        if((FINAL_POS - START_POS)>200) {
                            DZ_case = 1;
                        } else if((FINAL_POS - START_POS)<-200) {
                            DZ_case = -1;
                        } else {
                            DZ_case = 0;
                        }

                        CAN_TX_PRES((int16_t) (DZ_case), (int16_t) (6));

                        first_check = 1;
                        DZ_DIRECTION = 1;
                        VALVE_DZ_timer = 0;
                        Ref_Valve_Pos_Old = DDV_POS_AVG;
                        DZ_NUM = 1;
                        DZ_index = 1;

                    }
                } else {
                    if((DZ_case == -1 && DZ_NUM == 1) | (DZ_case == 1 && DZ_NUM == 1)) {
                        if(VALVE_DZ_timer < (int) (1.0 * (float) TMR_FREQ_5k)) {
                            Vout.ref = (float) P_GAIN_JOINT_POSITION * (0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end - (float) pos.sen)/(float) ENC_PULSE_PER_POSITION;
                            //pos.ref = 0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end;
                            //CONTROL_MODE = MODE_JOINT_CONTROL;
                        } else if(VALVE_DZ_timer == (int) (1.0f * (float) TMR_FREQ_5k)) {
                            START_POS = pos.sen;
                        } else if(VALVE_DZ_timer < (int) (2.0f * (float) TMR_FREQ_5k)) {
                            valve_pos.ref = Ref_Valve_Pos_Old  - DZ_case * DZ_DIRECTION * 64 / DZ_index;
                            if(valve_pos.ref <= VALVE_MIN_POS) {
                                valve_pos.ref = VALVE_MIN_POS;
                            } else if(valve_pos.ref >= VALVE_MAX_POS) {
                                valve_pos.ref = VALVE_MAX_POS;
                            }
                            VALVE_POS_CONTROL(valve_pos.ref);

                        } else if(VALVE_DZ_timer == (int) (2.0f * (float) TMR_FREQ_5k)) {
                            Ref_Valve_Pos_Old = valve_pos.ref;
                            FINAL_POS = pos.sen;

                            if((FINAL_POS - START_POS)>100) {
                                DZ_DIRECTION = 1 * DZ_case;
                            } else if((FINAL_POS - START_POS)<-100) {
                                DZ_DIRECTION = -1 * DZ_case;
                            } else {
                                DZ_DIRECTION = 1 * DZ_case;
                            }

                            VALVE_DZ_timer = 0;
                            DZ_index= DZ_index *2;
                            if(DZ_index >= 128) {
                                FIRST_DZ = valve_pos.ref;
                                DZ_NUM = 2;
                                Ref_Valve_Pos_Old = FIRST_DZ;
                                DZ_index = 1;
                                DZ_DIRECTION = 1;
                            }
                        }
                    } else if((DZ_case == -1 && DZ_NUM == 2) | (DZ_case == 1 && DZ_NUM == 2)) {
                        if(VALVE_DZ_timer < (int) (1.0f * (float) TMR_FREQ_5k)) {
                            Vout.ref = (float) P_GAIN_JOINT_POSITION * (0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end - (float) pos.sen)/(float) ENC_PULSE_PER_POSITION;
                            //pos.ref = 0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end;
                            //CONTROL_MODE = MODE_JOINT_CONTROL;
                        } else if(VALVE_DZ_timer == (int) (1.0f * (float) TMR_FREQ_5k)) {
                            START_POS = pos.sen;
                        } else if(VALVE_DZ_timer < (int) (2.0f * (float) TMR_FREQ_5k)) {
                            valve_pos.ref = Ref_Valve_Pos_Old  - DZ_case * DZ_DIRECTION * 64 / DZ_index;
                            if(valve_pos.ref <= VALVE_MIN_POS) {
                                valve_pos.ref = VALVE_MIN_POS;
                            } else if(valve_pos.ref >= VALVE_MAX_POS) {
                                valve_pos.ref = VALVE_MAX_POS;
                            }
                            VALVE_POS_CONTROL(valve_pos.ref);

                        } else if(VALVE_DZ_timer == (int) (2.0f * (float) TMR_FREQ_5k)) {
                            Vout.ref = 0.0f;
                        } else if(VALVE_DZ_timer > (int) (2.0f * (float) TMR_FREQ_5k)) {
                            Ref_Valve_Pos_Old = valve_pos.ref;
                            FINAL_POS = pos.sen;

                            if((FINAL_POS - START_POS)>100) {
                                DZ_DIRECTION = 1 * DZ_case;
                            } else if((FINAL_POS - START_POS)<-100) {
                                DZ_DIRECTION = -1 * DZ_case;
                            } else {
                                DZ_DIRECTION = -1 * DZ_case;
                            }

                            VALVE_DZ_timer = 0;
                            DZ_index= DZ_index * 2;
                            if(DZ_index >= 128) {
                                SECOND_DZ = valve_pos.ref;
                                VALVE_CENTER = (int) (0.5f * (float) (FIRST_DZ) + 0.5f * (float) (SECOND_DZ));
                                first_check = 0;
                                VALVE_DEADZONE_MINUS = (float) FIRST_DZ;
                                VALVE_DEADZONE_PLUS = (float) SECOND_DZ;

                                ROM_RESET_DATA();

                                CONTROL_UTILITY_MODE = MODE_NO_ACT;
                                DZ_index = 1;
                            }
                        }
                    } else if(DZ_case == 0 && DZ_NUM ==1) {
                        if(VALVE_DZ_timer < (int) (1.0f * (float) TMR_FREQ_5k)) {
                            Vout.ref = (float) P_GAIN_JOINT_POSITION * (0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end - (float) pos.sen)/(float) ENC_PULSE_PER_POSITION;
                            //pos.ref = 0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end;
                            //CONTROL_MODE = MODE_JOINT_CONTROL;
                        } else if(VALVE_DZ_timer == (int) (1.0f * (float) TMR_FREQ_5k)) {
                            START_POS = pos.sen;
                        } else if(VALVE_DZ_timer < (int) (2.0f * (float) TMR_FREQ_5k)) {
                            valve_pos.ref = Ref_Valve_Pos_Old  - DZ_DIRECTION * 64 / DZ_index;
                            if(valve_pos.ref <= VALVE_MIN_POS) {
                                valve_pos.ref = VALVE_MIN_POS;
                            } else if(valve_pos.ref >= VALVE_MAX_POS) {
                                valve_pos.ref = VALVE_MAX_POS;
                            }
                            VALVE_POS_CONTROL(valve_pos.ref);

                        } else if(VALVE_DZ_timer == (int) (2.0f * (float) TMR_FREQ_5k)) {
                            Ref_Valve_Pos_Old = valve_pos.ref;
                            FINAL_POS = pos.sen;

                            if((FINAL_POS - START_POS)>100) {
                                DZ_DIRECTION = 1;
                            } else if((FINAL_POS - START_POS)<-100) {
                                DZ_DIRECTION = -1;
                            } else {
                                DZ_DIRECTION = 1;
                            }
                            VALVE_DZ_timer = 0;
                            DZ_index= DZ_index *2;
                            if(DZ_index >= 128) {
                                FIRST_DZ = valve_pos.ref;
                                DZ_NUM = 2;
                                Ref_Valve_Pos_Old = FIRST_DZ;
                                DZ_index = 1;
                                DZ_DIRECTION = 1;
                            }
                        }
                    } else {
                        if(VALVE_DZ_timer < (int) (1.0f * (float) TMR_FREQ_5k)) {
                            Vout.ref = (float) P_GAIN_JOINT_POSITION * (0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end - (float) pos.sen)/(float) ENC_PULSE_PER_POSITION;
                            //pos.ref = 0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end;
                            //CONTROL_MODE = MODE_JOINT_CONTROL;
                        } else if(VALVE_DZ_timer == (int) (1.0f * (float) TMR_FREQ_5k)) {
                            START_POS = pos.sen;
                        } else if(VALVE_DZ_timer < (int) (2.0f * (float) TMR_FREQ_5k)) {
                            valve_pos.ref = Ref_Valve_Pos_Old  + DZ_DIRECTION * 64 / DZ_index;
                            if(valve_pos.ref <= VALVE_MIN_POS) {
                                valve_pos.ref = VALVE_MIN_POS;
                            } else if(valve_pos.ref > VALVE_MAX_POS) {
                                valve_pos.ref = VALVE_MAX_POS - 1;
                            }
                            VALVE_POS_CONTROL(valve_pos.ref);

                        } else if(VALVE_DZ_timer == (int) (2.0f * (float) TMR_FREQ_5k)) {
                            Vout.ref = 0.0f;
                        } else if(VALVE_DZ_timer > (int) (2.0f * (float) TMR_FREQ_5k)) {
                            Ref_Valve_Pos_Old = valve_pos.ref;
                            FINAL_POS = pos.sen;

                            if((FINAL_POS - START_POS)>100) {
                                DZ_DIRECTION = 1;
                            } else if((FINAL_POS - START_POS)<-100) {
                                DZ_DIRECTION = -1;
                            } else {
                                DZ_DIRECTION = 1;
                            }

                            VALVE_DZ_timer = 0;
                            DZ_index= DZ_index *2;
                            if(DZ_index >= 128) {
                                SECOND_DZ = valve_pos.ref;
                                VALVE_CENTER = (int) (0.5f * (float) (FIRST_DZ) + 0.5f * (float) (SECOND_DZ));
                                first_check = 0;
                                VALVE_DEADZONE_MINUS = (float) FIRST_DZ;
                                VALVE_DEADZONE_PLUS = (float) SECOND_DZ;

                                ROM_RESET_DATA();

                                CONTROL_UTILITY_MODE = MODE_NO_ACT;
                                DZ_index = 1;
                            }
                        }
                    }
                }
                break;
            }

            case MODE_DDV_POS_VS_FLOWRATE: {
                CONTROL_MODE = MODE_VALVE_OPEN_LOOP;
                VALVE_FR_timer = VALVE_FR_timer + 1;
                if(first_check == 0) {
                    if(VALVE_FR_timer < (int) (1.0f * (float) TMR_FREQ_5k)) {
                        Vout.ref = VALVE_VOLTAGE_LIMIT * 1000.0f;
                        //CAN_TX_PRES((int16_t) (VALVE_FR_timer), (int16_t) (6));
                    } else if(VALVE_FR_timer == (int) (1.0f * (float) TMR_FREQ_5k)) {
                        Vout.ref = VALVE_VOLTAGE_LIMIT * 1000.0f;
                        pos_plus_end = pos.sen;
                        //                    CAN_TX_PRES((int16_t) (V_out), (int16_t) (7));
                    } else if(VALVE_FR_timer < (int) (2.0f * (float) TMR_FREQ_5k)) {
                        Vout.ref = -VALVE_VOLTAGE_LIMIT * 1000.0f;
                    } else if(VALVE_FR_timer == (int) (2.0f * (float) TMR_FREQ_5k)) {
                        //                    CAN_TX_PRES((int16_t) (V_out), (int16_t) (8));
                        Vout.ref = -VALVE_VOLTAGE_LIMIT * 1000.0f;
                        pos_minus_end = pos.sen;
                        first_check = 1;
                        VALVE_FR_timer = 0;
                        valve_pos.ref = (float) VALVE_CENTER;
                        ID_index = 0;
                        max_check = 0;
                        min_check = 0;
                    }
                } else {
                    if(VALVE_FR_timer < (int) (1.0f * (float) TMR_FREQ_5k)) {
                        //V_out = (float) P_GAIN_JOINT_POSITION * (0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end - (float) pos.sen)/(float) ENC_PULSE_PER_POSITION;
                        pos.ref = 0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end;
                        CONTROL_MODE = MODE_JOINT_CONTROL;
                    } else if(VALVE_FR_timer == (int) (1.0f * (float) TMR_FREQ_5k)) {
                        data_num = 0;
                        valve_pos.ref = 10.0f*((float) ID_index_array[ID_index]) + (float) VALVE_CENTER;

                        VALVE_POS_CONTROL(valve_pos.ref);
                        START_POS = pos.sen;
                    } else if(VALVE_FR_timer < (int) (5.0f * (float) TMR_FREQ_5k)) {
                        valve_pos.ref = 10.0f*((float) ID_index_array[ID_index]) + (float) VALVE_CENTER;
                        VALVE_POS_CONTROL(valve_pos.ref);
                        data_num = data_num + 1;
                        if(abs(0.5f * (float) pos_plus_end + 0.5f * (float) pos_minus_end - (float) pos.sen) > 20000.0f) {
                            FINAL_POS = pos.sen;
                            one_period_end = 1;
                        }
                    } else if(VALVE_FR_timer == (int) (5.0f * (float) TMR_FREQ_5k)) {
                        FINAL_POS = pos.sen;
                        one_period_end = 1;
                        V_out = 0.0f;
                    }

                    if(one_period_end == 1) {
                        if(valve_pos.ref > VALVE_MAX_POS) {
                            max_check = 1;
                        } else if(valve_pos.ref < VALVE_MIN_POS) {
                            min_check = 1;
                        }
                        JOINT_VEL[ID_index] = (FINAL_POS - START_POS) / data_num * TMR_FREQ_5k;   //  pulse/sec

                        VALVE_FR_timer = 0;
                        one_period_end = 0;
                        ID_index= ID_index +1;
                        V_out = 0.0f;
                    }

                    if(max_check == 1 && min_check == 1) {

                        VALVE_POS_NUM = ID_index;
                        ROM_RESET_DATA();
                        ID_index = 0;
                        first_check = 0;
                        VALVE_FR_timer = 0;
                        CONTROL_UTILITY_MODE = MODE_NO_ACT;
//                        CAN_TX_PRES((int16_t) (VALVE_FR_timer), (int16_t) (6));
                    }
                }
                break;
            }

            case MODE_SYSTEM_ID: {
                freq_sysid_Iref = (double) cnt_sysid * DT_TMR3 * 3.;
                valve_pos.ref = 2500.0f * sin(2.0f * 3.14159f * freq_sysid_Iref * (double) cnt_sysid * DT_TMR3);
                CONTROL_MODE = MODE_VALVE_OPEN_LOOP;
                cnt_sysid++;
                if (freq_sysid_Iref >= 300) {
                    cnt_sysid = 0;
                    CONTROL_UTILITY_MODE = MODE_NO_ACT;
                }
                break;
            }



            default:
                break;
        }

        // CONTROL MODE ------------------------------------------------------------

        switch (CONTROL_MODE) {
            case MODE_NO_ACT: {
                V_out = 0.0f;
                break;
            }

            case MODE_VALVE_POSITION_CONTROL: {
                if (OPERATING_MODE == 5) { //SW Valve
                    VALVE_POS_CONTROL(valve_pos.ref);
                    V_out = Vout.ref;
                } else if (CURRENT_CONTROL_MODE == 0) { //PWM
                    V_out = valve_pos.ref;
                } else { 
                    I_REF = valve_pos.ref * 0.001f;
                }

                break;
            }

            case MODE_JOINT_CONTROL: {
                double torq_ref = 0.0f;
                pos.err = (pos.ref - pos.sen)/(float)(ENC_PULSE_PER_POSITION); //[mm]
                vel.err = (vel.ref - vel.sen)/(float)(ENC_PULSE_PER_POSITION); //[mm/s]
//                vel.err = (0.0f - vel.sen)/(float)(ENC_PULSE_PER_POSITION); //[mm/s]
                pos.err_sum += pos.err/(float) TMR_FREQ_5k; //[mm]
                
                //K & D Low Pass Filter
                float alpha_K_D = 1.0f/(1.0f + 5000.0f/(2.0f*3.14f*30.0f)); // f_cutoff : 30Hz
                K_LPF = K_LPF*(1.0f-alpha_K_D)+K_SPRING*(alpha_K_D);
                D_LPF = D_LPF*(1.0f-alpha_K_D)+D_DAMPER*(alpha_K_D);
                
                torq_ref = torq.ref + K_LPF * pos.err - D_LPF * vel.sen / ENC_PULSE_PER_POSITION; //[N]

                // torque feedback
                torq.err = torq_ref - torq.sen; //[N]
                torq.err_sum += torq.err/(float) TMR_FREQ_5k; //[N]

                if (((OPERATING_MODE&0b110)>>1) == 0 || ((OPERATING_MODE&0b110)>>1) == 1) {

                    double I_REF_POS = 0.0f;
                    double I_REF_FORCE_FB = 0.0f; // I_REF by Force Feedback
                    double I_REF_VC = 0.0f; // I_REF for velocity compensation

                    double temp_vel_pos = 0.0f;
                    double temp_vel_torq = 0.0f;
                    double wn_Pos = 2.0f * PI * 5.0f; // f_cut : 5Hz Position Control

                    if ((OPERATING_MODE && 0x01) == 0) { // Rotary Mode
                        temp_vel_pos = (0.01f * (double) P_GAIN_JOINT_POSITION * wn_Pos * pos.err + 0.01f * (double) I_GAIN_JOINT_POSITION * wn_Pos * pos.err_sum + 0.01f * (double) VELOCITY_COMP_GAIN * vel.ref / ENC_PULSE_PER_POSITION) * PI / 180.0f; // rad/s
                        //                            L when P-gain = 100, f_cut = 10Hz                                 L feedforward velocity
                    } else if ((OPERATING_MODE && 0x01) == 1) {
                        temp_vel_pos = (0.01f * (double) P_GAIN_JOINT_POSITION * wn_Pos * pos.err + 0.01f * (double) I_GAIN_JOINT_POSITION * wn_Pos * pos.err_sum + 0.01f * (double) VELOCITY_COMP_GAIN * vel.ref / ENC_PULSE_PER_POSITION); // mm/s
                        //                            L when P-gain = 100, f_cut = 10Hz                                 L feedforward velocity
                    }
                    if (temp_vel_pos > 0.0f) I_REF_POS = temp_vel_pos * ((double) PISTON_AREA_A * 0.00006f / (K_v * sqrt(2.0f * alpha3 / (alpha3 + 1.0f))));
                    else I_REF_POS = temp_vel_pos * ((double) PISTON_AREA_B * 0.00006f / (K_v * sqrt(2.0f / (alpha3 + 1.0f))));

                    // velocity compensation for torque control
                    if ((OPERATING_MODE && 0x01) == 0) { // Rotary Mode
                        I_REF_FORCE_FB = 0.001f * ((double) P_GAIN_JOINT_TORQUE * torq.err + (double) I_GAIN_JOINT_TORQUE * torq.err_sum);
                        //                temp_vel_torq = (0.01 * (double) VELOCITY_COMP_GAIN * (double) CUR_VELOCITY / (double) ENC_PULSE_PER_POSITION) * PI / 180.0; // rad/s
                        temp_vel_torq = (0.01f * (double) VELOCITY_COMP_GAIN * vel.ref / (double) ENC_PULSE_PER_POSITION) * PI / 180.0f; // rad/s
                        //                                                          L feedforward velocity
                    } else if ((OPERATING_MODE && 0x01) == 1) {
                        I_REF_FORCE_FB = 0.001f * 0.01f*((double) P_GAIN_JOINT_TORQUE * torq.err + (double) I_GAIN_JOINT_TORQUE * torq.err_sum); // Linear Actuators are more sensitive.
                        //                temp_vel_torq = (0.01 * (double) VELOCITY_COMP_GAIN * (double) CUR_VELOCITY / (double) ENC_PULSE_PER_POSITION); // mm/s
                        temp_vel_torq = (0.01f * (double) VELOCITY_COMP_GAIN * vel.ref / (double) ENC_PULSE_PER_POSITION); // mm/s
                        //                                                          L feedforward velocity
                    }
                    if (temp_vel_torq > 0.0f) I_REF_VC = temp_vel_torq * ((double) PISTON_AREA_A * 0.00006f / (K_v * sqrt(2.0f * alpha3 / (alpha3 + 1.0f))));
                    else I_REF_VC = temp_vel_torq * ((double) PISTON_AREA_B * 0.00006f / (K_v * sqrt(2.0f / (alpha3 + 1.0f))));
                    //                                                  L   velocity(rad/s or mm/s) >> I_ref(mA)
                    //            Ref_Joint_FT_dot = (Ref_Joint_FT_Nm - Ref_Joint_FT_Nm_old) / TMR_DT_5k;
                    //            Ref_Joint_FT_Nm_old = Ref_Joint_FT_Nm;

                    I_REF = (1.0f - alpha_trans) * I_REF_POS + alpha_trans * (I_REF_VC + I_REF_FORCE_FB);
                    
                    // Anti-windup for FT
                    if (I_GAIN_JOINT_TORQUE != 0) {
                        double I_MAX = 10.0f; // Maximum Current : 10mV
                        double Ka = 2.0f / ((double) I_GAIN_JOINT_TORQUE * 0.001f);
                        if (I_REF > I_MAX) {
                            double I_rem = I_REF - I_MAX;
                            I_rem = Ka*I_rem;
                            I_REF = I_MAX;
                            torq.err_sum = torq.err_sum - I_rem /(float) TMR_FREQ_5k;
                        } else if (I_REF < -I_MAX) {
                            double I_rem = I_REF - (-I_MAX);
                            I_rem = Ka*I_rem;
                            I_REF = -I_MAX;
                            torq.err_sum = torq.err_sum - I_rem /(float) TMR_FREQ_5k;
                        }
                    }

                } else {
                    float VALVE_POS_RAW_FORCE_FB = 0.0f;

                    VALVE_POS_RAW_FORCE_FB = alpha_trans*(((float) P_GAIN_JOINT_TORQUE * torq.err + (float) I_GAIN_JOINT_TORQUE * torq.err_sum) * 0.01f
                                                          + DDV_JOINT_POS_FF(vel.sen))+ (1.0f-alpha_trans) * (P_GAIN_JOINT_POSITION * 0.01f * pos.err + DDV_JOINT_POS_FF(vel.ref));

                    if (VALVE_POS_RAW_FORCE_FB >= 0) {
                        valve_pos.ref = VALVE_POS_RAW_FORCE_FB + VALVE_DEADZONE_PLUS;
                    } else {
                        valve_pos.ref = VALVE_POS_RAW_FORCE_FB + VALVE_DEADZONE_MINUS;
                    }

                    if(I_GAIN_JOINT_TORQUE != 0) {
                        double Ka = 1.0f / (double) I_GAIN_JOINT_TORQUE * 100.0f;
                        if(valve_pos.ref>VALVE_MAX_POS) {
                            double valve_pos_rem = valve_pos.ref - VALVE_MAX_POS;
                            valve_pos_rem = valve_pos_rem * Ka;
                            valve_pos.ref = VALVE_MAX_POS;
                            torq.err_sum = torq.err_sum - valve_pos_rem/(float) TMR_FREQ_5k;
                        } else if(valve_pos.ref < VALVE_MIN_POS) {
                            double valve_pos_rem = valve_pos.ref - VALVE_MIN_POS;
                            valve_pos_rem = valve_pos_rem * Ka;
                            valve_pos.ref = VALVE_MIN_POS;
                            torq.err_sum = torq.err_sum - valve_pos_rem/(float) TMR_FREQ_5k;
                        }
                    }

                    VALVE_POS_CONTROL(valve_pos.ref);

//                    Vout.ref = (float) P_GAIN_JOINT_POSITION * 0.01f * ((float) pos.err);
                    V_out = (float) Vout.ref;

                }

                break;
            }

            case MODE_VALVE_OPEN_LOOP: {
                V_out = (float) Vout.ref;
                break;
            }

            default:
                break;
        }


        if (((OPERATING_MODE&0b110)>>1) == 0 || ((OPERATING_MODE&0b110)>>1) == 1) { //Moog Valve or KNR Valve

            ////////////////////////////////////////////////////////////////////////////
            ////////////////////////////  CURRENT CONTROL //////////////////////////////
            ////////////////////////////////////////////////////////////////////////////
            
            if (CURRENT_CONTROL_MODE) {
                
                // Moog Valve Current Control Gain
                double R_model = 500.0f; // ohm
                double L_model = 1.2f;
                double w0 = 2.0f * 3.14f * 150.0f;
                double KP_I = 0.1f * L_model*w0;
                double KI_I = 0.1f * R_model*w0;

                // KNR Valve Current Control Gain
                if (((OPERATING_MODE & 0b110)>>1) == 1) { // KNR Valve
                    R_model = 163.0f; // ohm
                    L_model = 1.0f;
                    w0 = 2.0f * 3.14f * 80.0f;
                    KP_I = 1.0f * L_model*w0;
                    KI_I = 0.08f * R_model*w0;
                }
                
                double alpha_update_Iref = 1.0f / (1.0f + 5000.0f / (2.0f * 3.14f * 300.0f)); // f_cutoff : 500Hz
                I_REF_fil = (1.0f - alpha_update_Iref) * I_REF_fil + alpha_update_Iref*I_REF;
                
                FLAG_VALVE_DEADZONE = 1;
                
                if (FLAG_VALVE_DEADZONE) {
                    if (I_REF_fil > 0) I_REF_fil_DZ = I_REF_fil + VALVE_DEADZONE_PLUS / 1000.0f; // unit: mA
                    else if (I_REF_fil < 0) I_REF_fil_DZ = I_REF_fil + VALVE_DEADZONE_MINUS / 1000.0f; // unit: mA
                    else I_REF_fil_DZ = I_REF_fil + (VALVE_DEADZONE_PLUS+VALVE_DEADZONE_MINUS)/2.0f / 1000.0f; // unit: mA
                } else {
                    I_REF_fil_DZ = I_REF_fil;
                }

                I_ERR = I_REF_fil_DZ - cur.sen;
                I_ERR_INT = I_ERR_INT + (I_ERR) * 0.0002f;


                

                double FF_gain = 1.0f;

                VALVE_PWM_RAW = KP_I * 2.0f * I_ERR + KI_I * 2.0f* I_ERR_INT;
                //        VALVE_PWM_RAW = VALVE_PWM_RAW + FF_gain * (R_model*I_REF); // Unit : mV
                I_REF_fil_diff = I_REF_fil_DZ - I_REF_fil_old;
                I_REF_fil_old = I_REF_fil_DZ;
//                VALVE_PWM_RAW = VALVE_PWM_RAW + FF_gain * (R_model * I_REF_fil_DZ + L_model * I_REF_fil_diff * 5000.0f); // Unit : mV
                VALVE_PWM_RAW = VALVE_PWM_RAW + FF_gain * (R_model * I_REF_fil_DZ); // Unit : mV
                double V_MAX = 12000.0f; // Maximum Voltage : 12V = 12000mV

                double Ka = 3.0f / KP_I;
                if (VALVE_PWM_RAW > V_MAX) {
                    V_rem = VALVE_PWM_RAW - V_MAX;
                    V_rem = Ka*V_rem;
                    VALVE_PWM_RAW = V_MAX;
                    I_ERR_INT = I_ERR_INT - V_rem * 0.0002f;
                } else if (VALVE_PWM_RAW < -V_MAX) {
                    V_rem = VALVE_PWM_RAW - (-V_MAX);
                    V_rem = Ka*V_rem;
                    VALVE_PWM_RAW = -V_MAX;
                    I_ERR_INT = I_ERR_INT - V_rem * 0.0002f;
                }
                Cur_Valve_Open_pulse = cur.sen / mA_PER_pulse;
            } else {
                VALVE_PWM_RAW = I_REF * mV_PER_mA;
                Cur_Valve_Open_pulse = I_REF / mA_PER_pulse;
            }

            ////////////////////////////////////////////////////////////////////////////
            /////////////////  Dead Zone Cancellation & Linearization //////////////////
            ////////////////////////////////////////////////////////////////////////////
            // Dead Zone Cancellation (Mechanical Valve dead-zone)
//            if (FLAG_VALVE_DEADZONE) {
//                if (VALVE_PWM_RAW > 0) VALVE_PWM_RAW = VALVE_PWM_RAW + VALVE_DEADZONE_PLUS * mV_PER_pulse; // unit: mV
//                else if (VALVE_PWM_RAW < 0) VALVE_PWM_RAW = VALVE_PWM_RAW + VALVE_DEADZONE_MINUS * mV_PER_pulse; // unit: mV
//                VALVE_PWM_VALVE_DZ = VALVE_PWM_RAW + (double)VALVE_CENTER * mV_PER_pulse; // unit: mV
//            } else {
//                VALVE_PWM_VALVE_DZ = VALVE_PWM_RAW;
//            }

            // VALVE_DEADZONE_PLUS : Current[mA] to start extraction
            // VALVE_DEADZONE_MINUS : Current[mA] to start contraction
//            double R_model = 500.0f;
//            FLAG_VALVE_DEADZONE = true;
//            if (FLAG_VALVE_DEADZONE) {
//                if (VALVE_PWM_RAW > 0) VALVE_PWM_VALVE_DZ = VALVE_PWM_RAW + VALVE_DEADZONE_PLUS * R_model / 1000.0f; // unit: mV
//                else if (VALVE_PWM_RAW < 0) VALVE_PWM_VALVE_DZ = VALVE_PWM_RAW + VALVE_DEADZONE_MINUS * R_model / 1000.0f; // unit: mV
//                else VALVE_PWM_VALVE_DZ = VALVE_PWM_RAW + (VALVE_DEADZONE_PLUS+VALVE_DEADZONE_MINUS)/2.0f* R_model / 1000.0f;
//            } else {
                VALVE_PWM_VALVE_DZ = VALVE_PWM_RAW;
//            }

            // Output Voltage Linearization
            double CUR_PWM_nonlin = VALVE_PWM_VALVE_DZ; // Unit : mV
            double CUR_PWM_lin = PWM_duty_byLT(CUR_PWM_nonlin);  // -8000~8000

            // Dead Zone Cancellation (Electrical dead-zone)
            if (CUR_PWM_lin > 0) V_out = (float) (CUR_PWM_lin + 169.0f);
            else if (CUR_PWM_lin < 0) V_out = (float) (CUR_PWM_lin - 174.0f);
            else V_out = (float) (CUR_PWM_lin);
        }
        
//        if(V_out > 0.0f) V_out = (float) (V_out + 169.0f);
//        else if(V_out < 0.0f) V_out = (float) (V_out - 174.0f);
//        else V_out = V_out;
    
        /*******************************************************
        ***     PWM
        ********************************************************/
        if(DIR_VALVE<0){
            V_out = -V_out;
        }
        
        if (V_out >= VALVE_VOLTAGE_LIMIT*1000.0f) {
            V_out = VALVE_VOLTAGE_LIMIT*1000.0f;
        } else if(V_out<=-VALVE_VOLTAGE_LIMIT*1000.0f) {
            V_out = -VALVE_VOLTAGE_LIMIT*1000.0f;
        }
        PWM_out= V_out/(SUPPLY_VOLTAGE*1000.0f); // Full duty : 12000.0mV

        // Saturation of output voltage to 12.0V
        if(PWM_out > 1.0f) PWM_out=1.0f;
        else if (PWM_out < -1.0f) PWM_out=-1.0f;

        if (PWM_out>0.0f) {
            dtc_v=0.0f;
            dtc_w=PWM_out;
        } else {
            dtc_v=-PWM_out;
            dtc_w=0.0f;
        }

        //pwm
        TIM4->CCR2 = (PWM_ARR)*(1.0f-dtc_v);
        TIM4->CCR1 = (PWM_ARR)*(1.0f-dtc_w);


        if (TMR2_COUNT_CAN_TX % (int) ((int) TMR_FREQ_5k/CAN_FREQ) == 0) {

            // Position, Velocity, and Torque (ID:1200)
            if (flag_data_request[0] == HIGH) {
                if ((OPERATING_MODE & 0b01) == 0) { // Rotary Actuator
                    //if (SENSING_MODE == 0) {
                        CAN_TX_POSITION_FT((int16_t) (pos.sen), (int16_t) (vel.sen/10.0f), (int16_t) (torq.sen*10.0f));
                    //} else if (SENSING_MODE == 1) {
                    //    CAN_TX_POSITION_PRESSURE((int16_t) (pos.sen), (int16_t) (vel.sen/10.0f), (int16_t) ((pres_A.sen)*5.0f), (int16_t) ((pres_B.sen)*5.0f));
                    //}
                } else if ((OPERATING_MODE & 0b01) == 1) { // Linear Actuator
                    //if (SENSING_MODE == 0) {
                        CAN_TX_POSITION_FT((int16_t) (pos.sen/10.0f), (int16_t) (vel.sen/256.0f), (int16_t) (torq.sen * 10.0f * (float)(TORQUE_SENSOR_PULSE_PER_TORQUE)));
                    //} else if (SENSING_MODE == 1) {
                    //    CAN_TX_POSITION_PRESSURE((int16_t) (pos.sen/10.0f), (int16_t) (vel.sen/256.0f), (int16_t) ((pres_A.sen)*5.0f), (int16_t) ((pres_B.sen)*5.0f));
                    //}
                }
            }
            if (flag_data_request[1] == HIGH) {
                //valve position
                double t_value = 0;
//                if(valve_pos.ref>=(float) VALVE_CENTER) {
//                    t_value = 10000.0f*((double)valve_pos.ref - (double)VALVE_CENTER)/((double)VALVE_MAX_POS - (double)VALVE_CENTER);
//                } else {
//                    t_value = -10000.0f*((double)valve_pos.ref - (double)VALVE_CENTER)/((double)VALVE_MIN_POS - (double)VALVE_CENTER);
//                }
                if(OPERATING_MODE==5) {
                    t_value = (double) value;
                } else if(CURRENT_CONTROL_MODE==1) {
                    t_value = cur.sen;
                } else {
                    t_value = V_out;
                }
//                CAN_TX_TORQUE((int16_t) (I_REF_fil_DZ * 1000.0f)); //1300
                CAN_TX_TORQUE((int16_t) (cur.sen * 1000.0f)); //1300
                //CAN_TX_TORQUE((int16_t) (I_REF * 1000.0f)); //1300
            }


            if (flag_data_request[2] == HIGH) {
                //pressure A and B
                CAN_TX_PRES((int16_t) (pres_A.sen), (int16_t) (pres_B.sen)); // CUR_PRES_X : 0(0bar)~4096(210bar) //1400
            }

//            If it doesn't rest, below can can not work.
            for (can_rest = 0; can_rest < 10000; can_rest++) {
                ;
            }

            if (flag_data_request[3] == HIGH) {
                //PWM
                CAN_TX_PWM((int16_t) value); //1500
            }
            //for (i = 0; i < 10000; i++) {
//                ;
//            }
            if (flag_data_request[4] == HIGH) {
                //valve position
                CAN_TX_VALVE_POSITION((int16_t) (CAN_FREQ), (int16_t) (D_DAMPER), (int16_t) OPERATING_MODE); //1600
            }

            // Others : Reference position, Reference FT, PWM, Current  (ID:1300)
//        if (flag_data_request[1] == HIGH) {
//            CAN_TX_SOMETHING((int) (FORCE_VREF), (int16_t) (1), (int16_t) (2), (int16_t) (3));
//        }
            //if (flag_delay_test == 1){
            //CAN_TX_PRES((int16_t) (0),(int16_t) torq_ref);
            //}

            TMR2_COUNT_CAN_TX = 0;
        }
        TMR2_COUNT_CAN_TX++;

    }
    TIM3->SR = 0x0;  // reset the status register

}

void SystemClock_Config(void)
{
    RCC_OscInitTypeDef RCC_OscInitStruct = {0};
    RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

    /** Configure the main internal regulator output voltage
    */
    __HAL_RCC_PWR_CLK_ENABLE();
    __HAL_PWR_VOLTAGESCALING_CONFIG(PWR_REGULATOR_VOLTAGE_SCALE1);
    /** Initializes the CPU, AHB and APB busses clocks
    */
    RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI;
    RCC_OscInitStruct.HSIState = RCC_HSI_ON;
    RCC_OscInitStruct.HSICalibrationValue = RCC_HSICALIBRATION_DEFAULT;
    RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
    RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSI;
    RCC_OscInitStruct.PLL.PLLM = 8;  //8
    RCC_OscInitStruct.PLL.PLLN = 180;//180
    RCC_OscInitStruct.PLL.PLLP = RCC_PLLP_DIV2;
    RCC_OscInitStruct.PLL.PLLQ = 2;
    RCC_OscInitStruct.PLL.PLLR = 2;
    if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK) {
        //Error_Handler();
    }
    /** Activate the Over-Drive mode
    */
    if (HAL_PWREx_EnableOverDrive() != HAL_OK) {
        //Error_Handler();
    }
    /** Initializes the CPU, AHB and APB busses clocks
    */
    RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                                  |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
    RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
    RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
    RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV4;
    RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV2;

    if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_5) != HAL_OK) {
        //Error_Handler();
    }
    HAL_RCC_MCOConfig(RCC_MCO1, RCC_MCO1SOURCE_HSI, RCC_MCODIV_1);
    HAL_RCC_MCOConfig(RCC_MCO2, RCC_MCO2SOURCE_SYSCLK, RCC_MCODIV_2);
}