#include "mbed.h"
#include "SDFileSystem.h"
#include "LCD_DISCO_F746NG.h"
#include "TS_DISCO_F746NG.h"
#include <stdio.h>
#include <stdlib.h>
#include <string>

void drawImage(char * name, uint16_t x, uint16_t y);

LCD_DISCO_F746NG lcd;
DigitalOut myled(LED1);
SDFileSystem sd("sd");
TS_DISCO_F746NG ts;

int main() { 
  uint8_t TS_Status;

    lcd.SetBackColor(LCD_COLOR_BLACK);

    // In this example, the TS is initialized but not used.

    TS_Status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
    if (TS_Status != TS_OK) {
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
    } else {
        lcd.Clear(LCD_COLOR_BLACK);
        lcd.SetBackColor(LCD_COLOR_BLACK);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
    }

    wait(1);
    
    //Mounting SD-based filesystem
    sd.mount();              
    
    //Drawing BMP file from SD-card
    drawImage("/sd/interface.bmp", 0, 0);
}


void drawImage(char * name, uint16_t x, uint16_t y){
    int fileSize;
    char * buffer;
    FILE *Image = fopen(name, "rb");  // open the bmp file
  
    //obtain file size:
    fseek (Image , 0 , SEEK_END);
    fileSize = ftell (Image);
    rewind (Image);
    
    // allocate memory to contain the whole file:
    buffer = (char*) malloc (sizeof(char)*fileSize);
    
    // copy the file into the buffer:
    fseek (Image, 0 , SEEK_SET );  
    // set SD file data start position    
    fread (buffer,1,fileSize,Image);
    fclose (Image);

    //Draw image
    lcd.DrawBitmap(x,y,(uint8_t *)buffer);

    //Free allocated memory
    free (buffer);     
}