#include "BD_DISCO_F746NG.h"


BD_DISCO_F746NG::BD_DISCO_F746NG(bd_size_t block)
    : _read_size(block), _program_size(block), _erase_size(block)
    , _blocks(0)
{
    //MBED_ASSERT(_count * _erase_size == size);
}

BD_DISCO_F746NG::BD_DISCO_F746NG(bd_size_t read, bd_size_t program, bd_size_t erase)
    : _read_size(read), _program_size(program), _erase_size(erase)
    , _blocks(0)
{
    //MBED_ASSERT(_count * _erase_size == size);
    Timeout = 100;
}

BD_DISCO_F746NG::~BD_DISCO_F746NG()
{
    BSP_SD_DeInit();
    /*
    if (_blocks) {
        for (size_t i = 0; i < _count; i++) {
            free(_blocks[i]);
        }

        delete[] _blocks;
        _blocks = 0;
    }
    */
}

int BD_DISCO_F746NG::init()
{
    Timeout = 100;
    bool result;

    _SD_state = BSP_SD_Init();

    if(_SD_state != MSD_OK){
        if(_SD_state == MSD_ERROR_SD_NOT_PRESENT){
            return BD_ERROR_DEVICE_ERROR;
        } else {
            return BD_ERROR_DEVICE_ERROR;
        }
    } else {  
        BSP_SD_GetCardInfo(&_currentCardInfo);
        //_blocksize = _currentCardInfo.BlockSize;
        _blocksize = 512;
        return BD_ERROR_OK;
    }
/*
    if (!_blocks) {
        _blocks = new uint8_t*[_count];
        for (size_t i = 0; i < _count; i++) {
            _blocks[i] = 0;
        }
    }
*/
// return BD_ERROR_OK;
}

int BD_DISCO_F746NG::deinit()
{
    return BSP_SD_DeInit();
/*
    MBED_ASSERT(_blocks != NULL);
    // Memory is lazily cleaned up in destructor to allow
    // data to live across de/reinitialization
*/
//    return BD_ERROR_OK;
}

bd_size_t BD_DISCO_F746NG::get_read_size() const
{
    //MBED_ASSERT(_blocks != NULL);
    return _read_size;
}

bd_size_t BD_DISCO_F746NG::get_program_size() const
{
    //MBED_ASSERT(_blocks != NULL);
    return _program_size;
}

bd_size_t BD_DISCO_F746NG::get_erase_size() const
{
    //MBED_ASSERT(_blocks != NULL);
    return _erase_size;
}

bd_size_t BD_DISCO_F746NG::size() const
{
    //MBED_ASSERT(_blocks != NULL);
    //return (_currentCardInfo.BlockNbr*2) * _blocksize;
    return 128 * _blocksize;
}

int BD_DISCO_F746NG::read(void *b, bd_addr_t addr, bd_size_t size)
{
    int result;
    uint32_t nblocks = (uint32_t)size / _blocksize;
    result = BSP_SD_ReadBlocks((uint32_t *)b, (uint32_t)addr, nblocks, Timeout);
    return result;
}

int BD_DISCO_F746NG::program(const void *b, bd_addr_t addr, bd_size_t size)
{
    int result;
    uint32_t nblocks = (uint32_t)size / _blocksize;
    result = BSP_SD_WriteBlocks((uint32_t *)b, (uint32_t)addr, nblocks, Timeout);
    return result;
}

int BD_DISCO_F746NG::erase(bd_addr_t addr, bd_size_t size)
{
    int result;
    uint32_t StartAddr = addr;
    uint32_t EndAddr = StartAddr + size; 
    result = BSP_SD_Erase(StartAddr, EndAddr);

    return result;
}