#include "mbed.h"
#include "Si7005.h"

Si7005 rh(p28, p27);          // sda, scl
DigitalOut rh_cs_n(p26); // Chip select signal
Serial uart(USBTX, USBRX); // tx, rx

int main() {
    while(1) {
        // Enable RH sensor
        rh_cs_n = 0;
        // Let it startup!
        wait(0.05);
 
        char id;
        id = rh.readID();
        uart.printf("Sensor type: %02X\n", id);
 
        // Relative humidity measurement
        rh.startMeasurement(SI7005_RH);
        while (!rh.conversionDone()) {
            wait(0.01);
        }
        int measurement = rh.readResult(SI7005_RH);
        uart.printf("RH = %i procent\n", measurement);
 
        // Start temperature measurement
        rh.startMeasurement(SI7005_T);
        while (!rh.conversionDone()){
            wait (0.01);
        }
        measurement = rh.readResult(SI7005_T);
        uart.printf("Temp = %i degrees C\n", measurement);
 
        // Disable the sensor
        rh_cs_n = 1;
    }
}
