#ifndef _LOGGER_H_
#define _LOGGER_H_

/**
 * @addtogroup logger_lib
 * @{
 */

/**
 * Possible outputs of microcontroller
 * @todo include also output to LCD display and some other displays
 * \def L_SERIAL
 * @ingroup logger_lib
 * Output to Serial port
 * \def L_FILE
 * @ingroup logger_lib
 * Output to file
 * \def L_LED
 * Output to LED (morse code;))
 */
#define L_SERIAL    1
#define L_FILE      2
#define L_LED       3
#define L_BTSERIAL    4

/**
 * Error level indication
 * @def L_CRIT_ERROR
 * Critical error will append CE: to output
 * @def L_ERROR
 * Error will append E: to output
 * @def L_WARNING
 * Warning will append W: to output
 * @def L_DEBUG
 * Debug message will append D: to output
 * @def L_INFO
 * Information output will append I: to output
 */
#define L_CRIT_ERROR    1
#define L_ERROR         2
#define L_WARNING       3
#define L_DEBUG         4
#define L_INFO          5

extern Serial logSerial;
extern Serial BTSerial;

int32_t log_msg(uint8_t plc,uint8_t lvl, char *msg, uint32_t length);
int32_t log_init(uint8_t plc);
int32_t log_stash(uint8_t lvl, char *msg, uint32_t length, char *stash_buffer,size_t stash_buffer_len);
int32_t log_pop(uint8_t plc, char *stash_buffer,size_t stash_buffer_len);
///@}
#endif