#ifndef NAVIGATOR_H
#define NAVIGATOR_H

#include "mbed.h"
#include "Menu.h"
#include "TextLCD.h"

class Navigator {
    public:
        Navigator(Menu *root, TextLCD *lcd);

        void printMenu();
        
        void actionNone();
        void actionUp();
        void actionDown();
        void actionBack();
        void actionEnter();
        void actionHome();

    private:

        typedef enum {
            none, up, down, back, enter, home
        } Status;

        Menu *root;
        TextLCD *_lcd;

        /// the current menu can change when RPG is pushed on selection with child menu
        Menu *activeMenu;

        ///The last action
        Status _lastAction;
        ///which selection the cursor points to
        uint16_t cursorPos;
};

#endif
