#include "Navigator.h"

Navigator::Navigator(Menu *root, TextLCD *lcd) :
        root(root), activeMenu(root), _lcd(lcd) {
    cursorPos = 0;
    printMenu();
}

void Navigator::printMenu() {
    _lcd->cls();
    _lcd->printf("%s\n", activeMenu->menuID);
    _lcd->printf(">%s\n", activeMenu->selections[cursorPos].selText);
}

void Navigator::actionNone() {
    if (_lastAction != none) {

    }
    _lastAction = none;
}

void Navigator::actionUp() {
    if (_lastAction != up) {
        if (cursorPos > 0) {
            cursorPos--;
            printMenu();
        }
    }
    _lastAction = up;
}

void Navigator::actionDown() {
    if (_lastAction != down) {
        if (cursorPos < (activeMenu->selections.size() - 1)) {
            cursorPos++;
            printMenu();
        }
    }
    _lastAction = down;
}

void Navigator::actionBack() {
    if (_lastAction != back) {
        if (activeMenu->parent != NULL) {
            activeMenu = activeMenu->parent;
            cursorPos = 0;
            printMenu();
        }
    }
    _lastAction = back;
}

void Navigator::actionEnter() {
    if (_lastAction != enter) {
        if (activeMenu->selections[cursorPos].fun != NULL) {
            activeMenu->selections[cursorPos].fun->call();
            printMenu();
        }
        if (activeMenu->selections[cursorPos].childMenu != NULL) {
            activeMenu = activeMenu->selections[cursorPos].childMenu;
            cursorPos = 0;
            printMenu();
        }
    }
    _lastAction = enter;
}

void Navigator::actionHome() {
    if (_lastAction != home) {
        activeMenu = root;
        cursorPos = 0;
        printMenu();
    }
    _lastAction = home;
}
