#include "Joystick.h"

/** Create a Joystick HID for using regular mbed pins
 *
 * @param up    Joystick Up
 * @param down  Joystick Down
 * @param left  Joystick Left
 * @param right Joystick Right
 * @param press Joystick Press
 */
Joystick::Joystick(PinName up, PinName down, PinName left, PinName right, PinName press) :
        _up(up), _down(down), _left(left), _right(right), _press(press) {
    
}

void Joystick::functions(FunctionPointer *functionNone, FunctionPointer *functionUp, FunctionPointer *functionDown,
        FunctionPointer *functionLeft, FunctionPointer *functionRight, FunctionPointer *functionPress) {
    _functionNone = functionNone;
    _functionUp = functionUp;
    _functionDown = functionDown;
    _functionLeft = functionLeft;
    _functionRight = functionRight;
    _functionPress = functionPress;
}

/** Get status
 * Read the joystick status
 *
 * @returns Status of joystick
 */
Joystick::Status Joystick::getStatus() {
    if (!_up) {
        return up;
    }
    if (!_down) {
        return down;
    }
    if (!_left) {
        return left;
    }
    if (!_right) {
        return right;
    }
    if (!_press) {
        return press;
    }
    return none;
}

void Joystick::poll() {
    switch (getStatus()) {
        case none:
            _functionNone->call();
            break;
        case up:
            _functionUp->call();
            break;
        case down:
            _functionDown->call();
            break;
        case left:
            _functionLeft->call();
            break;
        case right:
            _functionRight->call();
            break;
        case press:
            _functionPress->call();
            break;
        default:
            break;
    }
}
