#ifndef DEPARTURE_H
#define DEPARTURE_H

#include <string>

/** Departure
*   Stores a single departure
*/
class Departure {
public:
    std::string crs;
    std::string locationName;
    std::string std;
    std::string etd;
    std::string platform;
    std::string operatorName;
    std::string operatorCode;
    
    /** Empty Departure constructor
    */
    Departure() {};
    /** Departure constructor
    * @param _crs Station code (in NR style)
    * @param _locationName Location of departure (i.e. where the train is going)
    * @param _std Scheduled time of departure (in 24-hour format, i.e. "14:03")
    * @param _etd Estimated time of departure (in 24-hour format, "On time", "Delayed" or "Cancelled")
    * @param _platform Intended platform
    * @param _operatorName The train operating company operating the service
    * @param _operatorCode The train operating companies' NR code
    */
    Departure(const std::string& _crs, const std::string& _locationName, const std::string& _std, const std::string& _etd, const std::string& _platform, const std::string& _operatorName, const std::string& _operatorCode);
    
    /** Determine if the departure is delayed
    *   @return a boolean stating if the departure is delayed
    */
    bool IsDelayed();
    /** Determine if a departure is cancelled
    *   @return a boolean stating if the departure is cancelled
    */
    bool IsCancelled();
    /** Determine if a departure is on time
    *   @return a boolean stating if the departure is on time
    */
    bool IsOnTime();
    /** Get the estimated time of departure
    *   @return a time string with the estimated time of departure (in format "HH:MM"), the phrase "Unknown" if it is not known, or the phrase "Cancelled" if it is cancelled
    */
    std::string GetETDFormatted();
};
#endif