#ifndef ARRIVAL_BOARD_H
#define ARRIVAL_BOARD_H

#include "MbedJSONValue.h"
#include "arrival.h"
#include <string>

/** Arrival_Board
*   Contains information pertaining to an arrival board; namely, a list of arrivals and a list of National Rail messages.
*/
class Arrival_Board
{
public:
    Arrival* arrivals;
    int num_arrivals;
    
    std::string* messages;
    int num_messages;
    
    /** Arrival_Board constructor
    * @param _arrivals pointer to a list of arrivals
    * @param _num_arrivals number of arrivals in that list
    * @param _messages pointer to a list of messages
    * @param _num_messages number of messages in that list
    */
    Arrival_Board(Arrival* _arrivals, const int& _num_arrivals, std::string* _messages, const int& _num_messages);
    /** Arrival_Board default constructor
    */
    Arrival_Board() {};
    
    /** Arrival_Board destructor
    */
    ~Arrival_Board();
};

/** Creates an Arrival_Board object from a JSON object string. Uses the MbedJSONValue library.
* @param jsonObject the JSON object to be parsed
* @return an Arrival_Board object containing the information from the JSON object string
*/
Arrival_Board arrBoardFromJson(const std::string& jsonObject);

#endif