#ifndef ARRIVAL_H
#define ARRIVAL_H

#include <string>

/** Arrival
*   Stores a single arrival
*/
class Arrival {
public:
    std::string crs;
    std::string locationName;
    std::string sta;
    std::string eta;
    std::string platform;
    std::string operatorName;
    std::string operatorCode;
    
    /** Empty Arrival constructor
    */
    Arrival() {};
    /** Arrival constructor
    * @param _crs Station code (in NR style)
    * @param _locationName Location of arrival (i.e. where the arrival comes from)
    * @param _sta Scheduled time of arrival (in 24-hour format, i.e. "14:03")
    * @param _eta Estimated time of arrival  (in 24-hour format, "On time", "Delayed" or "Cancelled")
    * @param _platform Intended platform
    * @param _operatorName The train operating company operating the service
    * @param _operatorCode The train operating companies' NR code
    */
    Arrival(const std::string& _crs, const std::string& _locationName, const std::string& _sta, const std::string& _eta, const std::string& _platform, const std::string& _operatorName, const std::string& _operatorCode);
    
    /** Determine if the arrival is delayed
    *   @return a boolean stating if the arrival is delayed
    */
    bool IsDelayed();
    /** Determine if a arrival is cancelled
    *   @return a boolean stating if the arrival is cancelled
    */
    bool IsCancelled();
    /** Determine if a arrival is on time
    *   @return a boolean stating if the arrival is on time
    */
    bool IsOnTime();
    /** Get the estimated time of arrival
    *   @return a time string with the estimated time of arrival (in format "HH:MM"), the phrase "Unknown" if it is not known, or the phrase "Cancelled" if it is cancelled
    */
    std::string GetETAFormatted();
};
#endif