#include "arrival.h"
#include "MbedJSONValue.h"
#include <string>

Arrival::Arrival(const std::string& _crs, const std::string& _locationName, const std::string& _sta, const std::string& _eta, const std::string& _platform, const std::string& _operatorName, const std::string& _operatorCode)
{
    crs = std::string(_crs);
    locationName = std::string(_locationName);
    sta = std::string(_sta);
    eta = std::string(_eta);
    platform = std::string(_platform);
    operatorName = std::string(_operatorName);
    operatorCode = std::string(_operatorCode);
}

std::string Arrival::GetETAFormatted()
{
    if(eta == "Delayed") return "Unknown";
    else if(eta == "On time") return sta;
    else return eta;
}    

bool Arrival::IsCancelled()
{
    if(eta == "Cancelled") return true;
    else return false;
}    

bool Arrival::IsOnTime()
{
    if(eta == "On time") return true;
    else return false;
}    