#ifndef DEPARTURE_BOARD_H
#define DEPARTURE_BOARD_H

#include "departure.h"
#include "MbedJSONValue.h"
#include <string>

/** Departure_Board
*   Contains information pertaining to an departure board; namely, a list of departures and a list of National Rail messages.
*/
class Departure_Board
{
public:
    Departure* departures;
    int num_departures;
    
    std::string* messages;
    int num_messages;
    
    /** Departure_Board constructor
    * @param _departures pointer to a list of departures
    * @param _num_departures number of departures in that list
    * @param _messages pointer to a list of messages
    * @param _num_messages number of messages in that list
    */
    Departure_Board(Departure* _departures, const int& _num_departures, std::string* _messages, const int& _num_messages);
    /** Departure_Board default constructor
    */
    Departure_Board() {};
    /** Departure_Board destructor
    */
    ~Departure_Board();
};

/** Creates a Departure_Board object from a JSON object string. Uses the MbedJSONValue library.
* @param jsonObject the JSON object to be parsed
* @return a Departure_Board object containing the information from the JSON object string
*/
Departure_Board depBoardFromJson(const std::string& jsonObject);

#endif