#include "departure.h"
#include <string>

Departure::Departure(const std::string& _crs, const std::string& _locationName, const std::string& _std, const std::string& _etd, const std::string& _platform, const std::string& _operatorName, const std::string& _operatorCode)
{
    crs = std::string(_crs);
    locationName = std::string(_locationName);
    std = std::string(_std);
    etd = std::string(_etd);
    platform = std::string(_platform);
    operatorName = std::string(_operatorName);
    operatorCode = std::string(_operatorCode);
};

bool Departure::IsDelayed()
{
    if(etd == "On time") return false;
    else if(etd == "Cancelled") return false;
    else return true;
}   

std::string Departure::GetETDFormatted()
{
    if(etd == "Delayed") return "Unknown";
    else if(etd == "On time") return std;
    else return etd;
}    

bool Departure::IsCancelled()
{
    if(etd == "Cancelled") return true;
    else return false;
}    

bool Departure::IsOnTime()
{
    if(etd == "On time") return true;
    else return false;
}    