#include "MbedJSONValue.h"
#include "arrival_board.h"

using std::string;

Arrival_Board::Arrival_Board(Arrival* _arrivals, const int& _num_arrivals, std::string* _messages, const int& _num_messages) 
{
    arrivals = _arrivals;
    num_arrivals = _num_arrivals;
    messages = _messages;
    num_messages = _num_messages;
}

Arrival_Board::~Arrival_Board() 
{
    delete arrivals;
    delete messages;
}    

Arrival_Board arrBoardFromJson(const string& jsonObject)
{
    Arrival_Board board;
    
    MbedJSONValue json (jsonObject);
    
    MbedJSONValue trainServices = json["trainServices"];
    MbedJSONValue messages = json["nrccMessages"];
    
    board.arrivals = new Arrival[trainServices.size()];
    board.num_arrivals = trainServices.size();
    
    board.messages = new string[messages.size()];
    board.num_messages = messages.size();
    
    for(int i = 0; i < trainServices.size(); ++i) {
        Arrival a;
        
        a.crs = trainServices[i]["origin"]["crs"].get<string>();
        a.locationName = trainServices[i]["origin"]["locationName"].get<string>();
        a.sta = trainServices[i]["sta"].get<string>();
        a.eta = trainServices[i]["eta"].get<string>();
        a.platform = trainServices[i]["platform"].get<string>();
        a.operatorName = trainServices[i]["operator"].get<string>();
        a.operatorCode = trainServices[i]["operatorCode"].get<string>();
        
        board.arrivals[i] = a;
    }
    
    for(int i = 0; i < messages.size(); ++i) {
        board.messages[i] = messages[i]["value"].get<string>();
    } 
    
    return board;   
}    