#include "MbedJSONValue.h"
#include "departure_board.h"


using std::string;

Departure_Board::Departure_Board(Departure* _departures, const int& _num_departures, std::string* _messages, const int& _num_messages)
{
    departures = _departures;
    num_departures = _num_departures;
    messages = _messages;
    num_messages = _num_messages;
}

Departure_Board::~Departure_Board() 
{
    delete departures;
    delete messages;
}    

Departure_Board depBoardFromJson(const string& jsonObject)
{
    Departure_Board board;
    
    MbedJSONValue json (jsonObject);
    
    MbedJSONValue trainServices = json["trainServices"];
    MbedJSONValue messages = json["nrccMessages"];
    
    board.departures = new Departure[trainServices.size()];
    board.num_departures = trainServices.size();
    
    board.messages = new string[messages.size()];
    board.num_messages = messages.size();
    
    for(int i = 0; i < trainServices.size(); ++i) {
        Departure d;
        
        d.crs = trainServices[i]["destination"]["crs"].get<string>();
        d.locationName = trainServices[i]["destination"]["locationName"].get<string>();
        d.std = trainServices[i]["std"].get<string>();
        d.etd = trainServices[i]["etd"].get<string>();
        d.platform = trainServices[i]["platform"].get<string>();
        d.operatorName = trainServices[i]["operator"].get<string>();
        d.operatorCode = trainServices[i]["operatorCode"].get<string>();
        
        board.departures[i] = d;
    }
    
    for(int i = 0; i < messages.size(); ++i) {
        board.messages[i] = messages[i]["value"].get<string>();
    } 
    
    return board;   
}    