#include "mbed.h"

Serial pc(USBTX,USBRX);

PwmOut ServoPWMpin(D8);
Ticker servoTick;
float i = 0;
char Key;
double ServoAngle = 89 ;
float Pulsew = 0.0015;
const float Frequency = 10;
double input_signal = 0;
double cali_min = 0;
double cali_max = 1;
double treshold = 0.5;
float treshold_multiplier = 0.5;
bool binary_input_signal = 0;
bool binary_input_signal_previous = 0;

void control_servo(){
    if (input_signal > treshold){                        // convert the emg to a zero or a one
        binary_input_signal = 1;
    } else {
        binary_input_signal = 0;
    }
    if(( binary_input_signal!= binary_input_signal_previous)&& binary_input_signal){
        if( ServoAngle < 45){                           // check wether it is more opened or closed
            ServoAngle = 89;                            // open 
        }
        else{
            ServoAngle = 1;                             // close 
        }
    }
    Pulsew = 0.0015+(ServoAngle)/180000;                // calculate the pulsewidth in the range 1 to 2 milliseconds
    ServoPWMpin.pulsewidth(Pulsew);                     // write the pulsewidth
    pc.printf("\n\r Pulsew is %f",Pulsew);
    
    binary_input_signal_previous = binary_input_signal;
}

int main(){
    pc.printf("\n\r ----------------------------------------\n\r --------------- START -----------------\n\r ----------------------------------------");
    treshold = (cali_max-cali_min)*treshold_multiplier;
    servoTick.attach(&control_servo, 1/Frequency);
    ServoPWMpin.period(0.01f);                          // 0.01 second period
    
    while (true) {        
        Key = pc.getc();                            // get the pressed key
        switch(Key) {                               //Check to see which key pressed
            case 0x2B:                              //It was the + key...
                pc.printf("\n\r +!");
                if( ServoAngle < 80){
                    ServoAngle = ServoAngle+10;     // increase the angle
                }
                break;
            case 0x2D:                              //It was the - Key key...
                pc.printf("\n\r -!");
                if( ServoAngle > 10){
                    ServoAngle = ServoAngle-10;     // decrease the angle
                }
                break;
            case 0x20:                              //It was the Spacebar key...
                pc.printf("\n\r SPACE!");
                if( ServoAngle < 45){               // Switch from open to closed or else otherwise
                    ServoAngle = 89;                // open/close 
                }
                else{
                    ServoAngle = 1;                 // open/close 
                }
                break;
            }
            input_signal = sin(i/10);
            i = i + 1;
            pc.printf("\n\r Switch klaar, i is %f.", i );
    }
}