#ifndef MATCHCOLORS_H
#define MATCHCOLORS_H

#ifndef COLOR_H
#define COLOR_H
#include "Color.h"
#endif

#include <iostream>
#include "GroveColourSensor.hpp"
#include "HL1606Stripe.h"
#include "ConfigFile.hpp"
#include "ColorManager.h"

class MatchColors
{

public :
    /*Constructeur*/
    MatchColors();
    
    /*Desctructeur*/
    ~MatchColors();
    
    /*Méthodes*/
    void InitGame();

private :
    /*Méthodes privées*/
    void Play();
    void ShowResult();

    /*Attributs*/
    uint8_t             m_nbleds;
    uint8_t             m_difficulty;
    GroveColourSensor*  m_colourSensor;
    HL1606Stripe*       m_stripe;
    uint8_t*            m_randomColors;
    ColorManager*       m_colormManager;
    bool                m_result;
    
    Timeout             m_timeoutInit;
    Timeout             m_timeoutPlay;
    Ticker              m_tickerResultat;
};

#endif
