#ifndef HL1606_STRIPE_H
#define HL1606_STRIPE_H

#ifndef COLOR_H
#define COLOR_H
#include "Color.h"
#endif

#include "mbed.h"
#include "Intensity.h"

class HL1606Stripe
{

public:
    /* Constructeur */
    HL1606Stripe(PinName mosi, PinName miso, PinName sclk, PinName latch, uint8_t numLEDs, uint8_t m_numColors);
    
    /* Destructeur */
    ~HL1606Stripe();

    /* Méthodes */
    void Update(void);
    void SwitchOffRGB(void);
    void FillRGB(uint8_t color);
    void FillRGB(uint8_t* colors);
    void FillRGB(uint8_t red, uint8_t green, uint8_t blue);
    void FillRandomlyRGB(uint8_t* randomColors);
    
    void setLED(uint8_t Color, uint8_t LEDx);

private:
    /*Attributs*/
    uint8_t* m_redPWM;
    uint8_t* m_greenPWM;
    uint8_t* m_bluePWM;
    
    uint8_t  m_numLEDs;
    uint8_t m_numColors;

    SPI m_SPI;
    DigitalOut m_latchPin;
    Ticker m_tickerUpdate;

};

#endif
