#include "ColorManager.h"

// Méthode permettant d'obtenir des valeurs de HSV avec des valeurs de RGB. Il faut donner en paramètre des structures RGB et HSV, par référence.
void ColorManager::RGBtoHSV(RGB &rgb, HSV &hsv)
{
    double min, max, delta;

    min = rgb.red < rgb.green ? rgb.red : rgb.green;
    min = min < rgb.blue ? min : rgb.blue;
    
    max = rgb.red > rgb.green ? rgb.red : rgb.green;
    max = max > rgb.blue ? max : rgb.blue;

    hsv.value = max;
    delta = max - min;

    if (delta < 0.00001)
    {
        hsv.saturation = 0;
        hsv.hue = 0;
        return;
    }
    if( max > 0.0 ) { 
        hsv.saturation = (delta/max);
    } else {
        hsv.saturation = 0.0;
        hsv.hue = NAN;
        return;
    }
    if(rgb.red >= max)
        hsv.hue = (rgb.green-rgb.blue)/delta;
    else
    if(rgb.green >= max)
        hsv.hue = 2.0 + (rgb.blue - rgb.red)/delta;
    else
        hsv.hue = 4.0 + (rgb.red - rgb.green ) / delta;
        
    hsv.hue *= 60.0;
    
    if(hsv.hue < 0.0)
        hsv.hue += 360.0;
}

// Méthode permettant d'obtenir des valeurs de RGB avec des valeurs de HSV. Il faut donner en paramètre des structures RGB et HSV, par référence.
void ColorManager::HSVtoRGB(RGB &rgb, HSV &hsv)
{
    double hh, p, q, t, ff;
    long i;

    if(hsv.saturation <= 0.0) {       // < is bogus, just shuts up warnings
        rgb.red = hsv.value;
        rgb.green = hsv.value;
        rgb.blue = hsv.value;;
        return;
    }
    hh = hsv.hue;
    if(hh >= 360.0) 
        hh = 0.0;
    hh /= 60.0;
    i = (long)hh;
    ff = hh - i;
    p = hsv.value * (1.0 - hsv.saturation);
    q = hsv.value * (1.0 - (hsv.saturation * ff));
    t = hsv.value * (1.0 - (hsv.saturation * (1.0 - ff)));

    switch(i) {
    case 0:
        rgb.red = hsv.value;
        rgb.green = t;
        rgb.blue = p;
        break;
    case 1:
        rgb.red = q;
        rgb.green = hsv.value;
        rgb.blue = p;
        break;
    case 2:
        rgb.red = p;
        rgb.green = hsv.value;
        rgb.blue = t;
        break;

    case 3:
        rgb.red = p;
        rgb.green = q;
        rgb.blue = hsv.value;
        break;
    case 4:
        rgb.red = t;
        rgb.green = p;
        rgb.blue = hsv.value;
        break;
    case 5:
    default:
        rgb.red = hsv.value;
        rgb.green = p;
        rgb.blue = q;
        break;
    }
}

// Métode qui retourne une couleur (de type Colour_t) en fonction d'une valeur de teinte passée en paramètre
Colour_t ColorManager::getColorFromHue(double hue)
{
    if(hue>=50 && hue < 100)
        return YELLOW;
    else if(hue >= 100 && hue < 135)
        return GREEN;
    else if(hue >= 135 && hue < 165)
        return CYAN;
    else if(hue >= 165 && hue < 270)
        return BLUE;
    else if( (hue >=270 && hue <360) || (hue >=0 && hue <50) )
        return RED;
    else
        return NA;
}
