#ifndef CONFIGURATION_FILE_H
#define CONFIGURATION_FILE_H

#include "mbed.h"
#include "rpc.h"
#include <fstream>
#include <iostream>

struct configSPI {
    PinName mosi;
    PinName miso;
    PinName sck;
};

struct configI2C {
    PinName sda;
    PinName scl;
};

class ConfigFile
{
    public:
    /*Constructeur*/
    ConfigFile(const char* fileName, uint8_t &level, uint8_t &numLeds, configSPI &spi, configI2C &i2c, PinName &latchPin) {
        int l, n;
        char configPins[6][3];

        /*Utiliser le système de fichier local*/
        LocalFileSystem local("local");

        /*Ouvrir le fichier de configuration*/
        FILE* ConfigFile = fopen(fileName, "r");

        if(ConfigFile) {

            /*Lire les données de configuration*/
            fscanf(ConfigFile,
                   "Difficulte = %d\nNombre de LEDs = %d\n\nMOSI pin = %s\nMISO pin = %s\nSCK pin = %s\nLatch pin = %s\n\nSDA pin = %s\nSCL pin = %s",
                   &l, &n, configPins[0], configPins[1], configPins[2], configPins[3], configPins[4], configPins[5]);

            /*Niveau du jeu*/
            level = (uint8_t) l;

            /*Nombre de LEDs sur le bandeau*/
            numLeds = (uint8_t) n;

            /*SPI*/
            spi.mosi = parse_pins(configPins[0]);
            spi.miso = parse_pins(configPins[1]);
            spi.sck = parse_pins(configPins[2]);

            /*Latch pin*/
            latchPin = parse_pins(configPins[3]);

            /*I2C*/
            i2c.sda = parse_pins(configPins[4]);
            i2c.scl = parse_pins(configPins[5]);

            /*Fermer le fichier de configuration*/
            fclose(ConfigFile);

        } else {
            std::cerr << "Erreur lors de l'ouverture du fichier de configuration !" << std::endl;
        }
    }
};
#endif
