//SGP30 Air Quality sensor
//Laurence Wilkins CU Coventry University

#include "mbed.h"
#include "C12832.h"

C12832 lcd(p5, p7, p6, p8, p11);                    // set up instance of LCd screen
I2C i2c(p28, p27);                                  //I2c built into mbed.h, define standard pins (data, clock)
DigitalOut CO2Alarm (LED1);
DigitalOut VOCAlarm (LED2);

const int SGP30I2CAddress8 = 0x58 << 1;             // 8-bit I2C address=0x58, shifted left (0xA2)


int main()
{
    char cmd[2];                                    //two byte array for 16 bit address/command
    char data[6];                                   // six byte array for data
    lcd.cls();                                      //clear LCD screen

    cmd[0] = 0x20;                                  //address 0X0203 initialises sensor
    cmd[1] = 0x03;
    wait_ms(1);                                     //give SGP30 time to stabilise after power up
    i2c.write(SGP30I2CAddress8, cmd, 2);            //2=two bytes of data
    lcd.printf("Initiailising...");

    while(1) {
        wait(1.0f);                                 //wait 1 second between reads
        lcd.locate(0,0);                            //LCD cursor to top left
        cmd[0] = 0x20;
        cmd[1] = 0x08;                              //command 0X0208 reads six bits of air quality
        if(i2c.write(SGP30I2CAddress8, cmd, 2)==false) {// check if I2C data was returned
            wait_ms(15);                                // MUST awiat 15mS after read request before read
            i2c.read(SGP30I2CAddress8, data, 6);        //read six bytes from sensor into  data array
            int CO2 = ((data[0]*256) + data[1]);        //first two bits are CO2. Ignore checksums
            int VOC = ((data[3]*256) + data[4]);        //bits 3 & 4 are VOC. Ignore checksums

            if (CO2>1000) {                             //check if thresholds reached, sound alarm
                CO2Alarm=true;
            } else {
                CO2Alarm=false;
            }
            if (VOC>500) {
                VOCAlarm=true;
            } else {
                VOCAlarm=false;
            }

            lcd.printf("SGP30 Gas Sensor    ");        //pretty heading
            lcd.locate(0,10);
            lcd.printf("CO2:%d ppm VOC:%d ppb   ",CO2,VOC);
            lcd.locate(0,20);
            lcd.printf("Data: %02hhX %02hhX %02hhX %02hhX %02hhX %02hhX", data[0], data[1], data[2], data[3], data[4], data[5]);
            //line above is for debugging only; it displays the six bytes read from sensor
        } else {                                        //if no I2C response
            lcd.cls();
            lcd.printf("Sensor offline - check connection.");
        }
    }
}
