/***************************************************************************************/
/*****************        Facharbeit Jannick Pötzel 23.12.2011    **********************/
/*****************         SRF08 Ultrasonic Range Finder          **********************/
/***************************************************************************************/

#include "mbed.h"
#include "TextLCD.h"


// allocation of variables
TextLCD lcd(p24, p25, p26, p27, p28, p29, p30);

DigitalOut mled0(LED1);
DigitalOut mled1(LED2);
DigitalOut mled2(LED3);
DigitalOut mled3(LED4);

I2C sonar(p9, p10);                         // Define SDA, SCL pins
Serial pc(USBTX, USBRX);                    // Define Tx, Rx for PC
const int addr = 0xE0;                      // I2C device address for SRF08
char cmd[2];
char echo[2];

// start amin programm
int main() {

// Set up SRF08 max range and receiver sensitivity over I2C bus
    cmd[0] = 0x02;                          // Range register
    cmd[1] = 0x1C;                          // Set max range about 100cm
    sonar.write(addr, cmd, 2);
    cmd[0] = 0x01;                          // Receiver gain register
    cmd[1] = 0x1B;                          // Set receiver gain
    sonar.write(addr, cmd, 2);

while(1)
{

// Get range data from SRF08
// Send Tx burst command over I2C bus
        cmd[0] = 0x00;                      // Command register
        cmd[1] = 0x51;                      // Ranging results in cm
        sonar.write(addr, cmd, 2);          // Send ranging burst

        wait(0.07);                         // Wait for return echo

// Read back range over I2C bus
        cmd[0] = 0x02;                      // Address of first echo
        sonar.write(addr, cmd, 1, 1);       // Send address of first echo       
        sonar.read(addr, echo, 2);          // read two-byte echo result
       
// calculate distance            
      int x = (echo[0]<<8)+echo[1];

// clear LCD       
      lcd.cls();
// if distance bigger than 99 cm write out of R to LCD
      if (x > 99)
      {
      lcd.writeData(' ');
      lcd.writeData('o');
      lcd.writeData('u');
      lcd.writeData('t');
      lcd.writeData(' ');
      lcd.writeData('o');
      lcd.writeData('f');
      lcd.writeData(' ');
      lcd.writeData('R');
      }
// write distance to LCD
      else
      {
      int x1=0x30+x%10;
      int x2=x/10;
      x2=0x30+x2%10;
      lcd.writeData(' ');
      lcd.writeData(x2);
      lcd.writeData(x1);
      lcd.writeData(' ');
      lcd.writeData('c');
      lcd.writeData('m');
      }

// Power in LEDs in dependence of measured distance
      
        if (x <= 40)
        {
            mled0 = 1;
            mled1 = 0;
            mled2 = 0;
            mled3 = 0; 
        }
       if (x <= 30)
        {
           mled0 = 1;
           mled1 = 1;
           mled2 = 0;
           mled3 = 0;
        }
       if (x <= 20)
        {
          mled0 = 1;
          mled1 = 1;
          mled2 = 1;
          mled3 = 0;
        }
       if (x <= 10)
        {
          mled0 = 1;
          mled1 = 1;
          mled2 = 1;
          mled3 = 1;
        }
       else if (x > 40)
        {
          mled0 = 0;
          mled1 = 0;
          mled2 = 0;
          mled3 = 0;
        }
  }       
}
