#include "mbed.h"

DigitalOut myled0(LED0); 
DigitalOut myled1(LED1);
InterruptIn pb0(SW0);
InterruptIn pb1(SW1);

LowPowerTicker toggleTicker;

float new_freq = 0.2f;
bool  ledblink = true;


// Callback for toggler
void ledToggler(void) {
    myled0 = !myled0 * ledblink;
    myled1 = !myled1 * (1-ledblink);
}

// Callback for pushbutton interrupt
void pb0_handler() {
    ledblink = !ledblink;
}

void pb1_handler() {
    if (ledblink) {
        new_freq = new_freq/2;
    }
    else {
        new_freq = new_freq*2;
    }    
}
 
int main() {
    float freq = 0.0f;
    //Enable the PB-handler
    pb0.rise(NULL);
    pb0.fall(&pb0_handler);
    
    pb1.rise(NULL);
    pb1.fall(&pb1_handler);
    
    while(1) {
        if (freq != new_freq) {
            toggleTicker.detach();
            toggleTicker.attach(&ledToggler, new_freq);
            freq = new_freq;
        }
        sleep();
    }
}