#include "mbed.h"
#include "QEI.h"

PwmOut turret_speed(p21);
DigitalOut turret_direction(p22);

QEI myEncoder (p16,p15, NC, 1600); 
Timer t;

int main()
{
float input_dc =50.0; 
int user_direction = 0;
float duty_cycle ; 
int pulses = 0; 
float theta[500] ;  
float time[500];
float Kp = 0.2;  
int counter = 1; 
int k; 

float theta_ref = 3.14/4.0; 

while(1)
    {
    printf("Enter duty cycle, 0 to 100:\n"); 
    scanf("%f", &input_dc); 
    
    duty_cycle = input_dc/100.0;  
    
    printf("\n %f duty cycle set. Enter 1 for CCW or 0 for CW spin direction:\n",duty_cycle); 
    scanf("%d", &user_direction); 
    
    t.start();
    turret_speed = duty_cycle; 
    turret_direction = user_direction; 
    
    while (t.read()<5.05)
    {
        wait(0.01); 
        pulses = myEncoder.getPulses(); 
        theta[counter] = ((float)pulses/ (1600.0*2.0))*-2.0*3.14;
        time[counter] = t.read(); 
        printf("Time(%d)= %f       Angle(%d) = %f \n", counter+1,time[counter],counter+1, theta[counter]);
        counter= counter + 1; 
    }
    t.stop();
    for(k=0; k<counter; k++) 
        {
            printf("time(%d,1) = %.5f;\n",k+1,time[k]);
            printf("theta(%d,1) = %.5f;\n",k+1,theta[k]);  
                  
        }    
    }
}