#include"mbed.h"
#include"TextLCD.h"
#include"WakeUp.h"
#include"mBuinoSleep.h"
//AnalogIn sm1(p16);
//AnalogIn sm2(p17);
//AnalogIn sm3(p18);
//AnalogIn sm4(p19);

DigitalOut myled(LED1);
DigitalOut ac(p20);
Serial GPRS(p9,p10);
Serial pc(USBTX,USBRX);
TextLCD lcd(p26, p25, p24, p23, p22, p21); //rs,e,d0-d3
LocalFileSystem local("local");

char   a=0x1A,c=0x0D;
char num[]="7411755981";
float s[5],m[5];
float ma;

int b=100,count,fb;
char col1[]="ITERATION",col2[]="SM1",col3[]="SM2",col4[]="SM3",col5[]="SM4",col6[]="Mean",col7[]="Configuring for data services",col8[]="Uploading Sensor values to the Internet ",col9[]="Feedback from Internet",col10[]="Required action",col11[]="Sending SMS",col12[]="Excel Shet File Updated";
char *char1;
float d;
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
void sleepwait(int q)
{        int x;
         x=q*1000;
         myled=1;
         WakeUp::calibrate();
         WakeUp::set_ms(x);
         mBuinoSleep(Sleep);
    }
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void SensorRead()
{        lcd.cls();
         lcd.locate(0,0);
         lcd.printf("Sensor Readings\r");
         s[1]=0.31;
         m[1]=(0.057*(s[1]*1024))+25.072;
         lcd.cls();
         lcd.printf("Raw SM1=%0.3f",s[1]); 
         sleepwait(1);
         s[2]=0.25;
         m[2]=(0.057*(s[2]*1024))+25.072;
         lcd.cls();
         lcd.printf("Raw SM2=%0.3f",s[2]); 
         sleepwait(1);
          s[3]=0.33;
         m[3]=(0.057*(s[3]*1024))+25.072;
         lcd.cls();
         lcd.printf("Raw SM3=%0.3f",s[3]); 
         sleepwait(1);
         s[4]=0.25;
         m[4]=(0.057*(s[4]*1024))+25.072;
         lcd.cls();
         lcd.printf("Raw SM4=%0.3f",s[4]); 
         sleepwait(1); 
         ma=(m[1]+m[2]+m[3]+m[4])/4;
         lcd.cls();
         lcd.locate(0,0);
         lcd.printf("Mean =%0.3f",ma);
         sleepwait(2);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
void ac_control()
{ 
   if(char1[0]=='0' ||char1[0]=='2'||char1[0]=='4'||char1[0]=='6'||char1[0]=='8')
  { lcd.cls();
   lcd.printf("Bulb ON");
   ac=1;
   }
   else
  { lcd.cls();
   lcd.printf("Bulb OFF");
   ac=0;
}
}
    
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void xlfile()
{       
        //Local storage (On board flash memory of 2MB)
        count++;
        FILE *fp=fopen("/local/KAEMS.csv","a");
        fprintf(fp,"%d,%0.3f,%0.3f,%0.3f,%0.3f,%0.3f,%s,%s,%c,%s,%s,%s\n",count,m[1],m[2],m[3],m[4],ma,col7,col8,char1[0],col10,col11,col12);
        fclose(fp);
        lcd.cls();
        lcd.printf("File updated");
        sleepwait(1);
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void flushSerialBuffer(void) 
{ char char2=0;
 while (GPRS.readable()) 
 {  char2=GPRS.getc();
  } return; 
 }
 
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void data_tx_rx()
{
        //GPRS commands
        WakeUp::calibrate();
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("   Updating\n www.kaems.org");
        sleepwait(3);
        
        GPRS.printf("AT+SAPBR=0,1\r\n");
        sleepwait(3);
        
        GPRS.printf("AT+SAPBR=3,1,\"CONTYPE\",\"GPRS\"\r\n");
       sleepwait(3);
        
        GPRS.printf("AT+SAPBR=3,1,\"APN\",\"AIRCELGPRS.COM\"\r\n");
        sleepwait(3);
        
        GPRS.printf("AT+SAPBR=1,1\r\n");
        sleepwait(3);
        
        GPRS.printf("AT+HTTPINIT\r\n");
        sleepwait(2);
        
        GPRS.printf("AT+HTTPPARA=\"CID\",1\r\n");
        sleepwait(2);
        
        GPRS.printf("AT+HTTPPARA=\"URL\",\"http://kaems.org/update.php?u=3&t=23&h=34&s1=%f&s2=%f&s3=%f&s4=%f&ph=5&b=%d\"\r\n",m[1],m[2],m[3],m[4],b--);
        sleepwait(2);
        
        GPRS.printf("AT+HTTPDATA=1000,5000\r\n");
        sleepwait(8);
        
        GPRS.printf("AT+HTTPACTION=1\r\n");
        sleepwait(5);
        
        GPRS.printf("AT+HTTPPARA=\"CID\",1\r\n");
        sleepwait(2);
        
        GPRS.printf("AT+HTTPPARA=\"URL\",\"http://kaems.org/feedback.php\"\r\n");
        sleepwait(2);
        
        GPRS.printf("AT+HTTPACTION=0\r\n");
        sleepwait(5);
        
        flushSerialBuffer();
        GPRS.printf("AT+HTTPREAD\r\n"); 
        while(!GPRS.readable())
        {    }
        GPRS.scanf("%s",char1);
        GPRS.scanf("%s",char1);
        GPRS.scanf("%s",char1);

        pc.printf("Str=%c\r\n",char1[0]);
        GPRS.printf("AT+HTTPTERM\r\n");
        
        
        lcd.cls();
        lcd.printf("KAEMS UPDATED");
        
        lcd.cls();
        lcd.printf("Fbk=%c",char1[0]);
        sleepwait(2);
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/*void feedback()
{       lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Waiting for feedback");
        wait(3);
        GPRS.printf("AT+SAPBR=0,1\r\n");
        wait(3);
        GPRS.printf("AT+SAPBR=3,1,\"CONTYPE\",\"GPRS\"\r\n");
        wait(3);
        GPRS.printf("AT+SAPBR=3,1,\"APN\",\"AIRCELGPRS.COM\"\r\n");
        wait(3);
        GPRS.printf("AT+SAPBR=1,1\r\n");
        wait(3);
        GPRS.printf("AT+HTTPINIT\r\n");
        wait(2);
        GPRS.printf("AT+HTTPPARA=\"CID\",1\r\n");
        wait(2);
       
//     switch(str2[0]){
//            case '1': break;
//            
//        }
        wait(5);
        GPRS.printf("AT+HTTPTERM\r\n");
        }  */
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void sms()
{   
    GPRS.printf("AT\r\n");
    sleepwait(2);
    
    GPRS.printf("AT+CMGF=1\r\n");
    sleepwait(2);
    
    GPRS.printf("AT+CMGS=\"%s\"\r\n",num);
    sleepwait(3);
  
        if(ma<40)
        {
            GPRS.printf(" Water level is low \nMoisture level =  %f \r\n",ma);
            sleepwait(1);
            
            GPRS.printf("%c",a);
            sleepwait(2);
        }
        
        if(ma>40)
        {
            GPRS.printf(" Land has sufficient amount of water \n Moisture level = %f \r\n",ma);
            sleepwait(1);
            
            GPRS.printf("%c",a);
            sleepwait(2);
        }   
        lcd.cls(); 
        lcd.printf("SMS Sent");
       sleepwait(2);
       }
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
int main() 
{        
         lcd.cls();
         lcd.printf("   PRECISION\n  AGRICULTURE");
         GPRS.baud(9600);
         GPRS.printf("AT\n");
         sleepwait(3);
         FILE *fp=fopen("/local/KAEMS.csv","a");
         fprintf(fp,"%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s\n",col1,col2,col3,col4,col5,col6,col7,col8,col9,col10,col11,col12);
         fclose(fp);
         
    while(1) 
    {
         SensorRead();
         //sms();
         data_tx_rx(); 
         ac_control();
         xlfile();
         lcd.cls();
         lcd.printf("   PRECISION\n  AGRICULTURE");
         sleepwait(2);
    }
}
