#include "mbed.h"
#include <Pulse1.h>
#include "TextLCD.h"
#include "stdio.h" 
#include "math.h" 

//===============================================================================CONTROL REMOTO SONY

PulseInOut irda(PTD4);                             //puerto para sensor infrarrojo
Serial pc(USBTX, USBRX);                           //Para Termite
DigitalOut led(LED1); DigitalOut led2(LED2);       // Leds
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // LCD
AnalogIn  y(PTB3);                                 //entrada analoga
AnalogOut u(PTE30);                                //salida analoga OJO solo se le pueden drenar 1.5mA en circuitos use un Buffer 
                                                   //si se ignora se daña la FRDMKL25Z
int header =0;                                   //tiempo de Bit de Inicio (4T)
int head_H = 2900;                         //20% tiempo de Bit de Inicio
int head_L= 1900;
int T_alto=1200;                           //Tiempo maximo de un bit 1
int T_bajo=600;                            //Tiempo maximo de un bit 0
int num_bits = 12;                         //Número de bits
int times[12];                       //almacenador de tiempos de bits

int dato=0;                                      //Tiempo del Bit actual
int bin[12];                                     //Cadena de Bits                 
//int Serie[20];                                   //Serie 2^n
int numero=0;                                    //Numero Decimal del botón
int boton=0;                                     //boton que se undió

int  Sp=0, Kp=0, Ki=0, Kd=0, pos=1 , i=0 , j=0 , k=0, valPar=0 ;     //Variables
float pid,ai,ad,ap,med,err,err_v;
//const int base[]={1,10,100};
int  C1=0x0F; int C4=0x0C;                           // cursor y cursor bajo
int binM[20];


//=============================================================================== Prototipo de Funciones 
void  PID  (int Sp,  int Kp,  int   Ki, int Kd);
void  LCD1 (int col, int fil, int   val  )     ;
void  LCD2 (int col, int fil, float val  )     ;


//================================================================================ Main - Configuración de Parámetros
  int main(){
     lcd.locate(0,1);  lcd.printf("**PID Control**");
     wait(2); lcd.cls(); lcd.writeCommand(C1);
    
     lcd.locate(0,0);    lcd.printf("Sp=%d",Sp);
     lcd.locate(8,0);    lcd.printf("Kp=%d",Kp);
     lcd.locate(0,1);    lcd.printf("Ki=%d",Ki);
     lcd.locate(8,1);    lcd.printf("Kd=%d",Kd);

    while(1){
      ini1: fflush( stdin );
         header=0;
         led2=0;       led=1;
      header = irda.read_low_us();    //funcion para leer un pulso de caida o bajo en header
      if (header > head_L && header < head_H) goto seguir;//verificar que este en la tolerancia +-20%
      else goto ini1;
      
seguir:
       //leo los datos de la trama y se meten a un arreglo
      wait_us(400);// ES EL TIEMPO DE HEADER QUE NO SE Lee O EL ALTO 
      led2=1;
      for(i=0;i<(num_bits-1);++i){ // POR OSCILOSCOPIO se determina que llegan (num_bits),datos
      dato = irda.read_low_us(); //leer un bit de datos que es pulso arriba en este control
      times[i]=dato;
      wait_us(400);        }
      
      wait(0.5); //espero un poquito luego de leer todo el arreglo y ponerlo en pantalla 
      
      pc.printf("heder= ,%d\n",header);
      
      for(i=0;i<(num_bits-1);++i){pc.printf("%d,",times[i]); }
      
      wait(0.1);         pc.printf("\n");
  
      for(i=0;i<(num_bits-1);++i){  
       
       if(times[i] > ((T_alto+T_bajo)/2)){ bin[i]=1;      }
       else{                             bin[i]=0;      }
       
            pc.printf("%d ",bin[i]);      }   
        
         pc.printf("\n");
      
      
     binM[0]=1;
     for(i=1;i<(num_bits-1);++i){   binM[i]=binM[i-1]*2; }
     
     numero=0;   
     for(i=0;i<(num_bits-1);++i){     numero=numero+(binM[i]*bin[i]);}
      
      
      pc.printf("numero=%d\n",numero);
     
     if (numero==128){ boton=1 ;} else if (numero==129){ boton=2 ;}                    //boton 1 a 0 normales
else if (numero==130){ boton=3 ;} else if (numero==131){ boton=4 ;}                    //boton 11 subir,    chan+
else if (numero==132){ boton=5 ;} else if (numero==133){ boton=6 ;}                    //boton 12 bajar,    chan-
else if (numero==134){ boton=7 ;} else if (numero==135){ boton=8 ;}                    //boton 13 derecha,  vol+
else if (numero==136){ boton=9 ;} else if (numero==137){ boton=0 ;}                    //boton 14 derecha,  vol+
else if (numero==144){ boton=11;} else if (numero==145){ boton=12;}                    //boton 15 ir a PID, MUTE
else if (numero==146){ boton=13;} else if (numero==147){ boton=14;}
else if (numero==148){ boton=15;}    else               { boton=16;}
    
     //pc.printf("boton= %d\n",boton);
    wait(0.2);
 //=================================================================USAR FLECHAS    
 
 switch  (boton)  {                       //Toca bajar al Parámetro //Llegó chan-
   case 11:                           
          if (pos==1) {                  
              if (Sp!=999){ Sp++;  LCD1(3,0,Sp) ; pc.printf("Sp=%d",Sp);}}
          if (pos==2) {
              if (Kp!=999){ Kp++;  LCD1(11,0,Kp);pc.printf("Kp=%d",Kp);}}  
          if (pos==3) {
              if (Ki!=999){ Ki++;  LCD1(3,1,Ki)  ;pc.printf("Ki=%d",Ki);}}
          if (pos==4 ){
              if (Kd!=999){ Kd++;  LCD1(3,11,Kd);pc.printf("Kd=%d",Kd);}}
                                                        break;
   
   case 12:                              //Toca bajar al Parámetro //Llegó chan-
          
          if( pos==1 ){               
              if (Sp!=0) { Sp--;  LCD1(3,0,Sp) ; pc.printf("Sp=%d",Sp);}}
          if (pos==2) {
              if (Kp!=0) { Kp--;  LCD1(11,0,Kp); pc.printf("Kp=%d",Kp);}}   
          if (pos==3) {
              if (Ki!=0) { Ki--;  LCD1(3,1,Ki) ; pc.printf("Ki=%d",Ki);}}
          if (pos==4) {
              if (Kd!=0) { Kd--;  LCD1(3,11,Kd); pc.printf("Kd=%d",Kd);}}
                                                        break;

   case 13:                                   //Mover hacia derecha, llegó vol+
      j=0; valPar=0;     
               if(pos==4){  pos=1; LCD1(3,0,Sp)  ; pc.printf("Sp=%d",Sp);}
          else if(pos==1){  pos++; LCD1(11,0,Kp) ;pc.printf("Kp=%d",Kp); }     
          else if(pos==2){  pos++; LCD1(3,1,Ki)  ;pc.printf("Ki=%d",Ki); }  
          else if(pos==3){  pos++; LCD1(11,1,Kd) ; pc.printf("Kd=%d",Kd); }
                                                       break;
   
   case 14:                                   //Mover hacia derecha, llegó vol-
      j=0; valPar=0; 
               if(pos==1){  pos=4; LCD1(11,1,Kd) ; pc.printf("Sp=%d",Sp);}
          else if(pos==4){  pos--; LCD1(3,1, Ki) ; pc.printf("Kp=%d",Kp);}
          else if(pos==3){  pos--; LCD1(11,0,Kp) ; pc.printf("Ki=%d",Ki);}
          else if(pos==2){  pos--; LCD1(3,0, Sp) ; pc.printf("Kd=%d",Kd);}
                                                      break;
 
   case 15:                                  //ir al PID, llegó Mute          
          PID(Sp,Kp,Ki,Kd) ;                  break;
   default:  {};     }                        // cierra Switch
         
         
//=======================================================================Botones
 if ((boton==0)||(boton==1)||(boton==2)||(boton==3)||(boton==4)||(boton==5)||(boton==6)||(boton==7)||(boton==8)||(boton==9)){
    if(j<3){  
       valPar = 10*valPar + boton; 
       j++;
    
      if(pos==1){ Sp=valPar; LCD1(3,0, Sp) ; }
 else if(pos==2){ Kp=valPar; LCD1(11,0,Kp) ; }
 else if(pos==3){ Ki=valPar; LCD1(3,1, Ki) ; }
 else if(pos==4){ Kd=valPar; LCD1(11,1, Kd) ; }   
      }}
    
    } // cierra while 
}     // cierran Main               

  
//=================================================================================CICLO PID INFINITO
void  PID (int Sp, int Kp, int Ki, int Kd) {
                                            //======================================= Parches del control  
    lcd.writeCommand(C4);                                     //quita cursor bajo
    lcd.cls();   lcd.printf("   GUARDADOS!") ; wait(1);       //borra la pantalla
    lcd.cls();   lcd.printf(" INICIA EL PID"); wait(1);
    lcd.cls();

    lcd.printf("Er=%3.0f",err);    
    lcd.locate(8,0);   lcd.printf("Me=%3.0f",med); 
    lcd.locate(0,1);   lcd.printf("Sp=%3.0f",Sp);     
    lcd.locate(8,1);   lcd.printf("Co=%3.0f",pid);
    wait(1);

while(1){      //=============================================================== CICLO PRINCIPAL CONTROLADOR PID
        med = y.read()*999  ;
        err = Sp-med        ;                         //se calcula el error
        ap  = Kp*err*0.01f  ;                        //se calcula la accion proporcinal
        ai  = (Ki*err*0.01f)+ai    ;                //calculo de la integral del error
        ad  = Kd*(err-err_v)*0.01f ;                //calculo de la accion derivativa
        pid = ap+ai+ad             ;                             
        
        if(pid<=0)   {pid=0  ;}                      // se verifica que pid sea positivo
        if(pid > 999){pid=999;}                      // se verifica que pid sea menor a 1000
     
        LCD2(3,0,err) ;           // pc.putc(sprintf (mm,"ER%3.0f",err));  wait_ms(30);   
        LCD2(11,0,med);           // pc.putc(sprintf(mm,"ME%3.0f",med)); wait_ms(30); 
        LCD2(3,1,Sp)  ; 
        LCD2(11,1,med);           // pc.putc(sprintf(mm,"ID%3.0f",pid));  wait_ms(30); 
            
        err_v = err;                          //  guarda error
        u.write(pid/999);                     //  se envia el valor pid (normalizado) a puerto analogico de salida (D/A)
     
  /*    pc.printf("%3.0f\t",ER);  pc.printf("%3.0f\t",ME);
        pc.printf("%3.0f\t",SP);  pc.printf("%3.0f\n",ID);*/
        wait_ms(300);                
    
    } //  cierra while
 }    // funtion
  
//==============================================================================Funciones Mostrar en LCD
void LCD1 (int col, int fil, int val ){  
     lcd.locate(col,fil);  lcd.printf(" ");                 
     lcd.locate(col,fil);  lcd.printf("%d", val);  }       
     
void LCD2 (int col, int fil, float val ){
     lcd.locate(col,fil);  lcd.printf("    ");
     lcd.locate(col,fil);  lcd.printf("%3.0f", val); }  