#include "QEI.h"
#include "mbed.h"
Serial pc(USBTX, USBRX);

#define ROTATE_PER_REVOLUTIONS  24
//Use X4 encoding.
QEI wheel(D6, D7, NC, ROTATE_PER_REVOLUTIONS, QEI::X4_ENCODING);
//Use X2 encoding by default.
//QEI wheel (p30, p29, NC, 624);

int main() {
    while(1){
        wait(0.1);
        pc.printf("Pulses: %07d\ｔ", wheel.getPulses());
        pc.printf("Rotate: %04.3f\n", (double)wheel.getPulses()/(ROTATE_PER_REVOLUTIONS*4));
    }
}