#include "mbed.h"
#include "math.h" // to use cos() function for LED4
#include "MPU6050.h"

PwmOut myled1(LED1);
PwmOut myled2(LED2);
PwmOut myled3(LED3);
PwmOut myled4(LED4);

// to see 6050 data on Serial terminal
Serial pc(USBTX, USBRX);
MPU6050 mpu;

int16_t ax, ay, az;
int16_t gx, gy, gz;

int main(){
    myled1.period_ms(1);
    myled2.period_ms(1);
    myled3.period_ms(1);
    myled4.period_ms(1);

    pc.printf("MPU6050 test\n\n");
    pc.printf("MPU6050 initialize \n");

    mpu.initialize();
    pc.printf("MPU6050 testConnection \n");

    bool mpu6050TestResult = mpu.testConnection();
    if(mpu6050TestResult){
        pc.printf("MPU6050 test passed \n");
    } else{
        pc.printf("MPU6050 test failed \n");
    }
    while(1){
        wait(0.2);
        mpu.getMotion6(&ax, &ay, &az, &gx, &gy, &gz);
        pc.printf("%d\t%d\t%d\t%d\t%d\t%d\n",ax,ay,az,gx,gy,gz);

        myled1 = abs(ax) / 16384.0;
        myled2 = abs(ay) / 16384.0;
        myled3 = abs(az) / 16384.0;
        myled4 = cos(190*2.0*3.13/360) * 0.5 + 0.5; // to see efect of the value which is 0,0076 on LED4
    }
}