#include "plane.h"

void plane::init(){
    _width = 7;
    _height = 8;
    int d[56] = {
            0,0,0,0,1,0,0,
            0,0,0,0,1,1,0,
            1,0,0,0,1,1,0,
            1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,
            1,0,0,0,1,1,0,
            0,0,0,0,1,1,0,
            0,0,0,0,1,0,0
            };
    for(int i = 0; i<56;i++){
        data[i] = d[i];
    }
    _xy.x = 0;
    _xy.y = 25;
}

void plane::update(Gamepad &pad){
    if(pad.get_direction() == N){
        _xy.y = _xy.y - 1;
    }else if(pad.get_direction() == S){
        _xy.y = _xy.y + 1;
    }else if(pad.get_direction() == W){
        _xy.x = _xy.x - 1;
    }else if(pad.get_direction() == E){
        _xy.x = _xy.x + 1;
    }
}

void plane::display(N5110 &lcd){
        unsigned int width = _width;
        unsigned int height = _height;
        Bitmap p(data, height, width);
        p.render(lcd, _xy.x, _xy.y);
}

xy plane::getxy(){return _xy;}

int plane::getwidth(){return _width;}
int plane::getheight(){return _height;}