#include "Bitmap.h"
#include "N5110.h"
#include "Gamepad.h"

#include "plane.h"
#include "life.h"
#include "engine.h"
#include "N5110.h"
#include "Gamepad.h"
#include<iostream>

using namespace std;
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
plane p;
life lf;
engine eg;
bool n = true;
bomb bo[20];
bullet bu[20];
int bunum = 0;
int bonum = 0;
int score = 0;
int m = 0;

void init();
void welcome();
void screen();
void update();
void gameover();
void drawBitmap(int x, int y, int width, int height, int *data);

int main()
{
    while(1){
        init();
        welcome();
        while(n){
            if(m%8 ==0){
                bo[bonum%20].y = eg.randombomb();
                bo[bonum%20].x = 82;
                bonum = bonum + 1;
            }
            lcd.clear();
            screen();
            update();
            lcd.refresh();
            wait(0.2);
            m = m + 1;
        }
        wait(1);
    }
}

void init(){
    lcd.init();
    pad.init();
    p.init();
    lf.init();
    eg.init();
    lcd.setContrast(0.4);
    n = true;
    bunum = 0;
    bonum = 0;
    score = 0;
    m = 0;
    for(int i = 0; i < 20; i++){
        bu[i].x = -1;
        bu[i].y = -1;
        bo[i].x = -1;
        bo[i].y = -1;
        bo[i].width = 8;
        bo[i].height = 8;
        int data[64]= {
                0,0,0,1,1,0,0,0,
                0,1,1,0,0,1,1,0,
                0,1,1,1,1,1,1,0,
                1,0,1,1,1,1,0,1,
                1,0,1,1,1,1,0,1,
                0,1,1,1,1,1,1,0,
                0,1,1,0,0,1,1,0,
                0,0,0,1,1,0,0,0                 
        };
        bo[i].data = data;
    }
}

void welcome(){
    lcd.clear();
    lcd.printString("The plane war!",0,1);  
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();
    while( pad.check_event(Gamepad::START_PRESSED) == false){
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
}

void screen(){
    lcd.clear();
    p.display(lcd);
    lf.display(lcd);
    for(int i = 0; i <20; i++){
        if(bo[i].x >=0){
            drawBitmap(bo[i].x, bo[i].y, bo[i].width, bo[i].height, bo[i].data);}
        if(bu[i].x >=0){
            lcd.drawRect(bu[i].x, bu[i].y, 2, 2, FILL_BLACK);}
    }
    lcd.refresh();
}

void update(){
    p.update(pad);
    for(int i = 0; i<20; i++){
        for(int j = 0; j < 20; j++){
            events e = eg.evet_check(p, bo[i],pad,bu[j]);
            if(e == DEAD){
                lf.update();
                bo[i].x = -1;
                pad.tone(1000,0.2);
                if(lf.liferest()==0){
                    gameover();
                    i = 20;
                    j = 20;
                    pad.tone(1000,0.5);
                    break;
                }
            }else if(e == FIRE){
                eg.fire(p.getxy().x+7, p.getxy().y+3, bu[bunum%20]);
                bunum = bunum + 1;
            }else if(e == ELMININATE){
                bo[i].x = -1;
                bu[j].x = -1;
                score = score + 5;
                cout <<score<<endl;
            }
        }
    }
    for(int i = 0; i<20; i++){
        if((bo[i].x >=0) && (bo[i].x<=84)){
            bo[i].x = bo[i].x - 1;
        }
        if((bu[i].x >=0) && (bu[i].x<=84)){
            bu[i].x = bu[i].x + 1;
        }
    }
    
}

void gameover(){
    cout <<"game over"<< endl;
    lcd.clear();
    lcd.printString("GAMEOVER    ",0,1);  
    lcd.printString("SCORE    ",0,2);  
    char buffer1[14];
    sprintf(buffer1,"%2d",score);
    lcd.printString(buffer1,0,3);
    lcd.printString("  Press A ",0,4);
    lcd.refresh();
    while ( pad.check_event(Gamepad::A_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
    n = false;
}

void drawBitmap(int x, int y, int width, int height, int *data){
    Bitmap p(data, height, width);
    p.render(lcd, x, y);
}