
#include "mbed.h"
#include "ecu_reader.h"
#include "globals.h"
#include "TextLCD.h"
#include <stdio.h>
#include <string>
//#include "SDFileSystem.h"

TextLCD lcd(p26, p25, p24, p23, p22, p20, p19, TextLCD::LCD20x4);//(p18, p19, p20, p17, p16, p15, p14); // rs, rw, e, d0, d1, d2, d3
//SDFileSystem sd(p5, p6, p7, p13, "sd");

Serial pc(USBTX, USBRX);
DigitalIn enable(p8);

Serial xbee1(p9, p10); //Creates a variable for serial comunication through pin 9 and 10
DigitalOut rst1(p11); //Digital reset for the XBee, 200ns for reset


ecu_reader obdii(CANSPEED_500);     //Create object and set CAN speed
//void sd_demo(void);

void Rx_interrupt() {
       float rx_data[8];
       int first_byte[8];
       int second_byte[8];
       char buffer[30];
    if (can2.read(can_MsgRx)){
     //xbee1.printf("\n\rPackets Received:\n\r");
     
     if((can_MsgRx.id == Filter1) || (can_MsgRx.id == Filter1) || (can_MsgRx.id == Filter2) || (can_MsgRx.id == Filter3) || (can_MsgRx.id == Filter4) || (can_MsgRx.id == Filter5) || (can_MsgRx.id == Filter6)
                || (can_MsgRx.id == Filter7) || (can_MsgRx.id == Filter8) || (can_MsgRx.id == Filter9) || (can_MsgRx.id == Filtera) || (can_MsgRx.id == Filterb) || (can_MsgRx.id == Filterc)){
                    //xbee1.printf("\n\rIgnored\n\r");
                }

                 else{
                    for (int z = 0; z < 8; z++){
                    rx_data[z] = (can_MsgRx.data[z]);
                    if (rx_data[z] > 15){
                    first_byte[z] = rx_data[z]/16;
                    second_byte[z] = (int)(rx_data[z])%16;}                
                    else {
                    first_byte[z] = 0;
                    second_byte[z] = rx_data[z];
                        }}
                    
                        sprintf(buffer,"\n\r%d, %d, %d, %d, %d, %d, %d, %d", (int) rx_data[0],(int) rx_data[1],(int) rx_data[2],(int) rx_data[3],(int) rx_data[4],(int) rx_data[5],(int) rx_data[6],(int) rx_data[7] ); 
                        xbee1.printf(buffer, "\n\r"); 
                        sprintf(buffer,"%d%d %d%d %d%d %d%d %d%d %d%d %d%d %d%d", (int) first_byte[0],(int) second_byte[0],(int) first_byte[1],(int) second_byte[1],(int) first_byte[2],(int) second_byte[2],(int) first_byte[3],(int) second_byte[3],
                        (int) first_byte[4],(int) second_byte[4],(int) first_byte[5],(int) second_byte[5],(int) first_byte[6],(int) second_byte[6],(int) first_byte[7],(int) second_byte[7]);
                        xbee1.printf(buffer);  
                        xbee1.printf("\n\r");     
                    }
                    }
    }

int main() {
   
   int Mod1 = 0;
   int Mod2 = 0;
   
    rst1 = 0; //Set reset pin to 0
    wait_ms(1);//Wait at least one millisecond
    rst1 = 1;//Set reset pin to 1
    wait_ms(1);
    
    //pc.baud(115200);
   // xbee1.baud(9600);
   xbee1.baud(115200);      //set serial baurd rate, need to configure the xbees to 115200 manually 
    char buffer[30];
    
   // xbee1.printf("ECU Reader \n"); 
  //  lcd.locate(0,0);                // Set LCD cursor position
  //  lcd.printf("ECU Malicious Attack");
    
  //  lcd.locate(0,1);
  //  lcd.printf("    UCLA EE202A");
  
   can2.attach(&Rx_interrupt);//, CAN::RxIrq );  //need to figure this out ///////
       
    xbee1.printf("\n\rECU Malicious Attack\n\rUCLA EE202A\n\r");
    //wait(3);
    //lcd.cls();
   // lcd.locate(0,2); 
    //lcd.printf("Use joystick");

   // lcd.locate(0,3);
   // lcd.printf(" Push BTN1 to Start");
    int can_bus_speed = 500000;
        
        xbee1.printf("\n\r\n\rSelect CAN BUS Frequency\n\r0: 125Kbps\n\r1: 250Kbps\n\r2: 500Kbps\n\r3: 1Mbps\n\r ");
        
    while(1){
        if (xbee1.readable()){
            
            char c_freq = xbee1.getc();
            
            if (c_freq == '0'){
                can_bus_speed = 125000;
                break;}
            if (c_freq == '1'){
                can_bus_speed = 25000;
                break;}
            if (c_freq == '2'){
                can_bus_speed = 500000;
                break;}
            if (c_freq == '3'){
                can_bus_speed = 1000000;  
                break;} 
                
            }
        }
            
     can2.frequency(can_bus_speed);
     
     xbee1.printf("\n\rPush BTN1 to Start\n\r");

    while(1)    // Wait until option is selected by the joystick
    {
                  
        if(enable == 0) break;
        
    }
    wait(1);
   // lcd.cls();
    
    xbee1.printf("\n\r\n\rSelect Mode of Operation:\n\r\n\r0: PID Reading (RPM, Air Intake Temp., Fuel Pressure, and Etc...)\n\r1: Transmit and Receive CAN Packets\n\r");
    
    while (1)
    {
       if (xbee1.readable()) {
         char c1 = xbee1.getc();
        if (c1 == '0'){
            Mod1 = 1;
            xbee1.printf("\n\rPID Mode Selected!\n\r");
            break; } 
        if (c1 == '1'){
            Mod2 = 1;
            xbee1.printf("\n\rCAN Packet Communication Mode Selected!\n\r");
            break;}
        }
    }

    while(1) {  // Main CAN loop
       
       if (Mod1 == 1){
             
        led2 = 1;
        wait(0.1);
        led2 = 0;
        wait(0.1);
        
        if(obdii.request(ENGINE_RPM,buffer) == 1)   // Get engine rpm and display on LCD
        {
            lcd.locate(0,0);
            lcd.printf(buffer);
              xbee1.printf(buffer);
              xbee1.printf("\n\r");
        }   
         
        if(obdii.request(ENGINE_COOLANT_TEMP,buffer) == 1)
        {
            lcd.locate(9,0);
            lcd.printf(buffer);
            xbee1.printf(buffer);
            xbee1.printf("\n\r");
        }
        
        if(obdii.request(VEHICLE_SPEED,buffer) == 1)
        {
            lcd.locate(0,1);
            lcd.printf(buffer);
            xbee1.printf(buffer);
            xbee1.printf("\n\r");
        }
     
        if(obdii.request(THROTTLE,buffer) ==1 )
        {
            lcd.locate(9,1);
            lcd.printf(buffer);    
            xbee1.printf(buffer); 
            xbee1.printf("\n\r");     
        }   
       
        if(obdii.request(AIR_INTAKE_TEMP,buffer) ==1 )  
        {
            lcd.locate(0,2);
            lcd.printf(buffer);    
            xbee1.printf(buffer); 
            xbee1.printf("\n\r");     
        }   
        
         if(obdii.request(FUEL_PRESSURE,buffer) ==1 )  
        {
            lcd.locate(9,2);
            lcd.printf(buffer);    
            xbee1.printf(buffer); 
            xbee1.printf("\n\r");     
        }   
       }
    
     else if (Mod2 == 1){
        led4 = 1;
        wait(0.1);
        led4 = 0;
        wait(0.1);
       float rx_data[8];
       int first_byte[8];
       int second_byte[8];
        
        int packet1 = 0;
        int packet2 = 0;
        int packet3 = 0;
        int packet4 = 0;
        int receive0 = 0;
                
        char can_bus_msg[8];
        
xbee1.printf("\n\r\n\rSelect Type of Packet to Transmit:\n\r\n\ra: Flow Control\n\rb: Tester Present\n\rc: Enhanced Diagnostics\n\rd: Security Access: Request Seed\n\re: Sniff Packets");
        
    
            while (1)
    {
       if (xbee1.readable()) {
        char c = xbee1.getc();
        if (c == 'a'){
            packet1 = 1;
            xbee1.printf("\n\rFlow Control Packet Selected!\n\r");
            break; } 
        if (c == 'b'){
            packet2 = 1;
            xbee1.printf("\n\rTester Present Packet Selected!\n\r");
            break;}
        if (c == 'e'){
            receive0 = 1;
            xbee1.printf("\n\rRead Filtered Packets!\n\r");
            break;}
        if (c == 'c'){
            packet3 = 1;
            xbee1.printf("\n\rEnhanced Diagnostics Packet Selected!\n\r");
            break;}
            
        if (c == 'd'){
            packet4 = 1;
            xbee1.printf("\n\rRequest Seed Packet Selected!\n\r");
            break;}    
        }
    }
    
    if (packet1) {              //flow control packet 
        
            can_bus_msg[0] = 0x30;   //0x30 Clear To Send, 0x31 Wait
            can_bus_msg[1] = 0;      //Block Size, 0 -> Don't wait, send as many frames as are in the message
            can_bus_msg[2] = 0;      //Separation Time -> 0 -> Send As Fast As Possible, 101-255 are viable numbers 
            can_bus_msg[3] = 0;      //Don't Care
            can_bus_msg[4] = 0;      //Don't Care
            can_bus_msg[5] = 0;      //Don't Care  
            can_bus_msg[6] = 0;      //Don't Care
            can_bus_msg[7] = 0;      //Don't Care
            
            can2.write(CANMessage(Ext_Diag, can_bus_msg, 8));           //7E0 Extension Diag. TX
            packet1 = 0;
        
        }
        
    else if (packet2) {
            
            can_bus_msg[0] = 0x02;  
            can_bus_msg[1] = 0x3E;
            can_bus_msg[2] = 0x02;  
            can_bus_msg[3] = 0;
            can_bus_msg[4] = 0;  
            can_bus_msg[5] = 0;
            can_bus_msg[6] = 0;  
            can_bus_msg[7] = 0;
            
            can2.write(CANMessage(Ext_Diag, can_bus_msg, 8));           //7E0 Extension Diag. TX
            packet2 = 0;
        }
    
    else if (packet3) {
            
            can_bus_msg[0] = 0x02;  
            can_bus_msg[1] = 0x10;
            can_bus_msg[2] = 0x82;  
            can_bus_msg[3] = 0;
            can_bus_msg[4] = 0;  
            can_bus_msg[5] = 0;
            can_bus_msg[6] = 0;  
            can_bus_msg[7] = 0;
            
            can2.write(CANMessage(Ext_Diag, can_bus_msg, 8));           //7E0 Extension Diag. TX
            packet3 = 0;
        }
    else if (packet4) {
            
            can_bus_msg[0] = 0x02;  
            can_bus_msg[1] = 0x27;
            can_bus_msg[2] = 0x01;  
            can_bus_msg[3] = 0;
            can_bus_msg[4] = 0;  
            can_bus_msg[5] = 0;
            can_bus_msg[6] = 0;  
            can_bus_msg[7] = 0;
            
            can2.write(CANMessage(Ext_Diag, can_bus_msg, 8));           //7E0 Extension Diag. TX
            packet3 = 0;
        }
    
    else if (receive0) {
        
            if (can2.read(can_MsgRx)){
                
                if((can_MsgRx.id == Filter1) || (can_MsgRx.id == Filter1) || (can_MsgRx.id == Filter2) || (can_MsgRx.id == Filter3) || (can_MsgRx.id == Filter4) || (can_MsgRx.id == Filter5) || (can_MsgRx.id == Filter6)
                || (can_MsgRx.id == Filter7) || (can_MsgRx.id == Filter8) || (can_MsgRx.id == Filter9) || (can_MsgRx.id == Filtera) || (can_MsgRx.id == Filterb) || (can_MsgRx.id == Filterc)){
                    xbee1.printf("\n\rIgnored\n\r");
                }

                 else{
                    for (int z = 0; z < 8; z++){
                    rx_data[z] = (can_MsgRx.data[z]);
                    if (rx_data[z] > 15){
                    first_byte[z] = rx_data[z]/16;
                    second_byte[z] = (int)(rx_data[z])%16;}                
                    else {
                    first_byte[z] = 0;
                    second_byte[z] = rx_data[z];
                        }}
                    
                        sprintf(buffer,"%d, %d, %d, %d, %d, %d, %d, %d", (int) rx_data[0],(int) rx_data[1],(int) rx_data[2],(int) rx_data[3],(int) rx_data[4],(int) rx_data[5],(int) rx_data[6],(int) rx_data[7] ); 
                        xbee1.printf(buffer); 
                        xbee1.printf("\n\r");
                        sprintf(buffer,"%d%d %d%d %d%d %d%d %d%d %d%d %d%d %d%d", (int) first_byte[0],(int) second_byte[0],(int) first_byte[1],(int) second_byte[1],(int) first_byte[2],(int) second_byte[2],(int) first_byte[3],(int) second_byte[3],
                        (int) first_byte[4],(int) second_byte[4],(int) first_byte[5],(int) second_byte[5],(int) first_byte[6],(int) second_byte[6],(int) first_byte[7],(int) second_byte[7]);
                        xbee1.printf(buffer);  
                        xbee1.printf("\n\r");     
                    }
        }
        
        }
         } // end else
    } //end while
}//end main


