#ifndef ECU_READER_H
#define ECU_READER_H

#define CANSPEED_125      125000        // CAN speed at 125 kbps
#define CANSPEED_250      250000        // CAN speed at 250 kbps
#define CANSPEED_500      500000        // CAN speed at 500 kbps

 /* Details from http://en.wikipedia.org/wiki/OBD-II_PIDs */
#define ENGINE_COOLANT_TEMP 0x05
#define ENGINE_RPM          0x0C
#define VEHICLE_SPEED       0x0D
#define MAF_SENSOR          0x10
#define THROTTLE            0x11
#define O2_VOLTAGE          0x14
#define AIR_INTAKE_TEMP     0x0F
#define FUEL_PRESSURE       0x0A

#define PID_REQUEST         0x7DF       //tx
#define PID_REPLY           0x7E8       //rx
#define Ext_Diag            0x7E0       //tx

//To Filter this IDs
#define Filter1             0x1EA
#define Filter2             0x1EB
#define Filter3             0x156
#define Filter4             0x18E
#define Filter5             0x1A6
#define Filter6             0x13C
#define Filter7             0x158
#define Filter8             0x1A4
#define Filter9             0x1B0
#define Filtera             0x255
#define Filterb             0x1D0
#define Filterc             0x191

namespace mbed { 

class ecu_reader{

public:

    ecu_reader(int can_speed);

    unsigned char request(unsigned char pid,  char *buffer);

private: 

    int i;
 
};





    } 



#endif
