#include "mbed.h"
#include "PowerControl.h"
#include "EthernetPowerControl.h"
 
// Read temperature from LM75BD
#define USR_POWERDOWN    (0x104)

I2C i2c(p28, p27);
Serial pc(USBTX, USBRX); // tx, rx
InterruptIn PIR_in(p5);
Serial xbee1(p9,p10);
DigitalOut rst1(p11);
AnalogIn light(p20);

Timer cal_temp_time; 
Timer cal_temp_time_c;

Timer PIR_c;
//Ticker flipper;

const int tx_addr = 0x14;
const int rx_addr = 0x15;
char readbuff [35];
char rb [35];
char tx_cmd[1];
int y[18];
 int x[16];
 int occupancy_count = 0;
 char c = 'y';
 int flag = 0;
 int room_temp = 0;
 int cal_temp[16];
  int flag_c = 0;
 int room_temp_c = 0;
 int cal_temp_c[16];
 int temp_occupancy_count_c = 0;
 int PIR_tag = 0;
 int initial_flag = 0;
 int after_cond_high = 0;
  int after_cond_low = 0;
 int temp_occupancy_count_ed = 0;
 int low_duration = 0;
 int high_duration = 0;
 int fluc_counter = 0;
 int human_temp_c = 0;
 int human_temp = 0;

void flip() {
   // pc.printf("kos kesh");
   if (PIR_tag == 1)
    {
        if (PIR_c.read() >= 30)         //check to see if the PIR sensor has been low for 30 seconds or more, if so, then most likely someone new just entered
            temp_occupancy_count_c = 1;
        else if (PIR_c.read() <= 10)
            temp_occupancy_count_c = temp_occupancy_count_ed; 
            PIR_c.reset();
            PIR_tag = 0;
        }
   
   
    tx_cmd[0] = 0x4C;
        //tx_cmd[1] = 0x4C;
        //i2c.write(tx_addr,
        i2c.write(tx_addr, tx_cmd , 1);
 
        wait(0.25);
 
        //i2c.write(rx_addr, cmd, 1);
        i2c.read(rx_addr, readbuff, 35);
 
        //float tmp = (float((cmd[0]<<8)|cmd[1]) / 256.0);
        for (int count = 0; count < 17; count++)
         y[count] = 256*readbuff[(count*2)+1] + readbuff [(count*2)];
        
         y[17] = readbuff[34];
         
         
                   //calibrating
               
               for (int temp_comp_c = 0; temp_comp_c < 16; temp_comp_c++)
               {    
                    if (( x[temp_comp_c] >= 240) && (x[temp_comp_c] <= 300))
                     room_temp_c = room_temp_c + 1;
                    if (( x[temp_comp_c] >= 300) && (x[temp_comp_c] <= 400))
                     human_temp_c = human_temp_c + 1;}
             if (flag_c == 0) {           
                if (room_temp_c >= 12){
                   for (int cal_c = 0; cal_c < 16; cal_c++)
                        cal_temp_c[cal_c] = x[cal_c];
                                                }
                        flag_c = 1;
                        cal_temp_time_c.start();
                        }
               
               if (cal_temp_time_c.read_ms() == 900000){
                    flag_c = 0;
                    cal_temp_time_c.reset();}
                    
 
              if (after_cond_high == 1){
         if ((PIR_c.read() <= 10) && (room_temp_c + room_temp <= 28) && (fluc_counter == 5))        //check to see if the PIR sensor has been high for 10 or less seconds if so, someone just passed by and probably left
           { temp_occupancy_count_c = temp_occupancy_count_c;}
             high_duration = PIR_c.read();  //how long did the PIR signal stay high (busy)
             PIR_c.reset();                 //reset timer
           if ((high_duration > low_duration) && (room_temp_c + room_temp <= 10) && (fluc_counter == 5))
             temp_occupancy_count_c++; 
          after_cond_low = 1; 
          after_cond_high = 0;     
       }     
       
    if (after_cond_low == 1){
        if ((PIR_c.read() >= 120) && (room_temp_c + room_temp >= 24) && (fluc_counter == 5))
            temp_occupancy_count_c--;
        else if ((PIR_c.read() >= 600) && (room_temp_c+room_temp >= 24) && (fluc_counter == 5)) 
            temp_occupancy_count_c = 1;
           low_duration = PIR_c.read();   //how long did the PIR signal stay low 
           PIR_c.reset();               //reset timer
           if (low_duration > high_duration)        //comparing low and high duration
            temp_occupancy_count_c--;
            after_cond_low = 0;
            after_cond_high = 1;
        }   
        
   if (initial_flag == 0){
        if (PIR_in == 1){           //first raising edge of Coord PIR Sensor (someone has entered the room)
            PIR_c.start();          // start timer for PIR sensor processing
           // temp_occupancy_count_c = temp_occupancy_count_c + 1
           initial_flag = 1 ;
           after_cond_high = 1;}        //initial condition met, neg to pos edge 
           // initial_flag = 1;
        else {
            PIR_c.start();
            PIR_tag = 1;        
             }   
        }      
          
         room_temp_c = 0;
         room_temp = 0;
         human_temp_c = 0;
         human_temp = 0;
        pc.printf("Coordinator:\n\r%d\t%d\t%d\t%d\n\r%d\t%d\t%d\t%d\n\r%d\t%d\t%d\t%d\n\r%d\t%d\t%d\t%d\n\r\n\r",y[1],y[2],y[3],
        y[4],y[5],y[6],y[7],y[8],y[9],y[10],y[11],y[12],y[13],y[14],y[15],y[16]);
        pc.printf("Occupany Count: %d\n\r", temp_occupancy_count_c);
        if (temp_occupancy_count_c <= 3)
        pc.printf("Low Occupancy\n\r");
        if ((temp_occupancy_count_c <= 6) && (temp_occupancy_count_c > 3))
        pc.printf("Mid Occupancy\n\r");
        if (temp_occupancy_count_c > 6)
        pc.printf("High Occupancy\n\r");
}

int main() {

   
    i2c.frequency(50000);
     xbee1.baud(115200);
     
     PHY_PowerDown();
    
    PIR_in.rise(&flip); 
    PIR_in.fall(&flip);

    rst1 = 0; //Set reset pin to 0
    wait_ms(1);//Wait at least one millisecond
    rst1 = 1;//Set reset pin to 1
    wait_ms(1);
    
   // pc.printf("not this");
   wait_ms(75000);  //wait one minute for initial start up 
   
    while (1) {
            
            
           // xbee1.putc(c);
            if (xbee1.readable()){
               // pc.printf("receiving\n\r");
               // pc.putc(xbee1.getc()); 
             
               if (fluc_counter < 6)   
                  fluc_counter++;
                  
               for (int j = 2; j < 34; j++)   
               rb[j] = xbee1.getc();
               
               for (int z = 0; z < 16; z++)
               x[z] = 256*rb[(2*z)+3]+rb[(2*z)+2];
               
                            //calibrating
               
               for (int temp_comp = 0; temp_comp < 16; temp_comp++)
               {    
                    if (( x[temp_comp] >= 240) && (x[temp_comp] <= 300))
                     room_temp = room_temp + 1;
                    if (( x[temp_comp] >= 300) && (x[temp_comp] <= 400))
                     human_temp = human_temp + 1;}
               if (flag == 0) {       
                if (room_temp >= 12){                         //good place to set the initial flag to begin duration timing
                   for (int cal = 0; cal < 16; cal++)
                        cal_temp[cal] = x[cal];
                                                }
                        flag = 1;
                        cal_temp_time.start();
                        }
               
               if (cal_temp_time.read_ms() == 900000){
                    flag = 0;
                    cal_temp_time.reset();}
               
              // pc.printf("x = %d\n\r", x);
              
              pc.printf("End Device\n\r%d\t%d\t%d\t%d\n\r%d\t%d\t%d\t%d\n\r%d\t%d\t%d\t%d\n\r%d\t%d\t%d\t%d\n\r\n\r",x[0],x[1],x[2],x[3],
              x[4],x[5],x[6],x[7],x[8],x[9],x[10],x[11],x[12],x[13],x[14],x[15]);
              pc.printf("Occupany Count: %d\n\r", temp_occupancy_count_c);}
              
              if ((PIR_c.read() >= 600) && (PIR_in == 0)) {            //if the signal has been low for 5 or more minutes, and the PIR_in is low, check the temp, if room, occupancy zero
                  tx_cmd[0] = 0x4C;
                 i2c.write(tx_addr, tx_cmd , 1);

                wait(0.25);
 
                i2c.read(rx_addr, readbuff, 35);
 
                for (int count = 0; count < 17; count++)
                y[count] = 256*readbuff[(count*2)+1] + readbuff [(count*2)];
        
                  y[17] = readbuff[34];
                  
                   for (int temp_comp_c = 0; temp_comp_c < 16; temp_comp_c++)
               {    
                    if (( x[temp_comp_c] >= 240) && (x[temp_comp_c] <= 300))
                     room_temp_c = room_temp_c + 1;
                    if (( x[temp_comp_c] >= 300) && (x[temp_comp_c] <= 400))
                     human_temp_c = human_temp_c + 1;}
                
                }
                
                if (room_temp_c >= 12)
                 temp_occupancy_count_c = 0;
                if (human_temp_c >= 6)
                  temp_occupancy_count_c = 1;
                if (human_temp_c >= 8)
                  temp_occupancy_count_c = 2;
                   
              
              if (light < 0.5){  //and thermal temp readings are low, need to think about this a little more
               occupancy_count = 0;
               }
                                    
      //   sleep();
        // pc.printf("system on idle\n\r");
        //pc.printf("x1 = %d\n",x1);
    }
}