#include "display.h"

/**************************************************************************************************************************
************************** Display Main Menu ******************************************************************************
**************************************************************************************************************************/
void Display::MainMenu(float humidity, float temperature)
{
    // start FT800 display list
    StartDL();
    
    // write main title
    (*_TFT).DL(COLOR_RGB(0, 0, 0));
    (*_TFT).Text(11, 15, 30, 0, "HYT-271 sensor from IST");

    // create blue rectangle with current humididty including 
    // rectangle is tagged as CURR_HUM_PRESS
    (*_TFT).DL(TAG_MASK(1));
    (*_TFT).DL(TAG(CURR_HUM_PRESS));
    (*_TFT).DL(COLOR_RGB(9, 0, 63));
    // if rectangle is already pressed, draw it with lighter color
    if (pressedButton == CURR_HUM_PRESS) {
        (*_TFT).DL(COLOR_RGB(75, 70, 108));
    }
    (*_TFT).DL(BEGIN(RECTS));
    (*_TFT).DL(VERTEX2II(12, 62, 0, 0));
    (*_TFT).DL(VERTEX2II(12 + 400, 62 + 93, 0, 0));
    (*_TFT).DL(COLOR_RGB(255, 255, 255));
    (*_TFT).Text(12 + 10, 62 + 5, 30, 0, "Current humidity (rH)");
    CreateStringTempHum(humidityStr, humidity, 0);
    (*_TFT).Text(12 + 10, 62 + 45, 31, 0, humidityStr);
    (*_TFT).DL(TAG_MASK(0));

    // create blue rectangle with current temperature including 
    // rectangle is tagged as CURR_TEMP_PRESS
    (*_TFT).DL(TAG_MASK(1));
    (*_TFT).DL(TAG(CURR_TEMP_PRESS));
    (*_TFT).DL(COLOR_RGB(9, 0, 63));
    // if rectangle is already pressed, draw it with lighter color
    if (pressedButton == CURR_TEMP_PRESS) {
        (*_TFT).DL(COLOR_RGB(75, 70, 108));
    }
    (*_TFT).DL(BEGIN(RECTS));
    (*_TFT).DL(VERTEX2II(12, 62 + 93 + 12, 0, 0));
    (*_TFT).DL(VERTEX2II(12 + 400, 62 + 93 + 12 + 93, 0, 0));
    (*_TFT).DL(COLOR_RGB(255, 255, 255));
    (*_TFT).Text(12 + 10, 62 + 93 + 12 + 5, 30, 0, "Current temperature");
    CreateStringTempHum(temperatureStr, temperature, 1);
    (*_TFT).Text(12 + 10, 62 + 93 + 12 + 45, 31, 0, temperatureStr);
    (*_TFT).DL(TAG_MASK(0));
    
    // finish FT800 display list
    FinishDL();
}