#include "display.h"

/**************************************************************************************************************************
************************** Draw horisontal grid for temperature (-50 .. +125) *********************************************
**************************************************************************************************************************/
void Display::HorisontalGrid_CurrentTemp()
{
    (*_TFT).DL(COLOR_RGB(20, 20, 20));
    char gridNumb = 125 + 50;
    for (int i = 70 * 16; i <= 225 * 16; i += 352) {
        (*_TFT).DL(BEGIN(LINES));
        (*_TFT).DL(LINE_WIDTH(8));
        (*_TFT).DL(VERTEX2F(15 * 16, i));
        (*_TFT).DL(VERTEX2F(423 * 16, i));
        if (gridNumb  >= 50) {
            (*_TFT).Number(435, i/16 - 9, 26, 0, gridNumb - 50);
        } else if (gridNumb == 25) {
            (*_TFT).Text(435, i/16 - 9, 26, 0, "-25");
        } else if (gridNumb == 0) {
            (*_TFT).Text(435, i/16 - 9, 26, 0, "-50");
        }
        gridNumb = gridNumb - 25;
    }
}

/**************************************************************************************************************************
************************** Draw horisontal grid for humidity (0 .. 100) ***************************************************
**************************************************************************************************************************/
void Display::HorisontalGrid_CurrentHumidity()
{
    (*_TFT).DL(COLOR_RGB(20, 20, 20));
    char gridNumb = 100;
    for (int i = 70 * 16; i <= 220 * 16; i += 600) {
        (*_TFT).DL(BEGIN(LINES));
        (*_TFT).DL(LINE_WIDTH(8));
        (*_TFT).DL(VERTEX2F(15 * 16, i));
        (*_TFT).DL(VERTEX2F(423 * 16, i));
        (*_TFT).Number(435, i/16 - 9, 26, 0, gridNumb);
        gridNumb = gridNumb - 25;
    }
}