#include "mbed.h"
#include "FT_Platform.h"
#include "HYT.h"
#include "display.h"
#include "statistics.h"

Ticker timeKeeping;
volatile uint64_t seconds = 0;
uint64_t secondsOffset = 0;

HYT SENSOR (PD6, PD7); // sda, scl [SLSTK3400A]
FT800 TFT (PE10, PE11, PE12, PE13, PB11, PD4); // mosi, miso, sck, ss, int, pd [SLSTK3400A]
//HYT SENSOR (D14, D15); // sda, scl [WIZwiki-W7500P]
//FT800 TFT (D11, D12, D13, D10, D9, D8); // mosi, miso, sck, ss, int, pd [WIZwiki-W7500P]
//HYT SENSOR (PA08, PA09); // sda, scl [ATSAMD21-XPRO]
//FT800 TFT (PA18, PA16, PA19, PA17, PA20, PA21); // mosi, miso, sck, ss, int, pd [ATSAMD21-XPRO]

Display disp(&TFT);
Statistics stat;

/**************************************************************************************************************************
************************** Update statistics data every second ************************************************************
**************************************************************************************************************************/
void secondsCallback(void)
{
    if (seconds != 0) {
        secondsOffset = stat.UpdateStatistics(SENSOR.humidity, SENSOR.temperature, seconds, secondsOffset);
    } else {
        stat.InitValues(SENSOR.humidity, SENSOR.temperature);
    }
    seconds ++;
}

/**************************************************************************************************************************
************************** HYT sensor polling cycle ***********************************************************************
**************************************************************************************************************************/
void dataUpdate(void)
{
    SENSOR.MRCommand();
    wait_ms(100);
    SENSOR.DFCommand();
}

/**************************************************************************************************************************
************************** Main function **********************************************************************************
**************************************************************************************************************************/
int main()
{
    timeKeeping.attach(&secondsCallback, 1.0f);

    disp.LoadImagesAndFonts();
    disp.HandleAllBitmaps();
    disp.Calibration();

    disp.activeScreen = MENU_SCREEN;
    disp.pressedButton = NONE_PRESS;

    //  change active screen depending on pressed area
    while(1) {
        dataUpdate();
        disp.pressedButton = disp.GetTouch();

        // ----------------------------------------------------------------------------------------------
        // Main menu screen
        if (disp.activeScreen == MENU_SCREEN) {
            disp.MainMenu(SENSOR.humidity, SENSOR.temperature);
            if (disp.pressedButton) {
                wait_ms(150);
                if (disp.pressedButton == CURR_TEMP_PRESS) {
                    disp.activeScreen = CURR_TEMP_SCREEN;
                } else if (disp.pressedButton == CURR_HUM_PRESS) {
                    disp.activeScreen = CURR_HUM_SCREEN;
                } else if (disp.pressedButton == STAT_HUM_PRESS) {
                    disp.activeScreen = HUM_24HRS_SCREEN;
                } else if (disp.pressedButton == STAT_TEMP_PRESS) {
                    disp.activeScreen = TEMP_24HRS_SCREEN;
                } else if (disp.pressedButton == ABOUT_PRESS) {
                    disp.activeScreen = ABOUT_SCREEN;
                }
                disp.pressedButton = NONE_PRESS;
            }

        // ----------------------------------------------------------------------------------------------
        // Any other screen
        } else {
            // ----------------------------------------------------------------------------------------------
            // You can back to main menu from any screen
            if (disp.pressedButton == MENU_PRESS) {
                disp.pressedButton = NONE_PRESS;
                disp.activeScreen = MENU_SCREEN;
            } else {
                // ----------------------------------------------------------------------------------------------
                // Screen with current temperature
                if (disp.activeScreen == CURR_TEMP_SCREEN) {
                    disp.CurrentTemperature(SENSOR.temperature);
                // ----------------------------------------------------------------------------------------------
                // Screen with current humidity
                } else if (disp.activeScreen == CURR_HUM_SCREEN) {
                    disp.CurrentHumidity(SENSOR.humidity);
                // ----------------------------------------------------------------------------------------------
                // Screens with humidity statistics
                } else if (disp.activeScreen == HUM_24HRS_SCREEN) {
                    disp.StatHumidity_24hrs(seconds, stat.humidity24hrs, secondsOffset);
                    if (disp.pressedButton >= ZONE_1_PRESS && disp.pressedButton <= ZONE_8_PRESS) {
                        wait_ms(150);
                        disp.activeScreen = HUM_3HRS_SCREEN;
                        disp.pressedButton = NONE_PRESS;
                    }
                } else if (disp.activeScreen == HUM_3HRS_SCREEN) {
                    disp.StatHumidity_3hrs(seconds, stat.humidity24hrs, secondsOffset);
                    if (disp.pressedButton >= ZONE_1_PRESS && disp.pressedButton <= ZONE_6_PRESS) {
                        wait_ms(150);
                        disp.activeScreen = HUM_30MIN_SCREEN;
                        disp.pressedButton = NONE_PRESS;
                    }
                } else if (disp.activeScreen == HUM_30MIN_SCREEN) {
                    disp.StatHumidity_30min(seconds, stat.humidity24hrs, secondsOffset);
                    if (disp.pressedButton == STAT_HUM_PRESS) {
                        disp.activeScreen = HUM_24HRS_SCREEN;
                        disp.pressedButton = NONE_PRESS;
                    }
                // ----------------------------------------------------------------------------------------------
                // Screens with humidity statistics
                } else if (disp.activeScreen == TEMP_24HRS_SCREEN) {
                    disp.StatTemperature_24hrs(seconds, stat.temperature24hrs, secondsOffset);
                    if (disp.pressedButton >= ZONE_1_PRESS && disp.pressedButton <= ZONE_8_PRESS) {
                        wait_ms(150);
                        disp.activeScreen = TEMP_3HRS_SCREEN;
                        disp.pressedButton = NONE_PRESS;
                    }
                } else if (disp.activeScreen == TEMP_3HRS_SCREEN) {
                    disp.StatTemperature_3hrs(seconds, stat.temperature24hrs, secondsOffset);
                    if (disp.pressedButton >= ZONE_1_PRESS && disp.pressedButton <= ZONE_6_PRESS) {
                        wait_ms(150);
                        disp.activeScreen = TEMP_30MIN_SCREEN;
                        disp.pressedButton = NONE_PRESS;
                    }
                } else if (disp.activeScreen == TEMP_30MIN_SCREEN) {
                    disp.StatTemperature_30min(seconds, stat.temperature24hrs, secondsOffset);
                    if (disp.pressedButton == STAT_TEMP_PRESS) {
                        disp.activeScreen = TEMP_24HRS_SCREEN;
                        disp.pressedButton = NONE_PRESS;
                    }
                // ----------------------------------------------------------------------------------------------
                // Screens with information about sensor
                } else if (disp.activeScreen == ABOUT_SCREEN) {
                    disp.AboutSensor();
                }
            }
        }
    }
}