#include "display.h"

/**************************************************************************************************************************
************************** Decompress images anf fonts from pictures.h and put them to the RAM memeory of FT800 ***********
**************************************************************************************************************************/
void Display::LoadImagesAndFonts()
{
    (*_TFT).WrCmd32(CMD_INFLATE);
    (*_TFT).WrCmd32(IMAGE_ADDR_HUMIDITY);
    (*_TFT).WrCmdBufFromFlash(hum_icon, sizeof(hum_icon));

    (*_TFT).WrCmd32(CMD_INFLATE);
    (*_TFT).WrCmd32(IMAGE_ADDR_TEMPERATURE);
    (*_TFT).WrCmdBufFromFlash(temp_icon, sizeof(temp_icon));   
       
    (*_TFT).WrCmd32(CMD_INFLATE);
    (*_TFT).WrCmd32(IMAGE_ADDR_SENSOR);
    (*_TFT).WrCmdBufFromFlash(HYT_photo, sizeof(HYT_photo));

    (*_TFT).WrCmd32(CMD_INFLATE);
    (*_TFT).WrCmd32(FONT_SET_ROBOTO_REGULAR_30);
    (*_TFT).WrCmdBufFromFlash(font_RobotoRegular30, sizeof(font_RobotoRegular30));
    
    (*_TFT).WrCmd32(CMD_INFLATE);
    (*_TFT).WrCmd32(FONT_SET_ROBOTO_REGULAR_16);
    (*_TFT).WrCmdBufFromFlash(font_RobotoRegular16, sizeof(font_RobotoRegular16));
}

/**************************************************************************************************************************
************************** Prepare images and fronts **********************************************************************
**************************************************************************************************************************/
void Display::HandleAllBitmaps()
{
     // start FT800 display list
    StartDL();
    
    (*_TFT).DL(BITMAP_HANDLE(0));
    (*_TFT).DL(BITMAP_SOURCE(IMAGE_ADDR_HUMIDITY));
    (*_TFT).DL(BITMAP_LAYOUT(ARGB4, 60, 38));
    (*_TFT).DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 30, 38));
    
    (*_TFT).DL(BITMAP_HANDLE(1));
    (*_TFT).DL(BITMAP_SOURCE(IMAGE_ADDR_TEMPERATURE));
    (*_TFT).DL(BITMAP_LAYOUT(ARGB4, 42, 42));
    (*_TFT).DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 21, 42));
        
    (*_TFT).DL(BITMAP_HANDLE(2));
    (*_TFT).DL(BITMAP_SOURCE(IMAGE_ADDR_SENSOR));
    (*_TFT).DL(BITMAP_LAYOUT(RGB332, 101, 147));
    (*_TFT).DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 101, 147));
    
    (*_TFT).DL(BITMAP_HANDLE(3));
    (*_TFT).DL(BITMAP_SOURCE(FONT_ADDR_ROBOTO_REGULAR_30));
    (*_TFT).DL(BITMAP_LAYOUT(L4, 16, 33));
    (*_TFT).DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 32, 33));

    (*_TFT).DL(BITMAP_HANDLE(4));
    (*_TFT).DL(BITMAP_SOURCE(FONT_ADDR_ROBOTO_REGULAR_16));
    (*_TFT).DL(BITMAP_LAYOUT(L4, 8, 20));
    (*_TFT).DL(BITMAP_SIZE(NEAREST, BORDER, BORDER, 16, 20));
    
    (*_TFT).SetFont(3, FONT_SET_ROBOTO_REGULAR_30);
    (*_TFT).SetFont(4, FONT_SET_ROBOTO_REGULAR_16);    
  
    // finish FT800 display list
    FinishDL();
}