#include "display.h"

/**************************************************************************************************************************
************************** Display real-time humidity *********************************************************************
**************************************************************************************************************************/

void Display::CurrentHumidity(float humidity)
{
    // accelerator for x-axis data output
    char accelerator = 6;
    // create string including current humididty and " %"
    CreateStringTempHum(humidityStr, humidity, 0);
    // write the new scalable (* 1.5) data to the next available array position
    currentHumidity_Y[currentHumidity_X] = (char)(humidity * 1.5);

    // start FT800 display list
    StartDL();

    // draw bottom color for graph line
    (*_TFT).DL(COLOR_RGB(200, 200, 200));
    (*_TFT).DL(BEGIN(EDGE_STRIP_B));
    for (int i = 0; i < 68; i++) {
        if (currentHumidity_Y[i] != 0 && i <= currentHumidity_X) {
            (*_TFT).DL(VERTEX2F((i * accelerator + 15) * 16, (220 - currentHumidity_Y[i]) * 16));
        }
    }

    // draw horisontal grid for humidity (0 .. 100)
    HorisontalGrid_Current_Humidity();

    // draw main graph line
    (*_TFT).DL(COLOR_RGB(9, 0, 63));
    (*_TFT).DL(BEGIN(POINTS));
    (*_TFT).DL(POINT_SIZE(25));
    for (int i = 0; i < 68; i++) {
        if (currentHumidity_Y[i] != 0 && (i < currentHumidity_X || i >= currentHumidity_X + 13)) {
            (*_TFT).DL(VERTEX2F((i * accelerator + 15) * 16, (222 - currentHumidity_Y[i]) * 16));
        }
    }

    // draw subtitle for main graph line
    (*_TFT).DL(COLOR_RGB(255, 255, 255));
    (*_TFT).DL(BEGIN(RECTS));
    (*_TFT).DL(VERTEX2II((currentHumidity_X * accelerator + 40) + 25, (200 - currentHumidity_Y[currentHumidity_X]), 0, 0));
    (*_TFT).DL(VERTEX2II((currentHumidity_X * accelerator + 40), (177 - currentHumidity_Y[currentHumidity_X]), 0, 0));
    (*_TFT).DL(COLOR_RGB(255, 0, 0));
    (*_TFT).Text((currentHumidity_X * accelerator + 30), (180 - currentHumidity_Y[currentHumidity_X] - 7), 28, 0, humidityStr);
    (*_TFT).DL(BEGIN(LINES));
    (*_TFT).DL(LINE_WIDTH(8));
    (*_TFT).DL(VERTEX2F((currentHumidity_X * accelerator + 15) * 16, (220 - currentHumidity_Y[currentHumidity_X]) * 16));
    (*_TFT).DL(VERTEX2F((currentHumidity_X * accelerator + 35) * 16, (200 - currentHumidity_Y[currentHumidity_X]) * 16));
    (*_TFT).DL(COLOR_RGB(255, 30, 33));
    (*_TFT).DL(BEGIN(POINTS));
    (*_TFT).DL(POINT_SIZE(33));
    (*_TFT).DL(VERTEX2F((currentHumidity_X * accelerator + 15) * 16, (220 - currentHumidity_Y[currentHumidity_X]) * 16));
    (*_TFT).DL(END());

    // write main title
    (*_TFT).DL(COLOR_RGB(0, 0, 0));
    CreateStringRussian("Относительная влажность");
    (*_TFT).Text(15, 15, 3, 0, russianStr);

    // clean the space under the plot, create link to the main menu
    (*_TFT).DL(SCISSOR_XY(15, 222));
    (*_TFT).DL(SCISSOR_SIZE(420, 53));
    (*_TFT).Gradient(0, 256, 0xFFFFFF, 450, 16, 0xFFFFFF);
    MainMenuReference();

    // finish FT800 display list
    FinishDL();

    // manage the index for array with real-time humidity
    if (currentHumidity_X >= 68) {
        currentHumidity_X = 0;
    } else {
        currentHumidity_X ++;
    }
    if (pressedButton == MENU_PRESS) {
        for (int i = 0; i < 68; i++) {
            currentHumidity_Y[i] = 0;
            currentHumidity_X = 0;
        }
    }
}

/**************************************************************************************************************************
************************** Display real-time temperature ******************************************************************
**************************************************************************************************************************/

void Display::CurrentTemperature(float temperature)
{
    // accelerator for x-axis data output
    char accelerator = 6;
    // create string including current temperature with decimal mark and " С"
    char degreeOffset = CreateStringTempHum(temperatureStr, temperature, 1);
    // write the new scalable (* 0.88 + 45) data to the next available array position
    currentTemperature_Y[currentTemperature_X] = (char)(temperature * 0.88 + 45);

    // start FT800 display list
    StartDL();

    // draw bottom color for graph line
    (*_TFT).DL(COLOR_RGB(200, 177, 199));
    (*_TFT).DL(BEGIN(EDGE_STRIP_B));
    for (int i = 0; i < 68; i++) {
        if (currentTemperature_Y[i] != 0 && i <= currentTemperature_X) {
            (*_TFT).DL(VERTEX2F((i * accelerator + 15) * 16, (220 - currentTemperature_Y[i]) * 16));
        }
    }

    // draw horisontal grid for temperature (-50 .. +125)
    HorisontalGrid_Current_Temperature();

    // draw main graph line
    (*_TFT).DL(COLOR_RGB(9, 0, 63));
    (*_TFT).DL(BEGIN(POINTS));
    (*_TFT).DL(POINT_SIZE(25));
    for (int i = 0; i < 68; i++) {
        if (currentTemperature_Y[i] != 0 && (i < currentTemperature_X || i >= currentTemperature_X + 13)) {
            (*_TFT).DL(VERTEX2F((i * accelerator + 15) * 16, (222 - currentTemperature_Y[i]) * 16));
        }
    }

    // draw subtitle for main graph line
    (*_TFT).DL(COLOR_RGB(255, 255, 255));
    (*_TFT).DL(BEGIN(RECTS));
    (*_TFT).DL(VERTEX2II((currentTemperature_X * accelerator + 40) + 25, (200 - currentTemperature_Y[currentTemperature_X]), 0, 0));
    (*_TFT).DL(VERTEX2II((currentTemperature_X * accelerator + 40), (177 - currentTemperature_Y[currentTemperature_X]), 0, 0));
    (*_TFT).DL(COLOR_RGB(255, 0, 0));
    (*_TFT).Text((currentTemperature_X * accelerator + 25), (173 - currentTemperature_Y[currentTemperature_X]), 28, 0, temperatureStr);
    (*_TFT).Text((currentTemperature_X * accelerator + 25) + (degreeOffset * 8 + 3), (173 - currentTemperature_Y[currentTemperature_X]) - 4, 20, 0, "o");
    (*_TFT).DL(BEGIN(LINES));
    (*_TFT).DL(LINE_WIDTH(8));
    (*_TFT).DL(VERTEX2F((currentTemperature_X * accelerator + 15) * 16, (220 - currentTemperature_Y[currentTemperature_X]) * 16));
    (*_TFT).DL(VERTEX2F((currentTemperature_X * accelerator + 35) * 16, (200 - currentTemperature_Y[currentTemperature_X]) * 16));
    (*_TFT).DL(COLOR_RGB(255, 30, 33));
    (*_TFT).DL(BEGIN(POINTS));
    (*_TFT).DL(POINT_SIZE(33));
    (*_TFT).DL(VERTEX2F((currentTemperature_X * accelerator + 15) * 16, (220 - currentTemperature_Y[currentTemperature_X]) * 16));
    (*_TFT).DL(END());

    // write main title
    (*_TFT).DL(COLOR_RGB(0, 0, 0));
    CreateStringRussian("Температура");
    (*_TFT).Text(15, 15, 3, 0, russianStr);

    // clean the space under the plot, create link to the main menu
    (*_TFT).DL(SCISSOR_XY(15, 225));
    (*_TFT).DL(SCISSOR_SIZE(420, 53));
    (*_TFT).Gradient(0, 256, 0xFFFFFF, 450, 16, 0xFFFFFF);
    MainMenuReference();

    // finish FT800 display list
    FinishDL();

    if (currentTemperature_X >= 68) {
        currentTemperature_X = 0;
    } else {
        currentTemperature_X ++;
    }
    if (pressedButton == MENU_PRESS) {
        for (int i = 0; i < 68; i++) {
            currentTemperature_Y[i] = 0;
            currentTemperature_X = 0;
        }
    }
}