#include "display.h"

/**************************************************************************************************************************
************************** Display data about humidity in the three-hour interval *****************************************
**************************************************************************************************************************/

void Display::StatHumidity_3hrs(volatile uint64_t seconds, short int statistics24hrs[3][288], uint64_t gridSecondsOffset)
{
    // start FT800 display list
    StartDL();
 
    // mark 6 areas for touch input (for zoom in),
    // make each every second zone gray, make the active zone green
    char ZonesCnt = 0;
    for (int i = 25; i < 433; i += 68) {
        (*_TFT).DL(COLOR_RGB(255, 255, 255));
        if (ZonesCnt % 2 == 0) {
            (*_TFT).DL(COLOR_RGB(233, 233, 233));
        }
        if (pressedButton - ZONE_1_PRESS == ZonesCnt) {
            (*_TFT).DL(COLOR_RGB(200, 255, 200));
            timePoint30min = 6 * ZonesCnt;
        }
        (*_TFT).DL(TAG_MASK(1));
        (*_TFT).DL(TAG(ZONE_1_PRESS + ZonesCnt));
        (*_TFT).DL(BEGIN(RECTS));
        (*_TFT).DL(VERTEX2II(i, 100, 0, 0));
        (*_TFT).DL(VERTEX2II(i + 68, 200, 0, 0));
        (*_TFT).DL(TAG_MASK(0));
        ZonesCnt++;
    }
    
    // create time string, GridLines, link to main menu 
    TimeSinceTurnOn(seconds);
    VerticalGrid3hrs(gridSecondsOffset);
    HorisontalGrid_Statistics_Humidity();
    MainMenuReference();

    // draw graph line
    for (int i = 0; i < 36; i++) {
        char currentValue = statistics24hrs[0][i + timePoint3hrs];
        char currentMinValue = statistics24hrs[1][i + timePoint3hrs];
        char currentMaxValue = statistics24hrs[2][i + timePoint3hrs];
        if (currentValue != INIT_STATISTICS_NUMBER) {
            (*_TFT).DL(COLOR_RGB(9, 0, 63));
            if (currentMaxValue - currentMinValue >= DELTA_HUMIDITY) {
                (*_TFT).DL(COLOR_RGB(207, 45, 13));
                (*_TFT).DL(BEGIN(LINES));
                (*_TFT).DL(LINE_WIDTH(16));
                (*_TFT).DL(VERTEX2F(i * 181 + 25 * 16, (200 - currentValue) * 16));
                (*_TFT).DL(VERTEX2F(i * 181 + 25 * 16, (200 - currentMaxValue) * 16));
                (*_TFT).DL(VERTEX2F(i * 181 + 22 * 16, (200 - currentMaxValue) * 16));
                (*_TFT).DL(VERTEX2F(i * 181 + 28 * 16, (200 - currentMaxValue) * 16));
                (*_TFT).DL(END());
                (*_TFT).DL(BEGIN(LINES));
                (*_TFT).DL(LINE_WIDTH(16));
                (*_TFT).DL(VERTEX2F(i * 181 + 25 * 16, (200 - currentValue) * 16));
                (*_TFT).DL(VERTEX2F(i * 181 + 25 * 16, (200 - currentMinValue) * 16));
                (*_TFT).DL(VERTEX2F(i * 181 + 22 * 16, (200 - currentMinValue) * 16));
                (*_TFT).DL(VERTEX2F(i * 181 + 28 * 16, (200 - currentMinValue) * 16));
                (*_TFT).DL(END());
            } 
            (*_TFT).DL(BEGIN(POINTS));
            (*_TFT).DL(POINT_SIZE(45));
            (*_TFT).DL(VERTEX2F(i * 181 + 25 * 16, (200 - currentValue) * 16));
        }
    }
    
    // write main title
    (*_TFT).DL(COLOR_RGB(0, 0, 0));
    CreateStringRussian("Отн. влажность за 3 часа");
    (*_TFT).Text(15, 15, 3, 0, russianStr); 
    
    // finish FT800 display list
    FinishDL();
}

/**************************************************************************************************************************
************************** Display data about temeprature in the three-hour interval **************************************
**************************************************************************************************************************/
void Display::StatTemperature_3hrs(volatile uint64_t seconds, short int statistics24hrs[3][288], uint64_t gridSecondsOffset) 
{
    // start FT800 display list
    StartDL();
 
    // mark 6 areas for touch input (for zoom in),
    // make each every second zone gray, make the active zone green
    char ZonesCnt = 0;
    for (int i = 25; i < 433; i += 68) {
        (*_TFT).DL(COLOR_RGB(255, 255, 255));
        if (ZonesCnt % 2 == 0) {
            (*_TFT).DL(COLOR_RGB(233, 233, 233));
        }
        if (pressedButton - ZONE_1_PRESS == ZonesCnt) {
            (*_TFT).DL(COLOR_RGB(200, 255, 200));
            timePoint30min = 6 * ZonesCnt;
        }
        (*_TFT).DL(TAG_MASK(1));
        (*_TFT).DL(TAG(ZONE_1_PRESS + ZonesCnt));
        (*_TFT).DL(BEGIN(RECTS));
        (*_TFT).DL(VERTEX2II(i, 100, 0, 0));
        (*_TFT).DL(VERTEX2II(i + 68, 200, 0, 0));
        (*_TFT).DL(TAG_MASK(0));
        ZonesCnt++;
    }

    // create time string, GridLines, link to main menu 
    TimeSinceTurnOn(seconds);
    VerticalGrid3hrs(gridSecondsOffset);
    HorisontalGrid_Statistics_Temperature();
    MainMenuReference();
    
    // draw graph line
    for (int i = 0; i < 36; i++) {
        char currentValue = (statistics24hrs[0][i + timePoint3hrs] / TEMPERATURE_MULTIPLIER + 50) * 0.57;
        char currentMinValue = (statistics24hrs[1][i + timePoint3hrs] / TEMPERATURE_MULTIPLIER + 50) * 0.57;
        char currentMaxValue = (statistics24hrs[2][i + timePoint3hrs] / TEMPERATURE_MULTIPLIER + 50) * 0.57;
        char delta = statistics24hrs[2][i + timePoint3hrs] - statistics24hrs[1][i + timePoint3hrs];
        
        if (statistics24hrs[0][i + timePoint3hrs] != INIT_STATISTICS_NUMBER) {
            (*_TFT).DL(COLOR_RGB(9, 0, 63));
            if (delta >= DELTA_TEMPERATURE + TEMPERATURE_MULTIPLIER) {
                (*_TFT).DL(COLOR_RGB(207, 45, 13));
                (*_TFT).DL(BEGIN(LINES));
                (*_TFT).DL(LINE_WIDTH(16));
                (*_TFT).DL(VERTEX2F(i * 181 + 25 * 16, (200 - currentValue) * 16));
                (*_TFT).DL(VERTEX2F(i * 181 + 25 * 16, (200 - currentMaxValue) * 16));
                (*_TFT).DL(VERTEX2F(i * 181 + 22 * 16, (200 - currentMaxValue) * 16));
                (*_TFT).DL(VERTEX2F(i * 181 + 28 * 16, (200 - currentMaxValue) * 16));
                (*_TFT).DL(END());
                (*_TFT).DL(BEGIN(LINES));
                (*_TFT).DL(LINE_WIDTH(16));
                (*_TFT).DL(VERTEX2F(i * 181 + 25 * 16, (200 - currentValue) * 16));
                (*_TFT).DL(VERTEX2F(i * 181 + 25 * 16, (200 - currentMinValue) * 16));
                (*_TFT).DL(VERTEX2F(i * 181 + 22 * 16, (200 - currentMinValue) * 16));
                (*_TFT).DL(VERTEX2F(i * 181 + 28 * 16, (200 - currentMinValue) * 16));
                (*_TFT).DL(END());
            } 
            (*_TFT).DL(BEGIN(POINTS));
            (*_TFT).DL(POINT_SIZE(45));
            (*_TFT).DL(VERTEX2F(i * 181 + 25 * 16, (200 - currentValue) * 16));
        }
    }
    
    // write main title
    (*_TFT).DL(COLOR_RGB(0, 0, 0));
    CreateStringRussian("Температура за 3 часа");
    (*_TFT).Text(15, 15, 3, 0, russianStr); 
    
    // finish FT800 display list
    FinishDL();  
}