#include "display.h"

/**************************************************************************************************************************
************************** Display Main Menu ******************************************************************************
**************************************************************************************************************************/

void Display::MainMenu(float humidity, float temperature)
{
     // start FT800 display list
    StartDL();
    
    // write main title
    (*_TFT).DL(COLOR_RGB(0, 0, 0));

    CreateStringRussian("Датчик HYT-271 от IST");
    (*_TFT).Text(15, 15, 3, 0, russianStr);    
   
    // create blue rectangle with current humididty including 
    // rectangle is tagged as CURR_HUM_PRESS
    (*_TFT).DL(TAG_MASK(1));
    (*_TFT).DL(TAG(CURR_HUM_PRESS));
    (*_TFT).DL(COLOR_RGB(9, 0, 63));
    // if rectangle is already pressed, draw it with lighter color
    if (pressedButton == CURR_HUM_PRESS) {
        (*_TFT).DL(COLOR_RGB(75, 70, 108));
    }
    (*_TFT).DL(BEGIN(RECTS));
    (*_TFT).DL(VERTEX2II(12, 62, 0, 0));
    (*_TFT).DL(VERTEX2II(12 + 300, 62 + 93, 0, 0));
    (*_TFT).DL(COLOR_RGB(255, 255, 255));
    CreateStringRussian("Отн. влажность");
    (*_TFT).Text(12 + 10, 62 + 5, 3, 0, russianStr); 
    CreateStringTempHum(humidityStr, humidity, 0);
    (*_TFT).Text(12 + 10, 62 + 45, 31, 0, humidityStr);
    (*_TFT).DL(BEGIN(BITMAPS));
    (*_TFT).DL(VERTEX2II(12 + 255, 62 + 10, 0, 0));
    (*_TFT).DL(END());
    (*_TFT).DL(TAG_MASK(0));

    // create blue rectangle with current temperature including 
    // rectangle is tagged as CURR_TEMP_PRESS
    (*_TFT).DL(TAG_MASK(1));
    (*_TFT).DL(TAG(CURR_TEMP_PRESS));
    (*_TFT).DL(COLOR_RGB(9, 0, 63));
    // if rectangle is already pressed, draw it with lighter color
    if (pressedButton == CURR_TEMP_PRESS) {
        (*_TFT).DL(COLOR_RGB(75, 70, 108));
    }
    (*_TFT).DL(BEGIN(RECTS));
    (*_TFT).DL(VERTEX2II(12, 62 + 93 + 12, 0, 0));
    (*_TFT).DL(VERTEX2II(12 + 300, 62 + 93 + 12 + 93, 0, 0));
    (*_TFT).DL(COLOR_RGB(255, 255, 255));
    CreateStringRussian("Температура");
    (*_TFT).Text(12 + 10, 62 + 93 + 12 + 5, 3, 0, russianStr);
    char degreeOffset = CreateStringTempHum(temperatureStr, temperature, 1);
    (*_TFT).Text(12 + 10, 62 + 93 + 12 + 45, 31, 0, temperatureStr);
    (*_TFT).Text(12 + 10 + (degreeOffset * 16 + 3), 62 + 93 + 12 + 45 - 2, 28, 0, "o");
    (*_TFT).DL(BEGIN(BITMAPS));
    (*_TFT).DL(VERTEX2II(12 + 260, 62 + 93 + 12 + 10, 1, 0));
    (*_TFT).DL(END());
    (*_TFT).DL(TAG_MASK(0));


    // create black rectangle tagged as STAT_HUM_PRESS    
    (*_TFT).DL(TAG_MASK(1));
    (*_TFT).DL(TAG(STAT_HUM_PRESS));
    (*_TFT).DL(COLOR_RGB(36, 36, 36));
    // if rectangle is already pressed, draw it lighter
    if (pressedButton == STAT_HUM_PRESS) {
        (*_TFT).DL(COLOR_RGB(56, 56, 56));
    }
    (*_TFT).DL(BEGIN(RECTS));
    (*_TFT).DL(VERTEX2II(12 + 300 + 12, 62, 0, 0));
    (*_TFT).DL(VERTEX2II(12 + 300 + 12 + 144, 62 + 58, 0, 0));
    (*_TFT).DL(COLOR_RGB(255, 255, 255));
    CreateStringRussian("Отн. влажность");
    (*_TFT).Text(12 + 300 + 12 + 10, 62 + 5, 4, 0, russianStr);
    CreateStringRussian("за сутки");
    (*_TFT).Text(12 + 300 + 12 + 10, 62 + 27, 4, 0, russianStr);
    (*_TFT).DL(TAG_MASK(0));

    // create black rectangle tagged as STAT_TEMP_PRESS    
    (*_TFT).DL(TAG_MASK(1));
    (*_TFT).DL(TAG(STAT_TEMP_PRESS));
    (*_TFT).DL(COLOR_RGB(36, 36, 36));
    // if rectangle is already pressed, draw it lighter
    if (pressedButton == STAT_TEMP_PRESS) {
        (*_TFT).DL(COLOR_RGB(56, 56, 56));
    }
    (*_TFT).DL(BEGIN(RECTS));
    (*_TFT).DL(VERTEX2II(12 + 300 + 12, 62 + 58 + 12, 0, 0));
    (*_TFT).DL(VERTEX2II(12 + 300 + 12 + 144, 62 + 58 + 12 + 58, 0, 0));
    (*_TFT).DL(COLOR_RGB(255, 255, 255));
    CreateStringRussian("Температура");
    (*_TFT).Text(12 + 300 + 12 + 10, 62 + 58 + 12 + 5, 4, 0, russianStr);
    CreateStringRussian("за сутки");
    (*_TFT).Text(12 + 300 + 12 + 10, 62 + 58 + 12 + 27, 4, 0, russianStr);
    (*_TFT).DL(TAG_MASK(0));
    
    // create black rectangle tagged as ABOUT_PRESS  
    (*_TFT).DL(TAG_MASK(1));
    (*_TFT).DL(TAG(ABOUT_PRESS));
    (*_TFT).DL(COLOR_RGB(36, 36, 36));
    // if rectangle is already pressed, draw it lighter
    if (pressedButton == ABOUT_PRESS) {
        (*_TFT).DL(COLOR_RGB(56, 56, 56));
    }
    (*_TFT).DL(BEGIN(RECTS));
    (*_TFT).DL(VERTEX2II(12 + 300 + 12, 62 + 58 + 12 + 58 + 12, 0, 0));
    (*_TFT).DL(VERTEX2II(12 + 300 + 12 + 144, 62 + 58 + 12 + 58 + 12 + 58, 0, 0));
    (*_TFT).DL(COLOR_RGB(255, 255, 255));
    CreateStringRussian("О датчике");
    (*_TFT).Text(12 + 144 + 12 + 144 + 12 + 10, 62 + 58 + 12 + 58 + 12 + 5, 4, 0, russianStr); 
    (*_TFT).DL(TAG_MASK(0));
    
    // finish FT800 display list
    FinishDL();
}