#include "display.h"

/**************************************************************************************************************************
************************** Display text & image about the HYT sensor ******************************************************
**************************************************************************************************************************/
void Display::AboutSensor()
{
    // start FT800 display list
    StartDL();

    // Write text
    (*_TFT).DL(COLOR_RGB(0, 0, 0));
    (*_TFT).DL(BEGIN(LINES));
    (*_TFT).DL(LINE_WIDTH(8));
    (*_TFT).DL(VERTEX2II(14, 65, 0, 0));
    (*_TFT).DL(VERTEX2II(14, 230, 0, 0));
    CreateStringRussian("Датчик температуры и относительной влажности");
    (*_TFT).Text(24, 62, 4, 0, russianStr); 
    CreateStringRussian("с интерфейсом I2C от швейцарской компании IST.");
    (*_TFT).Text(24, 82, 4, 0, russianStr); 
    (*_TFT).DL(COLOR_RGB(9, 0, 63));
    CreateStringRussian("Диапазон измерений: 0 .. 100% rH, -40 .. 125°C");
    (*_TFT).Text(24, 115, 4, 0, russianStr); 
    CreateStringRussian("Точность: ±1.8% rH в диапазоне 0 .. 80% rH,");
    (*_TFT).Text(24, 140, 4, 0, russianStr); 
    CreateStringRussian("±0.2°C в диапазоне 0 .. 60°C");
    (*_TFT).Text(105, 160, 4, 0, russianStr); 
    CreateStringRussian("Время отклика: < 4 сек");
    (*_TFT).Text(24, 185, 4, 0, russianStr); 
    CreateStringRussian("Напряжение питания: от 2.7 до 5.5 В");
    (*_TFT).Text(24, 210, 4, 0, russianStr); 
    (*_TFT).DL(COLOR_RGB(0, 0, 0));
    CreateStringRussian("Датчик HYT-271");
    (*_TFT).Text(15, 15, 3, 0, russianStr); 

    // Show photo
    (*_TFT).DL(COLOR_RGB(255, 255, 255));
    (*_TFT).DL(BEGIN(BITMAPS));
    (*_TFT).DL(VERTEX2II(360, 140, 2, 0));
    (*_TFT).DL(END());

    // create link to main menu 
    MainMenuReference();
    
    // finish FT800 display list
    FinishDL();
}
